/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.serve.common.util.freemark;

import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapper;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateExceptionHandler;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;

public class FreemarkUtil {
    private static Configuration configuration = new Configuration(Configuration.VERSION_2_3_0);

    public static File createDoc(Object dataMap, String templateName, String targetDir, String fileName) {
        File f = new File(targetDir + File.separator + fileName);
        Writer w = null;
        try {
            f.getParentFile().mkdirs();
            configuration.setDefaultEncoding("UTF-8");
            configuration.setClassForTemplateLoading(FreemarkUtil.class, "/template/files/");
            configuration.setObjectWrapper((ObjectWrapper)new DefaultObjectWrapper(Configuration.VERSION_2_3_0));
            configuration.setTemplateExceptionHandler(TemplateExceptionHandler.IGNORE_HANDLER);
            Template template = configuration.getTemplate(templateName, "utf-8");
            if (template == null) {
                throw new RuntimeException("\u6a21\u677f\u4e0d\u5b58\u5728!");
            }
            w = new OutputStreamWriter((OutputStream)new FileOutputStream(f), "utf-8");
            template.process(dataMap, w);
        }
        catch (IOException e) {
            throw new RuntimeException("IO\u5f02\u5e38\uff1a" + e.getMessage());
        }
        catch (TemplateException e) {
            throw new RuntimeException("\u6a21\u677f\u5f02\u5e38\uff1a" + e.getMessage());
        }
        finally {
            try {
                if (w != null) {
                    w.close();
                }
            }
            catch (IOException e) {
                throw new RuntimeException("IO\u5f02\u5e38\uff1a" + e.getMessage());
            }
        }
        return f;
    }

    public void generaDoc(Map<?, ?> dataMap, String templateName, String targetFile, OutputStream outputStream) {
        File f = new File(targetFile);
        try {
            int bytesRead;
            if (!f.getParentFile().exists()) {
                f.getParentFile().mkdirs();
            }
            configuration.setDefaultEncoding("UTF-8");
            configuration.setClassForTemplateLoading(FreemarkUtil.class, "/template/files/");
            configuration.setObjectWrapper((ObjectWrapper)new DefaultObjectWrapper());
            configuration.setTemplateExceptionHandler(TemplateExceptionHandler.IGNORE_HANDLER);
            Template t = configuration.getTemplate(templateName, "UTF-8");
            if (t == null) {
                throw new RuntimeException("\u6a21\u677f\u4e0d\u5b58\u5728!");
            }
            OutputStreamWriter w = new OutputStreamWriter((OutputStream)new FileOutputStream(f), "utf-8");
            t.process(dataMap, (Writer)w);
            ((Writer)w).close();
            BufferedInputStream bis = null;
            BufferedOutputStream bos = null;
            bis = new BufferedInputStream(new FileInputStream(f));
            bos = new BufferedOutputStream(outputStream);
            byte[] buff = new byte[2048];
            while (-1 != (bytesRead = bis.read(buff, 0, buff.length))) {
                bos.write(buff, 0, bytesRead);
            }
            bis.close();
            bos.close();
            f.delete();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new RuntimeException(ex);
        }
    }

    public static String loadFreemarkFile(Object dataMap, String templateName) {
        StringWriter writer = new StringWriter();
        try {
            configuration.setDefaultEncoding("UTF-8");
            configuration.setClassForTemplateLoading(FreemarkUtil.class, "/template");
            configuration.setObjectWrapper((ObjectWrapper)new DefaultObjectWrapper(Configuration.VERSION_2_3_0));
            configuration.setTemplateExceptionHandler(TemplateExceptionHandler.IGNORE_HANDLER);
            Template template = configuration.getTemplate(templateName, "utf-8");
            if (template == null) {
                throw new RuntimeException("\u6a21\u677f\u4e0d\u5b58\u5728!");
            }
            template.process(dataMap, (Writer)writer);
            String string = ((Object)writer).toString();
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException("IO\u5f02\u5e38\uff1a" + e.getMessage());
        }
        catch (TemplateException e) {
            throw new RuntimeException("\u6a21\u677f\u5f02\u5e38\uff1a" + e.getMessage());
        }
        finally {
            try {
                if (writer != null) {
                    ((Writer)writer).close();
                }
            }
            catch (IOException e) {
                throw new RuntimeException("IO\u5f02\u5e38\uff1a" + e.getMessage());
            }
        }
    }
}

