/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.serve.common.util.file;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;

public class FileUtils {
    private FileUtils() {
    }

    public static void copyFileByNio(FileInputStream inputStream, FileOutputStream outputStream) throws IOException {
        FileChannel inChannel = inputStream.getChannel();
        FileChannel outChannel = outputStream.getChannel();
        ByteBuffer byteBuffer = ByteBuffer.allocate(1024);
        int read = 0;
        int total = 0;
        while ((read = inChannel.read(byteBuffer)) > 0) {
            byteBuffer.flip();
            outChannel.write(byteBuffer);
            byteBuffer.flip();
            total += read;
        }
        inChannel.close();
        inputStream.close();
        outChannel.close();
        outputStream.close();
    }

    public static void copyFile(InputStream inputStream, OutputStream outputStream) throws IOException {
        BufferedInputStream bufi = new BufferedInputStream(inputStream);
        BufferedOutputStream bufo = new BufferedOutputStream(outputStream);
        FileUtils.copyFileByBuffer(bufi, bufo);
        bufi.close();
        bufo.close();
    }

    public static void copyFileNotCloseStream(InputStream inputStream, OutputStream outputStream) throws IOException {
        BufferedInputStream bufi = new BufferedInputStream(inputStream);
        BufferedOutputStream bufo = new BufferedOutputStream(outputStream);
        FileUtils.copyFileByBuffer(bufi, bufo);
    }

    private static void copyFileByBuffer(BufferedInputStream bufi, BufferedOutputStream bufo) throws IOException {
        int len;
        byte[] buffer = new byte[1024];
        while ((len = bufi.read(buffer)) > 0) {
            bufo.write(buffer, 0, len);
        }
        bufo.flush();
    }
}

