/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.serve.common.util.excel;

import cn.smarthse.serve.common.util.DateUtils;
import cn.smarthse.serve.common.util.excel.model.ColumnExportModel;
import cn.smarthse.serve.common.util.excel.model.ExcelExportModel;
import cn.smarthse.serve.common.util.excel.model.ExcelModel;
import cn.smarthse.serve.common.util.excel.model.RowModel;
import cn.smarthse.serve.common.util.excel.model.SheetData;
import cn.smarthse.serve.common.util.excel.model.SheetExportModel;
import cn.smarthse.serve.common.util.excel.model.SheetModel;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.NumberFormat;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ExcelUtils {
    private static NumberFormat nf = NumberFormat.getInstance();

    private ExcelUtils() {
    }

    public static List<String> getXlsSheetNames(InputStream inputStream) throws IOException {
        ArrayList<String> list = new ArrayList<String>(16);
        POIFSFileSystem poifsFileSystem = new POIFSFileSystem(inputStream);
        HSSFWorkbook hssfWorkbook = new HSSFWorkbook(poifsFileSystem);
        int numberOfSheets = hssfWorkbook.getNumberOfSheets();
        for (int i = 0; i < numberOfSheets; ++i) {
            HSSFSheet sheet = hssfWorkbook.getSheetAt(i);
            list.add(sheet.getSheetName());
        }
        poifsFileSystem.close();
        inputStream.close();
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ExcelModel parseXls(InputStream inputStream, int ... cellNums) {
        ExcelModel excelModel = new ExcelModel();
        LinkedList<SheetModel> sheetModels = new LinkedList<SheetModel>();
        excelModel.setSheets(sheetModels);
        try {
            POIFSFileSystem poifsFileSystem = new POIFSFileSystem(inputStream);
            HSSFWorkbook hssfWorkbook = new HSSFWorkbook(poifsFileSystem);
            int numberOfSheets = hssfWorkbook.getNumberOfSheets();
            for (int i = 0; i < numberOfSheets; ++i) {
                HSSFSheet sheet = hssfWorkbook.getSheetAt(i);
                if (sheet == null) continue;
                SheetModel sheetModel = new SheetModel();
                sheetModels.add(sheetModel);
                sheetModel.setSheetName(sheet.getSheetName());
                sheetModel.setRows(new LinkedList<RowModel>());
                int rowNum = sheet.getLastRowNum();
                for (int j = 0; j <= rowNum; ++j) {
                    HSSFRow row = sheet.getRow(j);
                    if (row == null) continue;
                    RowModel rowModel = new RowModel();
                    if (j == 0) {
                        sheetModel.setHeaders(rowModel);
                    }
                    boolean isAllCellEmpty = true;
                    for (int k = 0; k < cellNums[i]; ++k) {
                        HSSFCell cell = row.getCell(k);
                        if (cell != null) {
                            cell.setCellType(CellType.STRING);
                            String stringCellValue = cell.getStringCellValue();
                            if (stringCellValue.length() > 0) {
                                isAllCellEmpty = false;
                            }
                            rowModel.add(stringCellValue);
                            continue;
                        }
                        rowModel.add("");
                    }
                    if (isAllCellEmpty || j <= 0) continue;
                    sheetModel.getRows().add(rowModel);
                }
            }
            poifsFileSystem.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return excelModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ExcelModel parseXlsx(InputStream inputStream, int ... cellNums) {
        ExcelModel excelModel = new ExcelModel();
        LinkedList<SheetModel> sheetModels = new LinkedList<SheetModel>();
        excelModel.setSheets(sheetModels);
        try {
            XSSFWorkbook xwb = new XSSFWorkbook(inputStream);
            for (int numSheet = 0; numSheet < xwb.getNumberOfSheets(); ++numSheet) {
                XSSFSheet xSheet = xwb.getSheetAt(numSheet);
                if (xSheet == null) continue;
                SheetModel sheetModel = new SheetModel();
                sheetModels.add(sheetModel);
                sheetModel.setSheetName(xSheet.getSheetName());
                LinkedList<RowModel> rowModels = new LinkedList<RowModel>();
                sheetModel.setRows(rowModels);
                for (int numRow = 0; numRow <= xSheet.getLastRowNum(); ++numRow) {
                    XSSFRow xRow = xSheet.getRow(numRow);
                    if (xRow == null) continue;
                    RowModel rowModel = new RowModel();
                    if (numRow == 0) {
                        sheetModel.setHeaders(rowModel);
                    }
                    boolean isAllCellEmpty = true;
                    for (int numCell = 0; numCell < cellNums[numSheet]; ++numCell) {
                        XSSFCell xCell = xRow.getCell(numCell);
                        String value = ExcelUtils.getValue(xCell);
                        if (value != null && value.length() > 0) {
                            isAllCellEmpty = false;
                        }
                        rowModel.add(value);
                    }
                    if (isAllCellEmpty || numRow <= 0) continue;
                    sheetModel.getRows().add(rowModel);
                }
            }
            xwb.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return excelModel;
    }

    private static String getValue(XSSFCell xCell) {
        if (xCell == null) {
            return "";
        }
        if (xCell.getCellTypeEnum() == CellType.BOOLEAN) {
            return String.valueOf(xCell.getBooleanCellValue());
        }
        if (xCell.getCellTypeEnum() == CellType.NUMERIC) {
            double numericCellValue = xCell.getNumericCellValue();
            return nf.format(numericCellValue);
        }
        return String.valueOf(xCell.getStringCellValue());
    }

    public static void exportXls(OutputStream outputStream, ExcelExportModel excelExportModel) throws IOException, NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        HSSFWorkbook workbook = new HSSFWorkbook();
        HSSFCellStyle cellStyle = workbook.createCellStyle();
        HSSFFont font = workbook.createFont();
        font.setBold(true);
        cellStyle.setFont(font);
        for (SheetExportModel sheetModel : excelExportModel.getSheets()) {
            HSSFSheet sheet = workbook.createSheet(sheetModel.getSheetName());
            sheet.setColumnWidth(0, 3840);
            List<ColumnExportModel> columnExportModelList = sheetModel.getColumnExportModelList();
            int rowNum = 0;
            HSSFRow row = sheet.createRow(rowNum++);
            for (int i = 0; i < columnExportModelList.size(); ++i) {
                ColumnExportModel columnExportModel = columnExportModelList.get(i);
                HSSFCell hSSFCell = row.createCell(i);
                hSSFCell.setCellStyle(cellStyle);
                hSSFCell.setCellValue(columnExportModel.getHeaderName());
            }
            List<? extends Object> dataList = sheetModel.getDataList();
            if (dataList == null || dataList.isEmpty()) continue;
            for (Object object : dataList) {
                row = sheet.createRow(rowNum++);
                for (int i = 0; i < columnExportModelList.size(); ++i) {
                    ColumnExportModel columnExportModel = columnExportModelList.get(i);
                    HSSFCell cell = row.createCell(i);
                    String propertyName = columnExportModel.getPropertyName();
                    if (propertyName == null || propertyName == "") continue;
                    String firstChar = propertyName.substring(0, 1).toUpperCase();
                    Method getMethod = object.getClass().getMethod("get" + firstChar + propertyName.substring(1), new Class[0]);
                    Object result = getMethod.invoke(object, new Object[0]);
                    cell.setCellValue(ExcelUtils.formatToString(result));
                }
            }
        }
        workbook.write(outputStream);
        workbook.close();
        outputStream.close();
    }

    public static void exportXlsx(OutputStream outputStream, ExcelExportModel excelExportModel) throws IOException, NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        XSSFWorkbook workbook = new XSSFWorkbook();
        XSSFCellStyle cellStyle = workbook.createCellStyle();
        XSSFFont font = workbook.createFont();
        font.setBold(true);
        cellStyle.setFont((Font)font);
        for (SheetExportModel sheetModel : excelExportModel.getSheets()) {
            XSSFSheet sheet = workbook.createSheet(sheetModel.getSheetName());
            sheet.setColumnWidth(0, 3840);
            List<ColumnExportModel> columnExportModelList = sheetModel.getColumnExportModelList();
            int rowNum = 0;
            XSSFRow row = sheet.createRow(rowNum++);
            for (int i = 0; i < columnExportModelList.size(); ++i) {
                ColumnExportModel columnExportModel = columnExportModelList.get(i);
                XSSFCell xSSFCell = row.createCell(i);
                xSSFCell.setCellStyle((CellStyle)cellStyle);
                xSSFCell.setCellValue(columnExportModel.getHeaderName());
            }
            List<? extends Object> dataList = sheetModel.getDataList();
            if (dataList == null || dataList.isEmpty()) continue;
            for (Object object : dataList) {
                row = sheet.createRow(rowNum++);
                for (int i = 0; i < columnExportModelList.size(); ++i) {
                    ColumnExportModel columnExportModel = columnExportModelList.get(i);
                    XSSFCell cell = row.createCell(i);
                    String propertyName = columnExportModel.getPropertyName();
                    if (propertyName == null || propertyName == "") continue;
                    String firstChar = propertyName.substring(0, 1).toUpperCase();
                    Method getMethod = object.getClass().getMethod("get" + firstChar + propertyName.substring(1), new Class[0]);
                    Object result = getMethod.invoke(object, new Object[0]);
                    cell.setCellValue(ExcelUtils.formatToString(result));
                }
            }
        }
        workbook.write(outputStream);
        workbook.close();
        outputStream.close();
    }

    public static void exportSingleSheet(OutputStream outputStream, List<? extends Object> dataList, String columnHeaders) throws InvocationTargetException, NoSuchMethodException, IllegalAccessException, IOException {
        String[] columnHeaderArr;
        ExcelExportModel excelExportModel = new ExcelExportModel();
        excelExportModel.setSheets(new ArrayList<SheetExportModel>());
        excelExportModel.getSheets().add(new SheetExportModel());
        SheetExportModel sheetExportModel = excelExportModel.getSheets().get(0);
        sheetExportModel.setSheetName("sheet1");
        sheetExportModel.setDataList(dataList);
        sheetExportModel.setColumnExportModelList(new ArrayList<ColumnExportModel>());
        List<ColumnExportModel> columnExportModelList = sheetExportModel.getColumnExportModelList();
        for (String columnHeader : columnHeaderArr = columnHeaders.split(",")) {
            String[] strings = columnHeader.split("\\|");
            String propertyName = strings.length == 2 ? strings[0].trim() : "";
            String headerName = strings.length == 2 ? strings[1].trim() : columnHeader;
            columnExportModelList.add(new ColumnExportModel(propertyName, headerName));
        }
        ExcelUtils.exportXls(outputStream, excelExportModel);
    }

    public static void exportSingleSheetXlsx(OutputStream outputStream, List<? extends Object> dataList, String columnHeaders) throws InvocationTargetException, NoSuchMethodException, IllegalAccessException, IOException {
        String[] columnHeaderArr;
        ExcelExportModel excelExportModel = new ExcelExportModel();
        excelExportModel.setSheets(new ArrayList<SheetExportModel>());
        excelExportModel.getSheets().add(new SheetExportModel());
        SheetExportModel sheetExportModel = excelExportModel.getSheets().get(0);
        sheetExportModel.setSheetName("sheet1");
        sheetExportModel.setDataList(dataList);
        sheetExportModel.setColumnExportModelList(new ArrayList<ColumnExportModel>());
        List<ColumnExportModel> columnExportModelList = sheetExportModel.getColumnExportModelList();
        for (String columnHeader : columnHeaderArr = columnHeaders.split(",")) {
            String[] strings = columnHeader.split("\\|");
            String propertyName = strings.length == 2 ? strings[0].trim() : "";
            String headerName = strings.length == 2 ? strings[1].trim() : columnHeader;
            columnExportModelList.add(new ColumnExportModel(propertyName, headerName));
        }
        ExcelUtils.exportXlsx(outputStream, excelExportModel);
    }

    public static void exportSingleSheetBlankXlsx(OutputStream outputStream, String columnHeaders) throws InvocationTargetException, NoSuchMethodException, IllegalAccessException, IOException {
        String[] columnHeaderArr;
        ExcelExportModel excelExportModel = new ExcelExportModel();
        excelExportModel.setSheets(new ArrayList<SheetExportModel>());
        excelExportModel.getSheets().add(new SheetExportModel());
        SheetExportModel sheetExportModel = excelExportModel.getSheets().get(0);
        sheetExportModel.setSheetName("sheet1");
        sheetExportModel.setColumnExportModelList(new ArrayList<ColumnExportModel>());
        List<ColumnExportModel> columnExportModelList = sheetExportModel.getColumnExportModelList();
        for (String columnHeader : columnHeaderArr = columnHeaders.split(",")) {
            columnExportModelList.add(new ColumnExportModel("", columnHeader.trim()));
        }
        XSSFWorkbook workbook = new XSSFWorkbook();
        XSSFCellStyle cellStyle = workbook.createCellStyle();
        XSSFFont font = workbook.createFont();
        font.setBold(true);
        cellStyle.setFont((Font)font);
        for (SheetExportModel sheetModel : excelExportModel.getSheets()) {
            XSSFSheet sheet = workbook.createSheet(sheetModel.getSheetName());
            sheet.setColumnWidth(0, 3840);
            int rowNum = 0;
            XSSFRow row = sheet.createRow(rowNum++);
            for (int i = 0; i < columnExportModelList.size(); ++i) {
                ColumnExportModel columnExportModel = columnExportModelList.get(i);
                XSSFCell cell = row.createCell(i);
                cell.setCellStyle((CellStyle)cellStyle);
                cell.setCellValue(columnExportModel.getHeaderName());
            }
        }
        workbook.write(outputStream);
        workbook.close();
        outputStream.close();
    }

    private static String formatToString(Object o) {
        if (o == null) {
            return "";
        }
        if (o instanceof Date) {
            return DateUtils.format((Date)o, "yyyy-MM-dd HH:mm:ss");
        }
        if (o instanceof Double) {
            return nf.format((Double)o);
        }
        if (o instanceof LocalDateTime) {
            return DateUtils.formatDate((LocalDateTime)o);
        }
        if (o instanceof Boolean) {
            if (o.equals(true)) {
                return "\u662f";
            }
            return "\u5426";
        }
        return String.valueOf(o);
    }

    public static void exportXlsByModel(OutputStream outputStream, InputStream xlsModelInputStream, Map<String, SheetData> sheetDataMap) throws IOException {
        POIFSFileSystem poifsFileSystem = new POIFSFileSystem(xlsModelInputStream);
        HSSFWorkbook hssfWorkbook = new HSSFWorkbook(poifsFileSystem);
        int numberOfSheets = hssfWorkbook.getNumberOfSheets();
        for (int i = 0; i < numberOfSheets; ++i) {
            String sheetName;
            SheetData excelDataMode2;
            HSSFSheet sheet = hssfWorkbook.getSheetAt(i);
            if (sheet == null || (excelDataMode2 = sheetDataMap.get(sheetName = sheet.getSheetName())) == null) continue;
            int startRow = excelDataMode2.getStartRow();
            List<List<String>> dataList = excelDataMode2.getDataList();
            if (dataList == null) continue;
            for (List<String> rowList : dataList) {
                HSSFRow row = sheet.createRow(startRow++);
                for (int j = 0; j < rowList.size(); ++j) {
                    HSSFCell cell = row.createCell(j);
                    cell.setCellValue(rowList.get(j));
                }
            }
        }
        hssfWorkbook.write(outputStream);
        outputStream.close();
        xlsModelInputStream.close();
    }

    static {
        nf.setMaximumFractionDigits(4);
        nf.setGroupingUsed(false);
    }
}

