/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.serve.common.util.data;

import java.util.Date;
import java.util.GregorianCalendar;

public class SimpleLunarCalendar {
    private static final long minTimeInMillis = -2206425952001L;
    private static final long maxTimeInMillis = 4102416000000L;
    private static final int[] lunarInfo = new int[]{19416, 19168, 42352, 21717, 53856, 55632, 21844, 22191, 39632, 21970, 19168, 42422, 42192, 53840, 53909, 46415, 54944, 44450, 38320, 18807, 18815, 42160, 46261, 27216, 27968, 43860, 11119, 38256, 21234, 18800, 25958, 54432, 59984, 27285, 23263, 11104, 34531, 37615, 51415, 51551, 54432, 55462, 46431, 22176, 42420, 9695, 37584, 53938, 43344, 46423, 27808, 46416, 21333, 19887, 42416, 17779, 21183, 43432, 59728, 27296, 44710, 43856, 19296, 43748, 42352, 21088, 62051, 55632, 23383, 22176, 38608, 19925, 19152, 42192, 54484, 53840, 54616, 46400, 46752, 38310, 38335, 18864, 43380, 42160, 45690, 27216, 27968, 44870, 43872, 38256, 19189, 18800, 25776, 29859, 59984, 27480, 23232, 43872, 38613, 37600, 51552, 55636, 54432, 55888, 30034, 22176, 43959, 9680, 37584, 51893, 43344, 46240, 47780, 44368, 21977, 19360, 42416, 20854, 21183, 43312, 31060, 27296, 44368, 23378, 19296, 42726, 42208, 53856, 60005, 54576, 23200, 30371, 38608, 19195, 19152, 42192, 53430, 53855, 54560, 56645, 46496, 22224, 21938, 18864, 42359, 42160, 43600, 45653, 27951, 44448, 19299, 37759, 18936, 18800, 25776, 26790, 59999, 27424, 42692, 43759, 37600, 53987, 51552, 54615, 54432, 55888, 23893, 22176, 42704, 21972, 21200, 43448, 43344, 46240, 46758, 44368, 21920, 43940, 42416, 21168, 45683, 26928, 29495, 27296, 44368, 19285, 19311, 42352, 21732, 53856, 59752, 54560, 55968, 27302, 22239, 19168, 43476, 42192, 53584, 62034, 54560};
    private static final String[] Animals = new String[]{"\u9f20", "\u725b", "\u864e", "\u5154", "\u9f99", "\u86c7", "\u9a6c", "\u7f8a", "\u7334", "\u9e21", "\u72d7", "\u732a"};
    private static final String[] lunarString1 = new String[]{"\u96f6", "\u4e00", "\u4e8c", "\u4e09", "\u56db", "\u4e94", "\u516d", "\u4e03", "\u516b", "\u4e5d"};
    private static final String[] lunarString2 = new String[]{"\u521d", "\u5341", "\u5eff", "\u5345", "\u6b63", "\u814a", "\u51ac", "\u95f0"};
    private int lunarYear;
    private int lunarMonth;
    private int lunarDay;
    private boolean isLeap;
    private boolean isLeapYear;
    private int maxDayInMonth = 29;

    public SimpleLunarCalendar(long TimeInMillis) {
        this.init(TimeInMillis);
    }

    public SimpleLunarCalendar(Date date) {
        if (date == null) {
            date = new Date();
        }
        this.init(date.getTime());
    }

    private void init(long timeInMillis) {
        if (timeInMillis > -2206425952001L && timeInMillis < 4102416000000L) {
            long offset;
            GregorianCalendar baseDate = new GregorianCalendar(1900, 0, 31);
            this.lunarYear = 1900;
            int daysInLunarYear = SimpleLunarCalendar.getLunarYearDays(this.lunarYear);
            for (offset = (timeInMillis - baseDate.getTimeInMillis()) / 86400000L; this.lunarYear < 2100 && offset >= (long)daysInLunarYear; offset -= (long)daysInLunarYear) {
                daysInLunarYear = SimpleLunarCalendar.getLunarYearDays(++this.lunarYear);
            }
            int leapMonth = SimpleLunarCalendar.getLunarLeapMonth(this.lunarYear);
            this.isLeapYear = leapMonth > 0;
            int lunarMonth = 1;
            boolean isDecrease = true;
            boolean isLeap = false;
            int daysInLunarMonth = 0;
            while (lunarMonth < 13 && offset > 0L) {
                if (isLeap && !isDecrease) {
                    daysInLunarMonth = SimpleLunarCalendar.getLunarLeapDays(this.lunarYear);
                    isDecrease = true;
                } else {
                    daysInLunarMonth = SimpleLunarCalendar.getLunarMonthDays(this.lunarYear, lunarMonth);
                }
                if (offset < (long)daysInLunarMonth) break;
                offset -= (long)daysInLunarMonth;
                if (leapMonth == lunarMonth && !isLeap) {
                    isDecrease = false;
                    isLeap = true;
                    continue;
                }
                ++lunarMonth;
            }
            this.maxDayInMonth = daysInLunarMonth != 0 ? daysInLunarMonth : SimpleLunarCalendar.getLunarMonthDays(this.lunarYear, lunarMonth);
            this.lunarMonth = lunarMonth;
            this.isLeap = lunarMonth == leapMonth && isLeap;
            this.lunarDay = (int)offset + 1;
        }
    }

    private static int getLunarYearDays(int lunarYear) {
        int daysInLunarYear = 348;
        for (int i = 32768; i > 8; i >>= 1) {
            daysInLunarYear += (lunarInfo[lunarYear - 1900] & i) != 0 ? 1 : 0;
        }
        return daysInLunarYear += SimpleLunarCalendar.getLunarLeapDays(lunarYear);
    }

    private static int getLunarLeapDays(int lunarYear) {
        return SimpleLunarCalendar.getLunarLeapMonth(lunarYear) > 0 ? ((lunarInfo[lunarYear - 1899] & 0xF) == 15 ? 30 : 29) : 0;
    }

    private static int getLunarLeapMonth(int lunarYear) {
        int leapMonth = lunarInfo[lunarYear - 1900] & 0xF;
        leapMonth = leapMonth == 15 ? 0 : leapMonth;
        return leapMonth;
    }

    private static int getLunarMonthDays(int lunarYear, int lunarMonth) {
        int daysInLunarMonth = (lunarInfo[lunarYear - 1900] & 65536 >> lunarMonth) != 0 ? 30 : 29;
        return daysInLunarMonth;
    }

    private static String getLunarYearString(int lunarYear) {
        String lunarYearString = "";
        String year = String.valueOf(lunarYear);
        for (int i = 0; i < year.length(); ++i) {
            char yearChar = year.charAt(i);
            int index = Integer.parseInt(String.valueOf(yearChar));
            lunarYearString = lunarYearString + lunarString1[index];
        }
        return lunarYearString;
    }

    private static String getLunarMonthString(int lunarMonth) {
        String lunarMonthString = "";
        if (lunarMonth == 1) {
            lunarMonthString = lunarString2[4];
        } else {
            if (lunarMonth > 9) {
                lunarMonthString = lunarMonthString + lunarString2[1];
            }
            if (lunarMonth % 10 > 0) {
                lunarMonthString = lunarMonthString + lunarString1[lunarMonth % 10];
            }
        }
        return lunarMonthString;
    }

    private static String getLunarDayString(int lunarDay) {
        if (lunarDay < 1 || lunarDay > 30) {
            return "";
        }
        int i1 = lunarDay / 10;
        int i2 = lunarDay % 10;
        String c1 = lunarString2[i1];
        String c2 = lunarString1[i2];
        if (lunarDay < 11) {
            c1 = lunarString2[0];
        }
        if (i2 == 0) {
            c2 = lunarString2[1];
        }
        return c1 + c2;
    }

    public String getAnimalString() {
        if (this.lunarYear == 0) {
            return null;
        }
        return Animals[(this.lunarYear - 4) % 12];
    }

    public String getDayString() {
        if (this.lunarDay == 0) {
            return null;
        }
        return SimpleLunarCalendar.getLunarDayString(this.lunarDay);
    }

    public String getMonthString() {
        if (this.lunarMonth == 0) {
            return null;
        }
        return (this.isLeap() ? "\u95f0" : "") + SimpleLunarCalendar.getLunarMonthString(this.lunarMonth);
    }

    public String getYearString() {
        if (this.lunarYear == 0) {
            return null;
        }
        return SimpleLunarCalendar.getLunarYearString(this.lunarYear);
    }

    public String getDateString() {
        if (this.lunarYear == 0) {
            return null;
        }
        return this.getYearString() + "\u5e74" + this.getMonthString() + "\u6708" + this.getDayString() + "\u65e5";
    }

    public boolean isLeap() {
        return this.isLeap;
    }

    public boolean isLeapYear() {
        return this.isLeapYear;
    }

    public boolean isBigMonth() {
        return this.getMaxDayInMonth() > 29;
    }

    public int getMaxDayInMonth() {
        if (this.lunarYear == 0) {
            return 0;
        }
        return this.maxDayInMonth;
    }

    public int getDay() {
        return this.lunarDay;
    }

    public int getMonth() {
        return this.lunarMonth;
    }

    public int getYear() {
        return this.lunarYear;
    }
}

