/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.serve.common.util;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.WriterException;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.QRCodeWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.Base64;
import java.util.HashMap;

public class QRCodeGenerator {
    public static void generateQRCodeImage(String text, int width, int height, String filePath) throws WriterException, IOException {
        QRCodeWriter qrCodeWriter = new QRCodeWriter();
        HashMap<EncodeHintType, String> map = new HashMap<EncodeHintType, String>();
        map.put(EncodeHintType.CHARACTER_SET, "UTF-8");
        BitMatrix matrix = qrCodeWriter.encode(text, BarcodeFormat.QR_CODE, 150, 150, map);
        Path path = FileSystems.getDefault().getPath(filePath, new String[0]);
        MatrixToImageWriter.writeToPath((BitMatrix)matrix, (String)"PNG", (Path)path);
    }

    public static String getQRCodeImageBase64(String urlCode) throws WriterException, IOException {
        QRCodeWriter qrCodeWriter = new QRCodeWriter();
        BitMatrix bitMatrix1 = qrCodeWriter.encode(urlCode, BarcodeFormat.QR_CODE, 100, 100);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        MatrixToImageWriter.writeToStream((BitMatrix)bitMatrix1, (String)"PNG", (OutputStream)outputStream);
        Base64.Encoder encoder1 = Base64.getEncoder();
        String advUrl = "data:image/jpg;base64," + encoder1.encodeToString(outputStream.toByteArray());
        return advUrl;
    }
}

