/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.serve.common.util;

import cn.smarthse.serve.common.constant.CommonConstants;
import cn.smarthse.serve.common.constant.Constant;
import cn.smarthse.serve.common.util.StringUtils;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Clock;
import io.jsonwebtoken.ExpiredJwtException;
import io.jsonwebtoken.Jws;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import io.jsonwebtoken.impl.DefaultClock;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;

public class JwtUtil {
    private static Long admin_expiration = (long)(CommonConstants.LOGIN_EXPIRE_HOUR * 24 * 60 * 60) * 1000L;
    private static Long customer_expiration = (long)(CommonConstants.CUSTOMER_TOKEN_EXPIRE_DAY * 24 * 60 * 60) * 1000L;
    private static Clock clock = DefaultClock.INSTANCE;

    public static String generateToken(String subject) {
        HashMap<String, Object> claims = new HashMap<String, Object>();
        return JwtUtil.doGenerateToken(claims, subject);
    }

    public static String generateToken(Long userId, Integer type, String username, String nickname) {
        HashMap claims = new HashMap();
        Date createdDate = clock.now();
        Date expirationDate = JwtUtil.calculateExpirationDate(createdDate, Constant.TOKEN_EXPIRE_TIME);
        return Jwts.builder().setClaims(claims).setSubject(userId + "").claim("type", (Object)type).claim("username", (Object)username).claim("nickname", (Object)nickname).setIssuedAt(createdDate).setExpiration(expirationDate).signWith(SignatureAlgorithm.HS512, Constant.TOKEN_SECRET).compact();
    }

    public static String generateAppletToken(Long userId, Integer type, String username, String nickname) {
        HashMap claims = new HashMap();
        Date createdDate = clock.now();
        Date expirationDate = JwtUtil.calculateExpirationDate(createdDate, Constant.APPLET_TOKEN_EXPIRE_TIME);
        return Jwts.builder().setClaims(claims).setSubject(userId + "").claim("type", (Object)type).claim("username", (Object)username).claim("nickname", (Object)nickname).setIssuedAt(createdDate).setExpiration(expirationDate).signWith(SignatureAlgorithm.HS512, Constant.TOKEN_SECRET).compact();
    }

    public static String generateRefreshToken(Long userId, Integer type, String username, String nickname) {
        HashMap claims = new HashMap();
        Date createdDate = clock.now();
        Date expirationDate = JwtUtil.calculateExpirationDate(createdDate, Constant.TOKEN_REFRESH_TIME);
        return Jwts.builder().setClaims(claims).setSubject(userId + "").claim("type", (Object)type).claim("username", (Object)username).claim("nickname", (Object)nickname).setIssuedAt(createdDate).setExpiration(expirationDate).signWith(SignatureAlgorithm.HS512, Constant.TOKEN_SECRET).compact();
    }

    public static boolean verify(String token) {
        try {
            Jws jwt = Jwts.parser().setSigningKey(Constant.TOKEN_SECRET).setSigningKey(Constant.TOKEN_SECRET).parseClaimsJws(token);
            ((Claims)jwt.getBody()).get((Object)"username");
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static String getSubjectFromToken(String token) {
        try {
            return JwtUtil.getClaimFromToken(token, Claims::getSubject);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Long getUserIdFromToken(String token) {
        if (StringUtils.isBlank((CharSequence)token)) {
            return null;
        }
        try {
            return Long.parseLong(JwtUtil.getAllClaimsFromToken(token).getSubject());
        }
        catch (ExpiredJwtException e) {
            return Long.parseLong(e.getClaims().getSubject());
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getUsernameFromToken(String token) {
        if (StringUtils.isBlank((CharSequence)token)) {
            return null;
        }
        Claims claims = null;
        try {
            claims = JwtUtil.getAllClaimsFromToken(token);
        }
        catch (Exception e) {
            return null;
        }
        return claims == null ? null : (String)claims.get("username", String.class);
    }

    public static Integer getTypeFromToken(String token) {
        Claims claims = null;
        try {
            claims = JwtUtil.getAllClaimsFromToken(token);
        }
        catch (Exception e) {
            return 0;
        }
        Integer type = (Integer)claims.get("type", Integer.class);
        return claims == null || type == null ? 0 : type;
    }

    public static String getNicknameFromToken(String token) {
        if (StringUtils.isBlank((CharSequence)token)) {
            return null;
        }
        Claims claims = JwtUtil.getAllClaimsFromToken(token);
        return claims == null ? null : (String)claims.get("nickname", String.class);
    }

    public static boolean isTokenExpired(String token) {
        if (StringUtils.isBlank((CharSequence)token)) {
            return true;
        }
        Date expiration = JwtUtil.getExpirationDateFromToken(token);
        return expiration == null || expiration.before(clock.now());
    }

    public static Date getExpirationDateFromToken(String token) {
        return JwtUtil.getClaimFromToken(token, Claims::getExpiration);
    }

    private static String doGenerateToken(Map<String, Object> claims, String subject) {
        Date createdDate = clock.now();
        Date expirationDate = JwtUtil.calculateExpirationDate(createdDate);
        return Jwts.builder().setClaims(claims).setSubject(subject).setIssuedAt(createdDate).setExpiration(expirationDate).signWith(SignatureAlgorithm.HS512, Constant.TOKEN_SECRET).compact();
    }

    private static Date calculateExpirationDate(Date createdDate) {
        return new Date(createdDate.getTime() + Constant.TOKEN_EXPIRE_TIME);
    }

    private static Date calculateExpirationDate(Date createdDate, Long expiration) {
        return new Date(createdDate.getTime() + expiration);
    }

    private static <T> T getClaimFromToken(String token, Function<Claims, T> claimsResolver) {
        try {
            Claims claims = JwtUtil.getAllClaimsFromToken(token);
            return claimsResolver.apply(claims);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static Claims getAllClaimsFromToken(String token) {
        return (Claims)Jwts.parser().setSigningKey(Constant.TOKEN_SECRET).parseClaimsJws(token).getBody();
    }
}

