/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.serve.common.util;

import cn.smarthse.serve.common.util.DateDeserializer;
import cn.smarthse.serve.common.util.LocalDateTimeDeserializer;
import cn.smarthse.serve.common.util.LocalDateTimeSerializer;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.parser.ParserConfig;
import com.alibaba.fastjson.parser.deserializer.ObjectDeserializer;
import com.alibaba.fastjson.serializer.ObjectSerializer;
import com.alibaba.fastjson.serializer.SerializeConfig;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.fastjson.serializer.ToStringSerializer;
import java.time.LocalDateTime;
import java.util.Date;

public class JsonUtils {
    private JsonUtils() {
    }

    public static String toJsonString(Object javaBean) {
        SerializeConfig serializeConfig = new SerializeConfig();
        serializeConfig.put(Long.class, (ObjectSerializer)ToStringSerializer.instance);
        serializeConfig.put(LocalDateTime.class, (ObjectSerializer)LocalDateTimeSerializer.instance);
        return JSON.toJSONString((Object)javaBean, (SerializeConfig)serializeConfig, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue, SerializerFeature.DisableCircularReferenceDetect, SerializerFeature.WriteDateUseDateFormat});
    }

    public static String toJsonStringNoPretty(Object javaBean) {
        SerializeConfig serializeConfig = new SerializeConfig();
        serializeConfig.put(Long.class, (ObjectSerializer)ToStringSerializer.instance);
        serializeConfig.put(Date.class, (ObjectSerializer)ToStringSerializer.instance);
        serializeConfig.put(LocalDateTime.class, (ObjectSerializer)LocalDateTimeSerializer.instance);
        return JSON.toJSONString((Object)javaBean, (SerializeConfig)serializeConfig, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue, SerializerFeature.DisableCircularReferenceDetect, SerializerFeature.WriteDateUseDateFormat});
    }

    public static <T> T toObject(String json, Class<T> clazz) {
        ParserConfig parserConfig = new ParserConfig();
        parserConfig.putDeserializer(Date.class, (ObjectDeserializer)DateDeserializer.instance);
        parserConfig.putDeserializer(LocalDateTime.class, (ObjectDeserializer)LocalDateTimeDeserializer.instance);
        return (T)JSONObject.parseObject((String)json, clazz, (ParserConfig)parserConfig, (Feature[])new Feature[0]);
    }
}

