/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.serve.common.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.DayOfWeek;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.Month;
import java.time.MonthDay;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.Calendar;
import java.util.Date;

public class DateUtils {
    public static final String DATE_TIME_PATTERN = "yyyy-MM-dd HH:mm:ss";
    public static final String DATE_PATTERN = "yyyy-MM-dd";
    private static String[] weekDays = new String[]{"\u661f\u671f\u65e5", "\u661f\u671f\u4e00", "\u661f\u671f\u4e8c", "\u661f\u671f\u4e09", "\u661f\u671f\u56db", "\u661f\u671f\u4e94", "\u661f\u671f\u516d"};

    public static Date parseDate(String dateString, String pattern) throws ParseException {
        SimpleDateFormat dateFormat = new SimpleDateFormat(pattern);
        Date date = dateFormat.parse(dateString);
        return date;
    }

    public static String format(Date date, String pattern) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(pattern);
        return dateFormat.format(date);
    }

    public static String getNowDate(String pattern) {
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(pattern);
        LocalDateTime localDateTime = LocalDateTime.now();
        return dateTimeFormatter.format(localDateTime);
    }

    public static String getNowDateString() {
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(DATE_TIME_PATTERN);
        LocalDateTime localDateTime = LocalDateTime.now();
        return dateTimeFormatter.format(localDateTime);
    }

    public static LocalDateTime parseDateTime(String dateTime, String pattern) {
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(pattern);
        return LocalDateTime.parse(dateTime, dateTimeFormatter);
    }

    public static int getYear() {
        return LocalDate.now().getYear();
    }

    public static int getMonth() {
        Month month = LocalDate.now().getMonth();
        return month.getValue();
    }

    public static int getDay() {
        return LocalDate.now().getDayOfMonth();
    }

    public static Date getDate(String dateStr, String pattern) {
        SimpleDateFormat sdf = new SimpleDateFormat(pattern);
        try {
            return sdf.parse(dateStr);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getWeekOfDate(LocalDate localDate) {
        DayOfWeek dayOfWeek = localDate.getDayOfWeek();
        int w = dayOfWeek.getValue();
        if (w < 0 || w >= 7) {
            w = 0;
        }
        return weekDays[w];
    }

    public static int getDayOfWeek(LocalDate localDate) {
        return localDate.getDayOfWeek().getValue();
    }

    public static boolean isLeapYear(int year) {
        Year y = Year.of(year);
        return y.isLeap();
    }

    public static LocalDate getDate(int year, int month, int days) {
        Year y = Year.of(year);
        YearMonth yearMonth = y.atMonth(month);
        return yearMonth.atDay(days);
    }

    public static LocalDate getDateAutoParse(int year, int month, int days) {
        MonthDay monthDay = MonthDay.of(month, days);
        return monthDay.atYear(year);
    }

    public static String getDateString(int year, int month, int day) {
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(DATE_PATTERN);
        MonthDay monthDay = MonthDay.of(month, day);
        LocalDate date = monthDay.atYear(year);
        return dateTimeFormatter.format(date);
    }

    public static String getDateTimeString(LocalDate localDate) {
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(DATE_PATTERN);
        return dateTimeFormatter.format(localDate);
    }

    public static String getNextDate(LocalDate localDate, int i, String pattern) {
        LocalDate nextDate = localDate.plusDays(i);
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(pattern);
        return dateTimeFormatter.format(nextDate);
    }

    public static LocalDate getNextDate(LocalDate localDate, int i) {
        return localDate.plusDays(i);
    }

    public static String getNowTime() {
        String dateTime = DateUtils.getNowDateString();
        return dateTime.substring(11);
    }

    public static long calculateHours(LocalDateTime time1, LocalDateTime time2) {
        return ChronoUnit.HOURS.between(time1, time2);
    }

    public static LocalDate getStartDateOfWeek() {
        Calendar cal = Calendar.getInstance();
        cal.set(7, 2);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        Date date = cal.getTime();
        return DateUtils.getFromDate(date).toLocalDate();
    }

    public static LocalDate getEndDateOfWeek() {
        Calendar cal = Calendar.getInstance();
        cal.set(7, 7);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        Date date = cal.getTime();
        return DateUtils.getFromDate(date).toLocalDate().plusDays(1L);
    }

    public static LocalDate getStartDateOfMonth() {
        LocalDate now = LocalDate.now();
        return DateUtils.getLocalDateTime(now.getYear(), now.getMonthValue(), 1, 0, 0, 0).toLocalDate();
    }

    public static LocalDate getEndDateOfMonth() {
        LocalDate now = LocalDate.now();
        return DateUtils.getLocalDateTime(now.getYear(), now.getMonthValue(), now.getMonth().maxLength(), 0, 0, 0).toLocalDate();
    }

    public String getDateToDay(String pattern) {
        LocalDate today = LocalDate.now();
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(pattern);
        return dateTimeFormatter.format(today);
    }

    public static long calculateDays(LocalDate date1, LocalDate date2) {
        return ChronoUnit.DAYS.between(date1, date2);
    }

    public static long calculateYears(LocalDate date1, LocalDate date2) {
        return ChronoUnit.YEARS.between(date1, date2);
    }

    public static long calculateMonths(LocalDate date1, LocalDate date2) {
        return ChronoUnit.MONTHS.between(date1, date2);
    }

    public static long calculateMinutes(LocalDateTime time1, LocalDateTime time2) {
        return ChronoUnit.MINUTES.between(time1, time2);
    }

    public static long calculateSeconds(LocalDateTime time1, LocalDateTime time2) {
        return ChronoUnit.SECONDS.between(time1, time2);
    }

    public static long getMill(LocalDateTime localDateTime) {
        return localDateTime.toInstant(ZoneOffset.of("+8")).toEpochMilli();
    }

    public static LocalDateTime getFromDate(Date date) {
        Instant instant = date.toInstant();
        ZoneId zoneId = ZoneId.systemDefault();
        return LocalDateTime.ofInstant(instant, zoneId);
    }

    public static Date getDate(LocalDateTime localDateTime) {
        ZoneId zoneId = ZoneId.of("GMT+08");
        ZonedDateTime zdt = localDateTime.atZone(zoneId);
        Date date = Date.from(zdt.toInstant());
        return date;
    }

    public static String formatDate(LocalDateTime time) {
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(DATE_TIME_PATTERN);
        LocalDateTime localDateTime = LocalDateTime.now();
        return dateTimeFormatter.format(localDateTime);
    }

    public static String formatDate(LocalDateTime time, String pattern) {
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(pattern);
        return dateTimeFormatter.format(time);
    }

    public static String formatDate(LocalDate date, String pattern) {
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(pattern);
        return dateTimeFormatter.format(date);
    }

    public static Date getDateNow() {
        ZoneId zoneId = ZoneId.of("GMT+08");
        LocalDateTime localDateTime = LocalDateTime.now();
        ZonedDateTime zdt = localDateTime.atZone(zoneId);
        Date date = Date.from(zdt.toInstant());
        return date;
    }

    public static LocalDateTime getLocalDateTime(int year, int month, int day, int hour, int min, int second) {
        return LocalDateTime.of(year, month, day, hour, min, second);
    }

    public static LocalDate getLocalDate(String date) {
        return LocalDate.parse(date);
    }

    public static int getHour() {
        return LocalDateTime.now().getHour();
    }

    public static String getDateTimeStringByMil(long millisecond) {
        Date date = new Date(millisecond);
        SimpleDateFormat format = new SimpleDateFormat(DATE_TIME_PATTERN);
        return format.format(date);
    }

    public static String getDateStringByMil(long millisecond) {
        Date date = new Date(millisecond);
        SimpleDateFormat format = new SimpleDateFormat(DATE_PATTERN);
        return format.format(date);
    }

    public static long getMillisecond() {
        return new Date().getTime();
    }

    public static long getMillisecondByDateTimeString(String dateTime, String pattern) {
        SimpleDateFormat format = new SimpleDateFormat(pattern);
        try {
            return format.parse(dateTime).getTime();
        }
        catch (ParseException e) {
            e.printStackTrace();
            return 0L;
        }
    }

    public static DayCompare dayComparePrecise(LocalDate fromDate, LocalDate toDate) {
        int day;
        boolean isChange = false;
        if (toDate.compareTo(fromDate) < 0) {
            LocalDate temp = fromDate;
            fromDate = toDate;
            toDate = temp;
            isChange = true;
        }
        int fromYear = fromDate.getYear();
        int fromMonth = fromDate.getMonthValue();
        int fromDay = fromDate.getDayOfMonth();
        int toYear = toDate.getYear();
        int toMonth = toDate.getMonthValue();
        int toDay = toDate.getDayOfMonth();
        int year = toYear - fromYear;
        int month = toMonth - fromMonth;
        if (month < 0) {
            --year;
            month = 12 - fromMonth + toMonth;
        }
        if ((day = toDay - fromDay) < 0) {
            --month;
            int maxDay = DateUtils.getMaxDaysOfOneMonth(fromYear, fromMonth);
            day = maxDay - fromDay + toDay;
        }
        if (month < 0) {
            --year;
            month = 12 + month;
        }
        if (isChange) {
            year = 0 - year;
            month = 0 - month;
            day = 0 - day;
        }
        return new DayCompare(year, month, day);
    }

    private static int getMaxDaysOfOneMonth(int year, int month) {
        int day = 1;
        Calendar cal = Calendar.getInstance();
        cal.set(year, month - 1, day);
        return cal.getActualMaximum(5);
    }

    public static int getMonthDays(int year, int month) {
        if (month == 2) {
            if (DateUtils.isLeap(year)) {
                return 29;
            }
            return 28;
        }
        if (month == 4 || month == 6 || month == 9 || month == 11) {
            return 30;
        }
        return 31;
    }

    public static boolean isLeap(int year) {
        return year % 4 == 0 && year % 100 != 0 || year % 400 == 0;
    }

    public static String formatTime(Object timeTemp) {
        int timeParam = 0;
        if (timeTemp instanceof Integer) {
            timeParam = (Integer)timeTemp;
        }
        if (timeTemp instanceof String) {
            timeParam = Integer.parseInt((String)timeTemp);
        }
        int second = timeParam % 60;
        int minuteTemp = timeParam / 60;
        if (minuteTemp > 0) {
            int minute = minuteTemp % 60;
            int hour = minuteTemp / 60;
            if (hour > 0) {
                return (hour > 10 ? hour + "" : "0" + hour) + ":" + (minute > 10 ? minute + "" : "0" + minute) + ":" + (second > 10 ? second + "" : "0" + second);
            }
            return "00:" + (minute > 10 ? minute + "" : "0" + minute) + ":" + (second > 10 ? second + "" : "0" + second);
        }
        return "00:00:" + (second > 10 ? second + "" : "0" + second);
    }

    public static class DayCompare {
        private int year;
        private int month;
        private int day;

        public DayCompare(int year, int month, int day) {
            this.year = year;
            this.month = month;
            this.day = day;
        }

        public int getYear() {
            return this.year;
        }

        public void setYear(int year) {
            this.year = year;
        }

        public int getMonth() {
            return this.month;
        }

        public void setMonth(int month) {
            this.month = month;
        }

        public int getDay() {
            return this.day;
        }

        public void setDay(int day) {
            this.day = day;
        }
    }
}

