/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.serve.common.util;

import cn.smarthse.serve.common.util.StringUtils;
import cn.smarthse.serve.common.util.data.DateStyle;
import cn.smarthse.serve.common.util.data.SimpleLunarCalendar;
import cn.smarthse.serve.common.util.data.Week;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.commons.lang3.time.DateUtils;

public class DateUtil
extends DateUtils {
    public static final String DATE_FORMAT_DEFAULT = "yyyy-MM-dd HH:mm:ss";
    private static final String TIME_FORMAT_DEFAULT = "HH:mm:ss";
    private static final String DATE_FORMAT_YMD = "yyyy-MM-dd";
    private static final String[] zodiacArr = new String[]{"\u7334", "\u9e21", "\u72d7", "\u732a", "\u9f20", "\u725b", "\u864e", "\u5154", "\u9f99", "\u86c7", "\u9a6c", "\u7f8a"};
    private static final String[] constellationArr = new String[]{"\u6c34\u74f6\u5ea7", "\u53cc\u9c7c\u5ea7", "\u7261\u7f8a\u5ea7", "\u91d1\u725b\u5ea7", "\u53cc\u5b50\u5ea7", "\u5de8\u87f9\u5ea7", "\u72ee\u5b50\u5ea7", "\u5904\u5973\u5ea7", "\u5929\u79e4\u5ea7", "\u5929\u874e\u5ea7", "\u5c04\u624b\u5ea7", "\u9b54\u7faf\u5ea7"};
    private static final int[] constellationEdgeDay = new int[]{20, 19, 21, 21, 21, 22, 23, 23, 23, 23, 22, 22};
    private static String[] weeks = new String[]{"\u4e00", "\u4e8c", "\u4e09", "\u56db", "\u4e94", "\u516d", "\u65e5"};
    private static final ThreadLocal<SimpleDateFormat> threadLocal = new ThreadLocal();
    private static final Object object = new Object();
    private static String[] parsePatterns = new String[]{"yyyy-MM-dd", "yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd HH:mm", "yyyy-MM", "yyyy-MM-dd'T'HH:mm:ss", "yyyy-MM-dd'T'HH:mm", "yyyy/MM/dd", "yyyy/MM/dd HH:mm:ss", "yyyy/MM/dd HH:mm", "yyyy/MM", "yyyy.MM.dd", "yyyy.MM.dd HH:mm:ss", "yyyy.MM.dd HH:mm", "yyyy.MM"};

    public static String getDate() {
        return DateUtil.getDate(DATE_FORMAT_YMD);
    }

    public static String format(Date date, String pattern) {
        if (date == null) {
            return "";
        }
        return DateFormatUtils.format((Date)date, (String)pattern);
    }

    public static String formatDate(Date date) {
        return DateUtil.format(date, DATE_FORMAT_YMD);
    }

    public static String formatDateTime(Date date) {
        return DateUtil.format(date, DATE_FORMAT_DEFAULT);
    }

    public static String formatDateWithWeek(Date date) {
        if (date == null) {
            return "";
        }
        String d = DateUtil.format(date, "yyyy/MM/dd HH:mm");
        String week = weeks[Math.abs(DateUtil.getWeekByDate(date))];
        return d + " \u5468" + week;
    }

    public static String formatDateForWeibo(Date date) {
        if (date == null) {
            return "";
        }
        Calendar cal = Calendar.getInstance();
        int year = cal.get(1);
        int dateYear = Integer.parseInt(new SimpleDateFormat("yyyy").format(date));
        StringBuffer buffer = new StringBuffer();
        long millTime = System.currentTimeMillis() - date.getTime();
        long second = millTime / 1000L;
        long minutes = second / 60L;
        long hours = minutes / 60L;
        if (second < 60L) {
            buffer.append("\u521a\u521a");
        } else if (minutes < 60L) {
            buffer.append(minutes).append("\u5206\u949f\u524d");
        } else if (hours < 24L) {
            buffer.append(hours).append("\u5c0f\u65f6\u524d");
        } else if (dateYear != year) {
            buffer.append(new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5 HH:mm").format(date));
        } else {
            buffer.append(new SimpleDateFormat("MM\u6708dd\u65e5 HH:mm").format(date));
        }
        return buffer.toString();
    }

    public static String getTime() {
        return DateUtil.format(new Date(), TIME_FORMAT_DEFAULT);
    }

    public static String getDateTime() {
        return DateUtil.format(new Date(), DATE_FORMAT_DEFAULT);
    }

    public static String getYear() {
        return DateUtil.format(new Date(), "yyyy");
    }

    public static String getMonth() {
        return DateUtil.format(new Date(), "MM");
    }

    public static String getDay() {
        return DateUtil.format(new Date(), "dd");
    }

    public static String getWeek() {
        return DateUtil.format(new Date(), "E");
    }

    public static Date parseDate(Object str) {
        if (str == null || StringUtils.isEmpty((CharSequence)str.toString())) {
            return null;
        }
        try {
            return DateUtil.parseDate((String)str.toString(), (String[])parsePatterns);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static long pastDays(Date date) {
        long t = new Date().getTime() - date.getTime();
        return t / 86400000L;
    }

    public static long pastHour(Date date) {
        long t = new Date().getTime() - date.getTime();
        return t / 3600000L;
    }

    public static long pastMinutes(Date date) {
        long t = new Date().getTime() - date.getTime();
        return t / 60000L;
    }

    public static String formatDateTime(long timeMillis) {
        long day = timeMillis / 86400000L;
        long hour = timeMillis / 3600000L - day * 24L;
        long min = timeMillis / 60000L - day * 24L * 60L - hour * 60L;
        long s = timeMillis / 1000L - day * 24L * 60L * 60L - hour * 60L * 60L - min * 60L;
        long sss = timeMillis - day * 24L * 60L * 60L * 1000L - hour * 60L * 60L * 1000L - min * 60L * 1000L - s * 1000L;
        return (day > 0L ? day + "," : "") + hour + ":" + min + ":" + s + "." + sss;
    }

    public static double getDistanceOfTwoDate(Date before, Date after) {
        long beforeTime = before.getTime();
        long afterTime = after.getTime();
        return (afterTime - beforeTime) / 86400000L;
    }

    public static long getDistanceOfTodayDate(Date after) {
        long beforeTime = System.currentTimeMillis();
        long afterTime = after.getTime();
        return Math.abs(beforeTime - afterTime) / 86400000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SimpleDateFormat getDateFormat(String pattern) throws RuntimeException {
        SimpleDateFormat dateFormat = threadLocal.get();
        if (dateFormat == null) {
            Object object = DateUtil.object;
            synchronized (object) {
                if (dateFormat == null) {
                    dateFormat = new SimpleDateFormat(pattern);
                    dateFormat.setLenient(false);
                    threadLocal.set(dateFormat);
                }
            }
        }
        dateFormat.applyPattern(pattern);
        return dateFormat;
    }

    private static int getInteger(Date date, int dateType) {
        int num = 0;
        Calendar calendar = Calendar.getInstance();
        if (date != null) {
            calendar.setTime(date);
            num = calendar.get(dateType);
        }
        return num;
    }

    private static String addInteger(String date, int dateType, int amount) {
        String dateString = null;
        DateStyle dateStyle = DateUtil.getDateStyle(date);
        if (dateStyle != null) {
            Date myDate = DateUtil.StringToDate(date, dateStyle);
            myDate = DateUtil.addInteger(myDate, dateType, amount);
            dateString = DateUtil.DateToString(myDate, dateStyle);
        }
        return dateString;
    }

    private static Date addInteger(Date date, int dateType, int amount) {
        Date myDate = null;
        if (date != null) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            calendar.add(dateType, amount);
            myDate = calendar.getTime();
        }
        return myDate;
    }

    private static Date getAccurateDate(List<Long> timestamps) {
        Date date = null;
        long timestamp = 0L;
        HashMap<Long, long[]> map = new HashMap<Long, long[]>();
        ArrayList<Long> absoluteValues = new ArrayList<Long>();
        if (timestamps != null && timestamps.size() > 0) {
            if (timestamps.size() > 1) {
                for (int i = 0; i < timestamps.size(); ++i) {
                    for (int j = i + 1; j < timestamps.size(); ++j) {
                        long absoluteValue = Math.abs(timestamps.get(i) - timestamps.get(j));
                        absoluteValues.add(absoluteValue);
                        long[] timestampTmp = new long[]{timestamps.get(i), timestamps.get(j)};
                        map.put(absoluteValue, timestampTmp);
                    }
                }
                long minAbsoluteValue = -1L;
                if (!absoluteValues.isEmpty()) {
                    minAbsoluteValue = (Long)absoluteValues.get(0);
                    for (int i = 1; i < absoluteValues.size(); ++i) {
                        if (minAbsoluteValue <= (Long)absoluteValues.get(i)) continue;
                        minAbsoluteValue = (Long)absoluteValues.get(i);
                    }
                }
                if (minAbsoluteValue != -1L) {
                    long[] timestampsLastTmp = (long[])map.get(minAbsoluteValue);
                    long dateOne = timestampsLastTmp[0];
                    long dateTwo = timestampsLastTmp[1];
                    if (absoluteValues.size() > 1) {
                        timestamp = Math.abs(dateOne) > Math.abs(dateTwo) ? dateOne : dateTwo;
                    }
                }
            } else {
                timestamp = timestamps.get(0);
            }
        }
        if (timestamp != 0L) {
            date = new Date(timestamp);
        }
        return date;
    }

    public static boolean isDate(String date) {
        boolean isDate = false;
        if (date != null && DateUtil.getDateStyle(date) != null) {
            isDate = true;
        }
        return isDate;
    }

    public static DateStyle getDateStyle(String date) {
        DateStyle dateStyle = null;
        HashMap<Long, DateStyle> map = new HashMap<Long, DateStyle>();
        ArrayList<Long> timestamps = new ArrayList<Long>();
        for (DateStyle style : DateStyle.values()) {
            if (style.isShowOnly()) continue;
            Date dateTmp = null;
            if (date != null) {
                try {
                    ParsePosition pos = new ParsePosition(0);
                    dateTmp = DateUtil.getDateFormat(style.getValue()).parse(date, pos);
                    if (pos.getIndex() != date.length()) {
                        dateTmp = null;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (dateTmp == null) continue;
            timestamps.add(dateTmp.getTime());
            map.put(dateTmp.getTime(), style);
        }
        Date accurateDate = DateUtil.getAccurateDate(timestamps);
        if (accurateDate != null) {
            dateStyle = (DateStyle)((Object)map.get(accurateDate.getTime()));
        }
        return dateStyle;
    }

    public static Date StringToDate(String date) {
        DateStyle dateStyle = DateUtil.getDateStyle(date);
        return DateUtil.StringToDate(date, dateStyle);
    }

    public static Date StringToDate(String date, String pattern) {
        Date myDate = null;
        if (date != null) {
            try {
                myDate = DateUtil.getDateFormat(pattern).parse(date);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return myDate;
    }

    public static Date StringToDate(String date, DateStyle dateStyle) {
        Date myDate = null;
        if (dateStyle != null) {
            myDate = DateUtil.StringToDate(date, dateStyle.getValue());
        }
        return myDate;
    }

    public static String DateToString(Date date, String pattern) {
        String dateString = null;
        if (date != null) {
            try {
                dateString = DateUtil.getDateFormat(pattern).format(date);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return dateString;
    }

    public static String DateToString(Date date, DateStyle dateStyle) {
        String dateString = null;
        if (dateStyle != null) {
            dateString = DateUtil.DateToString(date, dateStyle.getValue());
        }
        return dateString;
    }

    public static String StringToString(String date, String newPattern) {
        DateStyle oldDateStyle = DateUtil.getDateStyle(date);
        return DateUtil.StringToString(date, oldDateStyle, newPattern);
    }

    public static String StringToString(String date, DateStyle newDateStyle) {
        DateStyle oldDateStyle = DateUtil.getDateStyle(date);
        return DateUtil.StringToString(date, oldDateStyle, newDateStyle);
    }

    public static String StringToString(String date, String olddPattern, String newPattern) {
        return DateUtil.DateToString(DateUtil.StringToDate(date, olddPattern), newPattern);
    }

    public static String StringToString(String date, DateStyle olddDteStyle, String newParttern) {
        String dateString = null;
        if (olddDteStyle != null) {
            dateString = DateUtil.StringToString(date, olddDteStyle.getValue(), newParttern);
        }
        return dateString;
    }

    public static String StringToString(String date, String olddPattern, DateStyle newDateStyle) {
        String dateString = null;
        if (newDateStyle != null) {
            dateString = DateUtil.StringToString(date, olddPattern, newDateStyle.getValue());
        }
        return dateString;
    }

    public static String StringToString(String date, DateStyle olddDteStyle, DateStyle newDateStyle) {
        String dateString = null;
        if (olddDteStyle != null && newDateStyle != null) {
            dateString = DateUtil.StringToString(date, olddDteStyle.getValue(), newDateStyle.getValue());
        }
        return dateString;
    }

    public static String addYear(String date, int yearAmount) {
        return DateUtil.addInteger(date, 1, yearAmount);
    }

    public static Date addYear(Date date, int yearAmount) {
        return DateUtil.addInteger(date, 1, yearAmount);
    }

    public static String addMonth(String date, int monthAmount) {
        return DateUtil.addInteger(date, 2, monthAmount);
    }

    public static Date addMonth(Date date, int monthAmount) {
        return DateUtil.addInteger(date, 2, monthAmount);
    }

    public static String addDay(String date, int dayAmount) {
        return DateUtil.addInteger(date, 5, dayAmount);
    }

    public static Date addDay(Date date, int dayAmount) {
        return DateUtil.addInteger(date, 5, dayAmount);
    }

    public static String addHour(String date, int hourAmount) {
        return DateUtil.addInteger(date, 11, hourAmount);
    }

    public static Date addHour(Date date, int hourAmount) {
        return DateUtil.addInteger(date, 11, hourAmount);
    }

    public static String addMinute(String date, int minuteAmount) {
        return DateUtil.addInteger(date, 12, minuteAmount);
    }

    public static Date addMinute(Date date, int minuteAmount) {
        return DateUtil.addInteger(date, 12, minuteAmount);
    }

    public static String addSecond(String date, int secondAmount) {
        return DateUtil.addInteger(date, 13, secondAmount);
    }

    public static Date addSecond(Date date, int secondAmount) {
        return DateUtil.addInteger(date, 13, secondAmount);
    }

    public static int getYear(String date) {
        return DateUtil.getYear(DateUtil.StringToDate(date));
    }

    public static int getYear(Date date) {
        return DateUtil.getInteger(date, 1);
    }

    public static int getMonth(String date) {
        return DateUtil.getMonth(DateUtil.StringToDate(date));
    }

    public static int getMonth(Date date) {
        return DateUtil.getInteger(date, 2) + 1;
    }

    public static Long getMonthLastDay() {
        return DateUtil.getMonthLastDate().getTime();
    }

    public static Date getMonthLastDate() {
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat datef = new SimpleDateFormat(DATE_FORMAT_YMD);
        cal.set(5, 1);
        cal.roll(5, -1);
        Date endTime = cal.getTime();
        String endTime1 = datef.format(endTime) + " 23:59:59";
        return DateUtil.StringToDate(endTime1, DATE_FORMAT_DEFAULT);
    }

    public static int getDay(String date) {
        return DateUtil.getDay(DateUtil.StringToDate(date));
    }

    public static int getDay(Date date) {
        return DateUtil.getInteger(date, 5);
    }

    public static int getHour(String date) {
        return DateUtil.getHour(DateUtil.StringToDate(date));
    }

    public static int getHour(Date date) {
        return DateUtil.getInteger(date, 11);
    }

    public static int getMinute(String date) {
        return DateUtil.getMinute(DateUtil.StringToDate(date));
    }

    public static int getMinute(Date date) {
        return DateUtil.getInteger(date, 12);
    }

    public static int getSecond(String date) {
        return DateUtil.getSecond(DateUtil.StringToDate(date));
    }

    public static int getSecond(Date date) {
        return DateUtil.getInteger(date, 13);
    }

    public static String getDate(String date) {
        return DateUtil.StringToString(date, DateStyle.YYYY_MM_DD);
    }

    public static String getDate(Date date) {
        return DateUtil.DateToString(date, DateStyle.YYYY_MM_DD);
    }

    public static String getTime(String date) {
        return DateUtil.StringToString(date, DateStyle.HH_MM_SS);
    }

    public static String getTime(Date date) {
        return DateUtil.DateToString(date, DateStyle.HH_MM_SS);
    }

    public static Week getWeek(String date) {
        Week week = null;
        DateStyle dateStyle = DateUtil.getDateStyle(date);
        if (dateStyle != null) {
            Date myDate = DateUtil.StringToDate(date, dateStyle);
            week = DateUtil.getWeek(myDate);
        }
        return week;
    }

    public static Week getWeek(Date date) {
        Week week = null;
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int weekNumber = calendar.get(7) - 1;
        switch (weekNumber) {
            case 0: {
                week = Week.SUNDAY;
                break;
            }
            case 1: {
                week = Week.MONDAY;
                break;
            }
            case 2: {
                week = Week.TUESDAY;
                break;
            }
            case 3: {
                week = Week.WEDNESDAY;
                break;
            }
            case 4: {
                week = Week.THURSDAY;
                break;
            }
            case 5: {
                week = Week.FRIDAY;
                break;
            }
            case 6: {
                week = Week.SATURDAY;
            }
        }
        return week;
    }

    public static int getWeekByDate(Date date) {
        Calendar cd = Calendar.getInstance();
        cd.setTime(date);
        int dayOfWeek = cd.get(7) - 1;
        if (dayOfWeek == 0) {
            dayOfWeek = 7;
        }
        if (dayOfWeek == 1) {
            return 0;
        }
        return 1 - dayOfWeek;
    }

    public static String getWeekStr(String date) {
        SimpleDateFormat df = new SimpleDateFormat(DATE_FORMAT_YMD);
        try {
            Date dt1 = df.parse(date);
            return weeks[Math.abs(DateUtil.getWeekByDate(dt1))];
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return "";
        }
    }

    public static int getIntervalDays(String date, String otherDate) {
        return DateUtil.getIntervalDays(DateUtil.StringToDate(date), DateUtil.StringToDate(otherDate));
    }

    public static int getIntervalDays(Date date, Date otherDate) {
        int num = -1;
        Date dateTmp = DateUtil.StringToDate(DateUtil.getDate(date), DateStyle.YYYY_MM_DD);
        Date otherDateTmp = DateUtil.StringToDate(DateUtil.getDate(otherDate), DateStyle.YYYY_MM_DD);
        if (dateTmp != null && otherDateTmp != null) {
            long time = Math.abs(dateTmp.getTime() - otherDateTmp.getTime());
            num = (int)(time / 86400000L);
        }
        return num;
    }

    public static SimpleLunarCalendar getSimpleLunarCalendar(String date) {
        return new SimpleLunarCalendar(DateUtil.StringToDate(date));
    }

    public static SimpleLunarCalendar getSimpleLunarCalendar(Date date) {
        return new SimpleLunarCalendar(date);
    }

    public static String date2Zodica(Calendar time) {
        return zodiacArr[time.get(1) % 12];
    }

    public static String getConstellation(int month, int day) {
        return day < constellationEdgeDay[month - 1] ? constellationArr[month - 1] : constellationArr[month];
    }

    public static int compare_date(String date) {
        return DateUtil.compare_date(new Date(), DateUtil.StringToDate(date, DATE_FORMAT_YMD));
    }

    public static int compare_date(Date d1, Date d2) {
        try {
            if (d1.getTime() > d2.getTime()) {
                System.out.println("dt1 \u5728dt2\u524d");
                return 1;
            }
            if (d1.getTime() < d2.getTime()) {
                System.out.println("dt1\u5728dt2\u540e");
                return -1;
            }
            return 0;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return 0;
        }
    }

    public static long compare_time(Date now, Date date) {
        if (now == null || date == null) {
            return 0L;
        }
        long l = now.getTime() - date.getTime();
        long day = l / 86400000L;
        return day;
    }

    public static long compare_time(long now, long t) {
        long l = now - t;
        long day = l / 86400000L;
        return day;
    }

    public static long compare_time2diff(Date sd, Date ed) {
        Long s = sd.getTime() / 1000L;
        Long e = ed.getTime() / 1000L;
        if (s > e) {
            Long tmp = s;
            s = e;
            e = tmp;
        }
        return e - s;
    }

    public static float date2diff(Date sd, Date ed) {
        Long s = sd.getTime();
        Long e = ed.getTime();
        if (s > e) {
            Long tmp = s;
            s = e;
            e = tmp;
        }
        Long diff = e - s;
        long nd = 86400000L;
        long nh = 3600000L;
        long nm = 60000L;
        long ns = 1000L;
        long day = diff / nd;
        long hour = diff % nd / nh;
        long min = diff % nd % nh / nm;
        long sec = diff % nd % nh % nm / ns;
        System.out.println("\u65f6\u95f4\u76f8\u5dee\uff1a" + day + "\u5929" + hour + "\u5c0f\u65f6" + min + "\u5206\u949f" + sec + "\u79d2\u3002");
        return Float.valueOf(String.format("%s.%s", day, hour)).floatValue();
    }

    public static void main(String[] args) {
        Date today;
        Date oldEdate = DateUtil.parseDate("2019-01-28");
        if (DateUtil.compare_date(oldEdate, today = new Date()) <= 0) {
            System.out.println("oldEdate \u5df2\u8fc7\u671f");
        } else {
            System.out.println("oldEdate \u672a\u8fc7\u671f");
        }
    }

    public static Date getYearFirstDay(int year) {
        String format = DATE_FORMAT_YMD;
        String firstDayDateString = year + "-01-01";
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        try {
            return sdf.parse(firstDayDateString);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static Date getYearLastDay(int year) {
        String format = DATE_FORMAT_YMD;
        String lastDayDateString = year + "-12-31";
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        try {
            return sdf.parse(lastDayDateString);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static int getAgeByDate(Date dateOfBirth) {
        int age = 0;
        Calendar born = Calendar.getInstance();
        Calendar now = Calendar.getInstance();
        if (dateOfBirth != null) {
            int bornDayOfYear;
            now.setTime(new Date());
            born.setTime(dateOfBirth);
            if (born.after(now)) {
                return 0;
            }
            age = now.get(1) - born.get(1);
            int nowDayOfYear = now.get(6);
            if (nowDayOfYear < (bornDayOfYear = born.get(6))) {
                --age;
            }
        }
        return age;
    }

    public static int getThisYear() {
        Calendar now = Calendar.getInstance();
        now.setTime(new Date());
        return now.get(1);
    }

    public static Date getDistanceDate(Date date, int type, int distance) {
        if (date == null) {
            return null;
        }
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(type, distance);
        Date d = c.getTime();
        return d;
    }

    public static String formatCheckTime(Date beginTime, Date endTime, String splitor) {
        String checkTime = "";
        String pattern = DATE_FORMAT_YMD;
        if (beginTime == null && endTime == null) {
            return checkTime;
        }
        if (beginTime == null) {
            return DateUtil.format(endTime, pattern);
        }
        if (endTime == null) {
            return DateUtil.format(beginTime, pattern);
        }
        checkTime = DateUtil.format(beginTime, pattern) + splitor + DateUtil.format(endTime, pattern);
        return checkTime;
    }
}

