/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.third.task.sync;

import cn.hutool.core.util.StrUtil;
import cn.smarthse.rho.modules.sys.model.wanda.sync.param.WandaHealthDataSyncParam;
import cn.smarthse.rho.modules.third.dao.wanda.WandaHcMapper;
import cn.smarthse.rho.modules.third.manager.hc.v2.WandaFswsHealthCheckSyncManagerV22;
import com.xxl.job.core.context.XxlJobHelper;
import com.xxl.job.core.handler.annotation.XxlJob;
import java.util.List;
import java.util.stream.Collectors;
import javax.smarthse.framework.exception.ServiceException;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class WandaHCCardSyncTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WandaHCCardSyncTask.class);
    @Autowired
    WandaFswsHealthCheckSyncManagerV22 healthCheckSyncManager;
    @Autowired
    private WandaHcMapper wandaHcMapper;

    @XxlJob(value="WandaHCCardSyncTask-syncHCCardInfo")
    public void syncHCCardInfo() {
        try {
            this.healthCheckSyncManager.syncBaseInfoData(new WandaHealthDataSyncParam());
        }
        catch (Exception e) {
            log.error("\u3010\u4f53\u68c0\u540c\u6b65\u3011\u3010\u57fa\u7840\u6570\u636e\u3011\u3010\u6574\u4f53\u3011\u540c\u6b65\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
        }
    }

    @XxlJob(value="WandaHCCardSyncTask-syncHCCardInfo-cidList")
    public void syncHCCardInfoCidList() {
        try {
            WandaHealthDataSyncParam param = new WandaHealthDataSyncParam();
            String certIdList = XxlJobHelper.getJobParam();
            if (StrUtil.isNotEmpty((CharSequence)certIdList)) {
                List split = StrUtil.split((CharSequence)certIdList, (CharSequence)",");
                for (String cid : split) {
                    if (StrUtil.isNumeric((CharSequence)cid)) continue;
                    throw new ServiceException("\u53c2\u6570\u9519\u8bef");
                }
                List cidList = split.stream().map(v -> Long.valueOf(v)).collect(Collectors.toList());
                param.setCidLimitList(cidList);
            } else {
                param.setCidLimitList(List.of(Long.valueOf(33L)));
            }
            this.healthCheckSyncManager.syncBaseInfoData(param);
        }
        catch (Exception e) {
            log.error("\u3010\u4f53\u68c0\u540c\u6b65\u3011\u3010\u57fa\u7840\u6570\u636e\u3011\u3010\u6574\u4f53\u3011\u540c\u6b65\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
        }
    }

    @XxlJob(value="WandaHCCardSyncTask-syncHCCardInfo-cleanWandaHcStateInfo")
    public void syncHCCardInfoCidListCleanWandaHcStateInfo() {
        String id = XxlJobHelper.getJobParam();
        if (StrUtil.isBlank((CharSequence)id)) {
            throw new ServiceException("\u53c2\u6570\u9519\u8bef");
        }
        this.wandaHcMapper.cleanWandaHcStateInfo(Long.valueOf(id));
    }

    @Generated
    public WandaHCCardSyncTask() {
    }
}

