/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.third.task.push;

import cn.hutool.core.date.StopWatch;
import cn.smarthse.framework.core.domain.ResponseData;
import cn.smarthse.framework.redis.utils.RedisUtils;
import cn.smarthse.rho.modules.third.service.wanda.push.RhoDevice2WandaServiceImpl;
import cn.smarthse.rho.modules.third.service.wanda.push.RhoPlace2WandaServiceImpl;
import cn.smarthse.rho.modules.third.service.wanda.push.WandaPushBaseService;
import cn.smarthse.rho.modules.third.service.wanda.push.WandaPushFswsErrorDataReturnLogServiceImpl;
import cn.smarthse.rho.modules.third.service.wanda.push.WandaPushRhoCompany2WandaServiceImpl;
import com.xxl.job.core.context.XxlJobHelper;
import com.xxl.job.core.handler.annotation.XxlJob;
import jakarta.annotation.Resource;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.redisson.api.RLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/wanda/push"})
public class WandaPushTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WandaPushTask.class);
    @Resource
    private WandaPushFswsErrorDataReturnLogServiceImpl wandaPushFswsErrorDataReturnLogService;
    @Resource
    private RhoPlace2WandaServiceImpl rhoPlace2WandaService;
    @Resource
    private WandaPushRhoCompany2WandaServiceImpl company2WandaService;
    @Resource
    private RhoDevice2WandaServiceImpl rhoDevice2WandaService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private ResponseData<String> executePushTask(String taskName, PushTask pushTask) {
        String lockKey = "wanda_push_task_lock:" + taskName;
        RLock lock = RedisUtils.getClient().getLock(lockKey);
        boolean lockAcquired = false;
        try {
            ResponseData responseData;
            if (!lock.tryLock(0L, 60L, TimeUnit.MINUTES)) {
                String msg = "\u4efb\u52a1 " + taskName + " \u6b63\u5728\u8fd0\u884c\u4e2d\uff0c\u672c\u6b21\u6267\u884c\u8df3\u8fc7";
                log.info(msg);
                XxlJobHelper.log((String)msg, (Object[])new Object[0]);
                ResponseData responseData2 = ResponseData.success((String)msg);
                return responseData2;
            }
            lockAcquired = true;
            log.info("========== {} \u5f00\u59cb ==========", (Object)taskName);
            XxlJobHelper.log((String)"========== {} \u5f00\u59cb ==========", (Object[])new Object[]{taskName});
            StopWatch stopWatch = new StopWatch(taskName);
            stopWatch.start();
            try {
                pushTask.execute();
                log.info(">>>>>>>>>> {} \u6267\u884c\u6210\u529f <<<<<<<<<<", (Object)taskName);
                XxlJobHelper.log((String)">>>>>>>>>> {} \u6267\u884c\u6210\u529f <<<<<<<<<<", (Object[])new Object[]{taskName});
                responseData = ResponseData.success((String)"\u6267\u884c\u6210\u529f");
            }
            catch (Exception e) {
                log.error("!!!!!!!!! {} \u5f02\u5e38 !!!!!!!!!", (Object)taskName, (Object)e);
                XxlJobHelper.log((String)"!!!!!!!!! {} \u5f02\u5e38: {} !!!!!!!!!", (Object[])new Object[]{taskName, e.toString()});
                ResponseData responseData3 = ResponseData.fail((String)"\u6267\u884c\u5931\u8d25");
                stopWatch.stop();
                log.info("========== {} \u7ed3\u675f ==========", (Object)taskName);
                XxlJobHelper.log((String)"========== {} \u7ed3\u675f ==========", (Object[])new Object[]{taskName});
                log.info("##### {} \u8017\u65f6\u7edf\u8ba1: {}ms #####", (Object)taskName, (Object)stopWatch.getTotalTimeMillis());
                XxlJobHelper.log((String)"##### {} \u8017\u65f6\u7edf\u8ba1: {}ms #####", (Object[])new Object[]{taskName, stopWatch.getTotalTimeMillis()});
                if (lockAcquired && lock.isHeldByCurrentThread()) {
                    lock.unlock();
                }
                return responseData3;
                {
                    catch (Throwable throwable) {
                        try {
                            stopWatch.stop();
                            log.info("========== {} \u7ed3\u675f ==========", (Object)taskName);
                            XxlJobHelper.log((String)"========== {} \u7ed3\u675f ==========", (Object[])new Object[]{taskName});
                            log.info("##### {} \u8017\u65f6\u7edf\u8ba1: {}ms #####", (Object)taskName, (Object)stopWatch.getTotalTimeMillis());
                            XxlJobHelper.log((String)"##### {} \u8017\u65f6\u7edf\u8ba1: {}ms #####", (Object[])new Object[]{taskName, stopWatch.getTotalTimeMillis()});
                            throw throwable;
                        }
                        catch (Exception e2) {
                            log.error("exception\uff1a", (Throwable)e2);
                            ResponseData responseData4 = ResponseData.fail((String)"\u6267\u884c\u5931\u8d25");
                            return responseData4;
                        }
                    }
                }
            }
            stopWatch.stop();
            log.info("========== {} \u7ed3\u675f ==========", (Object)taskName);
            XxlJobHelper.log((String)"========== {} \u7ed3\u675f ==========", (Object[])new Object[]{taskName});
            log.info("##### {} \u8017\u65f6\u7edf\u8ba1: {}ms #####", (Object)taskName, (Object)stopWatch.getTotalTimeMillis());
            XxlJobHelper.log((String)"##### {} \u8017\u65f6\u7edf\u8ba1: {}ms #####", (Object[])new Object[]{taskName, stopWatch.getTotalTimeMillis()});
            return responseData;
        }
        finally {
            if (lockAcquired && lock.isHeldByCurrentThread()) {
                lock.unlock();
            }
        }
    }

    @XxlJob(value="wandaPush_fswsErrorDataReturnLogTask")
    @GetMapping(value={"fswsErrorDataReturnLog"})
    public ResponseData<String> fswsErrorDataReturnLog() {
        return this.executePushTask("\u4e07\u8fbe\u4ed3\u6570\u636e\u63a8\u9001-\u5f02\u5e38\u6570\u636e\u9000\u56de\u8bb0\u5f55", () -> this.wandaPushFswsErrorDataReturnLogService.handData(WandaPushBaseService.OperationType.ADD));
    }

    @XxlJob(value="wandaPush_rhoDeviceDataTask")
    @GetMapping(value={"rhoDeviceDataPushToWanda"})
    public ResponseData<String> rhoDeviceDataPushToWanda() {
        return this.executePushTask("\u4e07\u8fbe\u4ed3\u6570\u636e\u63a8\u9001-rho\u8bbe\u5907\u6570\u636e", () -> this.rhoDevice2WandaService.handData(WandaPushBaseService.OperationType.ADD));
    }

    @XxlJob(value="wandaPush_rhoPlaceDataTask")
    @GetMapping(value={"rhoPlaceDataPushToWanda"})
    public ResponseData<String> rhoPlaceDataPushToWanda() {
        return this.executePushTask("\u4e07\u8fbe\u4ed3\u6570\u636e\u63a8\u9001-rho\u573a\u6240\u673a\u623f\u6570\u636e", () -> this.rhoPlace2WandaService.handData(WandaPushBaseService.OperationType.ADD));
    }

    @XxlJob(value="wandaPush_rhoCompanyDataPushToWanda")
    @GetMapping(value={"rhoCompanyDataPushToWanda"})
    public ResponseData<String> rhoCompanyDataPushToWanda() {
        return this.executePushTask("\u4e07\u8fbe\u4ed3\u6570\u636e\u63a8\u9001-rho\u9662\u533a\u6570\u636e", () -> this.company2WandaService.handData(WandaPushBaseService.OperationType.ADD));
    }

    @FunctionalInterface
    private static interface PushTask {
        public void execute() throws Exception;
    }
}

