/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.third.service.wanda.push;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HtmlUtil;
import cn.hutool.http.webservice.SoapClient;
import cn.smarthse.rho.core.framework.bootstrap.properties.SysProperties;
import cn.smarthse.rho.core.framework.utils.DateUtils;
import cn.smarthse.rho.modules.sys.model.wanda.base.WandaDto;
import cn.smarthse.rho.modules.sys.model.wanda.base.request.WandaRequestBody;
import cn.smarthse.rho.modules.sys.model.wanda.base.request.WandaRequestDataList;
import cn.smarthse.rho.modules.sys.model.wanda.base.request.WandaRequestHeader;
import cn.smarthse.rho.modules.sys.model.wanda.base.request.WandaRequestRequest;
import cn.smarthse.rho.modules.sys.model.wanda.base.request.WandaRequestRoot;
import cn.smarthse.rho.modules.sys.model.wanda.base.response.WandaResponseReport;
import cn.smarthse.rho.modules.sys.model.wanda.base.response.WandaResponseRoot;
import cn.smarthse.rho.modules.sys.model.wanda.base.response.WandaResponseSoapEnvelope;
import cn.smarthse.rho.modules.third.service.wanda.push.WandaPushBaseService;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.fasterxml.jackson.dataformat.xml.ser.ToXmlGenerator;
import com.github.pagehelper.PageInfo;
import com.xxl.job.core.context.XxlJobHelper;
import jakarta.annotation.Resource;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.smarthse.framework.exception.ServiceException;
import lombok.Generated;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class WandaPushBaseServiceImpl<T>
implements WandaPushBaseService<T> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WandaPushBaseServiceImpl.class);
    @Resource
    protected XmlMapper xmlMapper;
    @Resource
    private SysProperties sysProperties;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handData(WandaPushBaseService.OperationType optType) {
        boolean pageNum = true;
        int pageSize = 1000;
        WandaDto dto = this.fetchData(1, 1000, true, optType);
        int pageTotal = dto.getPageTotal();
        if (pageTotal == 0) {
            log.info(">>>>>>>>>> \u6ca1\u6709\u9700\u8981\u63a8\u9001\u7684\u6570\u636e <<<<<<<<<<");
            return;
        }
        log.info("##### \u603b\u5171 {} \u9875\u6570\u636e\u9700\u8981\u63a8\u9001 #####", (Object)pageTotal);
        int successPages = 0;
        int failPages = 0;
        for (int currentPage = 1; currentPage <= pageTotal; ++currentPage) {
            PageInfo pageInfo = (PageInfo)dto.getObject();
            if (CollUtil.isEmpty((Collection)pageInfo.getList())) {
                log.info("\u7b2c {} \u9875\u6ca1\u6709\u6570\u636e\uff0c\u8df3\u8fc7", (Object)currentPage);
                break;
            }
            try {
                log.info(">>>>>> \u5f00\u59cb\u63a8\u9001\u7b2c {} \u9875\u6570\u636e\uff0c\u5171 {} \u6761 <<<<<<", (Object)currentPage, (Object)pageInfo.getList().size());
                XxlJobHelper.log((String)">>>>>> \u5f00\u59cb\u63a8\u9001\u7b2c {} \u9875\u6570\u636e\uff0c\u5171 {} \u6761 <<<<<<", (Object[])new Object[]{currentPage, pageInfo.getList().size()});
                this.doPush(pageInfo, optType);
                ++successPages;
                log.info(">>>>>> \u7b2c {} \u9875\u6570\u636e\u63a8\u9001\u6210\u529f <<<<<<", (Object)currentPage);
                XxlJobHelper.log((String)">>>>>> \u7b2c {} \u9875\u6570\u636e\u63a8\u9001\u6210\u529f <<<<<<", (Object[])new Object[]{currentPage});
            }
            catch (Exception e) {
                ++failPages;
                log.error("!!!!!!!!! \u7b2c {} \u9875\u6570\u636e\u63a8\u9001\u5931\u8d25: {}", new Object[]{currentPage, e.getMessage(), e});
                XxlJobHelper.log((String)"\u7b2c {} \u9875\u6570\u636e\u63a8\u9001\u5931\u8d25: {}", (Object[])new Object[]{currentPage, e.getMessage()});
            }
            finally {
                if (CollUtil.isNotEmpty((Collection)pageInfo.getList())) {
                    pageInfo.getList().clear();
                }
            }
            dto = this.fetchData(1, 1000, false, optType);
        }
        log.info("##### \u4efb\u52a1\u7edf\u8ba1: \u603b\u9875\u6570={} \u6210\u529f\u9875\u6570={} \u5931\u8d25\u9875\u6570={} #####", new Object[]{pageTotal, successPages, failPages});
        XxlJobHelper.log((String)"\u4efb\u52a1\u7edf\u8ba1: \u603b\u9875\u6570={} \u6210\u529f\u9875\u6570={} \u5931\u8d25\u9875\u6570={}", (Object[])new Object[]{pageTotal, successPages, failPages});
    }

    private WandaDto fetchData(Integer pageNum, Integer pageSize, boolean count, WandaPushBaseService.OperationType optType) {
        PageInfo pageInfo;
        WandaDto dto = new WandaDto();
        if (optType == WandaPushBaseService.OperationType.ADD) {
            pageInfo = this.getAddData(pageNum, pageSize, count);
        } else if (optType == WandaPushBaseService.OperationType.UPDATE) {
            pageInfo = this.getUpdateData(pageNum, pageSize, count);
        } else if (optType == WandaPushBaseService.OperationType.DELETE) {
            pageInfo = this.getDeleteData(pageNum, pageSize, count);
        } else {
            throw new ServiceException("\u53c2\u6570\u4e0d\u5408\u6cd5");
        }
        if (count) {
            if (Objects.isNull(pageInfo)) {
                dto.setPageTotal(Integer.valueOf(0));
            } else {
                dto.setPageTotal(Integer.valueOf(pageInfo.getPages()));
            }
        }
        dto.setObject(pageInfo);
        return dto;
    }

    private void doPush(PageInfo<T> pageInfo, WandaPushBaseService.OperationType optType) {
        if (Objects.nonNull(pageInfo) && CollUtil.isNotEmpty((Collection)pageInfo.getList())) {
            WandaResponseRoot root;
            String xml;
            List list = pageInfo.getList();
            WandaRequestHeader header = new WandaRequestHeader();
            String msgId = UUID.randomUUID().toString();
            header.setMsgId(msgId);
            header.setAction("push");
            String dateTime = DateUtils.formatDateTime((Date)new Date());
            header.setSendTime(dateTime);
            String records = String.valueOf(list.size());
            header.setRecords(records);
            header.setPageSum(String.valueOf(pageInfo.getPages()));
            header.setPageSize(String.valueOf(pageInfo.getPageSize()));
            header.setPageNum(String.valueOf(pageInfo.getPageNum()));
            WandaRequestDataList dataList = new WandaRequestDataList(list);
            WandaRequestBody body = new WandaRequestBody(dataList);
            WandaRequestRequest requestRequest = new WandaRequestRequest(header, body);
            try {
                this.xmlMapper.configure(ToXmlGenerator.Feature.WRITE_XML_DECLARATION, true);
                this.xmlMapper.configure(ToXmlGenerator.Feature.WRITE_XML_1_1, true);
                xml = this.xmlMapper.writeValueAsString((Object)new WandaRequestRoot(requestRequest));
            }
            catch (Exception e) {
                log.error("[\u63a8\u9001\u5931\u8d25] xml\u5e8f\u5217\u5316\u9636\u6bb5\u5f02\u5e38\uff1a", (Throwable)e);
                XxlJobHelper.log((String)"[\u63a8\u9001\u5931\u8d25] xml\u5e8f\u5217\u5316\u9636\u6bb5\u5f02\u5e38\uff1a{}", (Object[])new Object[]{e.getMessage()});
                return;
            }
            String signDate = DateUtils.format((Date)new Date(), (String)"yyyyMMdd");
            String plaintext = this.appKey().concat(signDate).concat(this.sysProperties.getWandaAppSecret());
            String signText = DigestUtils.md5Hex((String)plaintext);
            String urlSuffixStr = "&appkey=" + this.appKey() + "&strtime=" + signDate + "&sign=" + signText;
            String xmlStr = SoapClient.create((String)this.sysProperties.getWandaPullUrl().concat(urlSuffixStr)).setMethod("ws:dataReceiveService", "http://ws.databus.wondersgroup.com/").setParam("arg0", (Object)msgId, false).setParam("arg1", (Object)this.appKey(), false).setParam("arg2", (Object)dateTime, false).setParam("arg3", (Object)records, false).setParam("arg4", (Object)"XML", false).setParam("arg5", (Object)this.dataKey(), false).setParam("arg6", (Object)xml, false).setParam("arg7", (Object)optType.getValue(), false).setParam("arg8", (Object)DigestUtils.md5Hex((String)(this.appKey() + dateTime + this.appSecret())), false).send();
            if (StrUtil.isBlank((CharSequence)xmlStr)) {
                log.error("[\u63a8\u9001\u8b66\u544a] \u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a");
                XxlJobHelper.log((String)"[\u63a8\u9001\u8b66\u544a] \u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a", (Object[])new Object[0]);
                return;
            }
            try {
                if (log.isDebugEnabled()) {
                    log.debug("\u4e07\u8fbe\u4ed3\u63a5\u53e3\u8fd4\u56dexmlStr=={}", (Object)xmlStr);
                }
                WandaResponseSoapEnvelope soapEnvelope = (WandaResponseSoapEnvelope)this.xmlMapper.readValue(xmlStr, WandaResponseSoapEnvelope.class);
                if (log.isDebugEnabled()) {
                    log.debug("\u4e07\u8fbe\u4ed3\u63a5\u53e3\u8fd4\u56desoapEnvelope=={}", (Object)soapEnvelope);
                }
                root = (WandaResponseRoot)this.xmlMapper.readValue(HtmlUtil.unescape((String)soapEnvelope.getBody().getDataReceiveServiceResponse().getReturnStr()), WandaResponseRoot.class);
                if (log.isDebugEnabled()) {
                    log.debug("\u4e07\u8fbe\u4ed3\u63a5\u53e3\u8fd4\u56deroot=={}", (Object)this.xmlMapper.writeValueAsString((Object)root));
                }
            }
            catch (Exception e) {
                log.error("[\u63a8\u9001\u5931\u8d25] xml\u89e3\u6790\u8fd4\u56de\u7ed3\u679c\u9636\u6bb5\u5f02\u5e38\uff1a", (Throwable)e);
                XxlJobHelper.log((String)"[\u63a8\u9001\u5931\u8d25] xml\u89e3\u6790\u8fd4\u56de\u7ed3\u679c\u9636\u6bb5\u5f02\u5e38\uff1a{}", (Object[])new Object[]{e.getMessage()});
                return;
            }
            if (Objects.nonNull(root)) {
                log.error("[\u63a8\u9001\u7ed3\u675f] \u54cd\u5e94\uff1a{}", (Object)root.getResponse());
                XxlJobHelper.log((String)"[\u63a8\u9001\u7ed3\u675f] \u54cd\u5e94\uff1a{}", (Object[])new Object[]{root.getResponse()});
                HashSet<String> failIdSet = new HashSet<String>();
                if (!"200".equals(root.getResponse().getCode())) {
                    WandaResponseReport report = root.getResponse().getReport();
                    if (Objects.nonNull(report) && StrUtil.isNotBlank((CharSequence)report.getFailKeys())) {
                        String[] split;
                        log.error("[\u90e8\u5206\u63a8\u9001\u5931\u8d25] \u9519\u8bef\u54cd\u5e94\uff1a{}", (Object)root.getResponse());
                        XxlJobHelper.log((String)"[\u90e8\u5206\u63a8\u9001\u5931\u8d25] \u9519\u8bef\u54cd\u5e94\uff1a{}", (Object[])new Object[]{root.getResponse()});
                        String failKeys = report.getFailKeys();
                        for (String s : split = failKeys.substring(1, failKeys.length() - 1).split(",")) {
                            String id = s.split(":")[1];
                            failIdSet.add(id);
                        }
                        log.error("[\u90e8\u5206\u63a8\u9001\u5931\u8d25] \u5931\u8d25ID\u6570\u91cf: {}\uff0c\u5931\u8d25\u7684ID\u5217\u8868: {}", (Object)failIdSet.size(), failIdSet);
                        XxlJobHelper.log((String)"[\u90e8\u5206\u63a8\u9001\u5931\u8d25] \u5931\u8d25ID\u6570\u91cf: {}\uff0c\u5931\u8d25\u7684ID\u5217\u8868: {}", (Object[])new Object[]{failIdSet.size(), failIdSet});
                    } else {
                        log.error("[\u63a8\u9001\u5931\u8d25] \u9519\u8bef\u54cd\u5e94\uff1a{}", (Object)root.getResponse());
                        XxlJobHelper.log((String)"[\u63a8\u9001\u5931\u8d25] \u9519\u8bef\u54cd\u5e94\uff1a{}", (Object[])new Object[]{root.getResponse()});
                        return;
                    }
                }
                this.setSuccessData(list);
                if (CollUtil.isNotEmpty(failIdSet)) {
                    this.setFailDataById(failIdSet);
                }
            }
        }
    }

    private void cleanInvalidXmlCharsInList(List<T> list) {
        for (T item : list) {
            this.cleanInvalidXmlCharsInObject(item);
        }
    }

    private void cleanInvalidXmlCharsInObject(Object obj) {
        if (obj == null) {
            return;
        }
        try {
            Field[] fields;
            Class<?> clazz = obj.getClass();
            for (Field field : fields = clazz.getDeclaredFields()) {
                field.setAccessible(true);
                Object value = field.get(obj);
                if (value instanceof String) {
                    String cleanedValue = this.cleanInvalidXmlChars((String)value);
                    field.set(obj, cleanedValue);
                    continue;
                }
                if (value == null || this.isPrimitiveOrWrapper(value.getClass())) continue;
                this.cleanInvalidXmlCharsInObject(value);
            }
        }
        catch (Exception e) {
            log.warn("\u6e05\u7406\u5bf9\u8c61\u975e\u6cd5\u5b57\u7b26\u65f6\u53d1\u751f\u5f02\u5e38: {}", (Object)e.getMessage());
        }
    }

    private boolean isPrimitiveOrWrapper(Class<?> clazz) {
        return clazz.isPrimitive() || clazz == String.class || clazz == Boolean.class || clazz == Character.class || clazz == Byte.class || clazz == Short.class || clazz == Integer.class || clazz == Long.class || clazz == Float.class || clazz == Double.class || clazz == Date.class || clazz.isEnum();
    }

    private String cleanInvalidXmlChars(String input) {
        if (input == null || input.isEmpty()) {
            return input;
        }
        StringBuilder cleaned = new StringBuilder();
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (!(c >= ' ' && c <= '\ud7ff' || c >= '\ue000' && c <= '\ufffd' || c >= '\u10000' && c <= '\u10ffff' || c == '\t' || c == '\n') && c != '\r') continue;
            cleaned.append(c);
        }
        return cleaned.toString();
    }
}

