/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.third.service.wanda.push;

import cn.hutool.core.collection.CollUtil;
import cn.smarthse.rho.modules.sys.enums.company.EdeviceTypeEnum;
import cn.smarthse.rho.modules.sys.model.wanda.push.param.WandaRhoDevicePushInfo;
import cn.smarthse.rho.modules.sys.utils.NeutronNameUtil;
import cn.smarthse.rho.modules.third.dao.wanda.RhoDeviceDatabaseMapper;
import cn.smarthse.rho.modules.third.service.wanda.push.WandaPushBaseServiceImpl;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RhoDevice2WandaServiceImpl
extends WandaPushBaseServiceImpl<WandaRhoDevicePushInfo> {
    @Autowired
    RhoDeviceDatabaseMapper deviceDatabaseMapper;

    @Override
    public String appKey() {
        return "h211b3";
    }

    @Override
    public String appSecret() {
        return "a2400002c0c04cffac05e2fc2e7a187e";
    }

    @Override
    public String dataKey() {
        return "RHO_DEVICE_ID";
    }

    @Override
    public PageInfo<WandaRhoDevicePushInfo> getAddData(Integer pageNum, Integer pageSize, boolean count) {
        PageHelper.startPage((int)pageNum, (int)pageSize, (boolean)count);
        List<WandaRhoDevicePushInfo> list = this.deviceDatabaseMapper.listRhoDeviceData();
        if (CollUtil.isNotEmpty(list)) {
            list.forEach(item -> {
                Integer type = Integer.parseInt(item.getType());
                if (type.equals(EdeviceTypeEnum.SOURCE_NON_SEALED.getValue()) || type.equals(EdeviceTypeEnum.SOURCE_SEALED.getValue())) {
                    item.setName(NeutronNameUtil.originalName2MontageName((String)item.getName()));
                }
            });
        }
        return new PageInfo(list);
    }

    @Override
    public PageInfo<WandaRhoDevicePushInfo> getUpdateData(Integer pageNum, Integer pageSize, boolean count) {
        return null;
    }

    @Override
    public PageInfo<WandaRhoDevicePushInfo> getDeleteData(Integer pageNum, Integer pageSize, boolean count) {
        return null;
    }

    @Override
    public void setSuccessData(List<WandaRhoDevicePushInfo> list) {
        List<String> successIdList = list.stream().map(WandaRhoDevicePushInfo::getRhoDeviceId).collect(Collectors.toList());
        if (CollUtil.isNotEmpty(successIdList)) {
            this.deviceDatabaseMapper.updateRhoDeviceSuccess(successIdList);
        }
    }

    @Override
    public void setFailDataById(Set<String> failIdSet) {
        if (CollUtil.isNotEmpty(failIdSet)) {
            this.deviceDatabaseMapper.updateRhoDeviceException(failIdSet);
        }
    }
}

