/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.third.service.room.impl;

import cn.hutool.core.util.StrUtil;
import cn.smarthse.framework.mybatisPlus.service.impl.ServiceImpl;
import cn.smarthse.framework.redis.utils.RedisUtils;
import cn.smarthse.rho.core.framework.model.BaseEntity;
import cn.smarthse.rho.modules.sys.entity.b.BCompany;
import cn.smarthse.rho.modules.sys.entity.e.EMachineRoom;
import cn.smarthse.rho.modules.sys.model.b.param.CompanySyncParam;
import cn.smarthse.rho.modules.sys.model.r.vo.GenRiskAboutPlaceVo;
import cn.smarthse.rho.modules.sys.model.third.param.SearchMachineRoomParam;
import cn.smarthse.rho.modules.sys.model.third.param.ThirdMachineRoomDto;
import cn.smarthse.rho.modules.sys.model.third.vo.ThirdMachineRoomVo;
import cn.smarthse.rho.modules.sys.provider.wp.IWholeProcessCMProvider;
import cn.smarthse.rho.modules.third.converter.MachineRoomCommonConverter;
import cn.smarthse.rho.modules.third.dao.room.EMachineRoomThirdMapper;
import cn.smarthse.rho.modules.third.service.room.IEMachineRoomThirdService;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.redisson.api.RLock;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
@Transactional(readOnly=true)
public class EMachineRoomThirdServiceImpl
extends ServiceImpl<EMachineRoomThirdMapper, EMachineRoom>
implements IEMachineRoomThirdService {
    private final MachineRoomCommonConverter machineRoomConverter;
    @DubboReference
    private IWholeProcessCMProvider wholeProcessCMProvider;

    @Override
    public List<GenRiskAboutPlaceVo> searchRoomForPlaceRiskTask() {
        return ((EMachineRoomThirdMapper)this.baseMapper).selectAllForPlaceRiskTask();
    }

    @Override
    public List<ThirdMachineRoomVo> getMachineRoomForThird(SearchMachineRoomParam param) {
        HashSet<ThirdMachineRoomVo> rst = new HashSet<ThirdMachineRoomVo>();
        if (!CollectionUtils.isEmpty((Collection)param.getUniqueCodeList())) {
            rst.addAll(((EMachineRoomThirdMapper)this.baseMapper).selectAllMachineRoomByUniqueCode(param));
        }
        if (!CollectionUtils.isEmpty((Collection)param.getMachineRoomNameList())) {
            rst.addAll(((EMachineRoomThirdMapper)this.baseMapper).selectAllMachineRoomByMachineRoomName(param));
        }
        if (CollectionUtils.isEmpty(rst)) {
            return null;
        }
        return new ArrayList<ThirdMachineRoomVo>(rst);
    }

    @Override
    @Transactional
    public List<ThirdMachineRoomDto> addMachineRoomForThird(List<ThirdMachineRoomDto> paramList) {
        if (CollectionUtils.isEmpty(paramList)) {
            return null;
        }
        ArrayList<ThirdMachineRoomDto> rst = new ArrayList<ThirdMachineRoomDto>();
        for (ThirdMachineRoomDto machineRoomDto : paramList) {
            CompanySyncParam companySyncParam = new CompanySyncParam();
            companySyncParam.setMedicalNucode(machineRoomDto.getUniqueCode());
            BCompany company = this.wholeProcessCMProvider.getAndSyncSingleCm(companySyncParam);
            if (company == null) continue;
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.eq(EMachineRoom::getName, (Object)machineRoomDto.getName())).eq(EMachineRoom::getCid, (Object)company.getId())).eq(BaseEntity::getIsValid, (Object)1)).last("limit 1");
            EMachineRoom dbMachineRoom = (EMachineRoom)this.getOne((Wrapper)queryWrapper);
            if (dbMachineRoom != null) continue;
            EMachineRoom machineRoom = this.addMachineRoomDetailLock(machineRoomDto, company);
            rst.add(this.machineRoomConverter.entity2ThirdDto(machineRoom));
        }
        return rst;
    }

    @Override
    @Transactional
    public void genOutId() {
        List<EMachineRoom> roomList = ((EMachineRoomThirdMapper)this.baseMapper).listEMachineRoomForGenOutId();
        for (EMachineRoom entity : roomList) {
            if (StrUtil.isNotBlank((CharSequence)entity.getOutId())) continue;
            entity.setOutId(IdWorker.get32UUID());
            LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
            ((LambdaUpdateWrapper)updateWrapper.set(EMachineRoom::getOutId, (Object)entity.getOutId())).eq(EMachineRoom::getId, (Object)entity.getId());
            this.update((Wrapper)updateWrapper);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional
    public EMachineRoom addMachineRoomDetailLock(ThirdMachineRoomDto machineRoomDto, BCompany company) {
        EMachineRoom machineRoom = this.machineRoomConverter.thirdDto2Entity(machineRoomDto);
        String lock_key = "genMachineRoomSerialNoForThird";
        RLock lock = RedisUtils.getClient().getLock(lock_key);
        try {
            if (lock.tryLock(2L, TimeUnit.MINUTES)) {
                machineRoom.setId(null);
                machineRoom.setCid(company.getId());
                machineRoom.setLicenseStatus(Integer.valueOf(0));
                machineRoom.setLicenseStatusType(Integer.valueOf(0));
                machineRoom.setWarningStatus(Integer.valueOf(0));
                String medicalNucode = machineRoomDto.getUniqueCode();
                Integer maxSerialNo = ((EMachineRoomThirdMapper)this.baseMapper).getMaxSerialNoByMedicalNucode(medicalNucode);
                if (maxSerialNo == null) {
                    maxSerialNo = 0;
                }
                int newSerialNo = maxSerialNo + 1;
                machineRoom.setRoomCode(medicalNucode + String.format("%06d", newSerialNo));
                machineRoom.setSerialNo(Integer.valueOf(newSerialNo));
                this.save(machineRoom);
                EMachineRoom eMachineRoom = machineRoom;
                return eMachineRoom;
            }
        }
        catch (Exception e) {
            this.log.error("exception \uff1a{}", (Throwable)e);
        }
        finally {
            lock.unlock();
        }
        return machineRoom;
    }

    @Generated
    public EMachineRoomThirdServiceImpl(MachineRoomCommonConverter machineRoomConverter) {
        this.machineRoomConverter = machineRoomConverter;
    }
}

