/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.third.service.room.impl;

import cn.hutool.core.date.DateUtil;
import cn.smarthse.framework.mybatisPlus.service.impl.ServiceImpl;
import cn.smarthse.rho.modules.sys.entity.d.DLocationCheck;
import cn.smarthse.rho.modules.sys.entity.wanda.FswsErrorDataReturnLog;
import cn.smarthse.rho.modules.sys.enums.wanda.FswsErrorDataErrTypeEnum;
import cn.smarthse.rho.modules.sys.enums.wanda.FswsErrorDataTableTypeEnum;
import cn.smarthse.rho.modules.sys.enums.wanda.WandaDataDealTypeEnum;
import cn.smarthse.rho.modules.sys.enums.wanda.WandaoptTypeEnum;
import cn.smarthse.rho.modules.sys.model.wanda.sync.param.WandaSyncParam;
import cn.smarthse.rho.modules.sys.model.wanda.sync.vo.WandaFswsPlaceCheckVo;
import cn.smarthse.rho.modules.third.dao.room.DLocationCheckMapper;
import cn.smarthse.rho.modules.third.service.room.IDLocationCheckService;
import cn.smarthse.rho.modules.third.service.wanda.sync.IFswsErrorDataReturnLogService;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
@Transactional(readOnly=true)
public class DLocationCheckServiceImpl
extends ServiceImpl<DLocationCheckMapper, DLocationCheck>
implements IDLocationCheckService {
    @Autowired
    private IFswsErrorDataReturnLogService errorDataReturnLogService;

    @Override
    @Transactional
    public void updateLatestFlag() {
        ((DLocationCheckMapper)this.baseMapper).updateLatestFlag();
    }

    @Transactional
    public void addOrUpdateListData(List<WandaFswsPlaceCheckVo> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        this.executeBatch(list, (sqlSession, entity) -> ((DLocationCheckMapper)sqlSession.getMapper(DLocationCheckMapper.class)).addOrUpdateListData((WandaFswsPlaceCheckVo)entity));
    }

    @Override
    @Transactional
    public void updateAfterSync(WandaSyncParam syncParam) {
        ((DLocationCheckMapper)this.baseMapper).updateAfterSync(syncParam);
    }

    @Override
    public PageInfo<WandaFswsPlaceCheckVo> getPlaceCheckSyncDataFromWanda(WandaSyncParam param) {
        PageHelper.startPage((int)param.getPage(), (int)param.getLimit(), (boolean)param.getCount());
        return new PageInfo(((DLocationCheckMapper)this.baseMapper).getPlaceCheckSyncDataFromWanda(param));
    }

    @Override
    @Transactional
    public void syncDataMain(WandaSyncParam param) {
        ArrayList<WandaFswsPlaceCheckVo> finalList = new ArrayList<WandaFswsPlaceCheckVo>();
        ArrayList<WandaFswsPlaceCheckVo> syncExceptionList = new ArrayList<WandaFswsPlaceCheckVo>();
        int pages = 0;
        do {
            PageInfo<WandaFswsPlaceCheckVo> page = this.getPlaceCheckSyncDataFromWanda(param);
            if (pages == 0) {
                pages = page.getPages();
            }
            if (page.getSize() > 0) {
                this.checkData(page.getList(), finalList, syncExceptionList);
                this.addOrUpdateListData(finalList);
                this.dealExceptionData(syncExceptionList);
                finalList.clear();
                syncExceptionList.clear();
                page.getList().clear();
            }
            param.setPage(param.getPage() + 1);
            param.setCount(Boolean.valueOf(false));
        } while (param.getPage() <= pages);
    }

    public void dealExceptionData(List<WandaFswsPlaceCheckVo> syncExceptionList) {
        if (CollectionUtils.isEmpty(syncExceptionList)) {
            return;
        }
        ArrayList<FswsErrorDataReturnLog> exceptionList = new ArrayList<FswsErrorDataReturnLog>();
        syncExceptionList.forEach(item -> {
            FswsErrorDataReturnLog exception = new FswsErrorDataReturnLog();
            exception.setId(IdWorker.getIdStr());
            exception.setTableType(FswsErrorDataTableTypeEnum.FSWS_DEVICE_CHECK.getName());
            exception.setErrType(item.getDataErrType());
            exception.setReason(item.getDataErrDesc());
            exceptionList.add(exception);
        });
        this.errorDataReturnLogService.saveBatch(exceptionList);
    }

    public void checkData(List<WandaFswsPlaceCheckVo> list, List<WandaFswsPlaceCheckVo> finalList, List<WandaFswsPlaceCheckVo> syncFailData) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.forEach(item -> {
            item.setId(Long.valueOf(IdWorker.getId()));
            this.baseColumnsCheck((WandaFswsPlaceCheckVo)item);
            this.businessColumns((WandaFswsPlaceCheckVo)item);
            if (!StringUtils.isBlank((CharSequence)item.getDataErrDesc())) {
                item.setSyncErrType(Integer.valueOf(WandaDataDealTypeEnum.ERROR.getCode()));
                item.setDataErrType(Integer.valueOf(FswsErrorDataErrTypeEnum.FORMAT_ERROR.getCode()));
                syncFailData.add((WandaFswsPlaceCheckVo)item);
            } else {
                finalList.add((WandaFswsPlaceCheckVo)item);
            }
        });
    }

    private void baseColumnsCheck(WandaFswsPlaceCheckVo item) {
        StringBuilder dataErrDesc = new StringBuilder();
        if (item.getSourceId() == null) {
            dataErrDesc.append("\u4e3b\u952e[id]\u4e0d\u80fd\u4e3a\u7a7a\uff1b");
        }
        if (StringUtils.isBlank((CharSequence)item.getOrgName())) {
            dataErrDesc.append("\u68c0\u6d4b\u673a\u6784\u540d\u79f0[orgName]\u4e0d\u80fd\u4e3a\u7a7a\uff1b");
        }
        if (StringUtils.isBlank((CharSequence)item.getOrgCode())) {
            dataErrDesc.append("\u68c0\u6d4b\u673a\u6784\u4fe1\u7528\u4ee3\u7801[orgCode]\u4e0d\u80fd\u4e3a\u7a7a\uff1b");
        }
        if (StringUtils.isBlank((CharSequence)item.getHospitalName())) {
            dataErrDesc.append("\u653e\u5c04\u8bca\u7597\u673a\u6784\u540d\u79f0[hospitalName]\u4e0d\u80fd\u4e3a\u7a7a\uff1b");
        }
        if (StringUtils.isBlank((CharSequence)item.getHospitalCreditCode())) {
            dataErrDesc.append("\u653e\u5c04\u8bca\u7597\u673a\u6784\u4fe1\u7528\u4ee3\u7801[hospitalCreditCode]\u4e0d\u80fd\u4e3a\u7a7a\uff1b");
        }
        if (item.getZwyHospitalId() == null) {
            dataErrDesc.append("\u653e\u5c04\u8bca\u7597\u673a\u6784id[zwyHospitalId]\u4e0d\u80fd\u4e3a\u7a7a\uff1b");
        }
        if (StringUtils.isBlank((CharSequence)item.getCheckType())) {
            dataErrDesc.append("\u68c0\u6d4b\u7c7b\u578b[checkType]\u4e0d\u80fd\u4e3a\u7a7a\uff1b");
        }
        if (StringUtils.isBlank((CharSequence)item.getCheckTime())) {
            dataErrDesc.append("\u68c0\u6d4b\u65f6\u95f4[checkTime]\u4e0d\u80fd\u4e3a\u7a7a\uff1b");
        } else {
            try {
                DateUtil.parse((CharSequence)item.getCheckTime(), (String)"yyyy-MM-dd");
            }
            catch (Exception e) {
                dataErrDesc.append("\u68c0\u6d4b\u65f6\u95f4[checkTime]\u683c\u5f0f\u9519\u8bef\uff1b");
            }
        }
        if (StringUtils.isBlank((CharSequence)item.getReportName())) {
            dataErrDesc.append("\u68c0\u6d4b\u62a5\u544a\u540d\u79f0[reportName]\u4e0d\u80fd\u4e3a\u7a7a\uff1b");
        }
        if (StringUtils.isBlank((CharSequence)item.getReportNo())) {
            dataErrDesc.append("\u68c0\u6d4b\u62a5\u544a\u7f16\u53f7[reportNo]\u4e0d\u80fd\u4e3a\u7a7a\uff1b");
        }
        if (StringUtils.isBlank((CharSequence)item.getCheckNum())) {
            dataErrDesc.append("\u68c0\u6d4b\u8bbe\u5907\u6570\u91cf[checkNum]\u4e0d\u80fd\u4e3a\u7a7a\uff1b");
        }
        if (item.getFailNum() == null) {
            dataErrDesc.append("\u4e0d\u5408\u683c\u6570\u91cf[failNum]\u4e0d\u80fd\u4e3a\u7a7a\uff1b");
        }
        if (StringUtils.isBlank((CharSequence)item.getIsInfulenceReport())) {
            dataErrDesc.append("\u662f\u5426\u5f71\u54cd\u62a5\u544a[isInfulenceReport]\u4e0d\u80fd\u4e3a\u7a7a\uff1b");
        }
        if (StringUtils.isNotBlank((CharSequence)item.getIsInfulenceReport()) && item.getIsInfulenceReport().equals("1") && StringUtils.isBlank((CharSequence)item.getDealType())) {
            dataErrDesc.append("\u5904\u7406\u7c7b\u578b[dealType]\u4e0d\u80fd\u4e3a\u7a7a\uff1b");
        }
        if (StringUtils.isBlank((CharSequence)item.getOptType())) {
            dataErrDesc.append("\u64cd\u4f5c\u7c7b\u578b[optType]\u4e0d\u80fd\u4e3a\u7a7a\uff1b");
        }
        if (StringUtils.isNotBlank((CharSequence)item.getOptType()) && !item.getOptType().equals(WandaoptTypeEnum.ADD.getValue()) && item.getOldSourceId() == null) {
            dataErrDesc.append("\u65e7\u6e90ID[oldSourceId]\u4e0d\u80fd\u4e3a\u7a7a\uff1b");
        }
        if (StringUtils.isNotBlank((CharSequence)item.getOptType()) && !item.getOptType().equals(WandaoptTypeEnum.ADD.getValue()) && StringUtils.isBlank((CharSequence)item.getOptReason())) {
            dataErrDesc.append("\u64cd\u4f5c\u539f\u56e0[optReason]\u4e0d\u80fd\u4e3a\u7a7a\uff1b");
        }
        item.setDataErrDesc(dataErrDesc.toString());
    }

    private void businessColumns(WandaFswsPlaceCheckVo item) {
        StringBuilder dataErrDesc = new StringBuilder(item.getDataErrDesc());
        item.setDataErrDesc(dataErrDesc.toString());
    }
}

