/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.third.service.device.impl;

import cn.hutool.core.date.DateUtil;
import cn.smarthse.framework.mybatisPlus.service.impl.ServiceImpl;
import cn.smarthse.rho.modules.sys.entity.d.DDeviceCheck;
import cn.smarthse.rho.modules.sys.entity.wanda.FswsErrorDataReturnLog;
import cn.smarthse.rho.modules.sys.enums.wanda.FswsErrorDataErrTypeEnum;
import cn.smarthse.rho.modules.sys.enums.wanda.FswsErrorDataTableTypeEnum;
import cn.smarthse.rho.modules.sys.enums.wanda.WandaDataDealTypeEnum;
import cn.smarthse.rho.modules.sys.model.wanda.sync.param.WandaSyncParam;
import cn.smarthse.rho.modules.sys.model.wanda.sync.vo.WandaFswsDeviceCheckVo;
import cn.smarthse.rho.modules.third.dao.device.DDeviceCheckMapper;
import cn.smarthse.rho.modules.third.service.device.IDDeviceCheckService;
import cn.smarthse.rho.modules.third.service.wanda.sync.IFswsErrorDataReturnLogService;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
@Transactional(readOnly=true)
public class DDeviceCheckServiceImpl
extends ServiceImpl<DDeviceCheckMapper, DDeviceCheck>
implements IDDeviceCheckService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DDeviceCheckServiceImpl.class);
    @Autowired
    private IFswsErrorDataReturnLogService errorDataReturnLogService;

    @Override
    @Transactional
    public void updateLatestFlag() {
        ((DDeviceCheckMapper)this.baseMapper).updateLatestFlag();
    }

    @Transactional
    public void addOrUpdateListData(List<WandaFswsDeviceCheckVo> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        this.executeBatch(list, (sqlSession, entity) -> ((DDeviceCheckMapper)sqlSession.getMapper(DDeviceCheckMapper.class)).addOrUpdateListData((WandaFswsDeviceCheckVo)entity));
    }

    @Override
    @Transactional
    public void updateAfterSync(WandaSyncParam syncParam) {
        ((DDeviceCheckMapper)this.baseMapper).updateAfterSync(syncParam);
    }

    @Override
    public PageInfo<WandaFswsDeviceCheckVo> getDeviceCheckSyncDataFromWanda(WandaSyncParam param) {
        PageHelper.startPage((int)param.getPage(), (int)param.getLimit(), (boolean)param.getCount());
        return new PageInfo(((DDeviceCheckMapper)this.baseMapper).getDeviceCheckSyncDataFromWanda(param));
    }

    @Override
    @Transactional
    public void syncDataMain(WandaSyncParam param) {
        ArrayList<WandaFswsDeviceCheckVo> finalList = new ArrayList<WandaFswsDeviceCheckVo>();
        ArrayList<WandaFswsDeviceCheckVo> syncExceptionList = new ArrayList<WandaFswsDeviceCheckVo>();
        int pages = 0;
        do {
            PageInfo<WandaFswsDeviceCheckVo> page = this.getDeviceCheckSyncDataFromWanda(param);
            if (pages == 0) {
                pages = page.getPages();
            }
            if (page.getSize() > 0) {
                this.checkData(page.getList(), finalList, syncExceptionList);
                this.addOrUpdateListData(finalList);
                this.dealExceptionData(syncExceptionList);
                finalList.clear();
                syncExceptionList.clear();
                page.getList().clear();
            }
            param.setPage(param.getPage() + 1);
            param.setCount(Boolean.valueOf(false));
        } while (param.getPage() <= pages);
    }

    public void dealExceptionData(List<WandaFswsDeviceCheckVo> syncExceptionList) {
        if (CollectionUtils.isEmpty(syncExceptionList)) {
            return;
        }
        ArrayList<FswsErrorDataReturnLog> exceptionList = new ArrayList<FswsErrorDataReturnLog>();
        syncExceptionList.forEach(item -> {
            FswsErrorDataReturnLog exception = new FswsErrorDataReturnLog();
            exception.setId(IdWorker.get32UUID());
            exception.setTableType(String.valueOf(FswsErrorDataTableTypeEnum.FSWS_DEVICE_CHECK.getValue()));
            exception.setErrType(item.getDataErrType());
            exception.setReason(item.getDataErrDesc());
            exceptionList.add(exception);
        });
        this.errorDataReturnLogService.saveBatch(exceptionList);
    }

    public void checkData(List<WandaFswsDeviceCheckVo> list, List<WandaFswsDeviceCheckVo> finalList, List<WandaFswsDeviceCheckVo> syncFailData) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.forEach(item -> {
            item.setId(Long.valueOf(IdWorker.getId()));
            this.baseColumnsCheck((WandaFswsDeviceCheckVo)item);
            this.businessColumns((WandaFswsDeviceCheckVo)item);
            if (!StringUtils.isBlank((CharSequence)item.getDataErrDesc())) {
                item.setSyncErrType(Integer.valueOf(WandaDataDealTypeEnum.ERROR.getCode()));
                item.setDataErrType(Integer.valueOf(FswsErrorDataErrTypeEnum.FORMAT_ERROR.getCode()));
                syncFailData.add((WandaFswsDeviceCheckVo)item);
            } else {
                finalList.add((WandaFswsDeviceCheckVo)item);
            }
        });
    }

    private void baseColumnsCheck(WandaFswsDeviceCheckVo item) {
        StringBuilder dataErrDesc = new StringBuilder();
        if (item.getSourceId() == null) {
            dataErrDesc.append("\u4e3b\u952e[id]\u4e0d\u80fd\u4e3a\u7a7a\uff1b");
        }
        if (StringUtils.isBlank((CharSequence)item.getOrgName())) {
            dataErrDesc.append("\u68c0\u6d4b\u673a\u6784\u540d\u79f0[orgName]\u4e0d\u80fd\u4e3a\u7a7a\uff1b");
        }
        if (StringUtils.isBlank((CharSequence)item.getOrgCode())) {
            dataErrDesc.append("\u68c0\u6d4b\u673a\u6784\u4fe1\u7528\u4ee3\u7801[orgCode]\u4e0d\u80fd\u4e3a\u7a7a\uff1b");
        }
        if (StringUtils.isBlank((CharSequence)item.getHospitalName())) {
            dataErrDesc.append("\u653e\u5c04\u8bca\u7597\u673a\u6784\u540d\u79f0[hospitalName]\u4e0d\u80fd\u4e3a\u7a7a\uff1b");
        }
        if (StringUtils.isBlank((CharSequence)item.getHospitalCreditCode())) {
            dataErrDesc.append("\u653e\u5c04\u8bca\u7597\u673a\u6784\u4fe1\u7528\u4ee3\u7801[hospitalCreditCode]\u4e0d\u80fd\u4e3a\u7a7a\uff1b");
        }
        if (item.getZwyHospitalId() == null) {
            dataErrDesc.append("\u653e\u5c04\u8bca\u7597\u673a\u6784id[zwyHospitalId]\u4e0d\u80fd\u4e3a\u7a7a\uff1b");
        }
        if (StringUtils.isBlank((CharSequence)item.getCheckType())) {
            dataErrDesc.append("\u68c0\u6d4b\u7c7b\u578b[checkType]\u4e0d\u80fd\u4e3a\u7a7a\uff1b");
        }
        if (StringUtils.isBlank((CharSequence)item.getCheckTime())) {
            dataErrDesc.append("\u68c0\u6d4b\u65f6\u95f4[checkTime]\u4e0d\u80fd\u4e3a\u7a7a\uff1b");
        } else {
            try {
                DateUtil.parse((CharSequence)item.getCheckTime(), (String)"yyyy-MM-dd");
            }
            catch (Exception e) {
                dataErrDesc.append("\u68c0\u6d4b\u65f6\u95f4[checkTime]\u683c\u5f0f\u9519\u8bef\uff1b");
            }
        }
        if (StringUtils.isBlank((CharSequence)item.getCheckNum())) {
            dataErrDesc.append("\u68c0\u6d4b\u8bbe\u5907\u6570\u91cf[checkNum]\u4e0d\u80fd\u4e3a\u7a7a\uff1b");
        }
        if (item.getFailNum() == null) {
            dataErrDesc.append("\u4e0d\u5408\u683c\u6570\u91cf[failNum]\u4e0d\u80fd\u4e3a\u7a7a\uff1b");
        }
        if (!StringUtils.isBlank((CharSequence)item.getCvaProjReportTime())) {
            try {
                DateUtil.parse((CharSequence)item.getCvaProjReportTime(), (String)"yyyy-MM-dd");
            }
            catch (Exception e) {
                dataErrDesc.append("\u63a7\u8bc4\u62a5\u544a\u51fa\u5177\u65f6\u95f4[cvaProjReportTime]\u683c\u5f0f\u9519\u8bef\uff1b");
            }
        }
        if (StringUtils.isBlank((CharSequence)item.getIsInfulenceReport())) {
            dataErrDesc.append("\u662f\u5426\u5f71\u54cd\u62a5\u544a[isInfulenceReport]\u4e0d\u80fd\u4e3a\u7a7a\uff1b");
        }
        if (StringUtils.isNotBlank((CharSequence)item.getIsInfulenceReport()) && item.getIsInfulenceReport().equals("1") && StringUtils.isBlank((CharSequence)item.getDealType())) {
            dataErrDesc.append("\u5904\u7406\u7c7b\u578b[dealType]\u4e0d\u80fd\u4e3a\u7a7a\uff1b");
        }
        if (StringUtils.isBlank((CharSequence)item.getOptType())) {
            dataErrDesc.append("\u64cd\u4f5c\u7c7b\u578b[optType]\u4e0d\u80fd\u4e3a\u7a7a\uff1b");
        }
        item.setDataErrDesc(dataErrDesc.toString());
    }

    private void businessColumns(WandaFswsDeviceCheckVo item) {
        StringBuilder dataErrDesc = new StringBuilder(item.getDataErrDesc());
        item.setDataErrDesc(dataErrDesc.toString());
    }
}

