/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.third.manager.hc.v2;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.date.LocalDateTimeUtil;
import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.StrUtil;
import cn.smarthse.rho.modules.sys.entity.c.CHealthCheckData;
import cn.smarthse.rho.modules.sys.enums.health.HealthCheckSourceEnum;
import cn.smarthse.rho.modules.sys.model.wanda.sync.param.WandaHealthDataSyncParam;
import cn.smarthse.rho.modules.sys.model.wanda.sync.vo.HCSyncVo;
import cn.smarthse.rho.modules.third.dao.wanda.WandaHcMapper;
import cn.smarthse.rho.modules.third.service.b.IBCompanyService;
import cn.smarthse.rho.modules.third.service.c.ICHealthCheckDataService;
import cn.smarthse.rho.modules.third.service.wanda.sync.IFswsErrorDataReturnLogService;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import lombok.Generated;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class WandaFswsHealthCheckSyncManagerV22 {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WandaFswsHealthCheckSyncManagerV22.class);
    private final ICHealthCheckDataService healthCheckDataService;
    private final RedissonClient redissonClient;
    private final IBCompanyService companyService;
    private final IFswsErrorDataReturnLogService errorDataReturnLogService;
    private final WandaHcMapper wandaHcMapper;
    private static final String LOCK_KEY = "WandaFswsHealthCheckSyncManager";
    private static final String MAP_KEY_NEED_ADD_INFO = "MAP_KEY_NEED_ADD_INFO";
    private static final String MAP_KEY_NEED_UP_INFO = "MAP_KEY_NEED_UP_INFO";
    private static final String MAP_KEY_NEED_ADD_OR_UP_INFO = "MAP_KEY_NEED_ADD_OR_UP_INFO";
    private static final String MAP_KEY_NEED_DEL_INFO = "MAP_KEY_NEED_DEL_INFO";
    private static final String MAP_KEY_ERROR_INFO = "MAP_KEY_ERROR_INFO";
    private static final Integer DATA_DEAL_TYPE_IGNORE = 0;
    private static final Integer DATA_DEAL_TYPE_NORMAL = 1;
    private static final Integer DATA_DEAL_TYPE_ERROR = 2;
    private static final List conclusionList = List.of("1", "2", "3", "4");
    private static final int IS_ERROR_ZC = 0;
    private static final int IS_ERROR_YC = 1;
    private static final int IS_ERROR_YC_TB = 2;
    private static final int IS_ERROR_YC_UN_RAY = 3;
    private static final int RHO_DATA_TYPE_WBJ = 0;
    private static final int RHO_DATA_TYPE_ZC = 1;
    private static final int RHO_DATA_TYPE_YC = 2;
    private static final int RHO_DATA_TYPE_YC_TB = 3;
    private static final int RHO_DATA_TYPE_YC_UN_RAY = 4;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean syncBaseInfoData(WandaHealthDataSyncParam param) {
        log.debug("wanda.fsws_health_card \u4f53\u68c0\u6570\u636e\uff1a syncBaseInfoData() start");
        boolean flag = false;
        RLock lock = this.redissonClient.getLock("WandaFswsHealthCheckSyncManager_syncBaseInfoData");
        boolean resLock = false;
        try {
            resLock = lock.tryLock(1L, 18000L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        if (resLock) {
            try {
                this.syncBaseInfoDataLock(param);
                log.debug("wanda.fsws_health_card \u4f53\u68c0\u6570\u636e\uff1a syncBaseInfoData() end");
                flag = true;
            }
            catch (Exception e) {
                log.error("\u3010wanda\u6570\u636e\u540c\u6b65\u3011\u3010\u4f53\u68c0V22\u3011\u3010\u6574\u4f53\u3011\u5931\u8d25\uff0ce:{}", (Throwable)e);
                flag = false;
            }
            finally {
                lock.unlock();
            }
        } else {
            log.error("{}\uff1aPending lock timeout\uff0cmethod:syncBaseInfoData()", (Object)LOCK_KEY);
            flag = false;
        }
        return flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void syncBaseInfoDataLock(WandaHealthDataSyncParam param) {
        List limitCidList = param.getCidLimitList();
        int limitSize = 5000;
        boolean stopFlag = false;
        this.wandaHcMapper.updateAllRhoCompanyId(param);
        int start = 0;
        List<HCSyncVo> hcSyncInfoList;
        while (!CollUtil.isEmpty(hcSyncInfoList = this.wandaHcMapper.getHCSyncInfoList(0, limitSize, limitCidList))) {
            if (hcSyncInfoList.size() < limitSize) {
                stopFlag = true;
            }
            try {
                this.genList(hcSyncInfoList);
            }
            catch (Exception e) {
                log.error("\u3010wanda\u6570\u636e\u540c\u6b65\u3011\u3010\u4f53\u68c0V22\u3011\u3010\u90e8\u5206\u6279\u91cf\u3011\u5931\u8d25\uff0ce:{}", (Throwable)e);
            }
            finally {
                if (CollUtil.isNotEmpty(hcSyncInfoList)) {
                    hcSyncInfoList.clear();
                }
            }
            if (stopFlag) {
                return;
            }
            if (start >= 10) {
                return;
            }
            ++start;
        }
        return;
    }

    private void genList(List<HCSyncVo> hcList) {
        for (HCSyncVo vo : hcList) {
            vo.setIdcardCode(StrUtil.toUpperCase((CharSequence)vo.getIdcardCode()));
        }
        this.fillConclusion(hcList);
        this.checkData(hcList);
        Map<Integer, List<HCSyncVo>> hcListMap = hcList.stream().collect(Collectors.groupingBy(v -> v.getIsError()));
        ArrayList<HCSyncVo> commonHcList = hcListMap.get(0);
        List<HCSyncVo> errorHcList = hcListMap.get(1);
        List<HCSyncVo> error2HcList = hcListMap.get(2);
        List<HCSyncVo> error3HcList = hcListMap.get(3);
        ArrayList<HCSyncVo> arrayList = commonHcList = CollUtil.isNotEmpty(commonHcList) ? commonHcList : new ArrayList<HCSyncVo>();
        if (CollUtil.isNotEmpty(error2HcList)) {
            commonHcList.addAll(error2HcList);
        }
        if (CollUtil.isNotEmpty(commonHcList)) {
            for (HCSyncVo hcVo : commonHcList) {
                this.addOrUpdate(hcVo);
            }
        }
        if (CollUtil.isNotEmpty(commonHcList)) {
            for (HCSyncVo vo : commonHcList) {
                this.healthCheckDataService.syncCFactors(vo.getZwyId());
                this.healthCheckDataService.syncDiags(vo.getZwyId());
                this.healthCheckDataService.syncFactors(vo.getZwyId());
            }
        }
        if (CollUtil.isNotEmpty(errorHcList)) {
            for (HCSyncVo vo : errorHcList) {
                this.delError(vo);
            }
        }
        if (CollUtil.isNotEmpty(error3HcList)) {
            for (HCSyncVo vo : error3HcList) {
                this.delUnRayError(vo);
            }
        }
    }

    private void delError(HCSyncVo vo) {
        this.wandaHcMapper.updateSyncResult(vo.getZwyId(), 1, vo.getIsRepeatedRho() == 1 ? 2 : vo.getIsRepeatedRho(), 2);
    }

    private void delUnRayError(HCSyncVo vo) {
        this.wandaHcMapper.updateSyncResult(vo.getZwyId(), 1, vo.getIsRepeatedRho() == 1 ? 2 : vo.getIsRepeatedRho(), 4);
    }

    private void fillConclusion(List<HCSyncVo> hcList) {
        for (HCSyncVo hcVo : hcList) {
            String conclusion = this.wandaHcMapper.getConclusion(hcVo.getZwyId());
            hcVo.setCheckResultCode(conclusion);
        }
    }

    private void checkData(List<HCSyncVo> hcList) {
        for (HCSyncVo vo : hcList) {
            StringBuilder sb = new StringBuilder();
            StringBuilder sb2 = new StringBuilder();
            StringBuilder sb3 = new StringBuilder();
            if (StrUtil.isBlank((CharSequence)vo.getZwyId())) {
                sb.append("\u7f3a\u5c11id\u3002");
            }
            if (this.wandaHcMapper.getRayFactorNum(vo.getZwyId()) == 0) {
                sb3.append("\u8be5\u4f53\u68c0\u7f3a\u5c11\u653e\u5c04\u5371\u5bb3\u56e0\u7d20");
            }
            if (StrUtil.isBlank((CharSequence)vo.getName())) {
                sb.append("\u7f3a\u5c11\u59d3\u540d\u3002");
            }
            if (StrUtil.isBlank((CharSequence)vo.getIdcardType())) {
                sb.append("\u7f3a\u5c11\u8eab\u4efd\u8bc1\u4ef6\u7c7b\u522b\u3002");
            } else if (!StrUtil.isNumeric((CharSequence)vo.getIdcardType())) {
                sb.append("\u8eab\u4efd\u8bc1\u4ef6\u7c7b\u522b\u9519\u8bef\u3002");
            }
            if (StrUtil.isBlank((CharSequence)vo.getIdcardCode())) {
                sb.append("\u7f3a\u5c11\u8eab\u4efd\u8bc1\u4ef6\u53f7\u7801\u3002");
            }
            if (StrUtil.isBlank((CharSequence)vo.getSexCode())) {
                sb.append("\u7f3a\u5c11\u6027\u522b\u7f16\u7801\u3002");
            } else if (!vo.getSexCode().equals("1") && !vo.getSexCode().equals("2")) {
                sb.append("\u6027\u522b\u7f16\u7801\u9519\u8bef\u3002");
            }
            if (StrUtil.isBlank((CharSequence)vo.getBirthday())) {
                sb.append("\u7f3a\u5c11\u51fa\u751f\u65e5\u671f\u3002");
            } else {
                try {
                    DateUtil.parse((CharSequence)vo.getBirthday(), (String)"yyyy-MM-dd");
                }
                catch (Exception e) {
                    sb.append("\u51fa\u751f\u65e5\u671f\u683c\u5f0f\u9519\u8bef\u3002");
                }
            }
            if (StrUtil.isBlank((CharSequence)vo.getJobCode())) {
                sb.append("\u7f3a\u5c11\u5de5\u79cd\u7f16\u7801\u3002");
            }
            if (StrUtil.isBlank((CharSequence)vo.getRadiationType())) {
                sb2.append("\u7f3a\u5c11\u653e\u5c04\u5de5\u79cd\u7f16\u7801\u3002");
            }
            if (StrUtil.isBlank((CharSequence)vo.getOrgName())) {
                sb.append("\u7f3a\u5c11\u4f53\u68c0\u673a\u6784\u540d\u79f0\u3002");
            }
            if (StrUtil.isBlank((CharSequence)vo.getCheckType())) {
                sb.append("\u7f3a\u5c11\u68c0\u67e5\u7c7b\u578b\u3002");
            } else if (!NumberUtil.isNumber((CharSequence)vo.getCheckType())) {
                sb.append("\u68c0\u67e5\u7c7b\u578b\u9519\u8bef");
            }
            if (StrUtil.isBlank((CharSequence)vo.getBodyCheckType())) {
                sb.append("\u7f3a\u5c11\u4f53\u68c0\u7c7b\u578b\u7f16\u7801\u3002");
            } else if (!NumberUtil.isNumber((CharSequence)vo.getBodyCheckType())) {
                sb.append("\u4f53\u68c0\u7c7b\u578b\u7f16\u7801\u9519\u8bef");
            }
            if (StrUtil.isBlank((CharSequence)vo.getCheckResultCode())) {
                sb.append("\u7f3a\u5c11\u4e3b\u68c0\u7ed3\u8bba\u3002");
            } else if (!NumberUtil.isNumber((CharSequence)vo.getCheckResultCode())) {
                sb.append("\u4e3b\u68c0\u7ed3\u8bba\u9519\u8bef");
            }
            if (StrUtil.isBlank((CharSequence)vo.getSuggest())) {
                sb.append("\u7f3a\u5c11\u4e3b\u68c0\u5efa\u8bae\u3002");
            }
            if (StrUtil.isBlank((CharSequence)vo.getCheckTime())) {
                sb.append("\u7f3a\u5c11\u4f53\u68c0\u65e5\u671f\u3002");
            } else {
                try {
                    DateUtil.parse((CharSequence)vo.getCheckTime(), (String)"yyyy-MM-dd");
                }
                catch (Exception e) {
                    sb.append("\u4f53\u68c0\u65e5\u671f\u683c\u5f0f\u9519\u8bef\u3002");
                }
            }
            if (StrUtil.isBlank((CharSequence)vo.getWriteDate())) {
                sb.append("\u7f3a\u5c11\u62a5\u544a\u51fa\u5177\u65e5\u671f\u3002");
            } else {
                try {
                    DateUtil.parse((CharSequence)vo.getWriteDate(), (String)"yyyy-MM-dd");
                }
                catch (Exception e) {
                    sb.append("\u62a5\u544a\u51fa\u5177\u65e5\u671f\u683c\u5f0f\u9519\u8bef\u3002");
                }
            }
            if (StrUtil.isBlank((CharSequence)vo.getCreditCodeEmployer())) {
                sb.append("\u7f3a\u5c11\u653e\u5c04\u8bca\u7597\u673a\u6784\u540d\u79f0\u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\u3002");
            }
            if (StrUtil.isBlank((CharSequence)vo.getEmployerNameEmployer())) {
                sb.append("\u7f3a\u5c11\u653e\u5c04\u8bca\u7597\u673a\u6784\u540d\u79f0\u540d\u79f0\u3002");
            }
            if (sb3.length() > 0) {
                vo.setIsError(Integer.valueOf(3));
                vo.setErrorDes(sb3.toString());
                continue;
            }
            if (sb.length() > 0) {
                vo.setIsError(Integer.valueOf(1));
                vo.setErrorDes(sb.toString());
                log.error("\u3010\u4f53\u68c0\u6570\u636e\u540c\u6b65\u6821\u9a8c\u3011\u3010\u5f02\u5e38\u6570\u636e\u3011sourceId:{},errorDesc:{}", (Object)vo.getZwyId(), (Object)vo.getErrorDes());
                continue;
            }
            if (sb2.length() > 0) {
                vo.setIsError(Integer.valueOf(2));
                vo.setErrorDes(sb2.toString());
                continue;
            }
            vo.setIsError(Integer.valueOf(0));
        }
    }

    private void addOrUpdate(HCSyncVo vo) {
        CHealthCheckData db = this.healthCheckDataService.getByZwyIdIncludeDel(vo.getZwyId());
        if (db != null && db.getIsValid() == 0) {
            return;
        }
        CHealthCheckData entity = new CHealthCheckData();
        entity.setId(db == null ? null : db.getId());
        entity.setZwyId(vo.getZwyId());
        entity.setCid(vo.getCid());
        entity.setSource(HealthCheckSourceEnum.WANDA.getValue());
        entity.setName(vo.getName());
        entity.setTechName(vo.getOrgName());
        entity.setIdcardType(vo.getIdcardType());
        entity.setIdcard(vo.getIdcardCode());
        entity.setSex(Boolean.valueOf(vo.getSexCode().equals("1")));
        entity.setPost(vo.getJobCode());
        entity.setRaType(vo.getRadiationType());
        entity.setCheckType(Integer.valueOf(vo.getCheckType()));
        entity.setBodyCheckType(vo.getBodyCheckType());
        entity.setPreviousZwyId(vo.getPreviousCardId());
        entity.setOtherPostName(vo.getOtherJobName());
        entity.setSeniorityYear(vo.getSeniorityYear());
        entity.setSeniorityMonth(vo.getSeniorityMonth());
        entity.setResult(null);
        entity.setResultCode(vo.getCheckResultCode());
        entity.setConclusion(vo.getConclusion());
        entity.setSuggest(vo.getSuggest());
        entity.setCheckDate(LocalDateTimeUtil.parse((CharSequence)vo.getCheckTime(), (DateTimeFormatter)DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")).toLocalDate());
        entity.setReportDate(LocalDateTimeUtil.parse((CharSequence)vo.getWriteDate(), (DateTimeFormatter)DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")).toLocalDate());
        entity.setReportNo(vo.getWriteNo());
        entity.setCreditCodeEmployer(vo.getCreditCodeEmployer());
        entity.setEmployerNameEmployer(vo.getEmployerNameEmployer());
        entity.setAssessment(vo.getAdaptEvaluate());
        entity.setWandaLoadTime(vo.getLoadTime());
        entity.setWandaIsDel(Integer.valueOf(vo.getIsValid() == 1 ? 0 : 1));
        this.healthCheckDataService.saveOrUpdate(entity);
        int isConverted = 1;
        int isRepeated = vo.getIsRepeatedRho() == 1 ? 2 : vo.getIsRepeatedRho();
        int rhoDateType = vo.getIsError() == 2 ? 3 : 1;
        this.wandaHcMapper.updateSyncResult(vo.getZwyId(), isConverted, isRepeated, rhoDateType);
    }

    @Generated
    public WandaFswsHealthCheckSyncManagerV22(ICHealthCheckDataService healthCheckDataService, RedissonClient redissonClient, IBCompanyService companyService, IFswsErrorDataReturnLogService errorDataReturnLogService, WandaHcMapper wandaHcMapper) {
        this.healthCheckDataService = healthCheckDataService;
        this.redissonClient = redissonClient;
        this.companyService = companyService;
        this.errorDataReturnLogService = errorDataReturnLogService;
        this.wandaHcMapper = wandaHcMapper;
    }
}

