/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.third.manager.company;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import cn.smarthse.rho.modules.sys.entity.b.BCompany;
import cn.smarthse.rho.modules.sys.entity.wanda.FswsErrorDataReturnLog;
import cn.smarthse.rho.modules.sys.enums.company.BusinessStatusEnum;
import cn.smarthse.rho.modules.sys.enums.staff.CmSourceEnum;
import cn.smarthse.rho.modules.sys.enums.wanda.FswsErrorDataErrTypeEnum;
import cn.smarthse.rho.modules.sys.enums.wanda.FswsErrorDataTableTypeEnum;
import cn.smarthse.rho.modules.sys.enums.wanda.WandaoptTypeEnum;
import cn.smarthse.rho.modules.sys.model.b.param.BCompanyPushParam;
import cn.smarthse.rho.modules.sys.model.b.param.CompanySyncParam;
import cn.smarthse.rho.modules.sys.model.b.vo.CompanySyncFswsHospitalInfoVo;
import cn.smarthse.rho.modules.sys.provider.company.ICompanyPushProvider;
import cn.smarthse.rho.modules.third.service.b.IBCompanyService;
import cn.smarthse.rho.modules.third.service.wanda.sync.IFswsErrorDataReturnLogService;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class WandaFswsHospitalInfoSyncManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WandaFswsHospitalInfoSyncManager.class);
    @DubboReference
    private ICompanyPushProvider companyPushProvider;
    private final IBCompanyService companyService;
    private final RedissonClient redissonClient;
    private final IFswsErrorDataReturnLogService errorDataReturnLogService;
    private static final String LOCK_KEY = "WandaCmFswsHospitalInfoSyncManager";
    private static final String MAP_KEY_NEED_ADD_INFO = "MAP_KEY_NEED_ADD_INFO";
    private static final String MAP_KEY_NEED_UP_INFO = "MAP_KEY_NEED_UP_INFO";
    private static final String MAP_KEY_ERROR_INFO = "MAP_KEY_ERROR_INFO";
    private static final Integer DATA_DEAL_TYPE_IGNORE = 0;
    private static final Integer DATA_DEAL_TYPE_NORMAL = 1;
    private static final Integer DATA_DEAL_TYPE_ERROR = 2;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void syncBaseInfoData(CompanySyncParam param) {
        log.debug("wanda.fsws_hospital_info\u533b\u9662\uff1a syncBaseInfoData() start");
        StringBuilder sb = new StringBuilder(LOCK_KEY).append("_syncBaseInfoData");
        RLock lock = this.redissonClient.getLock(sb.toString());
        boolean resLock = false;
        try {
            resLock = lock.tryLock(1L, 240L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        if (resLock) {
            try {
                this.syncBaseInfoDataLock(param);
                log.debug("wanda.fsws_hospital_info\u533b\u9662\uff1a syncBaseInfoData() end");
            }
            catch (Exception e) {
                log.error("wanda.fsws_hospital_info\u533b\u9662\u5931\u8d25\uff1a{}", (Throwable)e);
            }
            finally {
                lock.unlock();
            }
        } else {
            log.error("{}\uff1aPending lock timeout\uff0cmethod:syncBaseInfoData()", (Object)LOCK_KEY);
        }
    }

    public void syncBaseInfoDataLock(CompanySyncParam param) {
        this.companyService.initFswsHospitalInfoNewest(param);
        List<CompanySyncFswsHospitalInfoVo> list = this.companyService.getNeedAddBaseInfoFromWandaFswsHospitalInfoTable(param);
        for (CompanySyncFswsHospitalInfoVo vo : list) {
            vo.setCreditCode(StrUtil.toUpperCase((CharSequence)StrUtil.trim((CharSequence)vo.getCreditCode())));
        }
        this.syncBaseInfoDataSub(list);
    }

    public void syncBaseInfoDataSub(List<CompanySyncFswsHospitalInfoVo> list) {
        if (CollUtil.isEmpty(list)) {
            log.debug("wanda.fsws_hospital_info\u533b\u9662\uff1a syncBaseInfoData() \u65e0\u6570\u636e\u53ef\u540c\u6b65");
            return;
        }
        Map<String, Object> infoMap = this.extractInfo(list);
        List needAddInfoList = (List)infoMap.get(MAP_KEY_NEED_ADD_INFO);
        List needUpInfoList = (List)infoMap.get(MAP_KEY_NEED_UP_INFO);
        List errorInfoList = (List)infoMap.get(MAP_KEY_ERROR_INFO);
        List<Long> needPushIdList1 = this.saveBaseInfo(needAddInfoList);
        List<Long> needPushIdList2 = this.upBaseInfo(needUpInfoList);
        ArrayList<Long> needPushIdList = new ArrayList<Long>();
        needPushIdList.addAll(needPushIdList1);
        needPushIdList.addAll(needPushIdList2);
        this.pushCompany(needPushIdList);
        this.dealErrorInfo(errorInfoList);
    }

    private void pushCompany(List<Long> needPushIdList) {
        for (Long id : needPushIdList) {
            BCompany db = (BCompany)this.companyService.getById(id);
            BCompanyPushParam param = new BCompanyPushParam();
            param.setCompany(db);
            param.setOptType(WandaoptTypeEnum.UPDATE.getValue());
            param.setOptReason("\u7ed1\u5b9a\u4e86\u804c\u4f4d\u4e91id");
            this.companyPushProvider.pushCompanyInfo(param);
        }
    }

    private Map<String, Object> extractInfo(List<CompanySyncFswsHospitalInfoVo> list) {
        ArrayList needAddList = new ArrayList();
        ArrayList needUpList = new ArrayList();
        ArrayList errorList = new ArrayList();
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put(MAP_KEY_NEED_ADD_INFO, needAddList);
        resultMap.put(MAP_KEY_NEED_UP_INFO, needUpList);
        resultMap.put(MAP_KEY_ERROR_INFO, errorList);
        for (CompanySyncFswsHospitalInfoVo vo : list) {
            this.extractOneInfo(vo, resultMap);
        }
        return resultMap;
    }

    private void extractOneInfo(CompanySyncFswsHospitalInfoVo vo, Map<String, Object> resultMap) {
        List needAddList = (List)resultMap.get(MAP_KEY_NEED_ADD_INFO);
        List needUpList = (List)resultMap.get(MAP_KEY_NEED_UP_INFO);
        List errorList = (List)resultMap.get(MAP_KEY_ERROR_INFO);
        if ((vo = this.checkData(vo)).getDataDealType() == DATA_DEAL_TYPE_ERROR) {
            errorList.add(vo);
            return;
        }
        String rhoHospitalId = vo.getRhoHospitalId();
        if (rhoHospitalId != null) {
            BCompany dbByRhoId = this.companyService.getByRhoHospitalIdIncludeDel(rhoHospitalId);
            if (dbByRhoId != null && dbByRhoId.getZwyHospitalId() == null) {
                BCompany entity = new BCompany();
                entity.setId(dbByRhoId.getId());
                entity.setZwyHospitalId(vo.getZwyHospitalId());
                needUpList.add(entity);
            }
            return;
        }
        if (rhoHospitalId == null) {
            BCompany dbNewestByNameAanCC = this.companyService.getNewestByNameAndCreditCodeIncludeDel(vo.getName(), vo.getCreditCode());
            BCompany dbNewestByName = this.companyService.getNewestByNameIncludeDel(vo.getName());
            if (dbNewestByNameAanCC != null && StrUtil.isBlank((CharSequence)dbNewestByNameAanCC.getZwyHospitalId())) {
                BCompany entity = new BCompany();
                entity.setId(dbNewestByName.getId());
                entity.setZwyHospitalId(vo.getZwyHospitalId());
                needUpList.add(entity);
                return;
            }
            if (dbNewestByNameAanCC == null && dbNewestByName == null) {
                BCompany entity = this.wandaSyncInfo2EntityForAdding(vo);
                needAddList.add(entity);
                return;
            }
        }
    }

    private BCompany wandaSyncInfo2EntityForAdding(CompanySyncFswsHospitalInfoVo vo) {
        BCompany entity = new BCompany();
        entity.setZwyHospitalId(vo.getZwyHospitalId());
        entity.setName(vo.getName());
        entity.setCreditCode(vo.getCreditCode());
        entity.setBusinessStatus(BusinessStatusEnum.NORMAL.getValue());
        entity.setAreaId(Long.valueOf(vo.getWorkAreaId()));
        entity.setAddress(vo.getWorkAddress());
        entity.setRegisteredAddress(vo.getRegisterAddress());
        entity.setRegisteredFullAddress(vo.getRegisterAddress());
        entity.setSyncTime(LocalDateTime.now());
        entity.setSource(CmSourceEnum.WAND_ZWY.getValue());
        entity.setWandaLoadTime(vo.getLoadTime());
        entity.setCreateBy(Long.valueOf(123456789L));
        return entity;
    }

    private CompanySyncFswsHospitalInfoVo checkData(CompanySyncFswsHospitalInfoVo vo) {
        StringBuilder sb = new StringBuilder();
        if (vo.getZwyHospitalId() == null) {
            sb.append("\u7f3a\u5c11\u804c\u536b\u4e91id\u3002");
        }
        if (StrUtil.isEmpty((CharSequence)vo.getName())) {
            sb.append("\u7f3a\u5c11\u540d\u79f0\u3002");
        }
        if (StrUtil.isEmpty((CharSequence)vo.getCreditCode())) {
            sb.append("\u7f3a\u5c11\u4fe1\u7528\u4ee3\u7801\u3002");
        }
        if (StrUtil.isEmpty((CharSequence)vo.getWorkAddress())) {
            sb.append("\u7f3a\u5c11\u5de5\u4f5c\u573a\u6240\u5730\u5740\u3002");
        }
        if (StrUtil.isEmpty((CharSequence)vo.getBusinessStatus())) {
            sb.append("\u7f3a\u5c11\u8425\u4e1a\u72b6\u6001\u3002");
        }
        if (StrUtil.isEmpty((CharSequence)vo.getDataCreator())) {
            sb.append("\u7f3a\u5c11\u6570\u636e\u65b0\u589e\u65b9\u3002");
        }
        if (StrUtil.isEmpty((CharSequence)vo.getDataSource())) {
            sb.append("\u7f3a\u5c11\u6570\u636e\u6765\u6e90\u3002");
        }
        if (StrUtil.isEmpty((CharSequence)vo.getOptType())) {
            sb.append("\u7f3a\u5c11\u64cd\u4f5c\u7c7b\u578b\u3002");
        }
        if (vo.getDuplicateNum() >= 2) {
            sb.append("\u76f8\u540c\u9662\u533a\u7ed1\u5b9a\u4e86\u4e0d\u540c\u7684\u804c\u536b\u4e91id\u3002");
        }
        if (vo.getDuplicateNum() == 1 && vo.getDuplicateNameNum() >= 2) {
            sb.append("\u76f8\u540c\u9662\u533a\u540d\u79f0\u7ed1\u5b9a\u4e86\u4e0d\u540c\u7684\u804c\u536b\u4e91id\u3002");
        }
        if (sb.length() > 0) {
            vo.setDataDealType(DATA_DEAL_TYPE_ERROR);
            vo.setErrorDes(sb.toString());
            return vo;
        }
        String rhoHospitalId = vo.getRhoHospitalId();
        if (StrUtil.isNotBlank((CharSequence)rhoHospitalId)) {
            BCompany dbByRhoId = this.companyService.getByRhoHospitalIdIncludeDel(rhoHospitalId);
            if (dbByRhoId != null) {
                if (dbByRhoId.getZwyHospitalId() != null && !dbByRhoId.getZwyHospitalId().equals(vo.getZwyHospitalId())) {
                    vo.setDataDealType(DATA_DEAL_TYPE_ERROR);
                    vo.setErrorDes("\u653e\u5c04\u536b\u751f\u5728\u7ebf\u7cfb\u7edf\u4e2d\u9662\u533a\u6240\u7ed1\u5b9a\u7684zwyHospitalId\u4e0e\u63d0\u4f9b\u7684zwyHospitalId\u4e0d\u7b26\u3002");
                    return vo;
                }
            } else {
                vo.setDataDealType(DATA_DEAL_TYPE_ERROR);
                vo.setErrorDes("\u804c\u536b\u4e91\u7ed1\u5b9a\u7684rhoHospitalId\u4e0d\u5b58\u5728\u4e8e\u653e\u5c04\u7cfb\u7edf\u4e2d\u3002");
                return vo;
            }
        }
        if (StrUtil.isBlank((CharSequence)rhoHospitalId)) {
            BCompany dbNewestByNameAndCC = this.companyService.getNewestByNameAndCreditCodeIncludeDel(vo.getName(), vo.getCreditCode());
            BCompany dbNewestByName = this.companyService.getNewestByNameIncludeDel(vo.getName());
            if (dbNewestByNameAndCC != null && dbNewestByNameAndCC.getZwyHospitalId() != null && !dbNewestByNameAndCC.getZwyHospitalId().equals(vo.getZwyHospitalId())) {
                vo.setDataDealType(DATA_DEAL_TYPE_ERROR);
                vo.setErrorDes("\u653e\u5c04\u536b\u751f\u5728\u7ebf\u7cfb\u7edf\u4e2d\u9662\u533a\u6240\u7ed1\u5b9a\u7684zwyHospitalId\u4e0e\u63d0\u4f9b\u7684zwyHospitalId\u4e0d\u7b26\u3002");
                return vo;
            }
            if (dbNewestByNameAndCC == null && dbNewestByName != null) {
                vo.setDataDealType(DATA_DEAL_TYPE_ERROR);
                vo.setErrorDes("\u653e\u5c04\u536b\u751f\u5728\u7ebf\u7cfb\u7edf\u4e2d\u9662\u533a\u6240\u7ed1\u5b9a\u7684creditCode\u4e0e\u63d0\u4f9b\u7684creditCode\u4e0d\u7b26\u3002");
                return vo;
            }
        }
        vo.setDataDealType(DATA_DEAL_TYPE_NORMAL);
        return vo;
    }

    public List<Long> saveBaseInfo(List<BCompany> list) {
        ArrayList<Long> idList = new ArrayList<Long>();
        for (BCompany entity : list) {
            entity.setOutId(IdWorker.get32UUID());
            this.companyService.save(entity);
            idList.add(entity.getId());
        }
        return idList;
    }

    public List<Long> upBaseInfo(List<BCompany> list) {
        ArrayList<Long> idList = new ArrayList<Long>();
        for (BCompany entity : list) {
            this.companyService.updateById(entity);
            idList.add(entity.getId());
        }
        return idList;
    }

    public void dealErrorInfo(List<CompanySyncFswsHospitalInfoVo> errorInfoList) {
        List list = errorInfoList.stream().filter(v -> v.getDataDealType() == 2 && StrUtil.isNotBlank((CharSequence)v.getErrorDes())).collect(Collectors.toList());
        ArrayList<FswsErrorDataReturnLog> errorLogList = new ArrayList<FswsErrorDataReturnLog>();
        for (CompanySyncFswsHospitalInfoVo vo : list) {
            FswsErrorDataReturnLog log = new FswsErrorDataReturnLog();
            log.setTableType(String.valueOf(FswsErrorDataTableTypeEnum.FSWS_HOSPITAL_INFO.getValue()));
            log.setTableId(vo.getZwyHospitalId());
            log.setBizTime(vo.getLoadTime());
            log.setErrType(Integer.valueOf(FswsErrorDataErrTypeEnum.EXCEPTION_ERROR.getCode()));
            log.setReason(vo.getErrorDes());
            errorLogList.add(log);
        }
        if (CollUtil.isNotEmpty(errorLogList)) {
            this.errorDataReturnLogService.saveBatch(errorLogList);
        }
    }

    @Generated
    public WandaFswsHospitalInfoSyncManager(IBCompanyService companyService, RedissonClient redissonClient, IFswsErrorDataReturnLogService errorDataReturnLogService) {
        this.companyService = companyService;
        this.redissonClient = redissonClient;
        this.errorDataReturnLogService = errorDataReturnLogService;
    }
}

