/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.third.manager;

import cn.smarthse.rho.modules.sys.entity.e.EDevice;
import cn.smarthse.rho.modules.sys.entity.e.EDeviceRay;
import cn.smarthse.rho.modules.sys.entity.e.EDeviceSource;
import cn.smarthse.rho.modules.sys.entity.e.ESourceNonSealed;
import cn.smarthse.rho.modules.sys.entity.e.ESourceSealed;
import cn.smarthse.rho.modules.sys.entity.wanda.FswsErrorDataReturnLog;
import cn.smarthse.rho.modules.sys.enums.company.EdeviceTypeEnum;
import cn.smarthse.rho.modules.sys.enums.wanda.FswsErrorDataErrTypeEnum;
import cn.smarthse.rho.modules.sys.enums.wanda.FswsErrorDataTableTypeEnum;
import cn.smarthse.rho.modules.sys.model.wanda.sync.param.WandaSyncPlaceParam;
import cn.smarthse.rho.modules.sys.model.wanda.sync.vo.WandaZwyDeviceVo;
import cn.smarthse.rho.modules.sys.utils.NeutronNameUtil;
import cn.smarthse.rho.modules.third.converter.DeviceCommonConverter;
import cn.smarthse.rho.modules.third.dao.device.EDeviceNonSealedThirdMapper;
import cn.smarthse.rho.modules.third.dao.device.EDeviceRayThirdMapper;
import cn.smarthse.rho.modules.third.dao.device.EDeviceSealedThirdMapper;
import cn.smarthse.rho.modules.third.dao.device.EDeviceSourceThirdMapper;
import cn.smarthse.rho.modules.third.dao.device.EDeviceThirdMapper;
import cn.smarthse.rho.modules.third.service.device.IEDeviceThirdService;
import cn.smarthse.rho.modules.third.service.wanda.sync.IFswsErrorDataReturnLogService;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional(readOnly=true)
public class WandaZwyDeviceInfoManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WandaZwyDeviceInfoManager.class);
    private final IEDeviceThirdService deviceThirdService;
    private final EDeviceThirdMapper deviceThirdMapper;
    private final EDeviceRayThirdMapper deviceRayThirdMapper;
    private final EDeviceSealedThirdMapper sealedThirdMapper;
    private final EDeviceNonSealedThirdMapper nonSealedThirdMapper;
    private final EDeviceSourceThirdMapper deviceSourceThirdMapper;
    private final DeviceCommonConverter deviceCommonConverter;
    private final IFswsErrorDataReturnLogService errorLogService;

    @Transactional
    public void syncWandaZwyDeviceInfoToRho(WandaSyncPlaceParam param) {
        ArrayList<EDevice> deviceList = new ArrayList<EDevice>();
        ArrayList<FswsErrorDataReturnLog> errorDataList = new ArrayList<FswsErrorDataReturnLog>();
        if (param.getSearchType() == null) {
            param.setSearchType(Integer.valueOf(1));
        }
        List<WandaZwyDeviceVo> addDataList = this.deviceThirdMapper.listNeedAddZwyDeviceFromWanda(param);
        for (WandaZwyDeviceVo addData : addDataList) {
            FswsErrorDataReturnLog errorData;
            if (addData.getCid() == null) {
                FswsErrorDataReturnLog errorData2 = new FswsErrorDataReturnLog();
                errorData2.setTableType(String.valueOf(FswsErrorDataTableTypeEnum.FSWS_ZWY_DEVICE_INFO.getValue()));
                errorData2.setTableId(addData.getZwyDeviceId());
                errorData2.setBizTime(addData.getLoadTime());
                errorData2.setErrType(Integer.valueOf(FswsErrorDataErrTypeEnum.EXCEPTION_ERROR.getCode()));
                errorData2.setReason("\u672a\u67e5\u8be2\u5230zwyHospitalId\u5bf9\u5e94\u7684rhoHospitalId");
                errorDataList.add(errorData2);
                continue;
            }
            Integer deviceType = Integer.parseInt(addData.getType());
            if (!EdeviceTypeEnum.isExist((Integer)deviceType).booleanValue()) {
                errorData = new FswsErrorDataReturnLog();
                errorData.setTableType(String.valueOf(FswsErrorDataTableTypeEnum.FSWS_ZWY_DEVICE_INFO.getValue()));
                errorData.setTableId(addData.getZwyDeviceId());
                errorData.setBizTime(addData.getLoadTime());
                errorData.setErrType(Integer.valueOf(FswsErrorDataErrTypeEnum.EXCEPTION_ERROR.getCode()));
                errorData.setReason("\u8bbe\u5907\u7c7b\u578b\u4e0d\u5b58\u5728");
                errorDataList.add(errorData);
                continue;
            }
            if ((deviceType == EdeviceTypeEnum.SOURCE_NON_SEALED.getValue() || deviceType == EdeviceTypeEnum.SOURCE_SEALED.getValue()) && NeutronNameUtil.isValidMontageName((String)addData.getName())) {
                errorData = new FswsErrorDataReturnLog();
                errorData.setTableType(String.valueOf(FswsErrorDataTableTypeEnum.FSWS_ZWY_DEVICE_INFO.getValue()));
                errorData.setTableId(addData.getZwyDeviceId());
                errorData.setBizTime(addData.getLoadTime());
                errorData.setErrType(Integer.valueOf(FswsErrorDataErrTypeEnum.EXCEPTION_ERROR.getCode()));
                errorData.setReason("\u6838\u7d20\u540d\u79f0{" + addData.getName() + "}\u4e3a\u975e\u6cd5\u683c\u5f0f");
                errorDataList.add(errorData);
                continue;
            }
            EDevice device2 = this.deviceCommonConverter.wandaVo2BaseEntity(addData);
            device2.setId(Long.valueOf(IdWorker.getId()));
            device2.setCid(addData.getCid());
            device2.setDataSource(Integer.valueOf(2));
            device2.setZwyId(addData.getZwyDeviceId());
            device2.setOutId(IdWorker.get32UUID());
            this.deviceThirdService.save(device2);
            if (device2.getType() == EdeviceTypeEnum.DEVICE_RAY.getValue()) {
                EDeviceRay deviceRay = this.deviceCommonConverter.wandaVo2RayEntity(addData);
                deviceRay.setId(Long.valueOf(IdWorker.getId()));
                deviceRay.setCid(device2.getCid());
                deviceRay.setDid(device2.getId());
                this.deviceRayThirdMapper.insert(deviceRay);
            } else if (device2.getType() == EdeviceTypeEnum.SOURCE_NON_SEALED.getValue()) {
                ESourceNonSealed sourceNonSealed = this.deviceCommonConverter.wandaVo2SourceNonEntity(addData);
                sourceNonSealed.setId(Long.valueOf(IdWorker.getId()));
                sourceNonSealed.setCid(device2.getCid());
                sourceNonSealed.setDid(device2.getId());
                device2.setName(NeutronNameUtil.montageName2OriginalName((String)device2.getName()));
                this.nonSealedThirdMapper.insert(sourceNonSealed);
            } else if (device2.getType() == EdeviceTypeEnum.SOURCE_SEALED.getValue()) {
                ESourceSealed sourceSealed = this.deviceCommonConverter.wandaVo2SourceSealedEntity(addData);
                sourceSealed.setId(Long.valueOf(IdWorker.getId()));
                sourceSealed.setCid(device2.getCid());
                sourceSealed.setDid(device2.getId());
                device2.setName(NeutronNameUtil.montageName2OriginalName((String)device2.getName()));
                this.sealedThirdMapper.insert(sourceSealed);
            } else if (device2.getType() == EdeviceTypeEnum.DEVICE_SOURCE.getValue()) {
                EDeviceSource deviceSource = this.deviceCommonConverter.wandaVo2DeviceSourceEntity(addData);
                deviceSource.setId(Long.valueOf(IdWorker.getId()));
                deviceSource.setCid(device2.getCid());
                deviceSource.setDid(device2.getId());
                this.deviceSourceThirdMapper.insert(deviceSource);
            }
            deviceList.add(device2);
        }
        this.errorLogService.saveBatch(errorDataList);
        List<EDevice> updateDataList = this.deviceThirdMapper.listNeedUpdateZwyDeviceFromWanda(param);
        updateDataList.forEach(device -> this.deviceThirdService.update(device, (Wrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate().eq(EDevice::getId, (Object)device.getId())).set(EDevice::getOutId, (Object)device.getOutId())));
    }

    @Generated
    public WandaZwyDeviceInfoManager(IEDeviceThirdService deviceThirdService, EDeviceThirdMapper deviceThirdMapper, EDeviceRayThirdMapper deviceRayThirdMapper, EDeviceSealedThirdMapper sealedThirdMapper, EDeviceNonSealedThirdMapper nonSealedThirdMapper, EDeviceSourceThirdMapper deviceSourceThirdMapper, DeviceCommonConverter deviceCommonConverter, IFswsErrorDataReturnLogService errorLogService) {
        this.deviceThirdService = deviceThirdService;
        this.deviceThirdMapper = deviceThirdMapper;
        this.deviceRayThirdMapper = deviceRayThirdMapper;
        this.sealedThirdMapper = sealedThirdMapper;
        this.nonSealedThirdMapper = nonSealedThirdMapper;
        this.deviceSourceThirdMapper = deviceSourceThirdMapper;
        this.deviceCommonConverter = deviceCommonConverter;
        this.errorLogService = errorLogService;
    }
}

