/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.third.bootstrap;

import cn.smarthse.framework.oss.config.properties.OssClientProperties;
import cn.smarthse.rho.core.framework.bootstrap.properties.SysProperties;
import cn.smarthse.rho.core.framework.filter.CommonFilter;
import cn.smarthse.rho.modules.third.bootstrap.properties.JwtProperties;
import cn.smarthse.rho.modules.third.framework.handler.ApiHandlerInterceptor;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.servlet.Filter;
import java.util.ArrayList;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
public class MvcConfig
implements WebMvcConfigurer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MvcConfig.class);
    private final OssClientProperties ossClientProperties;
    private final SysProperties sysProperties;
    private final JwtProperties jwtProperties;
    private final ObjectMapper objectMapper;

    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        registry.addResourceHandler(new String[]{"/favicon.ico"}).addResourceLocations(new String[]{"classpath:/static/"}).setCachePeriod(Integer.valueOf(3600)).resourceChain(true);
        registry.addResourceHandler(new String[]{"/upload/**"}).addResourceLocations(new String[]{"file:" + this.ossClientProperties.getLocal() + "upload/"});
    }

    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor((HandlerInterceptor)new ApiHandlerInterceptor(this.jwtProperties, this.objectMapper)).addPathPatterns(new String[]{"/third/**"}).excludePathPatterns(new String[]{"/third/api/getToken", "/third/swagger-ui.html", "/third/swagger-ui/**", "/third/swagger-resources/**", "/third/img/**", "/third/webjars/**", "/third/doc.html", "/third/v3/api-docs/**"});
    }

    @Bean
    public FilterRegistrationBean<Filter> filterRegistrationCommon() {
        FilterRegistrationBean registration = new FilterRegistrationBean();
        registration.setFilter((Filter)new CommonFilter());
        ArrayList<String> urlList = new ArrayList<String>();
        urlList.add("/*");
        registration.setUrlPatterns(urlList);
        registration.setName("CommonFilter");
        registration.setOrder(-2147483646);
        return registration;
    }

    @Generated
    public MvcConfig(OssClientProperties ossClientProperties, SysProperties sysProperties, JwtProperties jwtProperties, ObjectMapper objectMapper) {
        this.ossClientProperties = ossClientProperties;
        this.sysProperties = sysProperties;
        this.jwtProperties = jwtProperties;
        this.objectMapper = objectMapper;
    }
}

