/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.third.service.wanda.push;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HtmlUtil;
import cn.hutool.http.webservice.SoapClient;
import cn.smarthse.common.util.DateUtils;
import cn.smarthse.core.framework.bootstrap.properties.SysProperties;
import cn.smarthse.rho.modules.sys.model.wanda.base.WandaDto;
import cn.smarthse.rho.modules.sys.model.wanda.base.request.WandaRequestBody;
import cn.smarthse.rho.modules.sys.model.wanda.base.request.WandaRequestDataList;
import cn.smarthse.rho.modules.sys.model.wanda.base.request.WandaRequestHeader;
import cn.smarthse.rho.modules.sys.model.wanda.base.request.WandaRequestRequest;
import cn.smarthse.rho.modules.sys.model.wanda.base.request.WandaRequestRoot;
import cn.smarthse.rho.modules.sys.model.wanda.base.response.WandaResponseReport;
import cn.smarthse.rho.modules.sys.model.wanda.base.response.WandaResponseRoot;
import cn.smarthse.rho.modules.sys.model.wanda.base.response.WandaResponseSoapEnvelope;
import cn.smarthse.rho.modules.third.service.wanda.push.WandaPushBaseService;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.fasterxml.jackson.dataformat.xml.ser.ToXmlGenerator;
import com.github.pagehelper.PageInfo;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Resource;
import javax.smarthse.framework.exception.ServiceException;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class WandaPushBaseServiceImpl<T>
implements WandaPushBaseService<T> {
    private static final Logger log = LoggerFactory.getLogger(WandaPushBaseServiceImpl.class);
    @Resource
    protected XmlMapper xmlMapper;
    @Resource
    private SysProperties sysProperties;

    public void handData(Integer pageNum, Integer pageSize, WandaPushBaseService.OperationType optType) {
        WandaDto dto = this.fetchData(pageNum, pageSize, true, optType);
        int pageTotal = dto.getPageTotal();
        if (pageTotal == 0) {
            return;
        }
        for (int i = 1; i <= pageTotal; ++i) {
            PageInfo pageInfo;
            if (i > 1) {
                dto = this.fetchData(i, pageSize, false, optType);
            }
            if (CollUtil.isEmpty((Collection)(pageInfo = (PageInfo)dto.getObject()).getList())) break;
            this.doPush(pageInfo, optType);
            pageInfo.getList().clear();
        }
    }

    private WandaDto fetchData(Integer pageNum, Integer pageSize, boolean count, WandaPushBaseService.OperationType optType) {
        PageInfo pageInfo;
        WandaDto dto = new WandaDto();
        if (optType == WandaPushBaseService.OperationType.ADD) {
            pageInfo = this.getAddData(pageNum, pageSize, count);
        } else if (optType == WandaPushBaseService.OperationType.UPDATE) {
            pageInfo = this.getUpdateData(pageNum, pageSize, count);
        } else if (optType == WandaPushBaseService.OperationType.DELETE) {
            pageInfo = this.getDeleteData(pageNum, pageSize, count);
        } else {
            throw new ServiceException("\u53c2\u6570\u4e0d\u5408\u6cd5");
        }
        if (count) {
            if (Objects.isNull(pageInfo)) {
                dto.setPageTotal(Integer.valueOf(0));
            } else {
                dto.setPageTotal(Integer.valueOf(pageInfo.getPages()));
            }
        }
        dto.setObject(pageInfo);
        return dto;
    }

    private void doPush(PageInfo<T> pageInfo, WandaPushBaseService.OperationType optType) {
        if (Objects.nonNull(pageInfo) && CollUtil.isNotEmpty((Collection)pageInfo.getList())) {
            List list = pageInfo.getList();
            WandaRequestHeader header = new WandaRequestHeader();
            String msgId = UUID.randomUUID().toString();
            header.setMsgId(msgId);
            header.setAction("push");
            String dateTime = DateUtils.formatDateTime((Date)new Date());
            header.setSendTime(dateTime);
            String records = String.valueOf(list.size());
            header.setRecords(records);
            header.setPageSum(String.valueOf(pageInfo.getPages()));
            header.setPageSize(String.valueOf(pageInfo.getPageSize()));
            header.setPageNum(String.valueOf(pageInfo.getPageNum()));
            WandaRequestDataList dataList = new WandaRequestDataList(list);
            WandaRequestBody body = new WandaRequestBody(dataList);
            WandaRequestRequest requestRequest = new WandaRequestRequest(header, body);
            String xml = null;
            try {
                xml = this.xmlMapper.configure(ToXmlGenerator.Feature.WRITE_XML_DECLARATION, true).writeValueAsString((Object)new WandaRequestRoot(requestRequest));
            }
            catch (JsonProcessingException e) {
                log.error("[\u63a8\u9001\u5931\u8d25] JsonProcessingException[writeValueAsString]\uff1a{}", (Object)e.getMessage());
            }
            String signDate = DateUtils.format((Date)new Date(), (String)"yyyyMMdd");
            String plaintext = this.appKey().concat(signDate).concat(this.sysProperties.getWandaAppSecret());
            String signText = DigestUtils.md5Hex((String)plaintext);
            String urlSuffixStr = "&appkey=" + this.appKey() + "&strtime=" + signDate + "&sign=" + signText;
            String xmlStr = SoapClient.create((String)this.sysProperties.getWandaPullUrl().concat(urlSuffixStr)).setMethod("ws:dataReceiveService", "http://ws.databus.wondersgroup.com/").setParam("arg0", (Object)msgId, false).setParam("arg1", (Object)this.appKey(), false).setParam("arg2", (Object)dateTime, false).setParam("arg3", (Object)records, false).setParam("arg4", (Object)"XML", false).setParam("arg5", (Object)this.dataKey(), false).setParam("arg6", (Object)xml, false).setParam("arg7", (Object)optType.getValue(), false).setParam("arg8", (Object)DigestUtils.md5Hex((String)(this.appKey() + dateTime + this.appSecret())), false).send();
            if (StrUtil.isBlank((CharSequence)xmlStr)) {
                return;
            }
            WandaResponseRoot root = null;
            try {
                log.info("\u4e07\u8fbe\u4ed3\u63a5\u53e3\u8fd4\u56dexmlStr=={}", (Object)xmlStr);
                WandaResponseSoapEnvelope soapEnvelope = (WandaResponseSoapEnvelope)this.xmlMapper.readValue(xmlStr, WandaResponseSoapEnvelope.class);
                log.info("\u4e07\u8fbe\u4ed3\u63a5\u53e3\u8fd4\u56desoapEnvelope=={}", (Object)soapEnvelope);
                root = (WandaResponseRoot)this.xmlMapper.readValue(HtmlUtil.unescape((String)soapEnvelope.getBody().getDataReceiveServiceResponse().getReturnStr()), WandaResponseRoot.class);
                log.info("\u4e07\u8fbe\u4ed3\u63a5\u53e3\u8fd4\u56deroot=={}", (Object)this.xmlMapper.writeValueAsString((Object)root));
            }
            catch (JsonProcessingException e) {
                log.error("[\u63a8\u9001\u5931\u8d25] JsonProcessingException[readValue]\uff1a{}", (Throwable)e);
            }
            if (Objects.nonNull(root)) {
                HashSet<String> failIdSet = new HashSet<String>();
                if (!"200".equals(root.getResponse().getCode())) {
                    WandaResponseReport report = root.getResponse().getReport();
                    if (Objects.nonNull(report) && StrUtil.isNotBlank((CharSequence)report.getFailKeys())) {
                        String[] split;
                        String failKeys = report.getFailKeys();
                        for (String s : split = failKeys.substring(1, failKeys.length() - 1).split(",")) {
                            String id = s.split(":")[1];
                            failIdSet.add(id);
                        }
                        log.warn("[\u63a8\u9001\u8b66\u544a] WandaResponseResponse\uff1a{}", (Object)root.getResponse());
                    } else {
                        log.error("[\u63a8\u9001\u5931\u8d25] WandaResponseResponse\uff1a{}", (Object)root.getResponse());
                    }
                }
                this.setSuccessData(list);
                if (CollUtil.isNotEmpty(failIdSet)) {
                    this.setFailDataById(failIdSet);
                }
            }
        }
    }
}

