/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.third.service.room.impl;

import cn.smarthse.core.framework.service.ServiceImpl;
import cn.smarthse.rho.modules.sys.entity.d.DLocationCheckData;
import cn.smarthse.rho.modules.sys.entity.wanda.FswsErrorDataReturnLog;
import cn.smarthse.rho.modules.sys.enums.wanda.FswsErrorDataErrTypeEnum;
import cn.smarthse.rho.modules.sys.enums.wanda.FswsErrorDataTableTypeEnum;
import cn.smarthse.rho.modules.sys.enums.wanda.WandaDataDealTypeEnum;
import cn.smarthse.rho.modules.sys.enums.wanda.WandaoptTypeEnum;
import cn.smarthse.rho.modules.sys.model.wanda.sync.param.WandaSyncParam;
import cn.smarthse.rho.modules.sys.model.wanda.sync.vo.WandaFswsPlaceCheckDataVo;
import cn.smarthse.rho.modules.third.dao.room.DLocationCheckDataMapper;
import cn.smarthse.rho.modules.third.service.room.IDLocationCheckDataService;
import cn.smarthse.rho.modules.third.service.wanda.sync.IFswsErrorDataReturnLogService;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
@Transactional(readOnly=true)
public class DLocationCheckDataServiceImpl
extends ServiceImpl<DLocationCheckDataMapper, DLocationCheckData>
implements IDLocationCheckDataService {
    @Autowired
    private IFswsErrorDataReturnLogService errorDataReturnLogService;

    @Override
    @Transactional
    public void updateLatestFlag() {
        ((DLocationCheckDataMapper)this.baseMapper).updateLatestFlag();
    }

    @Transactional
    public void addOrUpdateListData(List<WandaFswsPlaceCheckDataVo> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        this.executeBatch(list, (sqlSession, entity) -> ((DLocationCheckDataMapper)sqlSession.getMapper(DLocationCheckDataMapper.class)).addOrUpdateListData((WandaFswsPlaceCheckDataVo)entity));
    }

    @Override
    @Transactional
    public void updateAfterSync(WandaSyncParam syncParam) {
        ((DLocationCheckDataMapper)this.baseMapper).updateAfterSync(syncParam);
    }

    @Override
    public PageInfo<WandaFswsPlaceCheckDataVo> getPlaceCheckDataSyncDataFromWanda(WandaSyncParam param) {
        PageHelper.startPage((int)param.getPage(), (int)param.getLimit(), (boolean)param.getCount());
        return new PageInfo(((DLocationCheckDataMapper)this.baseMapper).getPlaceCheckDataSyncDataFromWanda(param));
    }

    @Override
    @Transactional
    public void syncDataMain(WandaSyncParam param) {
        ArrayList<WandaFswsPlaceCheckDataVo> finalList = new ArrayList<WandaFswsPlaceCheckDataVo>();
        ArrayList<WandaFswsPlaceCheckDataVo> syncExceptionList = new ArrayList<WandaFswsPlaceCheckDataVo>();
        int pages = 0;
        do {
            PageInfo<WandaFswsPlaceCheckDataVo> page = this.getPlaceCheckDataSyncDataFromWanda(param);
            if (pages == 0) {
                pages = page.getPages();
            }
            if (page.getSize() > 0) {
                this.checkData(page.getList(), finalList, syncExceptionList);
                this.addOrUpdateListData(finalList);
                this.dealExceptionData(syncExceptionList);
                finalList.clear();
                syncExceptionList.clear();
                page.getList().clear();
            }
            param.setPage(param.getPage() + 1);
            param.setCount(Boolean.valueOf(false));
        } while (param.getPage() <= pages);
    }

    public void dealExceptionData(List<WandaFswsPlaceCheckDataVo> syncExceptionList) {
        if (CollectionUtils.isEmpty(syncExceptionList)) {
            return;
        }
        ArrayList<FswsErrorDataReturnLog> exceptionList = new ArrayList<FswsErrorDataReturnLog>();
        syncExceptionList.forEach(item -> {
            FswsErrorDataReturnLog exception = new FswsErrorDataReturnLog();
            exception.setId(IdWorker.getIdStr());
            exception.setTableType(FswsErrorDataTableTypeEnum.FSWS_DEVICE_CHECK.getName());
            exception.setErrType(item.getDataErrType());
            exception.setReason(item.getDataErrDesc());
            exceptionList.add(exception);
        });
        this.errorDataReturnLogService.saveBatch(exceptionList);
    }

    public void checkData(List<WandaFswsPlaceCheckDataVo> list, List<WandaFswsPlaceCheckDataVo> finalList, List<WandaFswsPlaceCheckDataVo> syncFailData) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.forEach(item -> {
            item.setId(Long.valueOf(IdWorker.getId()));
            this.baseColumnsCheck((WandaFswsPlaceCheckDataVo)item);
            this.businessColumns((WandaFswsPlaceCheckDataVo)item);
            if (!StringUtils.isBlank((String)item.getDataErrDesc())) {
                item.setSyncErrType(Integer.valueOf(WandaDataDealTypeEnum.ERROR.getCode()));
                item.setDataErrType(Integer.valueOf(FswsErrorDataErrTypeEnum.FORMAT_ERROR.getCode()));
                syncFailData.add((WandaFswsPlaceCheckDataVo)item);
            } else {
                finalList.add((WandaFswsPlaceCheckDataVo)item);
            }
        });
    }

    private void baseColumnsCheck(WandaFswsPlaceCheckDataVo item) {
        StringBuilder dataErrDesc = new StringBuilder();
        if (item.getSourceId() == null) {
            dataErrDesc.append("\u4e3b\u952e[id]\u4e0d\u80fd\u4e3a\u7a7a\uff1b");
        }
        if (StringUtils.isBlank((String)item.getCheckId())) {
            dataErrDesc.append("\u68c0\u6d4b\u4e3b\u8868id[checkId]\u4e0d\u80fd\u4e3a\u7a7a\uff1b");
        }
        if (StringUtils.isBlank((String)item.getHospitalName())) {
            dataErrDesc.append("\u653e\u5c04\u8bca\u7597\u673a\u6784\u540d\u79f0[hospitalName]\u4e0d\u80fd\u4e3a\u7a7a\uff1b");
        }
        if (StringUtils.isBlank((String)item.getHospitalCreditCode())) {
            dataErrDesc.append("\u653e\u5c04\u8bca\u7597\u673a\u6784\u4fe1\u7528\u4ee3\u7801[hospitalCreditCode]\u4e0d\u80fd\u4e3a\u7a7a\uff1b");
        }
        if (StringUtils.isBlank((String)item.getZwyHospitalId())) {
            dataErrDesc.append("\u653e\u5c04\u8bca\u7597\u673a\u6784id[zwyHospitalId]\u4e0d\u80fd\u4e3a\u7a7a\uff1b");
        }
        if (StringUtils.isBlank((String)item.getZwyEngineRoomId())) {
            dataErrDesc.append("\u573a\u6240id[zwyEngineRoomId]\u4e0d\u80fd\u4e3a\u7a7a\uff1b");
        }
        if (StringUtils.isBlank((String)item.getEngineRoom())) {
            dataErrDesc.append("\u573a\u6240\u540d\u79f0[engineRoom]\u4e0d\u80fd\u4e3a\u7a7a\uff1b");
        }
        if (StringUtils.isBlank((String)item.getEngineRoomCode())) {
            dataErrDesc.append("\u573a\u6240\u7f16\u53f7[engineRoomCode]\u4e0d\u80fd\u4e3a\u7a7a\uff1b");
        }
        if (StringUtils.isBlank((String)item.getIfNoSealedSource())) {
            dataErrDesc.append("\u662f\u5426\u4f7f\u7528\u975e\u5bc6\u5c01\u578b\u653e\u5c04\u6027\u540c\u4f4d\u7d20[ifNoSealedSource]\u4e0d\u80fd\u4e3a\u7a7a\uff1b");
        } else if (item.getIfNoSealedSource().equals("1") && StringUtils.isBlank((String)item.getNoSealedSourceId())) {
            dataErrDesc.append("\u975e\u5bc6\u5c01\u578b\u653e\u5c04\u6027\u540c\u4f4d\u7d20id[sealedSourceId]\u4e0d\u80fd\u4e3a\u7a7a\uff1b");
        }
        if (StringUtils.isBlank((String)item.getResult())) {
            dataErrDesc.append("\u68c0\u6d4b\u7ed3\u679c[result]\u4e0d\u80fd\u4e3a\u7a7a\uff1b");
        }
        if (StringUtils.isBlank((String)item.getCheckReportName())) {
            dataErrDesc.append("\u68c0\u6d4b\u62a5\u544a\u540d\u79f0[checkReportName]\u4e0d\u80fd\u4e3a\u7a7a\uff1b");
        }
        if (StringUtils.isBlank((String)item.getCheckReportNo())) {
            dataErrDesc.append("\u68c0\u6d4b\u62a5\u544a\u7f16\u53f7[checkReportNo]\u4e0d\u80fd\u4e3a\u7a7a\uff1b");
        }
        if (StringUtils.isBlank((String)item.getIsInfulenceReport())) {
            dataErrDesc.append("\u662f\u5426\u5f71\u54cd\u62a5\u544a[isInfulenceReport]\u4e0d\u80fd\u4e3a\u7a7a\uff1b");
        }
        if (StringUtils.isNotBlank((String)item.getIsInfulenceReport()) && item.getIsInfulenceReport().equals("1") && StringUtils.isBlank((String)item.getDealType())) {
            dataErrDesc.append("\u5904\u7406\u7c7b\u578b[dealType]\u4e0d\u80fd\u4e3a\u7a7a\uff1b");
        }
        if (StringUtils.isBlank((String)item.getOptType())) {
            dataErrDesc.append("\u64cd\u4f5c\u7c7b\u578b[optType]\u4e0d\u80fd\u4e3a\u7a7a\uff1b");
        }
        if (StringUtils.isNotBlank((String)item.getOptType()) && !item.getOptType().equals(WandaoptTypeEnum.ADD.getValue()) && item.getOldSourceId() == null) {
            dataErrDesc.append("\u65e7\u6e90ID[oldSourceId]\u4e0d\u80fd\u4e3a\u7a7a\uff1b");
        }
        if (StringUtils.isNotBlank((String)item.getOptType()) && !item.getOptType().equals(WandaoptTypeEnum.ADD.getValue()) && StringUtils.isBlank((String)item.getOptReason())) {
            dataErrDesc.append("\u64cd\u4f5c\u539f\u56e0[optReason]\u4e0d\u80fd\u4e3a\u7a7a\uff1b");
        }
        item.setDataErrDesc(dataErrDesc.toString());
    }

    private void businessColumns(WandaFswsPlaceCheckDataVo item) {
        StringBuilder dataErrDesc = new StringBuilder(item.getDataErrDesc());
        item.setDataErrDesc(dataErrDesc.toString());
    }
}

