/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.third.service.device.impl;

import cn.smarthse.core.framework.service.ServiceImpl;
import cn.smarthse.rho.modules.sys.converter.DeviceCommonConverter;
import cn.smarthse.rho.modules.sys.entity.b.BCompany;
import cn.smarthse.rho.modules.sys.entity.e.EDevice;
import cn.smarthse.rho.modules.sys.model.b.param.CompanySyncParam;
import cn.smarthse.rho.modules.sys.model.third.param.SearchDeviceParam;
import cn.smarthse.rho.modules.sys.model.third.param.ThirdDeviceBaseDto;
import cn.smarthse.rho.modules.sys.model.third.param.ThirdDeviceDto;
import cn.smarthse.rho.modules.sys.model.third.vo.ThirdDeviceVo;
import cn.smarthse.rho.modules.sys.provider.wp.IWholeProcessCMProvider;
import cn.smarthse.rho.modules.third.dao.device.EDeviceThirdMapper;
import cn.smarthse.rho.modules.third.service.device.IEDeviceThirdService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
@Transactional(readOnly=true)
public class EDeviceThirdServiceImpl
extends ServiceImpl<EDeviceThirdMapper, EDevice>
implements IEDeviceThirdService {
    @Autowired(required=false)
    private DeviceCommonConverter deviceConverter;
    @DubboReference
    private IWholeProcessCMProvider wholeProcessCMProvider;

    @Override
    public List<ThirdDeviceVo> getDeviceForThird(SearchDeviceParam param) {
        HashSet<ThirdDeviceVo> rst = new HashSet<ThirdDeviceVo>();
        if (!CollectionUtils.isEmpty((Collection)param.getFactoryNoList())) {
            rst.addAll(((EDeviceThirdMapper)this.baseMapper).selectAllByDeviceCode(param.getFactoryNoList()));
        }
        if (!CollectionUtils.isEmpty((Collection)param.getUniqueCodeList())) {
            rst.addAll(((EDeviceThirdMapper)this.baseMapper).selectAllByUniqueCode(param.getUniqueCodeList()));
        }
        if (CollectionUtils.isEmpty(rst)) {
            return null;
        }
        return new ArrayList<ThirdDeviceVo>(rst);
    }

    @Override
    @Transactional
    public List<ThirdDeviceDto> addDeviceForThird(List<ThirdDeviceDto> paramList) {
        if (CollectionUtils.isEmpty(paramList)) {
            return null;
        }
        for (ThirdDeviceDto deviceDto : paramList) {
            ThirdDeviceBaseDto baseDto = deviceDto.getDeviceBaseDto();
            CompanySyncParam companySyncParam = new CompanySyncParam();
            companySyncParam.setMedicalNucode(baseDto.getUniqueCode());
            BCompany bCompany = this.wholeProcessCMProvider.getAndSyncSingleCm(companySyncParam);
            if (bCompany == null) continue;
            List<ThirdDeviceVo> deviceByFC = ((EDeviceThirdMapper)this.baseMapper).selectAllByDeviceCode(Arrays.asList(baseDto.getFactory()));
            if (!CollectionUtils.isEmpty(deviceByFC)) continue;
            EDevice device = this.deviceConverter.thirdBaseDto2Entity(baseDto);
            device.setId(null);
            device.setCid(bCompany.getId());
            device.setLicenseStatus(Integer.valueOf(2));
            device.setLicenseStatusType(Integer.valueOf(0));
            device.setWarningStatus(Integer.valueOf(0));
            device.setDataSource(Integer.valueOf(2));
        }
        return null;
    }
}

