/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.third.service.device.impl;

import cn.smarthse.core.framework.service.ServiceImpl;
import cn.smarthse.rho.modules.sys.entity.d.DDeviceCheckData;
import cn.smarthse.rho.modules.sys.entity.wanda.FswsErrorDataReturnLog;
import cn.smarthse.rho.modules.sys.enums.wanda.FswsErrorDataErrTypeEnum;
import cn.smarthse.rho.modules.sys.enums.wanda.FswsErrorDataTableTypeEnum;
import cn.smarthse.rho.modules.sys.enums.wanda.WandaDataDealTypeEnum;
import cn.smarthse.rho.modules.sys.enums.wanda.WandaoptTypeEnum;
import cn.smarthse.rho.modules.sys.model.wanda.sync.param.WandaSyncParam;
import cn.smarthse.rho.modules.sys.model.wanda.sync.vo.WandaFswsDeviceCheckDataVo;
import cn.smarthse.rho.modules.third.dao.device.DDeviceCheckDataMapper;
import cn.smarthse.rho.modules.third.service.device.IDDeviceCheckDataService;
import cn.smarthse.rho.modules.third.service.wanda.sync.IFswsErrorDataReturnLogService;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
@Transactional(readOnly=true)
public class DDeviceCheckDataServiceImpl
extends ServiceImpl<DDeviceCheckDataMapper, DDeviceCheckData>
implements IDDeviceCheckDataService {
    @Autowired
    private IFswsErrorDataReturnLogService errorDataReturnLogService;

    @Override
    @Transactional
    public void updateLatestFlag() {
        ((DDeviceCheckDataMapper)this.baseMapper).updateLatestFlag();
    }

    @Transactional
    public void addOrUpdateListData(List<WandaFswsDeviceCheckDataVo> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        this.executeBatch(list, (sqlSession, entity) -> ((DDeviceCheckDataMapper)sqlSession.getMapper(DDeviceCheckDataMapper.class)).addOrUpdateListData((WandaFswsDeviceCheckDataVo)entity));
    }

    @Override
    @Transactional
    public void updateAfterSync(WandaSyncParam syncParam) {
        ((DDeviceCheckDataMapper)this.baseMapper).updateAfterSync(syncParam);
    }

    @Override
    public PageInfo<WandaFswsDeviceCheckDataVo> getDeviceCheckDataSyncDataFromWanda(WandaSyncParam param) {
        PageHelper.startPage((int)param.getPage(), (int)param.getLimit(), (boolean)param.getCount());
        return new PageInfo(((DDeviceCheckDataMapper)this.baseMapper).getDeviceCheckDataSyncDataFromWanda(param));
    }

    @Override
    @Transactional
    public void syncDataMain(WandaSyncParam param) {
        ArrayList<WandaFswsDeviceCheckDataVo> finalList = new ArrayList<WandaFswsDeviceCheckDataVo>();
        ArrayList<WandaFswsDeviceCheckDataVo> syncExceptionList = new ArrayList<WandaFswsDeviceCheckDataVo>();
        int pages = 0;
        do {
            PageInfo<WandaFswsDeviceCheckDataVo> page = this.getDeviceCheckDataSyncDataFromWanda(param);
            if (pages == 0) {
                pages = page.getPages();
            }
            if (page.getSize() > 0) {
                this.checkData(page.getList(), finalList, syncExceptionList);
                this.addOrUpdateListData(finalList);
                this.dealExceptionData(syncExceptionList);
                finalList.clear();
                syncExceptionList.clear();
                page.getList().clear();
            }
            param.setPage(param.getPage() + 1);
            param.setCount(Boolean.valueOf(false));
        } while (param.getPage() <= pages);
    }

    public void dealExceptionData(List<WandaFswsDeviceCheckDataVo> syncExceptionList) {
        if (CollectionUtils.isEmpty(syncExceptionList)) {
            return;
        }
        ArrayList<FswsErrorDataReturnLog> exceptionList = new ArrayList<FswsErrorDataReturnLog>();
        syncExceptionList.forEach(item -> {
            FswsErrorDataReturnLog exception = new FswsErrorDataReturnLog();
            exception.setId(IdWorker.getIdStr());
            exception.setTableType(FswsErrorDataTableTypeEnum.FSWS_DEVICE_CHECK.getValue() + "");
            exception.setErrType(item.getDataErrType());
            exception.setReason(item.getDataErrDesc());
            exceptionList.add(exception);
        });
        this.errorDataReturnLogService.saveBatch(exceptionList);
    }

    public void checkData(List<WandaFswsDeviceCheckDataVo> list, List<WandaFswsDeviceCheckDataVo> finalList, List<WandaFswsDeviceCheckDataVo> syncFailData) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.forEach(item -> {
            item.setId(Long.valueOf(IdWorker.getId()));
            this.baseColumnsCheck((WandaFswsDeviceCheckDataVo)item);
            this.businessColumns((WandaFswsDeviceCheckDataVo)item);
            if (!StringUtils.isBlank((String)item.getDataErrDesc())) {
                item.setSyncErrType(Integer.valueOf(WandaDataDealTypeEnum.ERROR.getCode()));
                item.setDataErrType(Integer.valueOf(FswsErrorDataErrTypeEnum.FORMAT_ERROR.getCode()));
                syncFailData.add((WandaFswsDeviceCheckDataVo)item);
            } else {
                finalList.add((WandaFswsDeviceCheckDataVo)item);
            }
        });
    }

    private void baseColumnsCheck(WandaFswsDeviceCheckDataVo item) {
        StringBuilder dataErrDesc = new StringBuilder();
        if (item.getSourceId() == null) {
            dataErrDesc.append("\u4e3b\u952e[id]\u4e0d\u80fd\u4e3a\u7a7a\uff1b");
        }
        if (StringUtils.isBlank((String)item.getCheckId())) {
            dataErrDesc.append("\u68c0\u6d4b\u4e3b\u8868id[checkId]\u4e0d\u80fd\u4e3a\u7a7a\uff1b");
        }
        if (StringUtils.isBlank((String)item.getHospitalName())) {
            dataErrDesc.append("\u653e\u5c04\u8bca\u7597\u673a\u6784\u540d\u79f0[hospitalName]\u4e0d\u80fd\u4e3a\u7a7a\uff1b");
        }
        if (StringUtils.isBlank((String)item.getHospitalCreditCode())) {
            dataErrDesc.append("\u653e\u5c04\u8bca\u7597\u673a\u6784\u4fe1\u7528\u4ee3\u7801[hospitalCreditCode]\u4e0d\u80fd\u4e3a\u7a7a\uff1b");
        }
        if (item.getZwyHospitalId() == null) {
            dataErrDesc.append("\u653e\u5c04\u8bca\u7597\u673a\u6784id[zwyHospitalId]\u4e0d\u80fd\u4e3a\u7a7a\uff1b");
        }
        if (item.getZwyDeviceId() == null) {
            dataErrDesc.append("\u8bbe\u5907id[zwyDeviceId]\u4e0d\u80fd\u4e3a\u7a7a\uff1b");
        }
        if (StringUtils.isBlank((String)item.getDeviceName())) {
            dataErrDesc.append("\u8bbe\u5907\u540d\u79f0[deviceName]\u4e0d\u80fd\u4e3a\u7a7a\uff1b");
        }
        if (StringUtils.isBlank((String)item.getDeviceModel())) {
            dataErrDesc.append("\u8bbe\u5907\u578b\u53f7[deviceModel]\u4e0d\u80fd\u4e3a\u7a7a\uff1b");
        }
        if (StringUtils.isBlank((String)item.getDeviceNo())) {
            dataErrDesc.append("\u8bbe\u5907\u51fa\u5382\u7f16\u53f7[deviceNo]\u4e0d\u80fd\u4e3a\u7a7a\uff1b");
        }
        if (StringUtils.isBlank((String)item.getIfSealedSource())) {
            dataErrDesc.append("\u662f\u5426\u542b\u5bc6\u5c01\u6e90\u88c5\u7f6e[ifSealedSource]\u4e0d\u80fd\u4e3a\u7a7a\uff1b");
        } else if (item.getIfSealedSource().equals("1") && StringUtils.isBlank((String)item.getSealedSourceId())) {
            dataErrDesc.append("\u542b\u5bc6\u5c01\u6e90\u88c5\u7f6e\u7684\u88c5\u7f6eid[sealedSourceId]\u4e0d\u80fd\u4e3a\u7a7a\uff1b");
        }
        if (StringUtils.isBlank((String)item.getDeviceMoveType())) {
            dataErrDesc.append("\u662f\u5426\u53ef\u79fb\u52a8\u8bbe\u5907[deviceMoveType]\u4e0d\u80fd\u4e3a\u7a7a\uff1b");
        }
        if (StringUtils.isBlank((String)item.getBedsideType())) {
            dataErrDesc.append("\u662f\u5426\u5e8a\u8fb9\u8bbe\u5907[bedsideType]\u4e0d\u80fd\u4e3a\u7a7a\uff1b");
        }
        if (!StringUtils.isBlank((String)item.getVehicleType())) {
            dataErrDesc.append("\u662f\u5426\u8f66\u8f7d\u8bbe\u5907[vehicleType]\u4e0d\u80fd\u4e3a\u7a7a\uff1b");
        }
        if (StringUtils.isBlank((String)item.getResult())) {
            dataErrDesc.append("\u68c0\u6d4b\u7ed3\u679c[result]\u4e0d\u80fd\u4e3a\u7a7a\uff1b");
        }
        if (StringUtils.isBlank((String)item.getCheckReportName())) {
            dataErrDesc.append("\u68c0\u6d4b\u62a5\u544a\u540d\u79f0[checkReportName]\u4e0d\u80fd\u4e3a\u7a7a\uff1b");
        }
        if (StringUtils.isBlank((String)item.getCheckReportNo())) {
            dataErrDesc.append("\u68c0\u6d4b\u62a5\u544a\u7f16\u53f7[checkReportNo]\u4e0d\u80fd\u4e3a\u7a7a\uff1b");
        }
        if (StringUtils.isBlank((String)item.getIsInfulenceReport())) {
            dataErrDesc.append("\u662f\u5426\u5f71\u54cd\u62a5\u544a[isInfulenceReport]\u4e0d\u80fd\u4e3a\u7a7a\uff1b");
        }
        if (StringUtils.isNotBlank((String)item.getIsInfulenceReport()) && item.getIsInfulenceReport().equals("1") && StringUtils.isBlank((String)item.getDealType())) {
            dataErrDesc.append("\u5904\u7406\u7c7b\u578b[dealType]\u4e0d\u80fd\u4e3a\u7a7a\uff1b");
        }
        if (StringUtils.isBlank((String)item.getOptType())) {
            dataErrDesc.append("\u64cd\u4f5c\u7c7b\u578b[optType]\u4e0d\u80fd\u4e3a\u7a7a\uff1b");
        }
        if (StringUtils.isNotBlank((String)item.getOptType()) && !item.getOptType().equals(WandaoptTypeEnum.ADD.getValue()) && item.getOldSourceId() == null) {
            dataErrDesc.append("\u65e7\u6e90ID[oldSourceId]\u4e0d\u80fd\u4e3a\u7a7a\uff1b");
        }
        if (StringUtils.isNotBlank((String)item.getOptType()) && !item.getOptType().equals(WandaoptTypeEnum.ADD.getValue()) && StringUtils.isBlank((String)item.getOptReason())) {
            dataErrDesc.append("\u64cd\u4f5c\u539f\u56e0[optReason]\u4e0d\u80fd\u4e3a\u7a7a\uff1b");
        }
        item.setDataErrDesc(dataErrDesc.toString());
    }

    private void businessColumns(WandaFswsDeviceCheckDataVo item) {
        StringBuilder dataErrDesc = new StringBuilder(item.getDataErrDesc());
        item.setDataErrDesc(dataErrDesc.toString());
    }
}

