/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.third.manager;

import cn.smarthse.rho.modules.sys.converter.DeviceCommonConverter;
import cn.smarthse.rho.modules.sys.entity.e.EDevice;
import cn.smarthse.rho.modules.sys.entity.e.EDeviceRay;
import cn.smarthse.rho.modules.sys.entity.e.EDeviceSource;
import cn.smarthse.rho.modules.sys.entity.e.ESourceNonSealed;
import cn.smarthse.rho.modules.sys.entity.e.ESourceSealed;
import cn.smarthse.rho.modules.sys.entity.wanda.FswsErrorDataReturnLog;
import cn.smarthse.rho.modules.sys.enums.company.EdeviceTypeEnum;
import cn.smarthse.rho.modules.sys.enums.wanda.FswsErrorDataErrTypeEnum;
import cn.smarthse.rho.modules.sys.enums.wanda.FswsErrorDataTableTypeEnum;
import cn.smarthse.rho.modules.sys.model.wanda.sync.param.WandaSyncPlaceParam;
import cn.smarthse.rho.modules.sys.model.wanda.sync.vo.WandaZwyDeviceVo;
import cn.smarthse.rho.modules.sys.utils.NeutronNameUtil;
import cn.smarthse.rho.modules.third.dao.device.EDeviceNonSealedThirdMapper;
import cn.smarthse.rho.modules.third.dao.device.EDeviceRayThirdMapper;
import cn.smarthse.rho.modules.third.dao.device.EDeviceSealedThirdMapper;
import cn.smarthse.rho.modules.third.dao.device.EDeviceSourceThirdMapper;
import cn.smarthse.rho.modules.third.dao.device.EDeviceThirdMapper;
import cn.smarthse.rho.modules.third.service.device.IEDeviceThirdService;
import cn.smarthse.rho.modules.third.service.wanda.sync.IFswsErrorDataReturnLogService;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional(readOnly=true)
public class WandaZwyDeviceInfoManager {
    private static final Logger log = LoggerFactory.getLogger(WandaZwyDeviceInfoManager.class);
    private final IEDeviceThirdService deviceThirdService;
    private final EDeviceThirdMapper deviceThirdMapper;
    private final EDeviceRayThirdMapper deviceRayThirdMapper;
    private final EDeviceSealedThirdMapper sealedThirdMapper;
    private final EDeviceNonSealedThirdMapper nonSealedThirdMapper;
    private final EDeviceSourceThirdMapper deviceSourceThirdMapper;
    private final DeviceCommonConverter deviceCommonConverter;
    private final IFswsErrorDataReturnLogService errorLogService;

    @Transactional
    public void syncWandaZwyDeviceInfoToRho(WandaSyncPlaceParam param) {
        ArrayList<EDevice> deviceList = new ArrayList<EDevice>();
        ArrayList<FswsErrorDataReturnLog> errorDataList = new ArrayList<FswsErrorDataReturnLog>();
        if (param.getSearchType() == null) {
            param.setSearchType(Integer.valueOf(1));
        }
        List<WandaZwyDeviceVo> addDataList = this.deviceThirdMapper.listNeedAddZwyDeviceFromWanda(param);
        for (WandaZwyDeviceVo addData : addDataList) {
            if (addData.getCid() == null) {
                FswsErrorDataReturnLog errorData = new FswsErrorDataReturnLog();
                errorData.setTableType(String.valueOf(FswsErrorDataTableTypeEnum.FSWS_ZWY_DEVICE_INFO.getValue()));
                errorData.setTableId(addData.getZwyDeviceId());
                errorData.setBizTime(addData.getLoadTime());
                errorData.setErrType(Integer.valueOf(FswsErrorDataErrTypeEnum.EXCEPTION_ERROR.getCode()));
                errorData.setReason("\u672a\u67e5\u8be2\u5230zwyHospitalId\u5bf9\u5e94\u7684rhoHospitalId");
                errorDataList.add(errorData);
                continue;
            }
            Integer deviceType = Integer.parseInt(addData.getType());
            if ((deviceType == EdeviceTypeEnum.SOURCE_NON_SEALED.getValue() || deviceType == EdeviceTypeEnum.SOURCE_SEALED.getValue()) && NeutronNameUtil.isValidMontageName((String)addData.getName())) {
                FswsErrorDataReturnLog errorData = new FswsErrorDataReturnLog();
                errorData.setTableType(String.valueOf(FswsErrorDataTableTypeEnum.FSWS_ZWY_DEVICE_INFO.getValue()));
                errorData.setTableId(addData.getZwyDeviceId());
                errorData.setBizTime(addData.getLoadTime());
                errorData.setErrType(Integer.valueOf(FswsErrorDataErrTypeEnum.EXCEPTION_ERROR.getCode()));
                errorData.setReason("\u6838\u7d20\u540d\u79f0{" + addData.getName() + "}\u4e3a\u975e\u6cd5\u683c\u5f0f");
                errorDataList.add(errorData);
                continue;
            }
            EDevice device = this.deviceCommonConverter.wandaVo2BaseEntity(addData);
            device.setId(Long.valueOf(IdWorker.getId()));
            device.setCid(addData.getCid());
            device.setDataSource(Integer.valueOf(2));
            device.setZwyId(addData.getZwyDeviceId());
            this.deviceThirdService.save(device);
            if (device.getType() == EdeviceTypeEnum.DEVICE_RAY.getValue()) {
                EDeviceRay deviceRay = this.deviceCommonConverter.wandaVo2RayEntity(addData);
                deviceRay.setId(Long.valueOf(IdWorker.getId()));
                deviceRay.setCid(device.getCid());
                deviceRay.setDid(device.getId());
                this.deviceRayThirdMapper.insert(deviceRay);
            } else if (device.getType() == EdeviceTypeEnum.SOURCE_NON_SEALED.getValue()) {
                ESourceNonSealed sourceNonSealed = this.deviceCommonConverter.wandaVo2SourceNonEntity(addData);
                sourceNonSealed.setId(Long.valueOf(IdWorker.getId()));
                sourceNonSealed.setCid(device.getCid());
                sourceNonSealed.setDid(device.getId());
                device.setName(NeutronNameUtil.montageName2OriginalName((String)device.getName()));
                this.nonSealedThirdMapper.insert(sourceNonSealed);
            } else if (device.getType() == EdeviceTypeEnum.SOURCE_SEALED.getValue()) {
                ESourceSealed sourceSealed = this.deviceCommonConverter.wandaVo2SourceSealedEntity(addData);
                sourceSealed.setId(Long.valueOf(IdWorker.getId()));
                sourceSealed.setCid(device.getCid());
                sourceSealed.setDid(device.getId());
                device.setName(NeutronNameUtil.montageName2OriginalName((String)device.getName()));
                this.sealedThirdMapper.insert(sourceSealed);
            } else if (device.getType() == EdeviceTypeEnum.DEVICE_SOURCE.getValue()) {
                EDeviceSource deviceSource = this.deviceCommonConverter.wandaVo2DeviceSourceEntity(addData);
                deviceSource.setId(Long.valueOf(IdWorker.getId()));
                deviceSource.setCid(device.getCid());
                deviceSource.setDid(device.getId());
                this.deviceSourceThirdMapper.insert(deviceSource);
            }
            deviceList.add(device);
        }
        this.errorLogService.saveBatch(errorDataList);
        List<EDevice> updateDataList = this.deviceThirdMapper.listNeedUpdateZwyDeviceFromWanda(param);
        this.deviceThirdService.updateBatchById(updateDataList);
    }

    public WandaZwyDeviceInfoManager(IEDeviceThirdService deviceThirdService, EDeviceThirdMapper deviceThirdMapper, EDeviceRayThirdMapper deviceRayThirdMapper, EDeviceSealedThirdMapper sealedThirdMapper, EDeviceNonSealedThirdMapper nonSealedThirdMapper, EDeviceSourceThirdMapper deviceSourceThirdMapper, DeviceCommonConverter deviceCommonConverter, IFswsErrorDataReturnLogService errorLogService) {
        this.deviceThirdService = deviceThirdService;
        this.deviceThirdMapper = deviceThirdMapper;
        this.deviceRayThirdMapper = deviceRayThirdMapper;
        this.sealedThirdMapper = sealedThirdMapper;
        this.nonSealedThirdMapper = nonSealedThirdMapper;
        this.deviceSourceThirdMapper = deviceSourceThirdMapper;
        this.deviceCommonConverter = deviceCommonConverter;
        this.errorLogService = errorLogService;
    }
}

