/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.third.manager;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import cn.smarthse.rho.modules.sys.entity.b.BCert;
import cn.smarthse.rho.modules.sys.entity.b.BCompany;
import cn.smarthse.rho.modules.sys.enums.company.EdeviceDiagnosisTypeEnum;
import cn.smarthse.rho.modules.sys.enums.staff.CmSourceEnum;
import cn.smarthse.rho.modules.sys.model.b.param.CompanySyncParam;
import cn.smarthse.rho.modules.sys.model.b.vo.CompanyCertSyncVo;
import cn.smarthse.rho.modules.third.service.b.IBCertChangeLogService;
import cn.smarthse.rho.modules.third.service.b.IBCertService;
import cn.smarthse.rho.modules.third.service.b.IBCompanyService;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class WandaFswsHospitalInfoOtherSyncManager {
    private static final Logger log = LoggerFactory.getLogger(WandaFswsHospitalInfoOtherSyncManager.class);
    private static final String LOCK_KEY = "WandaFswsHospitalInfoOtherSyncManager";
    private final RedissonClient redissonClient;
    private final IBCompanyService companyService;
    private final IBCertService certService;
    private final IBCertChangeLogService certChangeLogService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteAndInitNewestInfo(CompanySyncParam param) {
        boolean flag = false;
        String methodName = "deleteAndInitNewestInfo";
        String subKey = "_deleteAndInitNewestInfo";
        String title = "wanda. \u8868: fsws_hospital_info_newest \u5220\u9664\u4e0e\u521b\u5efa\uff1a " + methodName;
        log.debug(title + "start");
        StringBuilder sb = new StringBuilder(LOCK_KEY).append(subKey);
        RLock lock = this.redissonClient.getLock(sb.toString());
        boolean resLock = false;
        try {
            resLock = lock.tryLock(30L, 30L, TimeUnit.MINUTES);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        if (resLock) {
            try {
                this.deleteAndInitNewestInfoSub(param);
                log.debug(title + "end");
                flag = true;
            }
            catch (Exception e) {
                log.error(title + "\u5931\u8d25\uff1a{}", (Throwable)e);
            }
            finally {
                lock.unlock();
            }
        } else {
            log.error("{}\uff1aPending lock timeout\uff0cmethod:" + methodName, (Object)LOCK_KEY);
        }
        return flag;
    }

    private void deleteAndInitNewestInfoSub(CompanySyncParam param) {
        this.companyService.initOtherFswsHospitalInfoNewest(param);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void syncCompanyCert(CompanySyncParam param) {
        String methodName = "syncCompanyCert";
        String subKey = "_syncCompanyCert";
        String title = "wanda. \u8868: fsws_hospital_info_newest \u540c\u6b65\u8bc1\u4e66\uff1a " + methodName;
        log.debug(title + "start");
        StringBuilder sb = new StringBuilder(LOCK_KEY).append(subKey);
        RLock lock = this.redissonClient.getLock(sb.toString());
        boolean resLock = false;
        try {
            resLock = lock.tryLock(240L, 240L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        if (resLock) {
            try {
                this.syncCompanyCertSub(param);
                log.debug(title + "end");
            }
            catch (Exception e) {
                log.error(title + "\u5931\u8d25\uff1a{}", (Throwable)e);
            }
            finally {
                lock.unlock();
            }
        } else {
            log.error("{}\uff1aPending lock timeout\uff0cmethod:" + methodName, (Object)LOCK_KEY);
        }
    }

    private void syncCompanyCertSub(CompanySyncParam param) {
        List<CompanyCertSyncVo> list = this.certService.getWandaSyncInfo(param);
        List<CompanyCertSyncVo> canSyncList = list.stream().filter(v -> this.canSync((CompanyCertSyncVo)v)).collect(Collectors.toList());
        if (CollUtil.isNotEmpty(canSyncList)) {
            List<BCert> entitList = this.wandaSyncInfo2Entity(canSyncList);
            this.certService.saveOrUpdateBatch(entitList);
        }
    }

    private List<BCert> wandaSyncInfo2Entity(List<CompanyCertSyncVo> canSyncList) {
        ArrayList<BCert> resultList = new ArrayList<BCert>();
        for (CompanyCertSyncVo vo : canSyncList) {
            BCert entity = this.wandaSyncInfo2Entity(vo);
            if (entity != null) {
                resultList.add(entity);
            }
            if (resultList.size() <= 500) continue;
            log.debug("\u8bc1\u4e66\u6570\u91cf\u8d85\u8fc7500\uff0c\u5f00\u59cb\u6279\u91cf\u4fdd\u5b58");
            this.certService.saveBatch(resultList);
            resultList.clear();
        }
        return resultList;
    }

    private BCert wandaSyncInfo2Entity(CompanyCertSyncVo vo) {
        BCompany company = this.companyService.getByMedicalNucode(vo.getMedicalNucode());
        if (company == null) {
            return null;
        }
        BCert entity = this.certService.getByCid(company.getId());
        entity = entity == null ? new BCert() : entity;
        entity.setCid(company.getId());
        entity.setSourceId(vo.getSourceId());
        entity.setMedicalNucode(vo.getMedicalNucode());
        entity.setSyncTime(vo.getSyncTime());
        entity.setName(vo.getName());
        entity.setCertNo(vo.getCertNo());
        entity.setBeginDate(vo.getBeginDate());
        entity.setLastVerificationDate(vo.getBeginDate());
        entity.setR(EdeviceDiagnosisTypeEnum.getCodesByNames((String)vo.getRName(), (String)","));
        entity.setSource(CmSourceEnum.WAND.getValue());
        return entity;
    }

    private boolean canSync(CompanyCertSyncVo vo) {
        boolean flag = true;
        if (vo.getBeginDate() == null) {
            flag = false;
        }
        if (StrUtil.isBlank((CharSequence)vo.getName())) {
            flag = false;
        }
        if (StrUtil.isBlank((CharSequence)vo.getSourceId())) {
            flag = false;
        }
        if (vo.getSyncTime() == null) {
            flag = false;
        }
        if (StrUtil.isBlank((CharSequence)vo.getMedicalNucode())) {
            flag = false;
        } else {
            BCompany company = this.companyService.getByMedicalNucode(vo.getMedicalNucode());
            if (company == null) {
                flag = false;
            }
        }
        return flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void syncCompanyCertChangeLog(CompanySyncParam param) {
        String methodName = "syncCompanyCertChangeLog";
        String subKey = "_syncCompanyCertChangeLog";
        String title = "wanda. \u8868: fsws_hospital_info_newest \u540c\u6b65\u8bc1\u4e66\u4fee\u6539\u8bb0\u5f55\uff1a " + methodName;
        log.debug(title + "start");
        StringBuilder sb = new StringBuilder(LOCK_KEY).append(subKey);
        RLock lock = this.redissonClient.getLock(sb.toString());
        boolean resLock = false;
        try {
            resLock = lock.tryLock(240L, 240L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        if (resLock) {
            try {
                this.syncCompanyCertChangeLogSub(param);
                log.debug(title + "end");
            }
            catch (Exception e) {
                log.error(title + "\u5931\u8d25\uff1a{}", (Throwable)e);
            }
            finally {
                lock.unlock();
            }
        } else {
            log.error("{}\uff1aPending lock timeout\uff0cmethod:" + methodName, (Object)LOCK_KEY);
        }
    }

    private void syncCompanyCertChangeLogSub(CompanySyncParam param) {
        this.certChangeLogService.addWandaChangeLog(param);
        this.certChangeLogService.updateWandaChangeLog(param);
        this.certChangeLogService.updateChangeLogCertId(param);
    }

    public WandaFswsHospitalInfoOtherSyncManager(RedissonClient redissonClient, IBCompanyService companyService, IBCertService certService, IBCertChangeLogService certChangeLogService) {
        this.redissonClient = redissonClient;
        this.companyService = companyService;
        this.certService = certService;
        this.certChangeLogService = certChangeLogService;
    }
}

