/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.third.manager;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.StrUtil;
import cn.smarthse.rho.modules.sys.entity.b.BCompany;
import cn.smarthse.rho.modules.sys.entity.c.CHealthCheckData;
import cn.smarthse.rho.modules.sys.entity.wanda.FswsErrorDataReturnLog;
import cn.smarthse.rho.modules.sys.enums.wanda.FswsErrorDataErrTypeEnum;
import cn.smarthse.rho.modules.sys.enums.wanda.FswsErrorDataTableTypeEnum;
import cn.smarthse.rho.modules.sys.enums.wanda.WandaoptTypeEnum;
import cn.smarthse.rho.modules.sys.model.wanda.sync.param.WandaHealthDataSyncParam;
import cn.smarthse.rho.modules.sys.model.wanda.sync.vo.HealthSyncFswsHealthInfoVo;
import cn.smarthse.rho.modules.third.service.b.IBCompanyService;
import cn.smarthse.rho.modules.third.service.c.ICHealthCheckDataService;
import cn.smarthse.rho.modules.third.service.wanda.sync.IFswsErrorDataReturnLogService;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class WandaFswsHealthCheckSyncManager {
    private static final Logger log = LoggerFactory.getLogger(WandaFswsHealthCheckSyncManager.class);
    private final ICHealthCheckDataService healthCheckDataService;
    private final RedissonClient redissonClient;
    private final IBCompanyService companyService;
    private final IFswsErrorDataReturnLogService errorDataReturnLogService;
    private static final String LOCK_KEY = "WandaFswsHealthCheckSyncManager";
    private static final String MAP_KEY_NEED_ADD_INFO = "MAP_KEY_NEED_ADD_INFO";
    private static final String MAP_KEY_NEED_UP_INFO = "MAP_KEY_NEED_UP_INFO";
    private static final String MAP_KEY_NEED_ADD_OR_UP_INFO = "MAP_KEY_NEED_ADD_OR_UP_INFO";
    private static final String MAP_KEY_NEED_DEL_INFO = "MAP_KEY_NEED_DEL_INFO";
    private static final String MAP_KEY_ERROR_INFO = "MAP_KEY_ERROR_INFO";
    private static final Integer DATA_DEAL_TYPE_IGNORE = 0;
    private static final Integer DATA_DEAL_TYPE_NORMAL = 1;
    private static final Integer DATA_DEAL_TYPE_ERROR = 2;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean syncBaseInfoData(WandaHealthDataSyncParam param) {
        log.debug("wanda.fsws_health_card \u4f53\u68c0\u6570\u636e\uff1a syncBaseInfoData() start");
        boolean flag = false;
        StringBuilder sb = new StringBuilder(LOCK_KEY).append("_syncBaseInfoData");
        RLock lock = this.redissonClient.getLock(sb.toString());
        boolean resLock = false;
        try {
            resLock = lock.tryLock(240L, 240L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        if (resLock) {
            try {
                this.syncBaseInfoDataLock(param);
                log.debug("wanda.fsws_health_card \u4f53\u68c0\u6570\u636e\uff1a syncBaseInfoData() end");
                flag = true;
            }
            catch (Exception e) {
                log.error("wanda.fsws_health_card \u4f53\u68c0\u6570\u636e\u5931\u8d25\uff1a{}", (Throwable)e);
                flag = false;
            }
            finally {
                lock.unlock();
            }
        } else {
            log.error("{}\uff1aPending lock timeout\uff0cmethod:syncBaseInfoData()", (Object)LOCK_KEY);
            flag = false;
        }
        return flag;
    }

    public void syncBaseInfoDataLock(WandaHealthDataSyncParam param) {
        this.healthCheckDataService.initFswsHealthCheckCardNewest(param);
        List<HealthSyncFswsHealthInfoVo> list = this.healthCheckDataService.getNeedAddUpInfoFromWandaFswsHealthTable(param);
        this.syncBaseInfoDataSub(list);
    }

    public void syncBaseInfoDataSub(List<HealthSyncFswsHealthInfoVo> list) {
        log.debug("wanda.fsws_health_card \u4f53\u68c0\u6570\u636e\uff1a syncBaseInfoData() start");
        Map<String, List<HealthSyncFswsHealthInfoVo>> infoMap = this.extractInfo(list);
        List<HealthSyncFswsHealthInfoVo> needAddOrUpInfoList = infoMap.get(MAP_KEY_NEED_ADD_OR_UP_INFO);
        List<HealthSyncFswsHealthInfoVo> needDelList = infoMap.get(MAP_KEY_NEED_DEL_INFO);
        List<HealthSyncFswsHealthInfoVo> errorInfoList = infoMap.get(MAP_KEY_ERROR_INFO);
        needAddOrUpInfoList.addAll(needDelList);
        this.addOrUpdate(needAddOrUpInfoList);
        this.dealErrorInfo(errorInfoList);
    }

    private Map<String, List<HealthSyncFswsHealthInfoVo>> extractInfo(List<HealthSyncFswsHealthInfoVo> list) {
        ArrayList addOrUpList = new ArrayList();
        ArrayList needDelList = new ArrayList();
        ArrayList errorList = new ArrayList();
        HashMap<String, List<HealthSyncFswsHealthInfoVo>> resultMap = new HashMap<String, List<HealthSyncFswsHealthInfoVo>>();
        resultMap.put(MAP_KEY_NEED_ADD_OR_UP_INFO, addOrUpList);
        resultMap.put(MAP_KEY_NEED_DEL_INFO, needDelList);
        resultMap.put(MAP_KEY_ERROR_INFO, errorList);
        for (HealthSyncFswsHealthInfoVo vo : list) {
            this.extractOneInfo(vo, resultMap);
        }
        return resultMap;
    }

    private void extractOneInfo(HealthSyncFswsHealthInfoVo vo, Map<String, List<HealthSyncFswsHealthInfoVo>> resultMap) {
        List<HealthSyncFswsHealthInfoVo> addOrUpList = resultMap.get(MAP_KEY_NEED_ADD_OR_UP_INFO);
        List<HealthSyncFswsHealthInfoVo> delLIst = resultMap.get(MAP_KEY_NEED_DEL_INFO);
        List<HealthSyncFswsHealthInfoVo> errorList = resultMap.get(MAP_KEY_ERROR_INFO);
        if ((vo = this.checkData(vo)) != null && vo.getDataDealType() == DATA_DEAL_TYPE_ERROR) {
            errorList.add(vo);
        } else {
            if (vo.getOptType().equals(WandaoptTypeEnum.DEL.getValue())) {
                delLIst.add(vo);
            }
            if (vo.getOptType().equals(WandaoptTypeEnum.ADD.getValue()) || vo.getOptType().equals(WandaoptTypeEnum.UPDATE.getValue())) {
                addOrUpList.add(vo);
            }
        }
    }

    private CHealthCheckData wandaSyncInfo2EntityForAdding(HealthSyncFswsHealthInfoVo vo) {
        CHealthCheckData entity = new CHealthCheckData();
        return entity;
    }

    private HealthSyncFswsHealthInfoVo checkData(HealthSyncFswsHealthInfoVo vo) {
        BCompany company;
        StringBuilder sb = new StringBuilder();
        if (StrUtil.isBlank((CharSequence)vo.getId())) {
            sb.append("\u7f3a\u5c11id\u3002");
        }
        if (StrUtil.isBlank((CharSequence)vo.getName())) {
            sb.append("\u7f3a\u5c11\u59d3\u540d\u3002");
        }
        if (StrUtil.isBlank((CharSequence)vo.getIdcardType())) {
            sb.append("\u7f3a\u5c11\u8eab\u4efd\u8bc1\u4ef6\u7c7b\u522b\u3002");
        } else if (!StrUtil.isNumeric((CharSequence)vo.getIdcardType())) {
            sb.append("\u8eab\u4efd\u8bc1\u4ef6\u7c7b\u522b\u9519\u8bef\u3002");
        }
        if (StrUtil.isBlank((CharSequence)vo.getIdcardCode())) {
            sb.append("\u7f3a\u5c11\u8eab\u4efd\u8bc1\u4ef6\u53f7\u7801\u3002");
        }
        if (StrUtil.isBlank((CharSequence)vo.getSexCode())) {
            sb.append("\u7f3a\u5c11\u6027\u522b\u7f16\u7801\u3002");
        } else if (!vo.getSexCode().equals("1") && !vo.getSexCode().equals("2")) {
            sb.append("\u6027\u522b\u7f16\u7801\u9519\u8bef\u3002");
        }
        if (StrUtil.isBlank((CharSequence)vo.getBirthday())) {
            sb.append("\u7f3a\u5c11\u51fa\u751f\u65e5\u671f\u3002");
        } else {
            try {
                DateUtil.parse((CharSequence)vo.getBirthday(), (String)"yyyy-MM-dd");
            }
            catch (Exception e) {
                sb.append("\u51fa\u751f\u65e5\u671f\u683c\u5f0f\u9519\u8bef\u3002");
            }
        }
        if (StrUtil.isBlank((CharSequence)vo.getJobCode())) {
            sb.append("\u7f3a\u5c11\u5de5\u79cd\u7f16\u7801\u3002");
        }
        if (StrUtil.isBlank((CharSequence)vo.getRadiationType())) {
            sb.append("\u7f3a\u5c11\u653e\u5c04\u5de5\u79cd\u7f16\u7801\u3002");
        }
        if (StrUtil.isBlank((CharSequence)vo.getOrgName())) {
            sb.append("\u7f3a\u5c11\u4f53\u68c0\u673a\u6784\u540d\u79f0\u3002");
        }
        if (StrUtil.isBlank((CharSequence)vo.getCheckType())) {
            sb.append("\u7f3a\u5c11\u68c0\u67e5\u7c7b\u578b\u3002");
        } else if (!NumberUtil.isNumber((CharSequence)vo.getCheckType())) {
            sb.append("\u68c0\u67e5\u7c7b\u578b\u9519\u8bef");
        }
        if (StrUtil.isBlank((CharSequence)vo.getBodyCheckType())) {
            sb.append("\u7f3a\u5c11\u4f53\u68c0\u7c7b\u578b\u7f16\u7801\u3002");
        } else if (!NumberUtil.isNumber((CharSequence)vo.getBodyCheckType())) {
            sb.append("\u4f53\u68c0\u7c7b\u578b\u7f16\u7801\u9519\u8bef");
        }
        if (StrUtil.isBlank((CharSequence)vo.getCheckResultCode())) {
            sb.append("\u7f3a\u5c11\u4e3b\u68c0\u7ed3\u8bba\u3002");
        } else if (!NumberUtil.isNumber((CharSequence)vo.getCheckResultCode())) {
            sb.append("\u4e3b\u68c0\u7ed3\u8bba\u9519\u8bef");
        }
        if (StrUtil.isBlank((CharSequence)vo.getSuggest())) {
            sb.append("\u7f3a\u5c11\u4e3b\u68c0\u5efa\u8bae\u3002");
        }
        if (vo.getCheckTime() == null) {
            sb.append("\u7f3a\u5c11\u4f53\u68c0\u65e5\u671f\u3002");
        } else {
            try {
                DateUtil.parse((CharSequence)vo.getCheckTime(), (String)"yyyy-MM-dd");
            }
            catch (Exception e) {
                sb.append("\u4f53\u68c0\u65e5\u671f\u683c\u5f0f\u9519\u8bef\u3002");
            }
        }
        if (vo.getWriteDate() == null) {
            sb.append("\u7f3a\u5c11\u62a5\u544a\u51fa\u5177\u65e5\u671f\u3002");
        } else {
            try {
                DateUtil.parse((CharSequence)vo.getWriteDate(), (String)"yyyy-MM-dd");
            }
            catch (Exception e) {
                sb.append("\u62a5\u544a\u51fa\u5177\u65e5\u671f\u683c\u5f0f\u9519\u8bef\u3002");
            }
        }
        if (StrUtil.isBlank((CharSequence)vo.getWriteNo())) {
            sb.append("\u7f3a\u5c11\u62a5\u544a\u7f16\u53f7\u3002");
        }
        if (StrUtil.isBlank((CharSequence)vo.getCreditCodeEmployer())) {
            sb.append("\u7f3a\u5c11\u653e\u5c04\u8bca\u7597\u673a\u6784\u540d\u79f0\u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\u3002");
        }
        if (StrUtil.isBlank((CharSequence)vo.getEmployerNameEmployer())) {
            sb.append("\u7f3a\u5c11\u653e\u5c04\u8bca\u7597\u673a\u6784\u540d\u79f0\u540d\u79f0\u3002");
        }
        if (StrUtil.isBlank((CharSequence)vo.getZwyEmployerId())) {
            sb.append("\u7f3a\u5c11\u653e\u5c04\u8bca\u7597\u673a\u6784\u540d\u79f0id (\u804c\u536b\u4e91)\u3002");
        }
        if (StrUtil.isNotBlank((CharSequence)vo.getRhoEmployerId()) && (company = this.companyService.getByIdIncludeDel(vo.getRhoEmployerId())) == null) {
            sb.append("\u653e\u5c04\u536b\u751f\u5728\u7ebf\u4e0d\u5b58\u5728rhoEmployerId\u76f8\u5173\u7f16\u53f7\u7684\u9662\u533a");
        }
        if (StrUtil.isBlank((CharSequence)vo.getAdaptEvaluate())) {
            sb.append("\u7f3a\u5c11\u9002\u4efb\u6027\u8bc4\u4ef7\u3002");
        }
        if (StrUtil.isBlank((CharSequence)vo.getOptType())) {
            sb.append("\u7f3a\u5c11\u64cd\u4f5c\u7c7b\u578b\u3002");
        } else if (!StrUtil.isNumeric((CharSequence)vo.getOptType())) {
            sb.append("\u64cd\u4f5c\u7c7b\u578b\u9519\u8bef\u3002");
        } else if (StrUtil.isEmpty((CharSequence)WandaoptTypeEnum.getName((String)vo.getOptType()))) {
            sb.append("\u64cd\u4f5c\u7c7b\u578b\u9519\u8bef\u3002");
        }
        if (sb.length() > 0) {
            vo.setDataDealType(DATA_DEAL_TYPE_ERROR);
            vo.setErrorDes(sb.toString());
            return vo;
        }
        vo.setDataDealType(DATA_DEAL_TYPE_NORMAL);
        return vo;
    }

    public void addOrUpdate(List<HealthSyncFswsHealthInfoVo> list) {
        if (CollUtil.isEmpty(list)) {
            return;
        }
        for (HealthSyncFswsHealthInfoVo vo : list) {
            try {
                this.addOrupdate(vo);
            }
            catch (Exception e) {
                log.error("Exception\uff1a", (Throwable)e);
            }
        }
    }

    private void addOrupdate(HealthSyncFswsHealthInfoVo vo) {
        CHealthCheckData db = this.healthCheckDataService.getByZwyIdIncludeDel(vo.getId());
        if (db != null && db.getIsValid() == 0) {
            return;
        }
        CHealthCheckData entity = new CHealthCheckData();
        entity.setId(db == null ? null : db.getId());
        entity.setZwyId(vo.getId());
        entity.setName(vo.getName());
        entity.setIdcardType(vo.getIdcardType());
        entity.setIdcard(vo.getIdcardCode());
        entity.setSex(Boolean.valueOf(vo.getSexCode().equals("1")));
        entity.setPost(vo.getJobCode());
        entity.setRaType(vo.getRadiationType());
        entity.setCheckType(Integer.valueOf(vo.getCheckType()));
        entity.setBodyCheckType(vo.getBodyCheckType());
        entity.setPreviousZwyId(vo.getPreviousCardId());
        entity.setOtherPostName(vo.getOtherJobName());
        entity.setSeniorityYear(vo.getSeniorityYear());
        entity.setSeniorityMonth(vo.getSeniorityMonth());
        entity.setResult(null);
        entity.setResultCode(vo.getCheckResultCode());
        entity.setSuggest(vo.getSuggest());
        entity.setCheckDate(LocalDate.parse(vo.getCheckTime(), DateTimeFormatter.ofPattern("yyyy-MM-dd")));
        entity.setReportDate(LocalDate.parse(vo.getWriteDate(), DateTimeFormatter.ofPattern("yyyy-MM-dd")));
        entity.setReportNo(vo.getWriteNo());
        entity.setCreditCodeEmployer(vo.getCreditCodeEmployer());
        entity.setEmployerNameEmployer(vo.getEmployerNameEmployer());
        entity.setZwyEmployerId(vo.getZwyEmployerId());
        entity.setRhoEmployerId(vo.getRhoEmployerId());
        entity.setAssessment(vo.getAdaptEvaluate());
        entity.setWandaLoadTime(vo.getLoadTime());
        entity.setWandaIsDel(Integer.valueOf(vo.getOptType().equals(WandaoptTypeEnum.DEL.getValue()) ? 1 : 0));
        this.healthCheckDataService.saveOrUpdate(entity);
    }

    public void dealErrorInfo(List<HealthSyncFswsHealthInfoVo> errorInfoList) {
        List list = errorInfoList.stream().filter(v -> v.getDataDealType() == 2 && StrUtil.isNotBlank((CharSequence)v.getErrorDes())).collect(Collectors.toList());
        ArrayList<FswsErrorDataReturnLog> errorLogList = new ArrayList<FswsErrorDataReturnLog>();
        for (HealthSyncFswsHealthInfoVo vo : list) {
            FswsErrorDataReturnLog log = new FswsErrorDataReturnLog();
            log.setTableType(String.valueOf(FswsErrorDataTableTypeEnum.FSWS_HOSPITAL_INFO.getValue()));
            log.setTableId(vo.getId());
            log.setBizTime(vo.getLoadTime());
            log.setErrType(Integer.valueOf(FswsErrorDataErrTypeEnum.EXCEPTION_ERROR.getCode()));
            log.setReason(vo.getErrorDes());
            errorLogList.add(log);
        }
        if (CollUtil.isNotEmpty(errorLogList)) {
            this.errorDataReturnLogService.saveBatch(errorLogList);
        }
    }

    public WandaFswsHealthCheckSyncManager(ICHealthCheckDataService healthCheckDataService, RedissonClient redissonClient, IBCompanyService companyService, IFswsErrorDataReturnLogService errorDataReturnLogService) {
        this.healthCheckDataService = healthCheckDataService;
        this.redissonClient = redissonClient;
        this.companyService = companyService;
        this.errorDataReturnLogService = errorDataReturnLogService;
    }
}

