/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.third.manager;

import cn.smarthse.rho.modules.sys.model.wanda.sync.param.WandaHealthDataSyncParam;
import cn.smarthse.rho.modules.third.service.b.IBCompanyService;
import cn.smarthse.rho.modules.third.service.c.ICHealthCheckDataService;
import java.util.concurrent.TimeUnit;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class WandaFswsHCFactorsSyncManager {
    private static final Logger log = LoggerFactory.getLogger(WandaFswsHCFactorsSyncManager.class);
    private final ICHealthCheckDataService healthCheckDataService;
    private final RedissonClient redissonClient;
    private final IBCompanyService companyService;
    private static final String LOCK_KEY = "WandaFswsHCFactorsSyncManager";
    private static final String MAP_KEY_NEED_ADD_INFO = "MAP_KEY_NEED_ADD_INFO";
    private static final String MAP_KEY_NEED_UP_INFO = "MAP_KEY_NEED_UP_INFO";
    private static final String MAP_KEY_NEED_ADD_OR_UP_INFO = "MAP_KEY_NEED_ADD_OR_UP_INFO";
    private static final String MAP_KEY_NEED_DEL_INFO = "MAP_KEY_NEED_DEL_INFO";
    private static final String MAP_KEY_ERROR_INFO = "MAP_KEY_ERROR_INFO";
    private static final Integer DATA_DEAL_TYPE_IGNORE = 0;
    private static final Integer DATA_DEAL_TYPE_NORMAL = 1;
    private static final Integer DATA_DEAL_TYPE_ERROR = 2;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean syncBaseInfoData(WandaHealthDataSyncParam param) {
        log.debug("wanda.fsws_hc_Factors \u4f53\u68c0\u5371\u5bb3\u56e0\u7d20\uff1a syncBaseInfoData() start");
        boolean flag = false;
        StringBuilder sb = new StringBuilder(LOCK_KEY).append("_syncBaseInfoData");
        RLock lock = this.redissonClient.getLock(sb.toString());
        boolean resLock = false;
        try {
            resLock = lock.tryLock(240L, 240L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        if (resLock) {
            try {
                this.syncBaseInfoDataLock(param);
                log.debug("wanda.fsws_hc_Factors \u4f53\u68c0\u5371\u5bb3\u56e0\u7d20\uff1a syncBaseInfoData() end");
                flag = true;
            }
            catch (Exception e) {
                log.error("wanda.fsws_hc_Factors \u4f53\u68c0\u5371\u5bb3\u56e0\u7d20\u5931\u8d25\uff1a{}", (Throwable)e);
                flag = false;
            }
            finally {
                lock.unlock();
            }
        } else {
            log.error("{}\uff1aPending lock timeout\uff0cmethod:syncBaseInfoData()", (Object)LOCK_KEY);
            flag = false;
        }
        return flag;
    }

    public void syncBaseInfoDataLock(WandaHealthDataSyncParam param) {
        this.healthCheckDataService.initFswsHCFactorsNewest(param);
        this.healthCheckDataService.insertFswsHCFactors2Rho(param);
        this.healthCheckDataService.updateFswsHCFactors2Rho(param);
    }

    public WandaFswsHCFactorsSyncManager(ICHealthCheckDataService healthCheckDataService, RedissonClient redissonClient, IBCompanyService companyService) {
        this.healthCheckDataService = healthCheckDataService;
        this.redissonClient = redissonClient;
        this.companyService = companyService;
    }
}

