/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.third.manager;

import cn.hutool.core.collection.CollUtil;
import cn.smarthse.common.redis.utils.RedisUtils;
import cn.smarthse.rho.modules.sys.entity.c.CDose;
import cn.smarthse.rho.modules.sys.entity.c.CDoseData;
import cn.smarthse.rho.modules.sys.entity.wanda.FswsDoseMonitor;
import cn.smarthse.rho.modules.sys.entity.wanda.FswsDoseMonitorData;
import cn.smarthse.rho.modules.sys.entity.wanda.FswsErrorDataReturnLog;
import cn.smarthse.rho.modules.sys.enums.wanda.FswsErrorDataErrTypeEnum;
import cn.smarthse.rho.modules.sys.enums.wanda.FswsErrorDataTableTypeEnum;
import cn.smarthse.rho.modules.sys.model.wanda.sync.param.WandaSyncDoseParam;
import cn.smarthse.rho.modules.third.service.c.ICDoseDataService;
import cn.smarthse.rho.modules.third.service.c.ICDoseService;
import cn.smarthse.rho.modules.third.service.wanda.sync.IFswsErrorDataReturnLogService;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.xxl.job.core.context.XxlJobHelper;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.redisson.api.RLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class WandaFswsDoseMonitorManager {
    private static final Logger log = LoggerFactory.getLogger(WandaFswsDoseMonitorManager.class);
    private final ICDoseService doseService;
    private final ICDoseDataService doseDataService;
    private final IFswsErrorDataReturnLogService fswsErrorDataReturnLogService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean syncData(WandaSyncDoseParam param) {
        RLock lock = RedisUtils.getClient().getLock("wanda:WandaDoseMonitorSyncTask");
        try {
            if (lock.tryLock(10L, TimeUnit.MINUTES)) {
                log.info("[WandaDoseMonitorSyncTask] wanda.fsws_dose_monitor\u3001wanda.fsws_dose_monitor_data \u5f00\u59cb");
                XxlJobHelper.log((String)"[WandaDoseMonitorSyncTask] wanda.fsws_dose_monitor\u3001wanda.fsws_dose_monitor_data \u5f00\u59cb", (Object[])new Object[0]);
                if (Objects.isNull(param.getEndDate())) {
                    param.setEndDate(LocalDateTime.now());
                }
                log.info("[WandaDoseMonitorSyncTask] wanda.fsws_dose_monitor \u6807\u8bc6\u6700\u65b0\u6570\u636e\u5f00\u59cb");
                XxlJobHelper.log((String)"[WandaDoseMonitorSyncTask] wanda.fsws_dose_monitor \u6807\u8bc6\u6700\u65b0\u6570\u636e\u5f00\u59cb", (Object[])new Object[0]);
                this.doseService.updateLatestFlag();
                log.info("[WandaDoseMonitorSyncTask] wanda.fsws_dose_monitor \u6807\u8bc6\u6700\u65b0\u6570\u636e\u7ed3\u675f");
                XxlJobHelper.log((String)"[WandaDoseMonitorSyncTask] wanda.fsws_dose_monitor \u6807\u8bc6\u6700\u65b0\u6570\u636e\u7ed3\u675f", (Object[])new Object[0]);
                log.info("[WandaDoseMonitorSyncTask] wanda.fsws_dose_monitor \u5224\u65ad\u5f02\u5e38\u6570\u636e\u8bb0\u5f55\u3001\u6b63\u5f0f\u6570\u636e\u5165\u5e93\u5f00\u59cb===========================================");
                XxlJobHelper.log((String)"[WandaDoseMonitorSyncTask] wanda.fsws_dose_monitor \u5224\u65ad\u5f02\u5e38\u6570\u636e\u8bb0\u5f55\u3001\u6b63\u5f0f\u6570\u636e\u5165\u5e93\u5f00\u59cb===========================================", (Object[])new Object[0]);
                LocalDateTime data1 = this.doseService.getMaxSourceLoadTime();
                param.setStartDate(data1);
                this.processMonitorData(param);
                log.info("[WandaDoseMonitorSyncTask] wanda.fsws_dose_monitor \u5224\u65ad\u5f02\u5e38\u6570\u636e\u8bb0\u5f55\u3001\u6b63\u5f0f\u6570\u636e\u5165\u5e93\u7ed3\u675f===========================================");
                XxlJobHelper.log((String)"[WandaDoseMonitorSyncTask] wanda.fsws_dose_monitor \u5224\u65ad\u5f02\u5e38\u6570\u636e\u8bb0\u5f55\u3001\u6b63\u5f0f\u6570\u636e\u5165\u5e93\u7ed3\u675f===========================================", (Object[])new Object[0]);
                PageHelper.clearPage();
                param.setPage(1);
                param.setCount(Boolean.valueOf(true));
                log.info("[WandaDoseMonitorSyncTask] wanda.fsws_dose_monitor_data \u6807\u8bc6\u6700\u65b0\u6570\u636e\u5f00\u59cb");
                XxlJobHelper.log((String)"[WandaDoseMonitorSyncTask] wanda.fsws_dose_monitor_data \u6807\u8bc6\u6700\u65b0\u6570\u636e\u5f00\u59cb", (Object[])new Object[0]);
                this.doseDataService.updateLatestFlag();
                log.info("[WandaDoseMonitorSyncTask] wanda.fsws_dose_monitor_data \u6807\u8bc6\u6700\u65b0\u6570\u636e\u7ed3\u675f");
                XxlJobHelper.log((String)"[WandaDoseMonitorSyncTask] wanda.fsws_dose_monitor_data \u6807\u8bc6\u6700\u65b0\u6570\u636e\u7ed3\u675f", (Object[])new Object[0]);
                log.info("[WandaDoseMonitorSyncTask] wanda.fsws_dose_monitor_data \u5224\u65ad\u5f02\u5e38\u6570\u636e\u8bb0\u5f55\u3001\u6b63\u5f0f\u6570\u636e\u5165\u5e93\u5f00\u59cb===========================================");
                XxlJobHelper.log((String)"[WandaDoseMonitorSyncTask] wanda.fsws_dose_monitor_data \u5224\u65ad\u5f02\u5e38\u6570\u636e\u8bb0\u5f55\u3001\u6b63\u5f0f\u6570\u636e\u5165\u5e93\u5f00\u59cb===========================================", (Object[])new Object[0]);
                LocalDateTime data2 = this.doseDataService.getMaxSourceLoadTime();
                param.setStartDate(data2);
                this.processMonitorDataData(param);
                log.info("[WandaDoseMonitorSyncTask] wanda.fsws_dose_monitor_data \u5224\u65ad\u5f02\u5e38\u6570\u636e\u8bb0\u5f55\u3001\u6b63\u5f0f\u6570\u636e\u5165\u5e93\u7ed3\u675f===========================================");
                XxlJobHelper.log((String)"[WandaDoseMonitorSyncTask] wanda.fsws_dose_monitor_data \u5224\u65ad\u5f02\u5e38\u6570\u636e\u8bb0\u5f55\u3001\u6b63\u5f0f\u6570\u636e\u5165\u5e93\u7ed3\u675f===========================================", (Object[])new Object[0]);
                log.info("[WandaDoseMonitorSyncTask] db_rho.c_dose \u8865\u5145\u653e\u5c04\u536b\u751f\u81ea\u8eab\u6570\u636e\u5e93\u6570\u636e\u5f00\u59cb");
                XxlJobHelper.log((String)"[WandaDoseMonitorSyncTask] db_rho.c_dose \u8865\u5145\u653e\u5c04\u536b\u751f\u81ea\u8eab\u6570\u636e\u5e93\u6570\u636e\u5f00\u59cb", (Object[])new Object[0]);
                param.setStartDate(data1);
                this.doseService.updateCid(param);
                log.info("[WandaDoseMonitorSyncTask] db_rho.c_dose \u8865\u5145\u653e\u5c04\u536b\u751f\u81ea\u8eab\u6570\u636e\u5e93\u6570\u636e\u7ed3\u675f");
                XxlJobHelper.log((String)"[WandaDoseMonitorSyncTask] db_rho.c_dose \u8865\u5145\u653e\u5c04\u536b\u751f\u81ea\u8eab\u6570\u636e\u5e93\u6570\u636e\u7ed3\u675f", (Object[])new Object[0]);
                log.info("[WandaDoseMonitorSyncTask] db_rho.c_dose_data \u8865\u5145\u653e\u5c04\u536b\u751f\u81ea\u8eab\u6570\u636e\u5e93\u6570\u636e\u5f00\u59cb");
                XxlJobHelper.log((String)"[WandaDoseMonitorSyncTask] db_rho.c_dose_data \u8865\u5145\u653e\u5c04\u536b\u751f\u81ea\u8eab\u6570\u636e\u5e93\u6570\u636e\u5f00\u59cb", (Object[])new Object[0]);
                param.setStartDate(data2);
                this.doseDataService.updateBaseIdAndCidAndTechName(param);
                this.doseDataService.updateStaffBaseInfoId(param);
                log.info("[WandaDoseMonitorSyncTask] db_rho.c_dose_data \u8865\u5145\u653e\u5c04\u536b\u751f\u81ea\u8eab\u6570\u636e\u5e93\u6570\u636e\u7ed3\u675f");
                XxlJobHelper.log((String)"[WandaDoseMonitorSyncTask] db_rho.c_dose_data \u8865\u5145\u653e\u5c04\u536b\u751f\u81ea\u8eab\u6570\u636e\u5e93\u6570\u636e\u7ed3\u675f", (Object[])new Object[0]);
            }
        }
        catch (Exception e) {
            log.error("[WandaDoseMonitorSyncTask] wanda.fsws_dose_monitor\u3001wanda.fsws_dose_monitor_data \u5f02\u5e38\uff1a", (Throwable)e);
            XxlJobHelper.log((String)"[WandaDoseMonitorSyncTask] wanda.fsws_dose_monitor\u3001wanda.fsws_dose_monitor_data \u5f02\u5e38\uff1a", (Object[])new Object[]{e});
            boolean bl = false;
            return bl;
        }
        finally {
            lock.unlock();
            log.info("[WandaDoseMonitorSyncTask] wanda.fsws_dose_monitor\u3001wanda.fsws_dose_monitor_data \u7ed3\u675f");
            XxlJobHelper.log((String)"[WandaDoseMonitorSyncTask] wanda.fsws_dose_monitor\u3001wanda.fsws_dose_monitor_data \u7ed3\u675f", (Object[])new Object[0]);
        }
        return true;
    }

    private void processMonitorData(WandaSyncDoseParam param) {
        int pages = 0;
        do {
            PageInfo<FswsDoseMonitor> page = this.doseService.selectDoseDataPage(param);
            log.info(String.format("[WandaDoseMonitorSyncTask] wanda.fsws_dose_monitor \u672c\u6b21\u8f6c\u6362\u5171\u6709%s\u6570\u636e", page.getTotal()));
            XxlJobHelper.log((String)String.format("[WandaDoseMonitorSyncTask] wanda.fsws_dose_monitor \u672c\u6b21\u8f6c\u6362\u5171\u6709%s\u6570\u636e", page.getTotal()), (Object[])new Object[0]);
            if (pages == 0) {
                pages = page.getPages();
            }
            if (page.getSize() > 0) {
                ArrayList<FswsErrorDataReturnLog> exceptionList = new ArrayList<FswsErrorDataReturnLog>(page.getSize() + 1);
                ArrayList<CDose> finalList = new ArrayList<CDose>(page.getSize() + 1);
                List dataList = page.getList();
                for (FswsDoseMonitor dto : dataList) {
                    FswsErrorDataReturnLog exception = new FswsErrorDataReturnLog();
                    CDose entity = new CDose();
                    StringBuffer sb = new StringBuffer();
                    entity.setId(Long.valueOf(IdWorker.getId()));
                    entity.setSourceId(dto.getId());
                    entity.setSourceLoadTime(dto.getLoadTime());
                    if (Objects.nonNull(dto.getZwyHospitalId())) {
                        entity.setSourceCid(dto.getZwyHospitalId());
                    } else {
                        sb.append("[zwyHospitalId]\u4e0d\u80fd\u4e3a\u7a7a\uff1b");
                    }
                    entity.setReportNo(dto.getReportNo());
                    entity.setReportUrl(dto.getReportUrl());
                    entity.setOrgName(dto.getOrgName());
                    entity.setOrgCode(dto.getOrgCode());
                    try {
                        if (Objects.nonNull(dto.getCycleDays())) {
                            entity.setCycleDays(Integer.valueOf(dto.getCycleDays()));
                        }
                    }
                    catch (Exception e) {
                        sb.append("[cycleDays]\u683c\u5f0f\u9519\u8bef\uff1b");
                    }
                    try {
                        if (Objects.nonNull(dto.getBeginDate())) {
                            entity.setBeginDate(LocalDate.parse(dto.getBeginDate()));
                        }
                    }
                    catch (Exception e) {
                        sb.append("[beginDate]\u683c\u5f0f\u9519\u8bef\uff1b");
                    }
                    try {
                        if (Objects.nonNull(dto.getEndDate())) {
                            entity.setEndDate(LocalDate.parse(dto.getEndDate()));
                        }
                    }
                    catch (Exception e) {
                        sb.append("[endDate]\u683c\u5f0f\u9519\u8bef\uff1b");
                    }
                    try {
                        if (Objects.nonNull(dto.getOptType())) {
                            int optType = Integer.parseInt(dto.getOptType());
                            if (optType == 1 || optType == 2) {
                                entity.setIsValid(Integer.valueOf(1));
                            } else if (optType == 3) {
                                entity.setIsValid(Integer.valueOf(0));
                            } else {
                                sb.append("[optType]\u53ea\u80fd\u4e3a1\u62162\u62163\uff1b");
                            }
                        }
                    }
                    catch (Exception e) {
                        sb.append("[optType]\u683c\u5f0f\u9519\u8bef\uff1b");
                    }
                    if (sb.length() > 0) {
                        exception.setId(IdWorker.getIdStr());
                        exception.setTableType(String.valueOf(FswsErrorDataTableTypeEnum.FSWS_DOSE_MONITOR.getValue()));
                        exception.setTableId(dto.getId());
                        exception.setBizTime(dto.getLoadTime());
                        exception.setErrType(Integer.valueOf(FswsErrorDataErrTypeEnum.FORMAT_ERROR.getCode()));
                        exception.setReason(sb.toString());
                        exceptionList.add(exception);
                        continue;
                    }
                    finalList.add(entity);
                }
                log.info(String.format("[WandaDoseMonitorSyncTask] wanda.fsws_dose_monitor \u6570\u636e\u8f6c\u6362\u7b2c%s\u6279\u6b21\u5f00\u59cb", page.getPageNum()));
                XxlJobHelper.log((String)String.format("[WandaDoseMonitorSyncTask] wanda.fsws_dose_monitor \u6570\u636e\u8f6c\u6362\u7b2c%s\u6279\u6b21\u5f00\u59cb", page.getPageNum()), (Object[])new Object[0]);
                if (CollUtil.isNotEmpty(finalList)) {
                    this.doseService.addOrUpdateDoseData(finalList);
                }
                if (CollUtil.isNotEmpty(exceptionList)) {
                    this.fswsErrorDataReturnLogService.saveBatch(exceptionList);
                }
                finalList.clear();
                exceptionList.clear();
                page.getList().clear();
                log.info(String.format("[WandaDoseMonitorSyncTask] wanda.fsws_dose_monitor \u6570\u636e\u8f6c\u6362\u7b2c%s\u6279\u6b21\u7ed3\u675f", page.getPageNum()));
                XxlJobHelper.log((String)String.format("[WandaDoseMonitorSyncTask] wanda.fsws_dose_monitor \u6570\u636e\u8f6c\u6362\u7b2c%s\u6279\u6b21\u7ed3\u675f", page.getPageNum()), (Object[])new Object[0]);
            }
            param.setPage(param.getPage() + 1);
            param.setCount(Boolean.valueOf(false));
        } while (param.getPage() <= pages);
    }

    private void processMonitorDataData(WandaSyncDoseParam param) {
        int pages = 0;
        do {
            PageInfo<FswsDoseMonitorData> page = this.doseDataService.selectDoseDataDataPage(param);
            log.info(String.format("[WandaDoseMonitorSyncTask] wanda.fsws_dose_monitor_data \u672c\u6b21\u8f6c\u6362\u5171\u6709%s\u6570\u636e", page.getTotal()));
            XxlJobHelper.log((String)String.format("[WandaDoseMonitorSyncTask] wanda.fsws_dose_monitor_data \u672c\u6b21\u8f6c\u6362\u5171\u6709%s\u6570\u636e", page.getTotal()), (Object[])new Object[0]);
            if (pages == 0) {
                pages = page.getPages();
            }
            if (page.getSize() > 0) {
                ArrayList<FswsErrorDataReturnLog> exceptionList = new ArrayList<FswsErrorDataReturnLog>(page.getSize() + 1);
                ArrayList<CDoseData> finalList = new ArrayList<CDoseData>(page.getSize() + 1);
                List dataList = page.getList();
                for (FswsDoseMonitorData dto : dataList) {
                    FswsErrorDataReturnLog exception = new FswsErrorDataReturnLog();
                    CDoseData entity = new CDoseData();
                    StringBuffer sb = new StringBuffer();
                    entity.setId(Long.valueOf(IdWorker.getId()));
                    entity.setSourceId(dto.getId());
                    entity.setSourceCheckId(dto.getCheckId());
                    entity.setSourceLoadTime(dto.getLoadTime());
                    if (Objects.nonNull(dto.getZwyHospitalId())) {
                        entity.setSourceCid(dto.getZwyHospitalId());
                    } else {
                        sb.append("[zwyHospitalId]\u4e0d\u80fd\u4e3a\u7a7a\uff1b");
                    }
                    entity.setName(dto.getName());
                    entity.setIdcard(dto.getIdCard());
                    try {
                        if (Objects.nonNull(dto.getSex())) {
                            int sex = Integer.parseInt(dto.getSex());
                            if (sex == 0 || sex == 1) {
                                entity.setSex(Integer.valueOf(sex));
                            } else {
                                sb.append("[sex]\u53ea\u80fd\u4e3a0\u62161\uff1b");
                            }
                        }
                    }
                    catch (Exception e) {
                        sb.append("[sex]\u683c\u5f0f\u9519\u8bef\uff1b");
                    }
                    try {
                        if (Objects.nonNull(dto.getAge())) {
                            entity.setSex(Integer.valueOf(Integer.parseInt(dto.getAge())));
                        }
                    }
                    catch (Exception e) {
                        sb.append("[age]\u683c\u5f0f\u9519\u8bef\uff1b");
                    }
                    entity.setPost(dto.getPost());
                    entity.setRaType(dto.getRaType());
                    entity.setExposureType(dto.getExposureType());
                    try {
                        if (Objects.nonNull(dto.getBeginDate())) {
                            entity.setBeginDate(LocalDate.parse(dto.getBeginDate()));
                        }
                    }
                    catch (Exception e) {
                        sb.append("[beginDate]\u683c\u5f0f\u9519\u8bef\uff1b");
                    }
                    try {
                        if (Objects.nonNull(dto.getEndDate())) {
                            entity.setEndDate(LocalDate.parse(dto.getEndDate()));
                        }
                    }
                    catch (Exception e) {
                        sb.append("[endDate]\u683c\u5f0f\u9519\u8bef\uff1b");
                    }
                    entity.setResult(dto.getResult());
                    entity.setDoseResult(dto.getDoseResult());
                    entity.setBigDoseReport(dto.getBigDoseReport());
                    entity.setBigDoseReportName(dto.getBigDoseReportName());
                    try {
                        entity.setIsBigDose(Boolean.valueOf(dto.getIsBigDose()));
                    }
                    catch (Exception e) {
                        sb.append("[isBigDose]\u683c\u5f0f\u9519\u8bef\uff1b");
                    }
                    try {
                        entity.setIsYearBigDose(Boolean.valueOf(dto.getIsYearBigDose()));
                    }
                    catch (Exception e) {
                        sb.append("[isYearBigDose]\u683c\u5f0f\u9519\u8bef\uff1b");
                    }
                    entity.setInvestigateStatus(dto.getInvestigateStatus());
                    entity.setInvestigator(dto.getInvestigator());
                    try {
                        if (Objects.nonNull(dto.getOptType())) {
                            int optType = Integer.parseInt(dto.getOptType());
                            if (optType == 1 || optType == 2) {
                                entity.setIsValid(Integer.valueOf(1));
                            } else if (optType == 3) {
                                entity.setIsValid(Integer.valueOf(0));
                            } else {
                                sb.append("[optType]\u53ea\u80fd\u4e3a1\u62162\u62163\uff1b");
                            }
                        }
                    }
                    catch (Exception e) {
                        sb.append("[optType]\u683c\u5f0f\u9519\u8bef\uff1b");
                    }
                    if (sb.length() > 0) {
                        exception.setId(IdWorker.getIdStr());
                        exception.setTableType(String.valueOf(FswsErrorDataTableTypeEnum.FSWS_DOSE_MONITOR_DATA.getValue()));
                        exception.setTableId(dto.getId());
                        exception.setBizTime(dto.getLoadTime());
                        exception.setErrType(Integer.valueOf(FswsErrorDataErrTypeEnum.FORMAT_ERROR.getCode()));
                        exception.setReason(sb.toString());
                        exceptionList.add(exception);
                        continue;
                    }
                    finalList.add(entity);
                }
                log.info(String.format("[WandaDoseMonitorSyncTask] wanda.fsws_dose_monitor_data \u6570\u636e\u8f6c\u6362\u7b2c%s\u6279\u6b21\u5f00\u59cb", page.getPageNum()));
                XxlJobHelper.log((String)String.format("[WandaDoseMonitorSyncTask] wanda.fsws_dose_monitor_data \u6570\u636e\u8f6c\u6362\u7b2c%s\u6279\u6b21\u5f00\u59cb", page.getPageNum()), (Object[])new Object[0]);
                if (CollUtil.isNotEmpty(finalList)) {
                    this.doseDataService.addOrUpdateDoseDataData(finalList);
                }
                if (CollUtil.isNotEmpty(exceptionList)) {
                    this.fswsErrorDataReturnLogService.saveBatch(exceptionList);
                }
                finalList.clear();
                exceptionList.clear();
                page.getList().clear();
                log.info(String.format("[WandaDoseMonitorSyncTask] wanda.fsws_dose_monitor_data \u6570\u636e\u8f6c\u6362\u7b2c%s\u6279\u6b21\u7ed3\u675f", page.getPageNum()));
                XxlJobHelper.log((String)String.format("[WandaDoseMonitorSyncTask] wanda.fsws_dose_monitor_data \u6570\u636e\u8f6c\u6362\u7b2c%s\u6279\u6b21\u7ed3\u675f", page.getPageNum()), (Object[])new Object[0]);
            }
            param.setPage(param.getPage() + 1);
            param.setCount(Boolean.valueOf(false));
        } while (param.getPage() <= pages);
    }

    public WandaFswsDoseMonitorManager(ICDoseService doseService, ICDoseDataService doseDataService, IFswsErrorDataReturnLogService fswsErrorDataReturnLogService) {
        this.doseService = doseService;
        this.doseDataService = doseDataService;
        this.fswsErrorDataReturnLogService = fswsErrorDataReturnLogService;
    }
}

