/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.third.manager;

import cn.smarthse.rho.modules.sys.model.wanda.sync.param.WandaSyncParam;
import cn.smarthse.rho.modules.third.service.device.IDDeviceCheckDataService;
import java.util.concurrent.TimeUnit;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class WandaFswsDeviceCheckDataSyncManager {
    private static final Logger log = LoggerFactory.getLogger(WandaFswsDeviceCheckDataSyncManager.class);
    private final IDDeviceCheckDataService deviceCheckDataService;
    private final RedissonClient redissonClient;
    private static final String LOCK_KEY = "WANDA_FSWS_DEVICE_CHECK_DATA_LOCK";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void syncData(WandaSyncParam syncParam) {
        RLock lock = this.redissonClient.getLock(LOCK_KEY);
        try {
            boolean isLocked = lock.tryLock(20L, 180L, TimeUnit.SECONDS);
            if (isLocked) {
                log.info("\u3010\u8bbe\u5907\u68c0\u6d4b\u6570\u636e\u5b50\u8868\u3011-\u6700\u65b0\u6570\u636e\u6807\u8bc6\u5b57\u6bb5\u66f4\u65b0\u5f00\u59cb...");
                this.deviceCheckDataService.updateLatestFlag();
                log.info("\u3010\u8bbe\u5907\u68c0\u6d4b\u6570\u636e\u5b50\u8868\u3011-\u6700\u65b0\u6570\u636e\u6807\u8bc6\u5b57\u6bb5\u66f4\u65b0\u5b8c\u6210...");
                log.info("\u3010\u8bbe\u5907\u68c0\u6d4b\u6570\u636e\u5b50\u8868\u3011-\u6570\u636e\u540c\u6b65\u4efb\u52a1\u5f00\u59cb...");
                this.deviceCheckDataService.syncDataMain(syncParam);
                log.info("\u3010\u8bbe\u5907\u68c0\u6d4b\u6570\u636e\u5b50\u8868\u3011-\u6570\u636e\u540c\u6b65\u4efb\u52a1\u5b8c\u6210...");
                log.info("\u3010\u8bbe\u5907\u68c0\u6d4b\u6570\u636e\u5b50\u8868\u3011-\u8865\u507f\u66f4\u65b0\u76f8\u5173\u5b57\u6bb5\u4efb\u52a1\u5f00\u59cb...");
                this.deviceCheckDataService.updateAfterSync(syncParam);
                log.info("\u3010\u8bbe\u5907\u68c0\u6d4b\u6570\u636e\u5b50\u8868\u3011-\u8865\u507f\u66f4\u65b0\u76f8\u5173\u5b57\u6bb5\u4efb\u52a1\u5b8c\u6210...");
            } else {
                log.info("\u65e0\u6cd5\u83b7\u53d6\u9501\uff0c\u653e\u5f03\u540c\u6b65\u6570\u636e...");
            }
        }
        catch (Exception e) {
            log.error("\u4e07\u8fbe\u6570\u636e\u540c\u6b65-\u8bbe\u5907\u68c0\u6d4b\u6570\u636e\u5b50\u8868\u540c\u6b65\u4efb\u52a1\u5f02\u5e38\uff1a", (Throwable)e);
        }
        finally {
            if (lock.isHeldByCurrentThread()) {
                lock.unlock();
            }
        }
    }

    public WandaFswsDeviceCheckDataSyncManager(IDDeviceCheckDataService deviceCheckDataService, RedissonClient redissonClient) {
        this.deviceCheckDataService = deviceCheckDataService;
        this.redissonClient = redissonClient;
    }
}

