/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.third.framework.util;

import cn.hutool.core.util.StrUtil;
import cn.smarthse.common.framework.Constants;
import cn.smarthse.core.framework.utils.ServletUtils;
import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTVerifier;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.exceptions.JWTDecodeException;
import com.auth0.jwt.exceptions.JWTVerificationException;
import com.auth0.jwt.interfaces.Claim;
import com.auth0.jwt.interfaces.DecodedJWT;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;

public class JwtUtils {
    public static Long getUserId() {
        try {
            DecodedJWT jwt = JWT.decode((String)JwtUtils.getToken());
            return jwt.getClaim("userId").asLong();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Long getUserId(String token) {
        try {
            DecodedJWT jwt = JWT.decode((String)token);
            return jwt.getClaim("userId").asLong();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getUsername() {
        try {
            DecodedJWT jwt = JWT.decode((String)JwtUtils.getToken());
            return jwt.getClaim("username").asString();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getUsername(String token) {
        try {
            DecodedJWT jwt = JWT.decode((String)token);
            return jwt.getClaim("username").asString();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Long getOid() {
        try {
            DecodedJWT jwt = JWT.decode((String)JwtUtils.getToken());
            return jwt.getClaim("oid").asLong();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Long getOid(String token) {
        try {
            DecodedJWT jwt = JWT.decode((String)token);
            return jwt.getClaim("oid").asLong();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getToken(HttpServletRequest request) {
        String token = request.getHeader(Constants.TOKEN_HEADER_NAME);
        if (StrUtil.isBlank((CharSequence)token)) {
            return request.getParameter(Constants.REFRESH_TOKEN_HEADER_NAME);
        }
        return token;
    }

    public static String createToken(Long userId, String username, Long oid, String ip, String secret, Long time) {
        Date date = new Date(System.currentTimeMillis() + time);
        Algorithm algorithm = Algorithm.HMAC256((String)secret);
        return JWT.create().withClaim("userId", userId).withClaim("username", username).withClaim("oid", oid).withClaim("ip", ip).withExpiresAt(date).sign(algorithm);
    }

    public static String createToken(Long userId, String username, String secret, Long time) {
        Date date = new Date(System.currentTimeMillis() + time);
        Algorithm algorithm = Algorithm.HMAC256((String)secret);
        return JWT.create().withClaim("userId", userId).withClaim("username", username).withExpiresAt(date).sign(algorithm);
    }

    public static boolean verify(String token, String secret) {
        try {
            Algorithm algorithm = Algorithm.HMAC256((String)secret);
            JWTVerifier verifier = JWT.require((Algorithm)algorithm).withClaim("username", JwtUtils.getUsername(token)).withClaim("userId", JwtUtils.getUserId(token)).build();
            verifier.verify(token);
            return true;
        }
        catch (JWTVerificationException exception) {
            return false;
        }
    }

    private static String getToken() {
        return ServletUtils.getRequest().getHeader(Constants.TOKEN_HEADER_NAME);
    }

    public static Boolean isTokenExpired(String token) {
        Date expiration = JwtUtils.getExpiration(token);
        return expiration == null || expiration.before(new Date());
    }

    public static Date getExpiration(String token) {
        try {
            return ((Claim)JWT.decode((String)token).getClaims().get("exp")).asDate();
        }
        catch (JWTDecodeException e) {
            return null;
        }
    }

    public static Long getExpirationLong(String token) {
        try {
            return ((Claim)JWT.decode((String)token).getClaims().get("exp")).asLong();
        }
        catch (JWTDecodeException e) {
            return null;
        }
    }
}

