/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.third.framework.handler;

import cn.smarthse.common.framework.database.persistence.ResponseData;
import cn.smarthse.common.framework.enums.ResponseStateEnum;
import cn.smarthse.core.framework.utils.ServletUtils;
import cn.smarthse.rho.modules.third.bootstrap.JwtProperties;
import cn.smarthse.rho.modules.third.framework.util.ApiJwtUtil;
import com.fasterxml.jackson.databind.ObjectMapper;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.HandlerInterceptor;

@Configuration
public class ApiHandlerInterceptor
implements HandlerInterceptor {
    private final JwtProperties jwtProperties;
    private final ObjectMapper objectMapper;

    public ApiHandlerInterceptor(JwtProperties jwtProperties, ObjectMapper objectMapper) {
        this.jwtProperties = jwtProperties;
        this.objectMapper = objectMapper;
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) {
        String dy_token = request.getHeader(this.jwtProperties.getTokenName());
        if (dy_token == null) {
            this.returnErr((ResponseData<Object>)new ResponseData(ResponseStateEnum.UNAUTHORIZED, "\u672a\u6388\u6743"), (ServletResponse)response);
            return false;
        }
        if (!ApiJwtUtil.verify(dy_token, this.jwtProperties.getTokenSecret())) {
            this.returnErr((ResponseData<Object>)new ResponseData(ResponseStateEnum.UNAUTHORIZED, "\u975e\u6cd5token"), (ServletResponse)response);
            return false;
        }
        return true;
    }

    private void returnErr(ResponseData<Object> data, ServletResponse response) {
        ServletUtils.renderString((HttpServletResponse)((HttpServletResponse)response), (String)this.objectMapper.writeValueAsString(data));
    }
}

