/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.third.controller;

import cn.smarthse.common.framework.database.persistence.ResponseData;
import cn.smarthse.common.web.core.ControllerSupport;
import cn.smarthse.rho.modules.sys.entity.api.ApiSecret;
import cn.smarthse.rho.modules.sys.model.third.param.AppKeyParam;
import cn.smarthse.rho.modules.third.bootstrap.JwtProperties;
import cn.smarthse.rho.modules.third.service.api.IApiService;
import com.auth0.jwt.JWT;
import com.auth0.jwt.algorithms.Algorithm;
import com.github.xiaoymin.knife4j.annotations.ApiSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Date;
import java.util.Objects;
import org.apache.commons.lang.time.DateUtils;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@ApiSupport(order=1)
@Api(tags={"\u83b7\u53d6token"})
@RestController
@RequestMapping(value={"/third/api"})
@Validated
public class ApiController
extends ControllerSupport {
    private final IApiService apiService;
    private final JwtProperties jwtProperties;

    @ApiOperation(value="\u83b7\u53d6token")
    @PostMapping(value={"getToken"})
    public ResponseData<String> getToken(@Validated @RequestBody AppKeyParam param) {
        ApiSecret secret = this.apiService.getSecret(param.getAppId());
        if (secret == null) {
            return ResponseData.fail((String)"appId\u4e0d\u5b58\u5728\uff01");
        }
        if (!Objects.equals(secret.getAppSecret(), param.getAppSecret())) {
            return ResponseData.fail((String)"appSecret\u9519\u8bef\uff01");
        }
        String token = JWT.create().withIssuer(this.jwtProperties.getIssuer()).withExpiresAt(DateUtils.addDays((Date)new Date(), (int)1)).withClaim("appId", param.getAppId()).sign(Algorithm.HMAC256((String)this.jwtProperties.getTokenSecret()));
        return ResponseData.success((String)token);
    }

    public ApiController(IApiService apiService, JwtProperties jwtProperties) {
        this.apiService = apiService;
        this.jwtProperties = jwtProperties;
    }
}

