/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.third.bootstrap;

import cn.smarthse.rho.modules.third.bootstrap.JwtProperties;
import cn.smarthse.rho.modules.third.framework.handler.ApiHandlerInterceptor;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
public class MvcConfig
implements WebMvcConfigurer {
    private static final Logger log = LoggerFactory.getLogger(MvcConfig.class);
    private final JwtProperties jwtProperties;
    private final ObjectMapper objectMapper;

    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        registry.addResourceHandler(new String[]{"doc.html"}).addResourceLocations(new String[]{"classpath:/META-INF/resources/"});
        registry.addResourceHandler(new String[]{"/webjars/**"}).addResourceLocations(new String[]{"classpath:/META-INF/resources/webjars/"});
    }

    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor((HandlerInterceptor)new ApiHandlerInterceptor(this.jwtProperties, this.objectMapper)).addPathPatterns(new String[]{"/third/**"}).excludePathPatterns(new String[]{"/third/api/getToken"});
    }

    public MvcConfig(JwtProperties jwtProperties, ObjectMapper objectMapper) {
        this.jwtProperties = jwtProperties;
        this.objectMapper = objectMapper;
    }
}

