/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.supervise.task;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.smarthse.core.framework.utils.StringUtils;
import cn.smarthse.rho.modules.supervise.service.c.ICTrainingService;
import com.xxl.job.core.biz.model.ReturnT;
import com.xxl.job.core.context.XxlJobHelper;
import com.xxl.job.core.handler.annotation.XxlJob;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;

@Configuration
public class RadiationTrainingSyncTask {
    private static final Logger log = LoggerFactory.getLogger(RadiationTrainingSyncTask.class);
    private final ICTrainingService trainingService;

    @XxlJob(value="RadiationTrainingSyncTask-trainingData")
    public ReturnT<String> trainingDataSync() {
        try {
            DateTime syncTime = null;
            String jobParam = XxlJobHelper.getJobParam();
            if (StringUtils.isNotEmpty((String)jobParam)) {
                syncTime = DateUtil.parse((CharSequence)jobParam, (String)"yyyy-MM-dd HH:mm:ss");
            }
            this.trainingService.trainingDataSync((Date)syncTime);
        }
        catch (Exception e) {
            log.error("RadiationTrainingSyncTask-trainingData\u653e\u5c04\u536b\u751f\u5728\u7ebf\u57f9\u8bad\u6570\u636e\u540c\u6b65\u66f4\u65b0\u5f02\u5e38", (Throwable)e);
            XxlJobHelper.handleFail((String)e.getMessage());
            return ReturnT.FAIL;
        }
        return ReturnT.SUCCESS;
    }

    @XxlJob(value="RadiationTrainingSyncTask-trainingChangeRecordData")
    public ReturnT<String> trainingChangeRecordDataSync() {
        try {
            DateTime syncTime = null;
            String jobParam = XxlJobHelper.getJobParam();
            if (StringUtils.isNotEmpty((String)jobParam)) {
                syncTime = DateUtil.parse((CharSequence)jobParam, (String)"yyyy-MM-dd HH:mm:ss");
            }
            this.trainingService.trainingChangeRecordDataSync((Date)syncTime);
        }
        catch (Exception e) {
            log.error("RadiationTrainingSyncTask-trainingChangeRecordData\u653e\u5c04\u536b\u751f\u5728\u7ebf\u57f9\u8bad\u64cd\u4f5c\u8bb0\u5f55\u6570\u636e\u540c\u6b65\u66f4\u65b0\u5f02\u5e38", (Throwable)e);
            XxlJobHelper.handleFail((String)e.getMessage());
            return ReturnT.FAIL;
        }
        return ReturnT.SUCCESS;
    }

    public RadiationTrainingSyncTask(ICTrainingService trainingService) {
        this.trainingService = trainingService;
    }
}

