/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.supervise.service.r.impl;

import cn.smarthse.core.framework.model.BaseEntity;
import cn.smarthse.core.framework.model.LayuiGridData;
import cn.smarthse.core.framework.model.LayuiGridParam;
import cn.smarthse.core.framework.service.ServiceImpl;
import cn.smarthse.rho.modules.supervise.dao.r.RRiskBasicSourceMapper;
import cn.smarthse.rho.modules.supervise.model.keyFactor.param.RiskQueryParam;
import cn.smarthse.rho.modules.supervise.model.keyFactor.vo.RiskDetailSourceVo;
import cn.smarthse.rho.modules.supervise.service.r.IRRiskBasicSourceService;
import cn.smarthse.rho.modules.sys.entity.f.FProjectDetail;
import cn.smarthse.rho.modules.sys.entity.r.RRiskBasicSource;
import cn.smarthse.rho.modules.sys.enums.risk.BasicRiskStatusEnum;
import cn.smarthse.rho.modules.sys.enums.risk.RiskTypeEnum;
import cn.smarthse.rho.modules.sys.enums.risk.RiskUnresolvedTypeEnum;
import cn.smarthse.rho.modules.sys.enums.risk.SourceRiskStatusEnum;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import java.util.List;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
@Transactional(readOnly=true)
public class RRiskBasicSourceServiceImpl
extends ServiceImpl<RRiskBasicSourceMapper, RRiskBasicSource>
implements IRRiskBasicSourceService {
    @Override
    public LayuiGridData<RiskDetailSourceVo> listSourceByRiskId(RiskQueryParam param) {
        if (param.getBasicId() == null) {
            return null;
        }
        PageHelper.startPage((int)param.getPage(), (int)param.getLimit());
        List<RiskDetailSourceVo> rst = ((RRiskBasicSourceMapper)this.baseMapper).listSourceByRiskId(param);
        if (!CollectionUtils.isEmpty(rst)) {
            for (RiskDetailSourceVo sourceVo : rst) {
                List<FProjectDetail> fProjectDetailList;
                if (sourceVo.getStatus() == SourceRiskStatusEnum.UN_RESOLVED.getValue() && sourceVo.getUnresolvedType() == RiskUnresolvedTypeEnum.UN_ACCEPT.getValue()) {
                    if (sourceVo.getType() == RiskTypeEnum.TRAINING.getValue()) {
                        sourceVo.setKeyFactoryAuditId(((RRiskBasicSourceMapper)this.baseMapper).getAuditIdForTrainSource(sourceVo));
                    } else if (sourceVo.getType() == RiskTypeEnum.THREE.getValue()) {
                        sourceVo.setKeyFactoryAuditId(((RRiskBasicSourceMapper)this.baseMapper).getAuditIdForThreeSource(sourceVo));
                    }
                }
                if (sourceVo.getType() != RiskTypeEnum.THREE.getValue() || CollectionUtils.isEmpty(fProjectDetailList = ((RRiskBasicSourceMapper)this.baseMapper).getFProjectDetailByProjectId(sourceVo.getBusinessId()))) continue;
                for (FProjectDetail fProjectDetail : fProjectDetailList) {
                    if (fProjectDetail.getType() == 1) {
                        sourceVo.setProjectDetail1Id(fProjectDetail.getId());
                        continue;
                    }
                    if (fProjectDetail.getType() != 2) continue;
                    sourceVo.setProjectDetail2Id(fProjectDetail.getId());
                }
            }
        }
        return new LayuiGridData((Page)rst, (LayuiGridParam)param);
    }

    @Override
    public List<RRiskBasicSource> listSourceForAcceptance(Long riskId) {
        if (riskId == null) {
            return null;
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.eq(RRiskBasicSource::getRiskId, (Object)riskId)).eq(RRiskBasicSource::getStatus, (Object)BasicRiskStatusEnum.UNRESOLVED.getValue())).eq(RRiskBasicSource::getUnresolvedType, (Object)RiskUnresolvedTypeEnum.UN_ACCEPT.getValue())).eq(BaseEntity::getIsValid, (Object)1);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<RRiskBasicSource> listSourceUnresolvedForKeyFactor(Long cid, Integer type, Long businessId, Long sub_businessId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.eq(RRiskBasicSource::getStatus, (Object)BasicRiskStatusEnum.UNRESOLVED.getValue())).eq(BaseEntity::getIsValid, (Object)1);
        if (cid != null) {
            queryWrapper.eq(RRiskBasicSource::getCid, (Object)cid);
        }
        if (type != null) {
            queryWrapper.eq(RRiskBasicSource::getType, (Object)type);
        }
        if (businessId != null) {
            queryWrapper.eq(RRiskBasicSource::getBusinessId, (Object)businessId);
        }
        if (sub_businessId != null) {
            queryWrapper.eq(RRiskBasicSource::getSubBusinessId, (Object)sub_businessId);
        }
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<Long> getAllResolvedRiskSourceBasicIds(Integer riskType, List<Long> riskBasicIds) {
        return ((RRiskBasicSourceMapper)this.baseMapper).getAllResolvedRiskSourceBasicIds(riskType, riskBasicIds);
    }
}

