/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.supervise.service.r.impl;

import cn.smarthse.core.framework.Constant;
import cn.smarthse.core.framework.model.BaseEntity;
import cn.smarthse.core.framework.model.LayuiGridData;
import cn.smarthse.core.framework.model.LayuiGridParam;
import cn.smarthse.core.framework.service.ServiceImpl;
import cn.smarthse.rho.modules.supervise.dao.b.BCompanyMapper;
import cn.smarthse.rho.modules.supervise.dao.r.RRiskBasicMapper;
import cn.smarthse.rho.modules.supervise.model.home.param.HomeRiskParam;
import cn.smarthse.rho.modules.supervise.model.home.param.HomeVisualizationDataParam;
import cn.smarthse.rho.modules.supervise.model.home.vo.HomeRiskAuditWorkDataVo;
import cn.smarthse.rho.modules.supervise.model.home.vo.HomeRiskResolutionByTypeVo;
import cn.smarthse.rho.modules.supervise.model.home.vo.HomeVisualizationRiskDataVo;
import cn.smarthse.rho.modules.supervise.model.keyFactor.param.RiskQueryParam;
import cn.smarthse.rho.modules.supervise.model.keyFactor.vo.CompanyManageInfoVo;
import cn.smarthse.rho.modules.supervise.model.keyFactor.vo.RiskDetailAcceptRecordVo;
import cn.smarthse.rho.modules.supervise.model.keyFactor.vo.RiskDetailStatisticDataVo;
import cn.smarthse.rho.modules.supervise.model.keyFactor.vo.RiskDetailVo;
import cn.smarthse.rho.modules.supervise.model.keyFactor.vo.RiskListExportVo;
import cn.smarthse.rho.modules.supervise.model.keyFactor.vo.RiskListVo;
import cn.smarthse.rho.modules.supervise.service.r.IRRiskBasicService;
import cn.smarthse.rho.modules.sys.converter.RRiskBasicConverter;
import cn.smarthse.rho.modules.sys.entity.r.RRiskBasic;
import cn.smarthse.rho.modules.sys.enums.risk.BasicRiskStatusEnum;
import cn.smarthse.rho.modules.sys.enums.risk.RiskTypeEnum;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class RRiskBasicServiceImpl
extends ServiceImpl<RRiskBasicMapper, RRiskBasic>
implements IRRiskBasicService {
    @Autowired(required=false)
    private RRiskBasicConverter rRiskBasicConverter;
    @Autowired
    private BCompanyMapper companyMapper;

    @Override
    public LayuiGridData<RiskListVo> listRiskData(RiskQueryParam param) {
        PageHelper.startPage((int)param.getPage(), (int)param.getLimit());
        return new LayuiGridData((Page)((RRiskBasicMapper)this.baseMapper).listRiskData(param), (LayuiGridParam)param);
    }

    @Override
    public List<RiskListExportVo> listRiskExportData(RiskQueryParam param) {
        List<RiskListExportVo> rst = ((RRiskBasicMapper)this.baseMapper).listRiskExportData(param);
        return rst;
    }

    @Override
    public List<RiskDetailVo> getRiskDetail(RiskQueryParam param) {
        List<RiskDetailVo> rst = ((RRiskBasicMapper)this.baseMapper).getRiskDetail(param);
        return rst;
    }

    @Override
    public List<RiskDetailVo> getRiskDetailForPermitCert(RiskQueryParam param) {
        return ((RRiskBasicMapper)this.baseMapper).getRiskDetailForPermitCert(param);
    }

    @Override
    public RiskDetailVo getCompanyInfoAndRiskStatistic(RiskQueryParam param) {
        CompanyManageInfoVo companyManageInfo;
        RiskDetailVo rst = ((RRiskBasicMapper)this.baseMapper).getCompanyInfoAndRiskStatistic(param);
        if (rst != null && (companyManageInfo = this.companyMapper.getCompanyManageInfo(rst.getCid())) != null) {
            rst.setRaManagerName(companyManageInfo.getRaManagerName());
            rst.setRaManagerTel(companyManageInfo.getRaManagerTel());
        }
        if (rst != null && rst.getType() == RiskTypeEnum.LICENSE_MANAGEMENT.getValue()) {
            rst.setAcceptRecordList(this.listAcceptRecordForDetail(param));
        }
        return rst;
    }

    @Override
    public RiskDetailStatisticDataVo getRiskStatisticData(RiskQueryParam param) {
        return ((RRiskBasicMapper)this.baseMapper).getRiskStatisticData(param);
    }

    @Override
    public HomeVisualizationRiskDataVo getHomeVisualizationDataWithRisk(HomeVisualizationDataParam param) {
        return ((RRiskBasicMapper)this.baseMapper).getHomeVisualizationDataWithRisk(param);
    }

    @Override
    public List<HomeVisualizationRiskDataVo> getHomeVisualizationDataWithRiskList(HomeVisualizationDataParam param) {
        return ((RRiskBasicMapper)this.baseMapper).getHomeVisualizationDataWithRiskList(param);
    }

    @Override
    public HomeVisualizationRiskDataVo getHomeVisualizationDataWithCompany(HomeVisualizationDataParam param) {
        return ((RRiskBasicMapper)this.baseMapper).getHomeVisualizationDataWithCompany(param);
    }

    @Override
    public HomeVisualizationRiskDataVo getHomeVisualizationDataWithLastWeekRisk(HomeVisualizationDataParam param) {
        return ((RRiskBasicMapper)this.baseMapper).getHomeVisualizationDataWithLastWeekRisk(param);
    }

    @Override
    public List<RiskDetailAcceptRecordVo> listAcceptRecordForDetail(RiskQueryParam param) {
        return ((RRiskBasicMapper)this.baseMapper).listAcceptRecordForDetail(param);
    }

    @Override
    public HomeRiskAuditWorkDataVo getData3ForHomeRisk(HomeRiskParam param) {
        return ((RRiskBasicMapper)this.baseMapper).getData3ForHomeRisk(param);
    }

    @Override
    public HomeRiskResolutionByTypeVo getData6ForHomeRisk(HomeRiskParam param) {
        return ((RRiskBasicMapper)this.baseMapper).getData6ForHomeRisk(param);
    }

    @Override
    public void resolveRiskBasicBatchByIds(List<Long> ids) {
        LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)wrapper.eq(BaseEntity::getIsValid, (Object)Constant.ACTIVE_YES)).in(RRiskBasic::getId, ids)).set(RRiskBasic::getStatus, (Object)BasicRiskStatusEnum.RESOLVED.getValue());
        ((RRiskBasicMapper)this.baseMapper).update((Wrapper)wrapper);
    }
}

