/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.supervise.service.r.impl;

import cn.smarthse.core.framework.service.ServiceImpl;
import cn.smarthse.rho.modules.supervise.dao.r.RRiskAcceptanceRecordMapper;
import cn.smarthse.rho.modules.supervise.model.keyFactor.param.AcceptanceRiskParam;
import cn.smarthse.rho.modules.supervise.service.r.IRRiskAcceptanceRecordService;
import cn.smarthse.rho.modules.supervise.service.r.IRRiskBasicService;
import cn.smarthse.rho.modules.supervise.service.r.IRRiskBasicSourceService;
import cn.smarthse.rho.modules.sys.entity.r.RRiskAcceptanceRecord;
import cn.smarthse.rho.modules.sys.entity.r.RRiskBasic;
import cn.smarthse.rho.modules.sys.entity.r.RRiskBasicSource;
import cn.smarthse.rho.modules.sys.enums.risk.AcceptanceRecordResultEnum;
import cn.smarthse.rho.modules.sys.enums.risk.AcceptanceRecordStatusEnum;
import cn.smarthse.rho.modules.sys.enums.risk.BasicRiskStatusEnum;
import cn.smarthse.rho.modules.sys.enums.risk.RiskTypeEnum;
import cn.smarthse.rho.modules.sys.enums.risk.RiskUnresolvedTypeEnum;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class RRiskAcceptanceRecordServiceImpl
extends ServiceImpl<RRiskAcceptanceRecordMapper, RRiskAcceptanceRecord>
implements IRRiskAcceptanceRecordService {
    @Autowired
    private IRRiskBasicService riskBasicService;
    @Autowired
    private IRRiskBasicSourceService sourceService;
    private static final List<Integer> genNewRecordTypeList = Arrays.asList(RiskTypeEnum.LICENSE_MANAGEMENT.getValue(), RiskTypeEnum.PERFORMANCE_TEST.getValue(), RiskTypeEnum.PLACE_TEST.getValue(), RiskTypeEnum.PHYSICAL_EXAMINATION.getValue(), RiskTypeEnum.DOSE_MONITORING.getValue());

    @Override
    @Transactional
    public void acceptanceRisk(AcceptanceRiskParam param) {
        RRiskAcceptanceRecord acceptanceRecord = (RRiskAcceptanceRecord)this.getById(param.getAccId());
        RRiskBasicSource sourceByAcceptance = (RRiskBasicSource)this.sourceService.getById(acceptanceRecord.getSourceId());
        RRiskBasic riskBasic = (RRiskBasic)this.riskBasicService.getById(acceptanceRecord.getRiskId());
        List<RRiskBasicSource> sourceList = this.sourceService.listSourceForAcceptance(acceptanceRecord.getRiskId());
        acceptanceRecord.setAcceptanceDate(param.getAcceptanceDate());
        acceptanceRecord.setAcceptanceDirectorName(param.getAcceptanceDirectorName());
        acceptanceRecord.setAcceptanceFiles(param.getAcceptanceFiles());
        acceptanceRecord.setStatus(AcceptanceRecordStatusEnum.DONE.getValue());
        acceptanceRecord.setActualFinishTime(param.getAcceptanceResult() == AcceptanceRecordResultEnum.PASS.getValue() ? LocalDate.now() : null);
        acceptanceRecord.setAcceptanceResult(param.getAcceptanceResult());
        acceptanceRecord.setAcceptanceResultExplain(param.getAcceptanceResultExplain());
        this.updateById(acceptanceRecord);
        if (Objects.equals(param.getAcceptanceResult(), AcceptanceRecordResultEnum.FAIL.getValue())) {
            sourceList.stream().forEach(source -> {
                source.setStatus(BasicRiskStatusEnum.UNRESOLVED.getValue());
                source.setUnresolvedType(RiskUnresolvedTypeEnum.RETURNED.getValue());
            });
            riskBasic.setStatus(BasicRiskStatusEnum.UNRESOLVED.getValue());
            riskBasic.setUnresolvedType(RiskUnresolvedTypeEnum.RETURNED.getValue());
        } else if (Objects.equals(param.getAcceptanceResult(), AcceptanceRecordResultEnum.PASS.getValue())) {
            sourceList.stream().forEach(source -> {
                source.setStatus(BasicRiskStatusEnum.RESOLVED.getValue());
                source.setUnresolvedType(RiskUnresolvedTypeEnum.NONE.getValue());
                source.setAcceptanceDate(param.getAcceptanceDate());
                source.setAcceptanceDirectorName(param.getAcceptanceDirectorName());
                source.setActualFinishTime(LocalDate.now());
            });
            riskBasic.setStatus(BasicRiskStatusEnum.RESOLVED.getValue());
            riskBasic.setUnresolvedType(RiskUnresolvedTypeEnum.NONE.getValue());
        }
        this.riskBasicService.updateById(riskBasic);
        this.sourceService.updateBatchById(sourceList);
        if (param.getAcceptanceResult() == 0 && riskBasic.getType() == RiskTypeEnum.LICENSE_MANAGEMENT.getValue()) {
            RRiskAcceptanceRecord newRecord = new RRiskAcceptanceRecord();
            newRecord.setId(Long.valueOf(IdWorker.getId()));
            newRecord.setRiskId(riskBasic.getId());
            newRecord.setSourceId(sourceByAcceptance.getId());
            newRecord.setCid(riskBasic.getCid());
            newRecord.setRequireFinishTime(sourceByAcceptance.getRequireFinishTime());
            newRecord.setStatus(Integer.valueOf(0));
            newRecord.setAcceptanceResult(null);
            this.save(newRecord);
        }
    }
}

