/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.supervise.service.r.impl;

import cn.smarthse.core.framework.model.LayuiGridData;
import cn.smarthse.core.framework.model.LayuiGridParam;
import cn.smarthse.core.framework.service.ServiceImpl;
import cn.smarthse.core.framework.utils.DateUtils;
import cn.smarthse.rho.modules.supervise.bootstrap.security.utils.ShiroUtil;
import cn.smarthse.rho.modules.supervise.dao.r.RKeyFactorAuditMapper;
import cn.smarthse.rho.modules.supervise.model.c.vo.RadiationTrainingCertVo;
import cn.smarthse.rho.modules.supervise.service.b.IBCompanyService;
import cn.smarthse.rho.modules.supervise.service.c.ICTrainingCertService;
import cn.smarthse.rho.modules.supervise.service.f.IFProjectService;
import cn.smarthse.rho.modules.supervise.service.g.IGProtectiveEquipmentService;
import cn.smarthse.rho.modules.supervise.service.g.IGSafetyDevicesWarningSignsService;
import cn.smarthse.rho.modules.supervise.service.r.IRKeyFactorAuditService;
import cn.smarthse.rho.modules.supervise.service.r.IRRiskBasicService;
import cn.smarthse.rho.modules.supervise.service.r.IRRiskBasicSourceService;
import cn.smarthse.rho.modules.sys.entity.b.BCompany;
import cn.smarthse.rho.modules.sys.entity.f.FProject;
import cn.smarthse.rho.modules.sys.entity.r.RKeyFactorAudit;
import cn.smarthse.rho.modules.sys.entity.r.RRiskBasicSource;
import cn.smarthse.rho.modules.sys.entity.sys.SysBusinessOperateLog;
import cn.smarthse.rho.modules.sys.enums.risk.BasicRiskStatusEnum;
import cn.smarthse.rho.modules.sys.enums.risk.KeyFactoAuditStatusEnum;
import cn.smarthse.rho.modules.sys.enums.risk.RiskTypeEnum;
import cn.smarthse.rho.modules.sys.enums.sys.SysBusinessOperateLogModuleEnum;
import cn.smarthse.rho.modules.sys.enums.sys.SysBusinessOperateLogTypeEnum;
import cn.smarthse.rho.modules.sys.enums.train.TrainingCertTypeEnum;
import cn.smarthse.rho.modules.sys.model.f.param.ThreeProjectDetailQueryParam;
import cn.smarthse.rho.modules.sys.model.f.vo.FThreeTimesProjectDetailVo;
import cn.smarthse.rho.modules.sys.model.g.vo.GEquipmentSelfCheckOneVo;
import cn.smarthse.rho.modules.sys.model.g.vo.GSafetyDeviceSelfCheckOneVo;
import cn.smarthse.rho.modules.sys.model.r.param.RKeyFactorAuditParam;
import cn.smarthse.rho.modules.sys.model.r.param.RKeyFactorAuditSearchParam;
import cn.smarthse.rho.modules.sys.model.r.vo.RKeyFactorAuditDetailVo;
import cn.smarthse.rho.modules.sys.model.r.vo.RKeyFactorAuditStatisticsVo;
import cn.smarthse.rho.modules.sys.model.r.vo.RKeyFactorAuditVo;
import cn.smarthse.rho.modules.sys.provider.sys.ISysBusinessOperateLogProvider;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import java.time.LocalDate;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.smarthse.framework.exception.ServiceException;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
@Transactional(readOnly=true)
public class RKeyFactorAuditServiceImpl
extends ServiceImpl<RKeyFactorAuditMapper, RKeyFactorAudit>
implements IRKeyFactorAuditService {
    @Autowired
    private ICTrainingCertService cTrainingCertService;
    @Autowired
    private IRRiskBasicService riskBasicService;
    @Autowired
    private IRRiskBasicSourceService riskBasicSourceService;
    @Autowired
    private IBCompanyService companyService;
    @Autowired
    private IFProjectService threeProjectService;
    @Autowired
    private IFProjectService projectService;
    @DubboReference
    private ISysBusinessOperateLogProvider operateLogProvider;
    @Autowired
    private IGProtectiveEquipmentService protectiveEquipmentService;
    @Autowired
    private IGSafetyDevicesWarningSignsService safetyDevicesWarningSignsService;

    @Override
    public LayuiGridData<RKeyFactorAuditVo> getListData(RKeyFactorAuditSearchParam param) {
        PageHelper.startPage((int)param.getPage(), (int)param.getLimit());
        Page page = (Page)((RKeyFactorAuditMapper)this.baseMapper).getListData(param);
        return new LayuiGridData(page, (LayuiGridParam)param);
    }

    @Override
    public RKeyFactorAuditDetailVo getDetail(Long id) {
        RKeyFactorAudit rKeyFactorAudit = (RKeyFactorAudit)this.getById(id);
        if (rKeyFactorAudit == null) {
            return null;
        }
        RKeyFactorAuditDetailVo result = new RKeyFactorAuditDetailVo();
        result.setId(rKeyFactorAudit.getId());
        result.setSubmitDate(rKeyFactorAudit.getCreateDate());
        result.setType(rKeyFactorAudit.getType());
        result.setStatus(rKeyFactorAudit.getStatus());
        result.setCompany((BCompany)this.companyService.getById(rKeyFactorAudit.getCid()));
        if (Objects.equals(rKeyFactorAudit.getType(), RiskTypeEnum.TRAINING.getValue())) {
            RadiationTrainingCertVo certDetail = this.cTrainingCertService.getTrainingCertDetail(rKeyFactorAudit.getBusinessId());
            result.setBusinessData((Object)certDetail);
        } else if (Objects.equals(rKeyFactorAudit.getType(), RiskTypeEnum.THREE.getValue())) {
            FThreeTimesProjectDetailVo detailByProjectId = this.projectService.getDetailByProjectId(new ThreeProjectDetailQueryParam().setCid(rKeyFactorAudit.getCid()).setProjectId(rKeyFactorAudit.getBusinessId()));
            result.setBusinessData((Object)detailByProjectId);
        } else if (Objects.equals(rKeyFactorAudit.getType(), RiskTypeEnum.PERSONAL_PROTECTIVE_EQUIPMENT.getValue())) {
            GEquipmentSelfCheckOneVo equipmentSelfCheckOneVo = this.protectiveEquipmentService.getOneById(rKeyFactorAudit.getBusinessId());
            result.setBusinessData((Object)equipmentSelfCheckOneVo);
        } else if (Objects.equals(rKeyFactorAudit.getType(), RiskTypeEnum.SAFETY_DEVICES_AND_ALERTS.getValue())) {
            GSafetyDeviceSelfCheckOneVo safetyDeviceSelfCheckOneVo = this.safetyDevicesWarningSignsService.getOneById(rKeyFactorAudit.getBusinessId());
            result.setBusinessData((Object)safetyDeviceSelfCheckOneVo);
        }
        List<RKeyFactorAuditStatisticsVo> statisticsVoList = this.getRKeyFactorAuditStatisticsVoList(rKeyFactorAudit.getCid(), KeyFactoAuditStatusEnum.AUDIT.getCode());
        result.setAuditStatisticsVos(statisticsVoList);
        return result;
    }

    @Override
    public List<RKeyFactorAuditStatisticsVo> getRKeyFactorAuditStatisticsVoList(Long cid, Integer status) {
        return ((RKeyFactorAuditMapper)this.baseMapper).getRKeyFactorAuditStatisticsVoList(cid, status);
    }

    @Override
    @Transactional
    public void audit(RKeyFactorAuditParam param) {
        RKeyFactorAudit rKeyFactorAudit = (RKeyFactorAudit)this.getById(param.getId());
        rKeyFactorAudit.setStatus(param.getStatus());
        this.updateById(rKeyFactorAudit);
        if (rKeyFactorAudit.getType().equals(RiskTypeEnum.TRAINING.getValue())) {
            this.cTrainingCertService.updateStatusById(rKeyFactorAudit.getBusinessId(), param.getStatus());
        }
        if (rKeyFactorAudit.getType().equals(RiskTypeEnum.THREE.getValue())) {
            this.projectService.updateStatusById(rKeyFactorAudit.getBusinessId(), param.getStatus());
        }
        if (rKeyFactorAudit.getType().equals(RiskTypeEnum.PERSONAL_PROTECTIVE_EQUIPMENT.getValue())) {
            this.protectiveEquipmentService.updateStatusById(rKeyFactorAudit.getBusinessId(), param.getStatus());
        }
        if (rKeyFactorAudit.getType().equals(RiskTypeEnum.SAFETY_DEVICES_AND_ALERTS.getValue())) {
            this.safetyDevicesWarningSignsService.updateStatusById(rKeyFactorAudit.getBusinessId(), param.getStatus());
        }
        SysBusinessOperateLog log = new SysBusinessOperateLog().setCid(rKeyFactorAudit.getCid()).setBusinessId(rKeyFactorAudit.getId()).setOperator(param.getOperator()).setOperatorCompanyName(ShiroUtil.getLoginUserOrgName()).setReason(param.getReason()).setCreateBy(ShiroUtil.getLoginUserId()).setUpdateBy(ShiroUtil.getLoginUserId());
        if (rKeyFactorAudit.getType() != null && rKeyFactorAudit.getType().equals(RiskTypeEnum.TRAINING.getValue())) {
            log.setModule(SysBusinessOperateLogModuleEnum.KEY_FACTOR_AUDIT_1.getValue());
        }
        if (rKeyFactorAudit.getType() != null && rKeyFactorAudit.getType().equals(RiskTypeEnum.THREE.getValue())) {
            log.setModule(SysBusinessOperateLogModuleEnum.KEY_FACTOR_AUDIT_2.getValue());
        }
        if (rKeyFactorAudit.getType() != null && rKeyFactorAudit.getType().equals(RiskTypeEnum.PERSONAL_PROTECTIVE_EQUIPMENT.getValue())) {
            log.setModule(SysBusinessOperateLogModuleEnum.KEY_FACTOR_AUDIT_3.getValue());
        }
        if (rKeyFactorAudit.getType() != null && rKeyFactorAudit.getType().equals(RiskTypeEnum.SAFETY_DEVICES_AND_ALERTS.getValue())) {
            log.setModule(SysBusinessOperateLogModuleEnum.KEY_FACTOR_AUDIT_4.getValue());
        }
        if (param.getStatus().equals(KeyFactoAuditStatusEnum.BACK.getCode())) {
            log.setType(SysBusinessOperateLogTypeEnum.BACK.getValue());
        } else if (param.getStatus().equals(KeyFactoAuditStatusEnum.PASS.getCode())) {
            log.setType(SysBusinessOperateLogTypeEnum.PASS.getValue());
        }
        this.operateLogProvider.addOrUpdateLog(log);
        if (param.getStatus().equals(KeyFactoAuditStatusEnum.PASS.getCode())) {
            List<Long> allResolvedRiskSourceBasicIds;
            List<Long> riskBasicIds;
            List<RRiskBasicSource> rRiskBasicSources;
            List<Long> allResolvedRiskSourceBasicIds2;
            List<Long> riskBasicIds2;
            List<RRiskBasicSource> rRiskBasicSources2;
            if (rKeyFactorAudit.getType().equals(RiskTypeEnum.TRAINING.getValue())) {
                RadiationTrainingCertVo certDetail = this.cTrainingCertService.getTrainingCertDetail(rKeyFactorAudit.getBusinessId());
                if (certDetail == null) {
                    throw new ServiceException("\u5173\u952e\u56e0\u7d20\u753b\u50cf\u5ba1\u6838-\u57f9\u8bad\uff1a\u672a\u627e\u5230\u5bf9\u5e94\u7684\u57f9\u8bad\u8bc1\u4e66\u4fe1\u606f\uff01");
                }
                if (certDetail.getCertType().equals(TrainingCertTypeEnum.TYPE_2.getValue())) {
                    rRiskBasicSources2 = this.riskBasicSourceService.listSourceUnresolvedForKeyFactor(null, RiskTypeEnum.TRAINING.getValue(), null, certDetail.getStaffBaseInfoId());
                    if (CollectionUtils.isEmpty(rRiskBasicSources2)) {
                        return;
                    }
                    riskBasicIds2 = rRiskBasicSources2.stream().map(RRiskBasicSource::getRiskId).distinct().collect(Collectors.toList());
                    for (RRiskBasicSource riskBasicSource : rRiskBasicSources2) {
                        riskBasicSource.setStatus(BasicRiskStatusEnum.RESOLVED.getValue());
                        riskBasicSource.setActualFinishTime(DateUtils.getLocalDate((Date)rKeyFactorAudit.getCreateDate()));
                        riskBasicSource.setAcceptanceDate(LocalDate.now());
                    }
                    this.riskBasicSourceService.updateBatchById(rRiskBasicSources2);
                    allResolvedRiskSourceBasicIds2 = this.riskBasicSourceService.getAllResolvedRiskSourceBasicIds(RiskTypeEnum.TRAINING.getValue(), riskBasicIds2);
                    if (!CollectionUtils.isEmpty((Collection)allResolvedRiskSourceBasicIds2)) {
                        this.riskBasicService.resolveRiskBasicBatchByIds(allResolvedRiskSourceBasicIds2);
                    }
                }
            }
            if (rKeyFactorAudit.getType().equals(RiskTypeEnum.THREE.getValue())) {
                FProject threeProject = (FProject)this.threeProjectService.getById(rKeyFactorAudit.getBusinessId());
                if (threeProject == null) {
                    throw new ServiceException("\u5173\u952e\u56e0\u7d20\u753b\u50cf\u5ba1\u6838-\u4e09\u540c\u65f6\uff1a\u672a\u627e\u5230\u5bf9\u5e94\u7684\u4e09\u540c\u65f6\u9879\u76ee\u4fe1\u606f\uff01");
                }
                rRiskBasicSources2 = this.riskBasicSourceService.listSourceUnresolvedForKeyFactor(threeProject.getCid(), RiskTypeEnum.THREE.getValue(), threeProject.getId(), null);
                if (CollectionUtils.isEmpty(rRiskBasicSources2)) {
                    return;
                }
                riskBasicIds2 = rRiskBasicSources2.stream().map(RRiskBasicSource::getRiskId).distinct().collect(Collectors.toList());
                for (RRiskBasicSource riskBasicSource : rRiskBasicSources2) {
                    riskBasicSource.setStatus(BasicRiskStatusEnum.RESOLVED.getValue());
                    riskBasicSource.setActualFinishTime(DateUtils.getLocalDate((Date)rKeyFactorAudit.getCreateDate()));
                    riskBasicSource.setAcceptanceDate(LocalDate.now());
                }
                this.riskBasicSourceService.updateBatchById(rRiskBasicSources2);
                allResolvedRiskSourceBasicIds2 = this.riskBasicSourceService.getAllResolvedRiskSourceBasicIds(RiskTypeEnum.THREE.getValue(), riskBasicIds2);
                if (!CollectionUtils.isEmpty(allResolvedRiskSourceBasicIds2)) {
                    this.riskBasicService.resolveRiskBasicBatchByIds(allResolvedRiskSourceBasicIds2);
                }
            }
            if (rKeyFactorAudit.getType().equals(RiskTypeEnum.PERSONAL_PROTECTIVE_EQUIPMENT.getValue())) {
                rRiskBasicSources = this.riskBasicSourceService.listSourceUnresolvedForKeyFactor(rKeyFactorAudit.getCid(), RiskTypeEnum.PERSONAL_PROTECTIVE_EQUIPMENT.getValue(), null, null);
                if (CollectionUtils.isEmpty(rRiskBasicSources)) {
                    return;
                }
                riskBasicIds = rRiskBasicSources.stream().map(RRiskBasicSource::getRiskId).distinct().collect(Collectors.toList());
                for (RRiskBasicSource riskBasicSource : rRiskBasicSources) {
                    riskBasicSource.setStatus(BasicRiskStatusEnum.RESOLVED.getValue());
                    riskBasicSource.setActualFinishTime(DateUtils.getLocalDate((Date)rKeyFactorAudit.getCreateDate()));
                    riskBasicSource.setAcceptanceDate(LocalDate.now());
                }
                this.riskBasicSourceService.updateBatchById(rRiskBasicSources);
                allResolvedRiskSourceBasicIds = this.riskBasicSourceService.getAllResolvedRiskSourceBasicIds(RiskTypeEnum.PERSONAL_PROTECTIVE_EQUIPMENT.getValue(), riskBasicIds);
                if (!CollectionUtils.isEmpty((Collection)allResolvedRiskSourceBasicIds)) {
                    this.riskBasicService.resolveRiskBasicBatchByIds(allResolvedRiskSourceBasicIds);
                }
            }
            if (rKeyFactorAudit.getType().equals(RiskTypeEnum.SAFETY_DEVICES_AND_ALERTS.getValue())) {
                rRiskBasicSources = this.riskBasicSourceService.listSourceUnresolvedForKeyFactor(rKeyFactorAudit.getCid(), RiskTypeEnum.SAFETY_DEVICES_AND_ALERTS.getValue(), null, null);
                if (CollectionUtils.isEmpty(rRiskBasicSources)) {
                    return;
                }
                riskBasicIds = rRiskBasicSources.stream().map(RRiskBasicSource::getRiskId).distinct().collect(Collectors.toList());
                for (RRiskBasicSource riskBasicSource : rRiskBasicSources) {
                    riskBasicSource.setStatus(BasicRiskStatusEnum.RESOLVED.getValue());
                    riskBasicSource.setActualFinishTime(DateUtils.getLocalDate((Date)rKeyFactorAudit.getCreateDate()));
                    riskBasicSource.setAcceptanceDate(LocalDate.now());
                }
                this.riskBasicSourceService.updateBatchById(rRiskBasicSources);
                allResolvedRiskSourceBasicIds = this.riskBasicSourceService.getAllResolvedRiskSourceBasicIds(RiskTypeEnum.SAFETY_DEVICES_AND_ALERTS.getValue(), riskBasicIds);
                if (!CollectionUtils.isEmpty(allResolvedRiskSourceBasicIds)) {
                    this.riskBasicService.resolveRiskBasicBatchByIds(allResolvedRiskSourceBasicIds);
                }
            }
        }
    }
}

