/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.supervise.service.impl.m;

import cn.smarthse.common.redis.utils.RedisUtils;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.core.framework.model.LayuiGridData;
import cn.smarthse.core.framework.model.LayuiGridParam;
import cn.smarthse.core.framework.service.ServiceImpl;
import cn.smarthse.modules.datacentre.model.system.riskFactors.OccupationalRiskAttrModel;
import cn.smarthse.modules.datacentre.provider.system.riskFactors.IOccupationalRiskAttrProvideService;
import cn.smarthse.rho.modules.supervise.dao.m.MOnlineMonitorDeviceMapper;
import cn.smarthse.rho.modules.supervise.service.m.IMOnlineMonitorDeviceService;
import cn.smarthse.rho.modules.sys.entity.m.MOnlineMonitorDevice;
import cn.smarthse.rho.modules.sys.model.m.param.MonitoringProtectDeviceAbnormalRateSetParam;
import cn.smarthse.rho.modules.sys.model.m.param.OnlineMonitorDeviceParam;
import cn.smarthse.rho.modules.sys.model.m.param.OnlineMonitoringSearchVo;
import cn.smarthse.rho.modules.sys.model.m.vo.MOnlineMonitorDeviceVo;
import cn.smarthse.rho.modules.sys.model.m.vo.OnlineDeviceRealData;
import cn.smarthse.rho.modules.sys.model.m.vo.OnlineMonitoringDataVo;
import cn.smarthse.rho.modules.sys.model.m.vo.OnlineMonitoringDeviceModel;
import cn.smarthse.rho.modules.sys.model.m.vo.OnlineMonitoringProtectDeviceModel;
import cn.smarthse.rho.modules.sys.model.m.vo.OnlineMonitoringRealDataVo;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.stereotype.Service;

@Service
public class MOnlineMonitorDeviceServiceImpl
extends ServiceImpl<MOnlineMonitorDeviceMapper, MOnlineMonitorDevice>
implements IMOnlineMonitorDeviceService {
    @DubboReference
    private IOccupationalRiskAttrProvideService riskAttrProvideService;
    private static final String HARMID_DATATYPE_ATTRNAME_VALUE = "harmid:datatype:attrname:value";
    public static final int EXCURSION_LIMIT = 5;
    public static final int ALARM_COUNT = 3;

    @Override
    public LayuiGridData<MOnlineMonitorDeviceVo> getMonitorDeviceList(OnlineMonitorDeviceParam param) {
        PageHelper.startPage((int)param.getPage(), (int)param.getLimit());
        Page page = (Page)((MOnlineMonitorDeviceMapper)this.baseMapper).getMonitorDeviceList(param);
        return new LayuiGridData(page, (LayuiGridParam)param);
    }

    @Override
    public LayuiGridData<OnlineMonitoringDeviceModel> getOnlineMonitorDeviceList(OnlineMonitorDeviceParam param) {
        Object deviceIds;
        List<OnlineDeviceRealData> lastRealData;
        PageHelper.startPage((int)param.getPage(), (int)param.getLimit());
        List<OnlineMonitoringDeviceModel> list = ((MOnlineMonitorDeviceMapper)this.baseMapper).getOnlineMonitoringDeviceList(param);
        Map<String, String> deviceLastRealDataMap = new HashMap<String, String>();
        if (CollectionUtils.isNotEmpty(list) && CollectionUtils.isNotEmpty(lastRealData = ((MOnlineMonitorDeviceMapper)this.baseMapper).getDeviceLastRealData((List<Long>)(deviceIds = list.stream().map(OnlineMonitoringDeviceModel::getId).collect(Collectors.toList()))))) {
            deviceLastRealDataMap = lastRealData.stream().collect(Collectors.toMap(this::generateKey2, OnlineDeviceRealData::getVData, (v1, v2) -> v1));
        }
        for (OnlineMonitoringDeviceModel model : list) {
            this.settingValue(model, deviceLastRealDataMap);
        }
        Page page = (Page)list;
        return new LayuiGridData(page, (LayuiGridParam)param);
    }

    private String generateKey(OnlineMonitoringDeviceModel model) {
        Long deviceId = model.getId();
        Long factorId = model.getFactorId();
        String dataType1 = model.getDataType();
        return (deviceId == null ? "" : deviceId.toString()) + (factorId == null ? "" : factorId.toString()) + (dataType1 == null ? "" : dataType1);
    }

    private String generateKey2(OnlineDeviceRealData model) {
        Long deviceId = model.getDeviceId();
        Long factorId = model.getFactorId();
        Integer dataType1 = model.getDataType();
        return (deviceId == null ? "" : deviceId.toString()) + (factorId == null ? "" : factorId.toString()) + (dataType1 == null ? "" : dataType1.toString());
    }

    private void settingValue(OnlineMonitoringDeviceModel model, Map<String, String> deviceLastRealDataMap) {
        if (model.getFactorId() != null) {
            String mapKey = this.generateKey(model);
            String realData = deviceLastRealDataMap.get(mapKey);
            if (realData != null) {
                model.setEarlyWarning(realData);
            }
            Integer dataType = null;
            if (!StringUtils.isEmpty((CharSequence)model.getDataType())) {
                if ("1002".equals(model.getDataType())) {
                    model.setFactorName(model.getFactorName() + "-\u603b\u5c18");
                } else if ("1003".equals(model.getDataType())) {
                    model.setFactorName(model.getFactorName() + "-\u547c\u5c18");
                }
                if (StringUtils.isNumber((String)model.getDataType())) {
                    dataType = Integer.parseInt(model.getDataType());
                }
            }
            if (org.apache.commons.lang.StringUtils.isEmpty((String)model.getAlarmVdata())) {
                String overLimit = this.getOverLimitByFactorId(model.getFactorId(), dataType);
                model.setAlarmVdata(overLimit);
            }
        }
    }

    public String getOverLimitByFactorId(Long factorId, Integer dataType) {
        if (factorId == null) {
            return null;
        }
        String cacheKey = HARMID_DATATYPE_ATTRNAME_VALUE + factorId + (dataType == null ? "" : dataType);
        String value = (String)RedisUtils.getCacheObject((String)cacheKey);
        if (org.apache.commons.lang.StringUtils.isNotEmpty((String)value)) {
            return value;
        }
        List factorLimitValues = this.riskAttrProvideService.getByFactorId(factorId);
        if (CollectionUtils.isNotEmpty((Collection)factorLimitValues)) {
            Map<String, String> limitMap = factorLimitValues.stream().collect(Collectors.toMap(OccupationalRiskAttrModel::getAttrName, OccupationalRiskAttrModel::getAttrValue));
            String attrValue = "";
            if (Objects.equals(dataType, 1002)) {
                attrValue = limitMap.get("twa_total");
                if (StringUtils.isNumber((String)attrValue)) {
                    BigDecimal multiply = new BigDecimal(attrValue).multiply(new BigDecimal(5));
                    attrValue = multiply.stripTrailingZeros().toPlainString();
                }
            } else if (Objects.equals(dataType, 1003)) {
                attrValue = limitMap.get("twa_respirabel");
                if (StringUtils.isNumber((String)attrValue)) {
                    BigDecimal multiply = new BigDecimal(attrValue).multiply(new BigDecimal(5));
                    attrValue = multiply.stripTrailingZeros().toPlainString();
                }
            } else {
                String mac = limitMap.get("mac");
                String twa = limitMap.get("twa");
                String stel = limitMap.get("stel");
                if (StringUtils.isNotBlank((CharSequence)mac)) {
                    attrValue = mac;
                } else if (StringUtils.isNotBlank((CharSequence)stel)) {
                    attrValue = stel;
                } else if (StringUtils.isNotBlank((CharSequence)twa)) {
                    BigDecimal multiply = new BigDecimal(twa).multiply(new BigDecimal(5));
                    attrValue = multiply.stripTrailingZeros().toPlainString();
                }
            }
            return attrValue;
        }
        return null;
    }

    @Override
    public OnlineMonitoringRealDataVo getDeviceRealMonitoringData(OnlineMonitoringSearchVo vo) {
        OnlineMonitoringRealDataVo result = ((MOnlineMonitorDeviceMapper)this.baseMapper).getMonitorDeviceInfoById(vo);
        if (result == null) {
            return null;
        }
        List<OnlineMonitoringDataVo> monitoringData = ((MOnlineMonitorDeviceMapper)this.baseMapper).getDeviceRealMonitoringData(vo);
        result.setDeviceId(vo.getDeviceId());
        result.setDatas(monitoringData);
        return result;
    }

    @Override
    public LayuiGridData<OnlineMonitoringProtectDeviceModel> getOnlineMonitorProtectDeviceList(OnlineMonitorDeviceParam param) {
        PageHelper.startPage((int)param.getPage(), (int)param.getLimit());
        List<OnlineMonitoringProtectDeviceModel> result = ((MOnlineMonitorDeviceMapper)this.baseMapper).getOnlineMonitorProtectDeviceList(param);
        return new LayuiGridData((Page)result, (LayuiGridParam)param);
    }

    @Override
    public void setAbnormalRate(MonitoringProtectDeviceAbnormalRateSetParam param) {
        ((MOnlineMonitorDeviceMapper)this.baseMapper).setAbnormalRate(param);
    }
}

