/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.supervise.service.impl.f;

import cn.smarthse.core.framework.model.LayuiGridData;
import cn.smarthse.core.framework.model.LayuiGridParam;
import cn.smarthse.core.framework.service.ServiceImpl;
import cn.smarthse.rho.modules.supervise.dao.f.FProjectMapper;
import cn.smarthse.rho.modules.supervise.service.b.IBCompanyService;
import cn.smarthse.rho.modules.supervise.service.e.IEdeviceService;
import cn.smarthse.rho.modules.supervise.service.f.IFProjectDetailService;
import cn.smarthse.rho.modules.supervise.service.f.IFProjectService;
import cn.smarthse.rho.modules.sys.entity.b.BCompany;
import cn.smarthse.rho.modules.sys.entity.e.EDevice;
import cn.smarthse.rho.modules.sys.entity.f.FProject;
import cn.smarthse.rho.modules.sys.entity.f.FProjectDetail;
import cn.smarthse.rho.modules.sys.enums.f.FProjectStatusEnum;
import cn.smarthse.rho.modules.sys.model.f.param.FThreeTimesProjectAddParam;
import cn.smarthse.rho.modules.sys.model.f.param.ThreeProjectDetailQueryParam;
import cn.smarthse.rho.modules.sys.model.f.param.ThreeProjectQueryParam;
import cn.smarthse.rho.modules.sys.model.f.vo.FThreeTimesProjectDetailVo;
import cn.smarthse.rho.modules.sys.model.f.vo.FThreeTimesProjectVo;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
@Transactional(readOnly=true)
public class FProjectServiceImpl
extends ServiceImpl<FProjectMapper, FProject>
implements IFProjectService {
    private static final Logger log = LoggerFactory.getLogger(FProjectServiceImpl.class);
    @Autowired
    private IFProjectDetailService projectDetailService;
    @Autowired
    private IEdeviceService eDeviceService;
    @Autowired
    private IBCompanyService companyService;

    @Override
    public LayuiGridData<FThreeTimesProjectVo> getThreeProjectList(ThreeProjectQueryParam param) {
        PageHelper.startPage((int)param.getPage(), (int)param.getLimit());
        Page page = (Page)((FProjectMapper)this.baseMapper).getThreeProjectList(param);
        return new LayuiGridData(page, (LayuiGridParam)param);
    }

    @Override
    public FThreeTimesProjectDetailVo getDetailByProjectId(ThreeProjectDetailQueryParam param) {
        List<FProjectDetail> projectDetailList;
        EDevice device;
        FThreeTimesProjectDetailVo result = new FThreeTimesProjectDetailVo();
        result.setBaseInfo((FProject)this.getById(param.getProjectId()));
        if (result.getBaseInfo() != null && (device = (EDevice)this.eDeviceService.getById(result.getBaseInfo().getDeviceId())) == null) {
            result.getBaseInfo().setDeviceType(device.getType());
            result.getBaseInfo().setDeviceNo(device.getFactoryNo());
        }
        if (CollectionUtils.isEmpty(projectDetailList = this.projectDetailService.getList(new ThreeProjectQueryParam().setProjectId(param.getProjectId()))) || projectDetailList.size() != 2) {
            log.info("\u4e09\u540c\u65f6\u9879\u76eeProjectId-{}\uff1a\u8bbe\u5907\u3001\u573a\u6240 \u9884\u63a7\u8bc4\u4ef7\u6570\u636e\u5f02\u5e38\uff01", (Object)param.getProjectId());
            return result;
        }
        FProjectDetail projectDetail1 = projectDetailList.stream().filter(item -> item.getType() == 1).findFirst().orElse(null);
        FProjectDetail projectDetail2 = projectDetailList.stream().filter(item -> item.getType() == 2).findFirst().orElse(null);
        result.setProjectDetail1(projectDetail1);
        result.setProjectDetail2(projectDetail2);
        return result;
    }

    @Override
    public void updateStatusById(Long businessId, Integer status) {
        LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)wrapper.eq(FProject::getId, (Object)businessId)).set(FProject::getStatus, (Object)status);
        ((FProjectMapper)this.baseMapper).update((Wrapper)wrapper);
    }

    @Override
    public void generateThreeTimesProject(FThreeTimesProjectAddParam param) {
        FProject fProject = new FProject();
        fProject.setCid(param.getCid());
        fProject.setName(param.getDeviceName());
        fProject.setDeviceId(param.getDeviceId());
        fProject.setDeviceNo(param.getDeviceNo());
        fProject.setRoomId(param.getRoomIds());
        fProject.setRoomName(param.getRoomNames());
        fProject.setBeginDate(new Date());
        fProject.setStatus(FProjectStatusEnum.DRAFT.getValue());
        BCompany company = (BCompany)this.companyService.getById(param.getCid());
        if (company != null) {
            fProject.setCname(company.getName());
            fProject.setAddress(company.getAddress());
            fProject.setCbranch(company.getHospitalName());
        }
        this.save(fProject);
        FProjectDetail projectDetail1 = new FProjectDetail();
        projectDetail1.setProjectId(fProject.getId());
        projectDetail1.setType(Integer.valueOf(1));
        FProjectDetail projectDetail2 = new FProjectDetail();
        projectDetail2.setProjectId(fProject.getId());
        projectDetail2.setType(Integer.valueOf(2));
        this.projectDetailService.saveBatch(Arrays.asList(projectDetail1, projectDetail2));
    }
}

