/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.supervise.service.impl.c;

import cn.smarthse.core.framework.Constant;
import cn.smarthse.core.framework.model.LayuiGridData;
import cn.smarthse.core.framework.model.LayuiGridParam;
import cn.smarthse.core.framework.service.ServiceImpl;
import cn.smarthse.rho.modules.supervise.dao.c.CTrainingMapper;
import cn.smarthse.rho.modules.supervise.model.c.param.RadiationTrainingParam;
import cn.smarthse.rho.modules.supervise.model.c.vo.RadiationTrainingListVo;
import cn.smarthse.rho.modules.supervise.service.c.ICTrainingService;
import cn.smarthse.rho.modules.sys.entity.c.CTraining;
import cn.smarthse.rho.modules.sys.entity.sys.SysBusinessOperateLog;
import cn.smarthse.rho.modules.sys.provider.sys.ISysBusinessOperateLogProvider;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class CTrainingServiceImpl
extends ServiceImpl<CTrainingMapper, CTraining>
implements ICTrainingService {
    @DubboReference
    private ISysBusinessOperateLogProvider operateLogProvider;

    @Override
    public LayuiGridData<RadiationTrainingListVo> getRadiationTrainingListData(RadiationTrainingParam param) {
        PageHelper.startPage((int)param.getPage(), (int)param.getLimit());
        Page page = (Page)((CTrainingMapper)this.baseMapper).getRadiationTrainingListData(param);
        return new LayuiGridData(page, (LayuiGridParam)param);
    }

    @Override
    @Transactional
    public void trainingDataSync(Date syncTime) {
        List<CTraining> trainings = ((CTrainingMapper)this.baseMapper).trainingDataSync(syncTime);
        if (CollectionUtils.isEmpty(trainings)) {
            return;
        }
        List<Long> trainingIds = trainings.stream().map(CTraining::getSourceTrainingId).collect(Collectors.toList());
        List<CTraining> trainingList = this.getTrainingListDataFromRho(trainingIds);
        if (!CollectionUtils.isEmpty(trainingList)) {
            trainings.forEach(training -> {
                CTraining localTraining = trainingList.stream().filter(item -> item.getSourceTrainingId().equals(training.getSourceTrainingId())).findFirst().orElse(null);
                if (localTraining != null) {
                    training.setId(localTraining.getId());
                }
            });
        }
        this.saveOrUpdateBatch(trainings);
    }

    List<CTraining> getTrainingListDataFromRho(List<Long> trainingIds) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.eq(CTraining::getIsValid, (Object)Constant.ACTIVE_YES)).in(CTraining::getSourceTrainingId, trainingIds)).groupBy(CTraining::getSourceTrainingId);
        return ((CTrainingMapper)this.baseMapper).selectList((Wrapper)queryWrapper);
    }

    @Override
    public void trainingChangeRecordDataSync(Date syncTime) {
        List<SysBusinessOperateLog> operateLogs = ((CTrainingMapper)this.baseMapper).trainingChangeRecordDataSync(syncTime);
        if (CollectionUtils.isEmpty(operateLogs)) {
            return;
        }
        this.operateLogProvider.addBatchLog(operateLogs);
    }
}

