/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.supervise.service.impl.c;

import cn.smarthse.core.framework.service.ServiceImpl;
import cn.smarthse.rho.modules.supervise.bootstrap.security.utils.ShiroUtil;
import cn.smarthse.rho.modules.supervise.converter.CStaffConverter;
import cn.smarthse.rho.modules.supervise.dao.c.CStaffMapper;
import cn.smarthse.rho.modules.supervise.service.c.ICStaffService;
import cn.smarthse.rho.modules.supervise.service.c.ICStaffWorkExperienceService;
import cn.smarthse.rho.modules.sys.entity.c.CStaff;
import cn.smarthse.rho.modules.sys.entity.c.CStaffBaseInfo;
import cn.smarthse.rho.modules.sys.entity.c.CStaffWorkExperience;
import cn.smarthse.rho.modules.sys.enums.staff.PostStatusEnum;
import cn.smarthse.rho.modules.sys.model.b.vo.BPostVo;
import cn.smarthse.rho.modules.sys.model.c.param.CStaffEditParam;
import cn.smarthse.rho.modules.sys.provider.company.IPostProvider;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import javax.smarthse.framework.exception.ServiceException;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Transactional(readOnly=true)
@Service
public class CStaffServiceImpl
extends ServiceImpl<CStaffMapper, CStaff>
implements ICStaffService {
    @Autowired
    private CStaffConverter converter;
    @Autowired
    private ICStaffWorkExperienceService cStaffWorkExperienceService;
    @DubboReference
    private IPostProvider postProvider;

    @Override
    @Transactional
    public void editInfo(CStaffEditParam param) {
        CStaff cStaff = this.converter.param2Entity(param);
        if (cStaff == null) {
            return;
        }
        if (cStaff.getId() == null) {
            throw new ServiceException("\u53c2\u6570\u9519\u8bef\uff0c\u53ef\u5c1d\u8bd5\u5237\u65b0\u9875\u9762\u540e\u91cd\u8bd5");
        }
        if (cStaff.getCid() != null && !ShiroUtil.getLoginUserOid().equals(cStaff.getCid())) {
            throw new ServiceException("\u516c\u53f8\u4fe1\u606f\u4e0d\u660e\u786e\uff0c\u53ef\u5c1d\u8bd5\u5237\u65b0\u9875\u9762\u540e\u91cd\u8bd5");
        }
        CStaff oldStaff = (CStaff)this.getById(param.getId());
        CStaffBaseInfo staffBaseInfo = ((CStaffMapper)this.baseMapper).getBaseInfoById(oldStaff.getBaseId());
        this.updateById(cStaff);
        CStaff newestStaff = (CStaff)this.getById(param.getId());
        this.recordWorkExperience(oldStaff, newestStaff, staffBaseInfo, param);
    }

    @Override
    public CStaff getInfo(Long baseId, Long cid) {
        QueryWrapper wrapper = new QueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.lambda().eq(CStaff::getBaseId, (Object)baseId)).eq(CStaff::getCid, (Object)cid)).last("limit");
        return (CStaff)this.getOne((Wrapper)wrapper);
    }

    @Override
    public CStaff getByBaseIdAndBranchCid(Long staffBaseInfoId, Long branchCid) {
        return ((CStaffMapper)this.baseMapper).getByBaseIdAndBranchCid(staffBaseInfoId, branchCid);
    }

    @Override
    public CStaff getByBaseIdAndCid(Long baseId, Long cid) {
        QueryWrapper wrapper = new QueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.lambda().eq(CStaff::getBaseId, (Object)baseId)).eq(CStaff::getCid, (Object)cid)).last("limit 1");
        return (CStaff)this.getOne((Wrapper)wrapper);
    }

    @Transactional
    public void recordWorkExperience(CStaff oldData, CStaff newestData, CStaffBaseInfo baseInfo, CStaffEditParam param) {
        BPostVo postInfo = this.postProvider.getPostInfo(newestData.getPost());
        BPostVo bPostVo = postInfo = postInfo == null ? new BPostVo() : postInfo;
        if (param.getType() == null) {
            return;
        }
        if (param.getType() == 0) {
            CStaffWorkExperience staffWorkExperience = new CStaffWorkExperience();
            staffWorkExperience.setCid(newestData.getCid());
            staffWorkExperience.setOrgId(newestData.getOrgId());
            staffWorkExperience.setStaffBaseInfoId(baseInfo.getId());
            staffWorkExperience.setPost(newestData.getPost());
            staffWorkExperience.setPostName(postInfo.getName());
            staffWorkExperience.setPostStatus(PostStatusEnum.NON_POST.getValue());
            staffWorkExperience.setType(param.getType());
            staffWorkExperience.setRaType(baseInfo.getRaType());
            staffWorkExperience.setPostDepartureTime(param.getPostDepartureTime());
            this.cStaffWorkExperienceService.save(staffWorkExperience);
        } else if (param.getType() == 1) {
            CStaffWorkExperience staffWorkExperience = new CStaffWorkExperience();
            staffWorkExperience.setCid(newestData.getCid());
            staffWorkExperience.setOrgId(newestData.getOrgId());
            staffWorkExperience.setStaffBaseInfoId(baseInfo.getId());
            staffWorkExperience.setPost(newestData.getPost());
            staffWorkExperience.setPostName(postInfo.getName());
            staffWorkExperience.setPostStatus(PostStatusEnum.ON_POST.getValue());
            staffWorkExperience.setType(param.getType());
            staffWorkExperience.setRaType(baseInfo.getRaType());
            staffWorkExperience.setPostStartTime(param.getPostStartTime());
            this.cStaffWorkExperienceService.save(staffWorkExperience);
        } else if (param.getType() == 2) {
            CStaffWorkExperience staffWorkExperience;
            CStaffWorkExperience newestWorkExperienceInfo = this.cStaffWorkExperienceService.getNewestInfo(baseInfo.getId(), oldData.getCid());
            if (newestWorkExperienceInfo != null && PostStatusEnum.ON_POST.getValue().equals(newestWorkExperienceInfo.getPostStatus())) {
                staffWorkExperience = new CStaffWorkExperience();
                staffWorkExperience.setId(newestWorkExperienceInfo.getId());
                staffWorkExperience.setPostStatus(PostStatusEnum.NON_POST.getValue());
                staffWorkExperience.setType(param.getType());
                staffWorkExperience.setPostDepartureTime(param.getPostDepartureTime());
                this.cStaffWorkExperienceService.updateById(staffWorkExperience);
            }
            staffWorkExperience = new CStaffWorkExperience();
            staffWorkExperience.setCid(newestData.getCid());
            staffWorkExperience.setOrgId(newestData.getOrgId());
            staffWorkExperience.setStaffBaseInfoId(baseInfo.getId());
            staffWorkExperience.setPost(newestData.getPost());
            staffWorkExperience.setPostName(postInfo.getName());
            staffWorkExperience.setPostStatus(PostStatusEnum.ON_POST.getValue());
            staffWorkExperience.setType(param.getType());
            staffWorkExperience.setRaType(baseInfo.getRaType());
            staffWorkExperience.setPostStartTime(param.getPostStartTime());
            this.cStaffWorkExperienceService.save(staffWorkExperience);
        } else {
            return;
        }
    }
}

