/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.supervise.service.impl.c;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.smarthse.core.framework.Constant;
import cn.smarthse.core.framework.model.BaseEntity;
import cn.smarthse.core.framework.model.LayuiGridData;
import cn.smarthse.core.framework.model.LayuiGridParam;
import cn.smarthse.core.framework.service.ServiceImpl;
import cn.smarthse.rho.modules.supervise.converter.CStaffBaseInfoConverter;
import cn.smarthse.rho.modules.supervise.dao.c.CStaffBaseInfoMapper;
import cn.smarthse.rho.modules.supervise.model.c.param.StaffStatisticsAdminParam;
import cn.smarthse.rho.modules.supervise.model.home.param.HomeVisualizationDataParam;
import cn.smarthse.rho.modules.supervise.model.home.vo.HomeVisualizationStaffDataVo;
import cn.smarthse.rho.modules.supervise.model.home.vo.HomeVisualizationStaffWarningDataVo;
import cn.smarthse.rho.modules.supervise.model.staffArchives.param.CertConditionParam;
import cn.smarthse.rho.modules.supervise.model.staffArchives.param.StaffInfoAdminParam;
import cn.smarthse.rho.modules.supervise.model.staffArchives.param.StaffPageAdminParam;
import cn.smarthse.rho.modules.supervise.model.staffArchives.vo.StaffArchiveListAdminVo;
import cn.smarthse.rho.modules.supervise.model.staffArchives.vo.StaffCompanyVo;
import cn.smarthse.rho.modules.supervise.model.staffArchives.vo.StaffDetailInfoVo;
import cn.smarthse.rho.modules.supervise.model.staffArchives.vo.StaffWarningVo;
import cn.smarthse.rho.modules.supervise.service.b.IBCompanyService;
import cn.smarthse.rho.modules.supervise.service.b.IBStatisticService;
import cn.smarthse.rho.modules.supervise.service.c.ICStaffBaseInfoService;
import cn.smarthse.rho.modules.supervise.service.c.ICStaffService;
import cn.smarthse.rho.modules.supervise.service.c.ICStatisticService;
import cn.smarthse.rho.modules.sys.entity.c.CStaffBaseInfo;
import cn.smarthse.rho.modules.sys.enums.staff.PostStatusEnum;
import cn.smarthse.rho.modules.sys.model.b.param.RayStaffQueryParam;
import cn.smarthse.rho.modules.sys.model.c.param.CStaffBaseInfoEditParam;
import cn.smarthse.rho.modules.sys.model.c.param.StaffAcInfoParam;
import cn.smarthse.rho.modules.sys.model.c.vo.CertConditionVo;
import cn.smarthse.rho.modules.sys.model.c.vo.RayStaffListVo;
import cn.smarthse.rho.modules.sys.model.c.vo.StaffAcVo;
import cn.smarthse.rho.modules.sys.model.c.vo.StaffArchiveListVo;
import cn.smarthse.rho.modules.sys.model.c.vo.StaffArchiveStatisticsAdminVo;
import cn.smarthse.rho.modules.sys.model.c.vo.StaffChooseListVo;
import cn.smarthse.rho.modules.sys.model.sys.vo.SysFileVo;
import cn.smarthse.rho.modules.sys.provider.sys.ISysFileProvider;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.smarthse.framework.exception.ServiceException;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class CStaffBaseInfoServiceImpl
extends ServiceImpl<CStaffBaseInfoMapper, CStaffBaseInfo>
implements ICStaffBaseInfoService {
    @Autowired
    private CStaffBaseInfoConverter cStaffBaseInfoConverter;
    @Autowired
    private ICStaffService cStaffService;
    @Autowired
    private IBCompanyService bCompanyService;
    @Autowired
    private ICStatisticService cStatisticService;
    @Autowired
    private IBStatisticService bStatisticService;
    @DubboReference
    private ISysFileProvider fileProvider;

    @Override
    public LayuiGridData<StaffArchiveListAdminVo> getStaffArchiveList(StaffPageAdminParam param) {
        List<StaffArchiveListAdminVo> list;
        PageHelper.startPage((int)param.getPage(), (int)param.getLimit());
        Integer hasCompany = param.getHasCompany() != null && param.getHasCompany() == 0 ? 0 : 1;
        List<StaffArchiveListAdminVo> list2 = hasCompany == 0 ? ((CStaffBaseInfoMapper)this.baseMapper).getNoCompanyStaffArchiveList(param) : (list = param.getOnlyThisArea() != 0 ? ((CStaffBaseInfoMapper)this.baseMapper).getStaffArchiveList(param) : ((CStaffBaseInfoMapper)this.baseMapper).getStaffArchiveListForRelateArea(param));
        if (CollectionUtil.isEmpty(list)) {
            return new LayuiGridData((Page)list, (LayuiGridParam)param);
        }
        if (hasCompany == 1) {
            List<Long> staffBaseInfoIdList = list.stream().map(v -> v.getId()).collect(Collectors.toList());
            CertConditionParam certConditionParam = new CertConditionParam().setStaffBaseInfoIdList(staffBaseInfoIdList).setAreaId(param.getAreaId()).setLevel(param.getLevel());
            List<CertConditionVo> certConditionList = this.getCertCondition(certConditionParam);
            Map<Long, CertConditionVo> certConditionVoMap = certConditionList.stream().collect(Collectors.toMap(v -> v.getStaffBaseInfoId(), v -> v));
            for (StaffArchiveListAdminVo vo : list) {
                if (certConditionVoMap.containsKey(vo.getId())) {
                    CertConditionVo certConditionVo = certConditionVoMap.get(vo.getId());
                    vo.setCertConditionVo(certConditionVo);
                }
                vo.genSex();
                vo.genAge();
                vo.genPhone();
                vo.genIdcard();
            }
        } else {
            for (StaffArchiveListAdminVo vo : list) {
                vo.setCertConditionVo(new CertConditionVo().setIsComplete(Integer.valueOf(0)));
                vo.genSex();
                vo.genAge();
                vo.genPhone();
                vo.genIdcard();
            }
        }
        return new LayuiGridData((Page)list, (LayuiGridParam)param);
    }

    @Override
    public LayuiGridData<StaffArchiveListAdminVo> getPostStaffArchiveList(StaffPageAdminParam param) {
        if (param.getPost() == null) {
            throw new ServiceException("\u7f3a\u5c11\u53c2\u6570");
        }
        PageHelper.startPage((int)param.getPage(), (int)param.getLimit());
        List<StaffArchiveListAdminVo> list = ((CStaffBaseInfoMapper)this.baseMapper).getPostStaffArchiveList(param);
        if (CollectionUtil.isEmpty(list)) {
            return new LayuiGridData((Page)list, (LayuiGridParam)param);
        }
        for (StaffArchiveListAdminVo vo : list) {
            vo.genSex();
            vo.genAge();
            vo.genPhone();
            vo.genIdcard();
        }
        return new LayuiGridData((Page)list, (LayuiGridParam)param);
    }

    @Override
    @Transactional
    public StaffArchiveListVo editInfo(CStaffBaseInfoEditParam param) {
        if (param.getId() == null) {
            throw new ServiceException("\u53c2\u6570\u9519\u8bef");
        }
        CStaffBaseInfo cStaffBaseInfo = this.cStaffBaseInfoConverter.param2Entity(param);
        cStaffBaseInfo.setCreateBy(param.getLoginUserId());
        cStaffBaseInfo.setUpdateBy(param.getLoginUserId());
        this.updateById(cStaffBaseInfo);
        this.cStaffService.editInfo(param.getStaffEditParam());
        return this.cStaffBaseInfoConverter.entity2ArchiveVo(cStaffBaseInfo);
    }

    @Override
    public StaffDetailInfoVo getInfo(StaffInfoAdminParam param) {
        SysFileVo sysFileVo;
        StaffDetailInfoVo vo = ((CStaffBaseInfoMapper)this.baseMapper).getInfoById(param);
        if (vo == null) {
            return null;
        }
        if (vo.getHeadId() != null && (sysFileVo = this.fileProvider.getFileById(vo.getHeadId())) != null) {
            vo.setHeadFileName(sysFileVo.getFileName());
            vo.setHeadFileUrl(sysFileVo.getFullOssUrl());
        }
        if (vo.getRaCertFileId() != null && (sysFileVo = this.fileProvider.getFileById(vo.getRaCertFileId())) != null) {
            vo.setRaCertUrl(sysFileVo.getFullOssUrl());
            vo.setRaCertFileName(sysFileVo.getFileName());
        }
        param.setPostStatus(PostStatusEnum.ON_POST.getValue());
        List<StaffWarningVo> staffCompanyList = this.getStaffWarningList(param);
        param.setPostStatus(PostStatusEnum.NON_POST.getValue());
        List<StaffWarningVo> staffCompanyList2 = this.getStaffWarningList(param);
        vo.setStaffWarningVoList(staffCompanyList);
        vo.setStaffWarningVoList2(staffCompanyList2);
        CertConditionParam certConditionParam = new CertConditionParam().setStaffBaseInfoIdList(CollectionUtil.toList((Object[])new Long[]{vo.getId()}));
        List<CertConditionVo> certConditionVoList = this.getCertCondition(certConditionParam);
        if (CollectionUtil.isNotEmpty(certConditionVoList)) {
            CertConditionVo certConditionVo = certConditionVoList.get(0);
            vo.setCertConditionVo(certConditionVo);
        }
        return vo;
    }

    @Override
    public StaffArchiveStatisticsAdminVo getStaffArchiveStatistics(StaffStatisticsAdminParam param) {
        return ((CStaffBaseInfoMapper)this.baseMapper).getStaffArchiveStatistics(param);
    }

    @Override
    public List<CertConditionVo> getCertCondition(CertConditionParam param) {
        List<Long> staffBaseInfoIdList = param.getStaffBaseInfoIdList();
        ArrayList<CertConditionVo> list = new ArrayList<CertConditionVo>();
        if (CollUtil.isEmpty(staffBaseInfoIdList)) {
            return list;
        }
        for (Long id : staffBaseInfoIdList) {
            param.setStaffBaseInfoId(id);
            param.setIsOnlineSpecialTestUser(param.getIsOnlineSpecialTestUser());
            CertConditionVo certCondition = this.getOneCertCondition(param);
            if (certCondition == null) {
                certCondition = new CertConditionVo();
                certCondition.setStaffBaseInfoId(id);
                certCondition.setProfilePictureInfo(Integer.valueOf(0));
                certCondition.setHealthCheckInfo(Integer.valueOf(-1));
                certCondition.setHealthCheckResult(null);
                certCondition.setTrainingInfo(Integer.valueOf(-1));
            }
            list.add(certCondition);
        }
        return list;
    }

    @Override
    public CertConditionVo getOneCertCondition(CertConditionParam param) {
        return ((CStaffBaseInfoMapper)this.baseMapper).getCertCondition(param);
    }

    @Override
    public List<StaffWarningVo> getStaffWarningList(StaffInfoAdminParam param) {
        List<StaffWarningVo> staffWarningList = ((CStaffBaseInfoMapper)this.baseMapper).getStaffWarningList(param);
        List<StaffCompanyVo> staffCompanyList = this.getStaffCompanyList(param);
        Map<Long, StaffCompanyVo> staffCompanyVoMap = staffCompanyList.stream().collect(Collectors.toMap(v -> v.getCid(), v -> v));
        for (StaffWarningVo vo : staffWarningList) {
            if (!staffCompanyVoMap.containsKey(vo.getCid())) continue;
            vo.setStaffCompanyVo(staffCompanyVoMap.get(vo.getCid()));
        }
        return staffWarningList;
    }

    @Override
    public List<StaffCompanyVo> getStaffCompanyList(StaffInfoAdminParam param) {
        return ((CStaffBaseInfoMapper)this.baseMapper).getStaffCompanyList(param);
    }

    @Override
    public LayuiGridData<StaffChooseListVo> getChooseList(StaffPageAdminParam param) {
        PageHelper.startPage((int)param.getPage(), (int)param.getLimit());
        List<StaffChooseListVo> list = ((CStaffBaseInfoMapper)this.baseMapper).getChooseList(param);
        return new LayuiGridData((Page)list, (LayuiGridParam)param);
    }

    @Override
    public LayuiGridData<RayStaffListVo> rayStaffList(RayStaffQueryParam param) {
        PageHelper.startPage((int)param.getPage(), (int)param.getLimit());
        List<RayStaffListVo> list = ((CStaffBaseInfoMapper)this.baseMapper).rayStaffList(param);
        return new LayuiGridData((Page)list, (LayuiGridParam)param);
    }

    @Override
    public StaffAcVo getAcInfo(StaffAcInfoParam param) {
        return ((CStaffBaseInfoMapper)this.baseMapper).getAcInfo(param);
    }

    @Override
    public HomeVisualizationStaffDataVo getHomeVisualizationDataWithRayStaffNum(HomeVisualizationDataParam param) {
        return ((CStaffBaseInfoMapper)this.baseMapper).getHomeVisualizationDataWithRayStaffNum(param);
    }

    @Override
    public HomeVisualizationStaffWarningDataVo getHomeVisualizationDataWithWarningNum(HomeVisualizationDataParam param) {
        return ((CStaffBaseInfoMapper)this.baseMapper).getHomeVisualizationDataWithWarningNum(param);
    }

    @Override
    public CStaffBaseInfo getByIdCard(String idCard) {
        QueryWrapper wrapper = new QueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.lambda().eq(CStaffBaseInfo::getIdcard, (Object)idCard)).eq(BaseEntity::getIsValid, (Object)Constant.ACTIVE_YES)).last("limit 1");
        return (CStaffBaseInfo)this.getOne((Wrapper)wrapper);
    }
}

