/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.supervise.service.impl.c;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.IdcardUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.extra.pinyin.PinyinUtil;
import cn.smarthse.core.framework.Constant;
import cn.smarthse.core.framework.model.BaseEntity;
import cn.smarthse.core.framework.service.ServiceImpl;
import cn.smarthse.rho.modules.supervise.bootstrap.security.utils.ShiroUtil;
import cn.smarthse.rho.modules.supervise.converter.CCertConverter;
import cn.smarthse.rho.modules.supervise.dao.c.CCertMapper;
import cn.smarthse.rho.modules.supervise.model.c.param.GenCertInfoParam;
import cn.smarthse.rho.modules.supervise.model.staffArchives.param.CertConditionParam;
import cn.smarthse.rho.modules.supervise.service.c.ICCertService;
import cn.smarthse.rho.modules.supervise.service.c.ICStaffBaseInfoService;
import cn.smarthse.rho.modules.sys.entity.b.BCompany;
import cn.smarthse.rho.modules.sys.entity.c.CCert;
import cn.smarthse.rho.modules.sys.entity.c.CStaffBaseInfo;
import cn.smarthse.rho.modules.sys.model.c.vo.CCertVo;
import cn.smarthse.rho.modules.sys.model.c.vo.CertConditionVo;
import cn.smarthse.rho.modules.sys.model.sys.vo.SysAreaVo;
import cn.smarthse.rho.modules.sys.provider.sys.ISysAreaProvider;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.smarthse.framework.exception.ServiceException;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class CCertServiceImpl
extends ServiceImpl<CCertMapper, CCert>
implements ICCertService {
    @Autowired
    private ICStaffBaseInfoService staffBaseInfoService;
    @Autowired
    private CCertConverter converter;
    @DubboReference
    private ISysAreaProvider sysAreaProvider;

    @Override
    @Transactional
    public Long completionCertBaseInfo(Long staffBaseInfoId) {
        SysAreaVo area = this.sysAreaProvider.getAreaById(ShiroUtil.getLoginUserAreaId());
        if (area == null) {
            throw new ServiceException("\u53d1\u8bc1\u8d26\u53f7\u7f3a\u5c11\u533a\u57df\u4fe1\u606f\uff0c\u53d1\u8bc1\u5931\u8d25");
        }
        CStaffBaseInfo staffBaseInfo = (CStaffBaseInfo)this.staffBaseInfoService.getById(staffBaseInfoId);
        this.checkCertCondition(staffBaseInfoId, area);
        CCert entity = this.genCertInfo(area, staffBaseInfo);
        this.saveOrUpdate(entity);
        return entity.getId();
    }

    private CCert genCertInfo(SysAreaVo area, CStaffBaseInfo staffBaseInfo) {
        Long staffBaseInfoId = staffBaseInfo.getId();
        GenCertInfoParam genCertInfoParam = new GenCertInfoParam();
        genCertInfoParam.setAreaId(area.getId());
        genCertInfoParam.setLevel(area.getLevel());
        genCertInfoParam.setStaffBaseInfoId(staffBaseInfoId);
        CCert certTime = ((CCertMapper)this.baseMapper).getAllCheckTimeForCert(genCertInfoParam);
        BCompany company = ((CCertMapper)this.baseMapper).getStaffCompanyInfoForCert(genCertInfoParam);
        String idCard = staffBaseInfo.getIdcard();
        boolean isIdCard = IdcardUtil.isValidCard((String)idCard);
        CCert dbEntity = this.getCertInfo(staffBaseInfoId);
        CCert entity = dbEntity != null ? dbEntity : new CCert();
        entity.setBaseId(staffBaseInfoId);
        this.genRaCertNoBaseInfo(company.getAreaId(), entity);
        entity.setRaType(staffBaseInfo.getRaType());
        entity.setName(staffBaseInfo.getName());
        entity.setIdcard(staffBaseInfo.getIdcard());
        entity.setBirthday(isIdCard ? LocalDate.from(DateUtil.toLocalDateTime((Date)IdcardUtil.getBirthDate((String)idCard))) : (staffBaseInfo.getBirthday() != null ? LocalDate.from(staffBaseInfo.getBirthday()) : null));
        entity.setSex(Integer.valueOf(isIdCard ? IdcardUtil.getGenderByIdCard((String)idCard) : staffBaseInfo.getSex()));
        entity.setHeadId(staffBaseInfo.getHeadId());
        entity.setHealthCheckTime(certTime == null ? null : certTime.getHealthCheckTime());
        entity.setDoseCheckTime(certTime == null ? null : certTime.getDoseCheckTime());
        entity.setTrainingTime(certTime == null ? null : certTime.getTrainingTime());
        entity.setCid(company.getId());
        entity.setCname(company.getName());
        entity.setIssueUnitId(ShiroUtil.getLoginUserOid());
        entity.setIssueUnitName(ShiroUtil.getLoginUserOrgName());
        entity.setIssueTime(LocalDate.now());
        entity.setEditTime(LocalDateTime.now());
        return entity;
    }

    @Override
    public CCertVo previewCertificateData(Long staffBaseInfoId) {
        SysAreaVo area = this.sysAreaProvider.getAreaById(ShiroUtil.getLoginUserAreaId());
        CStaffBaseInfo staffBaseInfo = (CStaffBaseInfo)this.staffBaseInfoService.getById(staffBaseInfoId);
        if (area == null || staffBaseInfo == null) {
            return null;
        }
        CCert cCert = this.genCertInfo(area, staffBaseInfo);
        return this.converter.entity2Vo(cCert);
    }

    private void checkCertCondition(Long staffBaseInfoId, SysAreaVo area) {
        CertConditionParam param = new CertConditionParam();
        param.setLevel(area.getLevel());
        param.setAreaId(area.getAreaId());
        param.setStaffBaseInfoIdList(Collections.singletonList(staffBaseInfoId));
        List<CertConditionVo> certConditionVoList = this.staffBaseInfoService.getCertCondition(param);
        if (CollectionUtil.isEmpty(certConditionVoList)) {
            throw new ServiceException("\u7528\u6237\u5728\u60a8\u7684\u7ba1\u8f96\u533a\u57df\u5185\u7f3a\u5c11\u53d6\u8bc1\u6761\u4ef6");
        }
        CertConditionVo certConditionVo = certConditionVoList.get(0);
        CCertServiceImpl.checkCertCondition(certConditionVo);
    }

    private static void checkCertCondition(CertConditionVo certConditionVo) {
        Integer trainingInfo;
        StringBuilder sb = new StringBuilder();
        if (certConditionVo.getProfilePictureInfo() == 0) {
            sb.append("\u7f3a\u5c11\u7528\u6237\u5934\u50cf\u3002");
        }
        String healthCheckResult = certConditionVo.getHealthCheckResult();
        Integer healthCheckInfo = certConditionVo.getHealthCheckInfo();
        if (healthCheckInfo == -1) {
            sb.append("\u7f3a\u5c11\u5065\u5eb7\u4f53\u68c0\u6cbb\u7597\u3002");
        }
        if (healthCheckInfo == 0) {
            sb.append("\u5065\u5eb7\u4f53\u68c0\u7ed3\u679c\u4e0d\u7b26\u5408\uff1a\u9002\u4efb\u6027\u7ed3\u8bba\u4e0d\u4e3a\u3010\u53ef\u4ece\u4e8b\u653e\u5c04\u5de5\u4f5c\u3011\u3010\u5728\u4e00\u5b9a\u9650\u5236\u6761\u4ef6\u4e0b\u53ef\u4ece\u4e8b\u653e\u5c04\u5de5\u4f5c\u3011");
        }
        if (healthCheckInfo == 0) {
            sb.append("\u7528\u6237\u5065\u5eb7\u4f53\u68c0\u7ed3\u679c\u4e0d\u7b26\u5408\u53d6\u8bc1\u6761\u4ef6\u3002");
        }
        if ((trainingInfo = certConditionVo.getTrainingInfo()) == -1) {
            sb.append("\u7528\u6237\u7f3a\u5c11\u57f9\u8bad\u6570\u636e\u3002");
        }
        if (trainingInfo == 0) {
            sb.append("\u7528\u6237\u57f9\u8bad\u4e0d\u5408\u683c\u3002");
        }
        if (sb.length() > 0) {
            throw new ServiceException(sb.toString());
        }
    }

    private void genRaCertNoBaseInfo(Long companyArea, CCert entity) {
        if (StrUtil.isNotEmpty((CharSequence)entity.getCityShortNamePy()) && StrUtil.isNotEmpty((CharSequence)entity.getAreaShortNamePy()) && entity.getSerialYear() != null) {
            return;
        }
        SysAreaVo area = this.sysAreaProvider.getAreaById(companyArea);
        if (area.getLevel() <= 1) {
            throw new ServiceException("\u533b\u9662\u533a\u57df\u4e0d\u591f\u7cbe\u786e\uff0c\u65e0\u6cd5\u751f\u6210\u8bc1\u4e66");
        }
        SysAreaVo cityArea = this.sysAreaProvider.getAreaById(area.getCityId());
        SysAreaVo areaArea = this.sysAreaProvider.getAreaById(area.getAreaId());
        String cityShortPy = PinyinUtil.getFirstLetter((String)area.getCityName(), (String)"");
        String areaShortY = PinyinUtil.getFirstLetter((String)area.getAreaName(), (String)"");
        cityShortPy = cityShortPy == null ? null : cityShortPy.toUpperCase();
        areaShortY = areaShortY == null ? null : areaShortY.toUpperCase();
        Integer serialYear = DateUtil.thisYear();
        if (StrUtil.isEmpty((CharSequence)cityShortPy)) {
            throw new ServiceException("\u533b\u9662\u5730\u5e02\u4fe1\u606f\u5f02\u5e38\uff0c\u8bc1\u4e66\u751f\u6210\u5931\u8d25");
        }
        if (StrUtil.isEmpty((CharSequence)areaShortY)) {
            throw new ServiceException("\u533b\u9662\u53bf\u533a\u4fe1\u606f\u5f02\u5e38\uff0c\u8bc1\u4e66\u751f\u6210\u5931\u8d25");
        }
        if (serialYear == null) {
            throw new ServiceException("\u5e74\u4efd\u4fe1\u606f\u5f02\u5e38\uff0c\u8bc1\u4e66\u751f\u6210\u5931\u8d25");
        }
        entity.setCityShortNamePy(cityShortPy);
        entity.setAreaShortNamePy(areaShortY);
        entity.setSerialYear(serialYear);
    }

    @Override
    public CCert getCertInfo(Long staffBaseInfoId) {
        QueryWrapper wrapper = new QueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.lambda().eq(BaseEntity::getIsValid, (Object)Constant.ACTIVE_YES)).eq(CCert::getBaseId, (Object)staffBaseInfoId)).last("limit 1");
        return (CCert)this.getOne((Wrapper)wrapper);
    }

    @Override
    public Integer getMaxSerialNo(String cityShortNamePy, String areaShortNamePy, Integer serialYear) {
        return ((CCertMapper)this.baseMapper).getMaxSerialNo(cityShortNamePy, areaShortNamePy, serialYear);
    }

    @Override
    public CCertVo getCert(Long certId) {
        CCert cert = (CCert)this.getById(certId);
        return this.converter.entity2Vo(cert);
    }
}

