/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.supervise.service.cert;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.io.resource.ResourceUtil;
import cn.hutool.core.util.IdcardUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.crypto.digest.MD5;
import cn.hutool.extra.qrcode.QrCodeUtil;
import cn.hutool.extra.qrcode.QrConfig;
import cn.smarthse.core.framework.bean.OssClientBean;
import cn.smarthse.core.framework.bootstrap.properties.SysProperties;
import cn.smarthse.core.framework.uploader.FileResourceEnum;
import cn.smarthse.core.framework.uploader.FileUploadSimple;
import cn.smarthse.core.framework.uploader.UploadFileParameter;
import cn.smarthse.core.framework.uploader.UploadFilePathEnum;
import cn.smarthse.core.framework.utils.FreemarkUtil;
import cn.smarthse.core.framework.utils.ImageUtil;
import cn.smarthse.rho.modules.supervise.bootstrap.security.utils.ShiroUtil;
import cn.smarthse.rho.modules.supervise.converter.CCertConverter;
import cn.smarthse.rho.modules.supervise.model.c.vo.CertGenVo;
import cn.smarthse.rho.modules.supervise.model.staffArchives.param.CertConditionParam;
import cn.smarthse.rho.modules.supervise.service.c.ICCertService;
import cn.smarthse.rho.modules.supervise.service.c.ICStaffBaseInfoService;
import cn.smarthse.rho.modules.sys.entity.c.CCert;
import cn.smarthse.rho.modules.sys.entity.c.CStaffBaseInfo;
import cn.smarthse.rho.modules.sys.entity.sys.SysFile;
import cn.smarthse.rho.modules.sys.enums.staff.RayCodeEnum;
import cn.smarthse.rho.modules.sys.model.c.vo.CCertVo;
import cn.smarthse.rho.modules.sys.model.c.vo.CertConditionVo;
import cn.smarthse.rho.modules.sys.model.sys.vo.SysFileVo;
import cn.smarthse.rho.modules.sys.provider.sys.ISysFileProvider;
import com.itextpdf.html2pdf.ConverterProperties;
import com.itextpdf.html2pdf.HtmlConverter;
import com.itextpdf.kernel.geom.PageSize;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDate;
import java.util.Date;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import javax.smarthse.framework.exception.ServiceException;
import org.apache.commons.io.FilenameUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class CertService {
    private static final Logger log = LoggerFactory.getLogger(CertService.class);
    private final OssClientBean ossClientBean;
    private final ICCertService cCertService;
    private final CCertConverter converter;
    private final RedissonClient redissonClient;
    public static final String certFont = "templates/font/ali/AlibabaPuHuiTi-3-55-Regular.ttf";
    @DubboReference
    private ISysFileProvider sysFileProvider;
    private final ICStaffBaseInfoService staffBaseInfoService;
    private final SysProperties sysProperties;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CCertVo genCert(Long baseInfoId) {
        Boolean genFlag;
        Long certId;
        block8: {
            String lock_key;
            block7: {
                CCert certInfo = this.cCertService.getCertInfo(baseInfoId);
                if (certInfo != null && StrUtil.isNotEmpty((CharSequence)certInfo.getRaCertUrl())) {
                    return this.converter.entity2Vo(certInfo);
                }
                CertConditionVo oneCertCondition = this.staffBaseInfoService.getOneCertCondition(new CertConditionParam().setStaffBaseInfoId(baseInfoId));
                if (oneCertCondition == null || oneCertCondition.getIsComplete() == 0) {
                    throw new ServiceException("\u8d44\u6599\u4e0d\u5b8c\u6574\uff0c\u65e0\u6cd5\u751f\u6210\u8bc1\u4e66");
                }
                certId = this.cCertService.completionCertBaseInfo(baseInfoId);
                CCert entityDB = (CCert)this.cCertService.getById(certId);
                lock_key = String.format("genCertFileLock:%s:%s:%s", entityDB.getCityShortNamePy(), entityDB.getAreaShortNamePy(), entityDB.getSerialYear());
                RLock lock = this.redissonClient.getLock(lock_key);
                boolean resLock = false;
                try {
                    resLock = lock.tryLock(15L, 15L, TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                genFlag = false;
                if (!resLock) break block7;
                try {
                    log.debug("\u751f\u6210\u8bc1\u4e66-\u83b7\u53d6\u9501\uff1akey:\u201c{}\u201c-id:{}-uname\uff1a{}", new Object[]{lock_key, entityDB.getId(), entityDB.getName()});
                    CertGenVo genInfo = this.getGenInfo(entityDB);
                    this.genCert(genInfo);
                    genFlag = true;
                }
                catch (Throwable throwable) {
                    lock.unlock();
                    log.debug("\u751f\u6210\u8bc1\u4e66-\u91ca\u653e\u9501\uff1akey:\u201c{}\u201c-id:{}-uname\uff1a{}", new Object[]{lock_key, entityDB.getId(), entityDB.getName()});
                    throw throwable;
                }
                lock.unlock();
                log.debug("\u751f\u6210\u8bc1\u4e66-\u91ca\u653e\u9501\uff1akey:\u201c{}\u201c-id:{}-uname\uff1a{}", new Object[]{lock_key, entityDB.getId(), entityDB.getName()});
                break block8;
            }
            genFlag = false;
            log.debug("{}\uff1aPending lock timeout\uff0cmethod:genCert()", (Object)lock_key);
        }
        if (genFlag.booleanValue()) {
            return this.converter.entity2Vo((CCert)this.cCertService.getById(certId));
        }
        throw new ServiceException("\u8bc1\u4e66\u751f\u6210\u5931\u8d25");
    }

    public void genCert(CertGenVo genInfo) {
        File file = this.genCertFile(genInfo);
        SysFileVo sysFileVo = this.uploadCertFile(file, FileUploadSimple.getNumberName((String)"pdf"));
        CCert entity = new CCert();
        entity.setId(genInfo.getId());
        entity.setSerialNo(genInfo.getSerialNo());
        entity.setRaCert(genInfo.getRaCert());
        entity.setRaCertFileId(sysFileVo.getId());
        entity.setRaCertUrl(sysFileVo.getFullOssUrl());
        this.cCertService.updateById(entity);
    }

    public File genCertFile(CertGenVo genVo) {
        this.checkGenInfo(genVo);
        HashMap<String, Object> dataMap = new HashMap<String, Object>(5);
        dataMap.put("cert", genVo);
        dataMap.put("certFont", ResourceUtil.getResource((String)certFont).getPath());
        String uploadDir = UploadFileParameter.FILE_PATH + FileResourceEnum.rho_supervise.getCode() + UploadFileParameter.FILE_PATH_SEP + UploadFilePathEnum.CERT.getPath() + UploadFileParameter.FILE_PATH_SEP + FileUploadSimple.getDataPath() + UploadFileParameter.FILE_PATH_SEP + System.currentTimeMillis();
        String realPath = this.ossClientBean.getLocal() + uploadDir;
        String filePath = realPath + UploadFileParameter.FILE_PATH_SEP + genVo.getId() + "-" + genVo.getName() + "-" + genVo.getRaCert() + ".pdf";
        try {
            Files.createDirectories(Paths.get(realPath, new String[0]), new FileAttribute[0]);
            ConverterProperties properties = new ConverterProperties();
            File file = new File(filePath);
            FileOutputStream os = new FileOutputStream(file);
            PdfWriter pdfWriter = new PdfWriter((OutputStream)os);
            PdfDocument pdfDocument = new PdfDocument(pdfWriter);
            PageSize pageSize = PageSize.A4;
            pageSize.applyMargins(0.0f, 0.0f, 0.0f, 0.0f, true);
            pdfDocument.setDefaultPageSize(pageSize);
            pdfDocument.getDocumentInfo().setAuthor("\u667a\u6167\u804c\u5b89\u73af\u4fdd\u79d1\u6280").setCreator("\u653e\u5c04\u536b\u751f\u5728\u7ebf\u7cfb\u7edf\u7cfb\u7edf").setKeywords("\u653e\u5c04\u5de5\u4f5c\u4eba\u5458\u8bc1").setTitle(String.format("%s\u7684\u8bc1\u4e66", genVo.getName())).setSubject(String.format("%s\u7684\u8bc1\u4e66", genVo.getName()));
            URL resource = ResourceUtil.getResource((String)"templates/images/cert2.png");
            dataMap.put("backImageUrl", resource.getPath());
            HtmlConverter.convertToPdf((String)FreemarkUtil.loadFreemarkFile(dataMap, (String)"cert2.html"), (PdfDocument)pdfDocument, (ConverterProperties)properties);
            return file;
        }
        catch (Exception e) {
            log.error("Exception\uff1a", (Throwable)e);
            return null;
        }
    }

    private CertGenVo getGenInfo(CCert entity) {
        if (entity == null) {
            throw new ServiceException("\u8bc1\u4e66\u76f8\u5173\u6570\u636e\u8fd8\u672a\u751f\u6210\uff0c\u8bc1\u4e66\u751f\u6210\u5931\u8d25");
        }
        CStaffBaseInfo staffBaseInfo = (CStaffBaseInfo)this.staffBaseInfoService.getById(entity.getBaseId());
        if (staffBaseInfo == null) {
            throw new ServiceException("\u4eba\u5458\u4fe1\u606f\u7f3a\u5931");
        }
        String idCard = staffBaseInfo.getIdcard();
        boolean isIdCard = IdcardUtil.isValidCard((String)idCard);
        int sex = isIdCard ? IdcardUtil.getGenderByIdCard((String)idCard) : entity.getSex();
        LocalDate birthday = isIdCard ? LocalDate.from(DateUtil.toLocalDateTime((Date)IdcardUtil.getBirthDate((String)idCard))) : entity.getBirthday();
        CertGenVo genVo = new CertGenVo();
        genVo.setId(entity.getId()).setName(staffBaseInfo.getName()).setSex(sex).setBirthday(birthday).setRaType(entity.getRaType()).setRaCert(entity.getRaCert()).setHealthCheckTime(entity.getHealthCheckTime()).setDoseCheckTime(entity.getDoseCheckTime()).setTrainingTime(entity.getTrainingTime()).setCname(entity.getCname()).setIssueUnitName(entity.getIssueUnitName()).setIssueTime(entity.getIssueTime());
        SysFileVo sysFileVo = this.sysFileProvider.getFileById(entity.getHeadId());
        if (sysFileVo != null && StrUtil.isNotEmpty((CharSequence)sysFileVo.getFullOssUrl())) {
            String fullOssUrl = sysFileVo.getFullOssUrl();
            try {
                String base64 = ImageUtil.netImg2Base64((String)fullOssUrl);
                genVo.setHeadUrl(base64);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        Integer serialNo = this.genSerialNO(entity);
        String reCert = entity.getCityShortNamePy() + entity.getAreaShortNamePy() + entity.getSerialYear() + serialNo;
        genVo.setCityShortNamePy(entity.getCityShortNamePy());
        genVo.setAreaShortNamePy(entity.getAreaShortNamePy());
        genVo.setSerialYear(entity.getSerialYear());
        genVo.setSerialNo(serialNo);
        genVo.setRaCert(reCert);
        genVo.setRaTypeName(RayCodeEnum.getName((String)entity.getRaType()));
        String qrUrl = this.sysProperties.getCertQrUrl() + entity.getId();
        genVo.setQrBase64(QrCodeUtil.generateAsBase64((String)qrUrl, (QrConfig)new QrConfig(150, 150), (String)"jpg"));
        this.checkGenInfo(genVo);
        return genVo;
    }

    private Integer genSerialNO(CCert entity) {
        Integer maxSerialNo;
        Integer serialNo = null;
        serialNo = entity.getSerialNo() == null ? Integer.valueOf((maxSerialNo = this.cCertService.getMaxSerialNo(entity.getCityShortNamePy(), entity.getAreaShortNamePy(), entity.getSerialYear())) == null ? 1 : maxSerialNo + 1) : entity.getSerialNo();
        return serialNo;
    }

    public SysFileVo uploadCertFile(File file, String ossFileName) {
        if (file == null) {
            throw new ServiceException("\u751f\u6210\u8bc1\u4e66\u5931\u8d25\uff0c\u60a8\u53ef\u5c1d\u8bd5\u7a0d\u540e\u518d\u6b21\u64cd\u4f5c\uff01");
        }
        String uploadDir = file.getParent().replace(this.ossClientBean.getLocal(), "").replace("\\", "/");
        int fileResource = FileResourceEnum.radiation_training.getValue();
        String originalFilename = file.getName();
        String fileExt = FilenameUtils.getExtension((String)file.getName());
        String ossUrl = null;
        if (this.ossClientBean.isAsynch()) {
            String fullname = StrUtil.isEmpty((CharSequence)FilenameUtils.getExtension((String)originalFilename)) ? originalFilename + "." + fileExt : originalFilename;
            String uploadFile = uploadDir + UploadFileParameter.FILE_PATH_SEP + fullname;
            ossUrl = this.ossClientBean.OSSPutObject(file, uploadFile, fullname);
            log.debug("\u4e0a\u4f20\u540e\u7684\u6587\u4ef6\u8def\u5f84\u4e3a\uff1a{}", (Object)ossUrl);
        }
        SysFile sysFile = new SysFile();
        sysFile.setResource(Integer.valueOf(fileResource)).setFileName(originalFilename).setFileSize(Long.valueOf(file.getFreeSpace())).setFileExt(fileExt).setFileHash(MD5.create().digestHex(file)).setOssUrl(ossUrl);
        file.delete();
        return this.sysFileProvider.addSysFile(sysFile, ShiroUtil.getLoginUserId());
    }

    public void checkGenInfo(CertGenVo vo) {
        StringBuilder sb = new StringBuilder();
        if (StrUtil.isEmpty((CharSequence)vo.getCityShortNamePy())) {
            sb.append("\u7f3a\u5c11\u5730\u5e02\u7b80\u79f0\u4fe1\u606f\u3002");
        }
        if (StrUtil.isEmpty((CharSequence)vo.getAreaShortNamePy())) {
            sb.append("\u7f3a\u5c11\u53bf\u533a\u7b80\u79f0\u4fe1\u606f\u3002");
        }
        if (vo.getSerialYear() == null) {
            sb.append("\u7f3a\u5c11\u5e74\u4efd\u4fe1\u606f\u3002");
        }
        if (vo.getSerialNo() == null) {
            sb.append("\u7f3a\u5c11\u6d41\u6c34\u53f7\u3002");
        }
        if (StrUtil.isEmpty((CharSequence)vo.getRaCert())) {
            sb.append("\u7f3a\u5c11\u653e\u5c04\u4eba\u5458\u5de5\u4f5c\u8bc1\u7f16\u7801\u3002");
        }
        if (StrUtil.isEmpty((CharSequence)vo.getRaType())) {
            sb.append("\u7f3a\u5c11\u804c\u4e1a\u7167\u5c04\u79cd\u7c7b\u53ca\u4ee3\u7801\u3002");
        }
        if (StrUtil.isEmpty((CharSequence)vo.getName())) {
            sb.append("\u7f3a\u5c11\u540d\u79f0\u3002");
        }
        if (vo.getSex() == null) {
            sb.append("\u7f3a\u5c11\u6027\u522b\u4fe1\u606f\u3002");
        } else if (vo.getSex() != 0 && vo.getSex() != 1) {
            sb.append("\u6027\u522b\u4fe1\u606f\u65e0\u6cd5\u8bc6\u522b\u3002");
        }
        if (vo.getBirthday() == null) {
            sb.append("\u7f3a\u5c11\u51fa\u751f\u65e5\u671f\u3002");
        }
        if (StrUtil.isEmpty((CharSequence)vo.getHeadUrl())) {
            sb.append("\u7f3a\u5c11\u5934\u50cf\u3002");
        }
        if (vo.getHealthCheckTime() == null) {
            sb.append("\u7f3a\u5c11\u4f53\u68c0\u65f6\u95f4\u3002");
        }
        if (vo.getDoseCheckTime() == null) {
            sb.append("\u7f3a\u5c11\u4e2a\u4eba\u5242\u91cf\u76d1\u6d4b\u65f6\u95f4\u3002");
        }
        if (vo.getTrainingTime() == null) {
            sb.append("\u7f3a\u5c11\u57f9\u8bad\u65f6\u95f4\u3002");
        }
        if (vo.getHealthCheckTime() == null) {
            sb.append("\u7f3a\u5c11\u4f53\u68c0\u65f6\u95f4\u3002");
        }
        if (StrUtil.isEmpty((CharSequence)vo.getCname())) {
            sb.append("\u7f3a\u5c11\u516c\u53f8\u540d\u79f0\u3002");
        }
        if (StrUtil.isEmpty((CharSequence)vo.getIssueUnitName())) {
            sb.append("\u7f3a\u5c11\u53d1\u8bc1\u5355\u4f4d\u540d\u79f0\u3002");
        }
        if (vo.getIssueTime() == null) {
            sb.append("\u7f3a\u5c11\u53d1\u8bc1\u65f6\u95f4\u3002");
        }
        if (sb.length() > 0) {
            throw new ServiceException(sb.toString());
        }
    }

    public CertService(OssClientBean ossClientBean, ICCertService cCertService, CCertConverter converter, RedissonClient redissonClient, ICStaffBaseInfoService staffBaseInfoService, SysProperties sysProperties) {
        this.ossClientBean = ossClientBean;
        this.cCertService = cCertService;
        this.converter = converter;
        this.redissonClient = redissonClient;
        this.staffBaseInfoService = staffBaseInfoService;
        this.sysProperties = sysProperties;
    }
}

