/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.supervise.service.b.impl;

import cn.hutool.core.util.StrUtil;
import cn.smarthse.core.framework.model.BaseEntity;
import cn.smarthse.core.framework.model.LayuiGridData;
import cn.smarthse.core.framework.model.LayuiGridParam;
import cn.smarthse.core.framework.model.PageParam;
import cn.smarthse.core.framework.service.ServiceImpl;
import cn.smarthse.rho.modules.supervise.converter.BCompanyConverter;
import cn.smarthse.rho.modules.supervise.dao.b.BCompanyMapper;
import cn.smarthse.rho.modules.supervise.model.company.param.BCompanySearchParam;
import cn.smarthse.rho.modules.supervise.model.company.vo.BCompanyCountVo;
import cn.smarthse.rho.modules.supervise.model.company.vo.BCompanyListVo;
import cn.smarthse.rho.modules.supervise.model.home.param.HomeVisualizationDataParam;
import cn.smarthse.rho.modules.supervise.model.home.vo.HomeVisualizationCompanyDataVo;
import cn.smarthse.rho.modules.supervise.model.home.vo.HomeVisualizationSubjectDataVo;
import cn.smarthse.rho.modules.supervise.model.staffArchives.vo.StaffCompanyVo;
import cn.smarthse.rho.modules.supervise.service.b.IBCompanyService;
import cn.smarthse.rho.modules.sys.entity.b.BCompany;
import cn.smarthse.rho.modules.sys.model.b.param.CompanyHospitalSelectParam;
import cn.smarthse.rho.modules.sys.model.b.vo.company.CompanyHospitalSelectVo;
import cn.smarthse.rho.modules.sys.provider.sys.ISysParamProvider;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import java.util.List;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class BCompanyServiceImpl
extends ServiceImpl<BCompanyMapper, BCompany>
implements IBCompanyService {
    @DubboReference
    public ISysParamProvider sysParamProvider;
    public final BCompanyConverter companyConverter;

    @Override
    public BCompanyCountVo getCompanyCount(PageParam param) {
        return ((BCompanyMapper)this.baseMapper).getCompanyCount(param);
    }

    @Override
    public LayuiGridData<BCompanyListVo> getListDataForSup(BCompanySearchParam param) {
        PageHelper.startPage((int)param.getPage(), (int)param.getLimit());
        Page list = (Page)((BCompanyMapper)this.baseMapper).getListData(param);
        if (list.getResult() != null) {
            list.getResult().parallelStream().forEach(r -> {
                r.setTypeStr(this.sysParamProvider.getName(r.getType()));
                r.setEconomyCodeStr(this.sysParamProvider.getName(r.getEconomyCode()));
                r.setUnitLevelStr(this.sysParamProvider.getName(r.getUnitLevel()));
                r.setBusinessTypeStr(this.sysParamProvider.getName(r.getBusinessType()));
            });
        }
        return new LayuiGridData(list, (LayuiGridParam)param);
    }

    @Override
    public LayuiGridData<BCompanyListVo> listSysCompanyExportData(BCompanySearchParam param) {
        PageHelper.startPage((int)param.getPage(), (int)param.getLimit());
        Page list = (Page)((BCompanyMapper)this.baseMapper).getListData(param);
        if (list.getResult() != null) {
            list.getResult().parallelStream().forEach(r -> {
                r.setTypeStr(this.sysParamProvider.getName(r.getType()));
                r.setEconomyCodeStr(this.sysParamProvider.getName(r.getEconomyCode()));
                r.setUnitLevelStr(this.sysParamProvider.getName(r.getUnitLevel()));
                r.setBusinessTypeStr(this.sysParamProvider.getName(r.getBusinessType()));
            });
        }
        return new LayuiGridData(list, (LayuiGridParam)param);
    }

    @Override
    public HomeVisualizationCompanyDataVo getHomeVisualizationData(HomeVisualizationDataParam param) {
        return ((BCompanyMapper)this.baseMapper).getHomeVisualizationData(param);
    }

    @Override
    public HomeVisualizationSubjectDataVo getHomeVisualizationDataWithSubject(HomeVisualizationDataParam param) {
        return ((BCompanyMapper)this.baseMapper).getHomeVisualizationDataWithSubject(param);
    }

    @Override
    public List<StaffCompanyVo> listForStaffArchive(List<Long> cidList) {
        return ((BCompanyMapper)this.baseMapper).listForStaffArchive(cidList);
    }

    @Override
    public BCompany getCompanyByName(String name) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(BCompany::getName, (Object)name)).eq(BaseEntity::getIsValid, (Object)1)).last("limit 1");
        return (BCompany)this.getOne((Wrapper)wrapper);
    }

    @Override
    public LayuiGridData<CompanyHospitalSelectVo> getHospitalNameList(CompanyHospitalSelectParam param) {
        if (StrUtil.isBlank((CharSequence)param.getKeyword()) && StrUtil.isBlank((CharSequence)param.getCreditCode())) {
            return new LayuiGridData(null, (LayuiGridParam)param);
        }
        PageHelper.startPage((int)param.getPage(), (int)param.getLimit());
        List<CompanyHospitalSelectVo> list = ((BCompanyMapper)this.baseMapper).getHospitalNameList(param);
        return new LayuiGridData((Page)list, (LayuiGridParam)param);
    }

    public BCompanyServiceImpl(BCompanyConverter companyConverter) {
        this.companyConverter = companyConverter;
    }
}

