/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.supervise.service.a.impl;

import cn.smarthse.core.framework.service.ServiceImpl;
import cn.smarthse.rho.modules.supervise.dao.a.AStatisticMapper;
import cn.smarthse.rho.modules.supervise.model.home.param.HomeRiskParam;
import cn.smarthse.rho.modules.supervise.model.home.vo.HomeRiskAboutRiskNumVo;
import cn.smarthse.rho.modules.supervise.model.home.vo.HomeRiskData7Vo;
import cn.smarthse.rho.modules.supervise.model.home.vo.HomeRiskDataCenterVo;
import cn.smarthse.rho.modules.supervise.model.home.vo.HomeRiskKeyPortraitDataVo;
import cn.smarthse.rho.modules.supervise.model.home.vo.HomeRiskResolutionByCompanyVo;
import cn.smarthse.rho.modules.supervise.model.keyFactor.param.RiskWarningQueryParam;
import cn.smarthse.rho.modules.supervise.model.keyFactor.vo.RiskWarningStatisticVo;
import cn.smarthse.rho.modules.supervise.model.keyFactor.vo.RiskWarningVo;
import cn.smarthse.rho.modules.supervise.service.a.IAStatisticService;
import cn.smarthse.rho.modules.sys.entity.a.AStatistic;
import cn.smarthse.rho.modules.sys.model.sys.vo.SysAreaVo;
import cn.smarthse.rho.modules.sys.provider.sys.ISysAreaProvider;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class AStatisticServiceImpl
extends ServiceImpl<AStatisticMapper, AStatistic>
implements IAStatisticService {
    @DubboReference
    private ISysAreaProvider sysAreaProvider;

    @Override
    public RiskWarningVo getStatisticAndListData(RiskWarningQueryParam param) {
        RiskWarningStatisticVo headInfo = ((AStatisticMapper)this.baseMapper).getStatisticByAreaId(param);
        List<RiskWarningStatisticVo> areaStatisticList = ((AStatisticMapper)this.baseMapper).listStatisticByAreaId(param);
        RiskWarningVo rst = new RiskWarningVo(headInfo, areaStatisticList);
        return rst;
    }

    @Override
    public HomeRiskKeyPortraitDataVo getData1ForHomeRisk(HomeRiskParam param) {
        return ((AStatisticMapper)this.baseMapper).getData1ForHomeRisk(param);
    }

    @Override
    public List<HomeRiskKeyPortraitDataVo> getData2ForHomeRisk(HomeRiskParam param) {
        return ((AStatisticMapper)this.baseMapper).getData2ForHomeRisk(param);
    }

    @Override
    public HomeRiskResolutionByCompanyVo getData4ForHomeRisk(HomeRiskParam param) {
        return ((AStatisticMapper)this.baseMapper).getData4ForHomeRisk(param);
    }

    @Override
    public HomeRiskAboutRiskNumVo getData5ForHomeRisk(HomeRiskParam param) {
        return ((AStatisticMapper)this.baseMapper).getData5ForHomeRisk(param);
    }

    @Override
    public List<HomeRiskData7Vo> getData7ForHomeRisk(HomeRiskParam param) {
        return ((AStatisticMapper)this.baseMapper).getData7ForHomeRisk(param);
    }

    @Override
    public HomeRiskDataCenterVo getHomeRiskDataCenter(HomeRiskParam param) {
        if (param.getLevel() == 0 || param.getLevel() == 1 || param.getLevel() == 4) {
            return null;
        }
        Integer curAreaLevel = param.getLevel();
        HomeRiskDataCenterVo rst = new HomeRiskDataCenterVo();
        List<HomeRiskDataCenterVo> dataForProvinceRank = ((AStatisticMapper)this.baseMapper).listDataForProvinceRank(param);
        if (curAreaLevel == 2) {
            int rank = this.findRankAndSetResolutionRate(dataForProvinceRank, param.getAreaId(), param.getLevel(), rst);
            rst.setProvinceRank(rank);
        } else if (curAreaLevel == 3) {
            int provinceRank = this.findRankAndSetResolutionRate(dataForProvinceRank, param.getAreaId(), param.getLevel(), rst);
            rst.setProvinceRank(provinceRank);
            SysAreaVo area = this.sysAreaProvider.getAreaById(param.getAreaId());
            List<HomeRiskDataCenterVo> dataForCurCityRank = ((AStatisticMapper)this.baseMapper).listDataForCurCityRank(param, area.getCityId());
            int cityRank = this.findRankAndSetResolutionRate(dataForCurCityRank, param.getAreaId(), param.getLevel(), rst);
            rst.setCityRank(cityRank);
        }
        return rst;
    }

    private int findRankAndSetResolutionRate(List<HomeRiskDataCenterVo> list, Long areaId, Integer level, HomeRiskDataCenterVo rst) {
        List sortedList = list.stream().sorted(Comparator.comparing(HomeRiskDataCenterVo::getResolutionRate).reversed()).collect(Collectors.toList());
        Long judgeAreaId = null;
        for (int i = 0; i < sortedList.size(); ++i) {
            if (level == 1) {
                judgeAreaId = ((HomeRiskDataCenterVo)sortedList.get(i)).getAreaId1();
            } else if (level == 2) {
                judgeAreaId = ((HomeRiskDataCenterVo)sortedList.get(i)).getAreaId2();
            } else if (level == 3) {
                judgeAreaId = ((HomeRiskDataCenterVo)sortedList.get(i)).getAreaId3();
            } else if (level == 4) {
                judgeAreaId = ((HomeRiskDataCenterVo)sortedList.get(i)).getAreaId4();
            }
            if (!judgeAreaId.equals(areaId)) continue;
            rst.setResolutionRate(((HomeRiskDataCenterVo)sortedList.get(i)).getResolutionRate());
            return i + 1;
        }
        return -1;
    }

    @Override
    @Transactional
    public void genAStatisticTask() {
        List areaList = this.sysAreaProvider.getSubAreaByIdAndLevel(Long.valueOf(330000000000L));
        List streetList = areaList.stream().filter(area -> area.getLevel() == 4).collect(Collectors.toList());
        streetList.stream().forEach(street -> {});
    }
}

