/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.supervise.model.home.vo;

import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.StrUtil;
import cn.smarthse.rho.modules.supervise.model.home.vo.HomeVisualizationBaseVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.NumberFormat;

@ApiModel(value="\u76d1\u7ba1\u7aef\u53ef\u89c6\u5316\u9996\u9875\uff1a\u98ce\u9669\u5316\u89e3-\u5316\u89e3\u7edf\u8ba1", description="\u76d1\u7ba1\u7aef\u53ef\u89c6\u5316\u9996\u9875\uff1a\u98ce\u9669\u5316\u89e3-\u5316\u89e3\u7edf\u8ba1")
public class HomeVisualizationRiskDataVo
extends HomeVisualizationBaseVo
implements Serializable {
    private static final long serialVersionUID = 1L;
    @ApiModelProperty(value="\u533a\u57dfid")
    private Long areaId;
    @ApiModelProperty(value="\u533a\u57df\u7b49\u7ea7")
    private Integer level;
    @ApiModelProperty(value="\u9700\u5316\u89e3\u98ce\u9669\u9662\u533a\u6570")
    private Integer needCompanyNum;
    @ApiModelProperty(value="\u5df2\u5316\u89e3\u98ce\u9669\u9662\u533a\u6570")
    private Integer resolvedCompanyNum;
    @ApiModelProperty(value="\u672a\u5316\u89e3\u98ce\u9669\u9662\u533a\u6570")
    private Integer unresolvedCompanyNum;
    @ApiModelProperty(value="\u63a8\u9001\u98ce\u9669\u6570\u6570")
    private Integer risk;
    @ApiModelProperty(value="\u5df2\u5316\u89e3\u98ce\u9669\u6570")
    private Integer resolvedRiskNum;
    @ApiModelProperty(value="\u672a\u5316\u89e3\u98ce\u9669\u6570")
    private Integer unresolvedRiskNum;
    @ApiModelProperty(value="\u63a8\u9001\u98ce\u9669\u6570\u6570")
    private Integer lastWeekRisk;
    @ApiModelProperty(value="\u5df2\u5316\u89e3\u98ce\u9669\u6570")
    private Integer lastWeekResolvedRiskNum;
    @ApiModelProperty(value="\u672a\u5316\u89e3\u98ce\u9669\u6570")
    private Integer lastWeekUnresolvedRiskNum;
    @ApiModelProperty(value="\u98ce\u9669\u5316\u89e3\u7387")
    private String resolutionRate;
    @ApiModelProperty(value="\u98ce\u9669\u5316\u89e3\u7387")
    private String lastWeekResolutionRate;
    @ApiModelProperty(value="\u73af\u6bd4")
    private String chain;
    @ApiModelProperty(value="\u63a8\u9001\u6570\u91cf\uff08\u63a8\u9001\u81f3\u98ce\u9669\u8c03\u5ea6\u4e2d\u5fc3\u7ebf\u7d22\u6570\uff09")
    private Integer pushNum;
    @ApiModelProperty(value="\u98ce\u9669\u5316\u6743\u91cd\uff08\u6392\u5e8f\u7528\uff09")
    private Double rankWeight;

    public String getResolutionRate() {
        if (this.resolvedRiskNum == null || this.risk == null || this.risk == 0) {
            return "-";
        }
        NumberFormat nf = NumberFormat.getPercentInstance();
        nf.setMinimumFractionDigits(2);
        return nf.format((double)this.resolvedRiskNum.intValue() / (double)this.risk.intValue());
    }

    public String getLastWeekResolutionRate() {
        if (this.lastWeekResolvedRiskNum == null || this.lastWeekRisk == null || this.lastWeekRisk == 0) {
            return "-";
        }
        NumberFormat nf = NumberFormat.getPercentInstance();
        nf.setMinimumFractionDigits(2);
        return nf.format((double)this.lastWeekResolvedRiskNum.intValue() / (double)this.lastWeekRisk.intValue());
    }

    public String getChain() {
        if (StrUtil.equals((CharSequence)"-", (CharSequence)this.getResolutionRate()) || StrUtil.equals((CharSequence)"-", (CharSequence)this.getLastWeekResolutionRate())) {
            return "-";
        }
        String r1 = this.getResolutionRate();
        String r2 = this.getLastWeekResolutionRate();
        if (r2.equals("0.00%")) {
            return "-";
        }
        BigDecimal div = NumberUtil.div((String)r1, (String)r2);
        NumberFormat nf = NumberFormat.getPercentInstance();
        nf.setMinimumFractionDigits(2);
        return nf.format(div);
    }

    public Double getRankWeight() {
        String rate = this.getResolutionRate();
        return rate.equals("-") || StrUtil.isEmpty((CharSequence)rate) ? 0.0 : NumberUtil.toBigDecimal((String)rate).doubleValue();
    }

    @Override
    public Long getAreaId() {
        return this.areaId;
    }

    @Override
    public Integer getLevel() {
        return this.level;
    }

    public Integer getNeedCompanyNum() {
        return this.needCompanyNum;
    }

    public Integer getResolvedCompanyNum() {
        return this.resolvedCompanyNum;
    }

    public Integer getUnresolvedCompanyNum() {
        return this.unresolvedCompanyNum;
    }

    public Integer getRisk() {
        return this.risk;
    }

    public Integer getResolvedRiskNum() {
        return this.resolvedRiskNum;
    }

    public Integer getUnresolvedRiskNum() {
        return this.unresolvedRiskNum;
    }

    public Integer getLastWeekRisk() {
        return this.lastWeekRisk;
    }

    public Integer getLastWeekResolvedRiskNum() {
        return this.lastWeekResolvedRiskNum;
    }

    public Integer getLastWeekUnresolvedRiskNum() {
        return this.lastWeekUnresolvedRiskNum;
    }

    public Integer getPushNum() {
        return this.pushNum;
    }

    @Override
    public HomeVisualizationRiskDataVo setAreaId(Long areaId) {
        this.areaId = areaId;
        return this;
    }

    @Override
    public HomeVisualizationRiskDataVo setLevel(Integer level) {
        this.level = level;
        return this;
    }

    public HomeVisualizationRiskDataVo setNeedCompanyNum(Integer needCompanyNum) {
        this.needCompanyNum = needCompanyNum;
        return this;
    }

    public HomeVisualizationRiskDataVo setResolvedCompanyNum(Integer resolvedCompanyNum) {
        this.resolvedCompanyNum = resolvedCompanyNum;
        return this;
    }

    public HomeVisualizationRiskDataVo setUnresolvedCompanyNum(Integer unresolvedCompanyNum) {
        this.unresolvedCompanyNum = unresolvedCompanyNum;
        return this;
    }

    public HomeVisualizationRiskDataVo setRisk(Integer risk) {
        this.risk = risk;
        return this;
    }

    public HomeVisualizationRiskDataVo setResolvedRiskNum(Integer resolvedRiskNum) {
        this.resolvedRiskNum = resolvedRiskNum;
        return this;
    }

    public HomeVisualizationRiskDataVo setUnresolvedRiskNum(Integer unresolvedRiskNum) {
        this.unresolvedRiskNum = unresolvedRiskNum;
        return this;
    }

    public HomeVisualizationRiskDataVo setLastWeekRisk(Integer lastWeekRisk) {
        this.lastWeekRisk = lastWeekRisk;
        return this;
    }

    public HomeVisualizationRiskDataVo setLastWeekResolvedRiskNum(Integer lastWeekResolvedRiskNum) {
        this.lastWeekResolvedRiskNum = lastWeekResolvedRiskNum;
        return this;
    }

    public HomeVisualizationRiskDataVo setLastWeekUnresolvedRiskNum(Integer lastWeekUnresolvedRiskNum) {
        this.lastWeekUnresolvedRiskNum = lastWeekUnresolvedRiskNum;
        return this;
    }

    public HomeVisualizationRiskDataVo setResolutionRate(String resolutionRate) {
        this.resolutionRate = resolutionRate;
        return this;
    }

    public HomeVisualizationRiskDataVo setLastWeekResolutionRate(String lastWeekResolutionRate) {
        this.lastWeekResolutionRate = lastWeekResolutionRate;
        return this;
    }

    public HomeVisualizationRiskDataVo setChain(String chain) {
        this.chain = chain;
        return this;
    }

    public HomeVisualizationRiskDataVo setPushNum(Integer pushNum) {
        this.pushNum = pushNum;
        return this;
    }

    public HomeVisualizationRiskDataVo setRankWeight(Double rankWeight) {
        this.rankWeight = rankWeight;
        return this;
    }

    @Override
    public String toString() {
        return "HomeVisualizationRiskDataVo(areaId=" + this.getAreaId() + ", level=" + this.getLevel() + ", needCompanyNum=" + this.getNeedCompanyNum() + ", resolvedCompanyNum=" + this.getResolvedCompanyNum() + ", unresolvedCompanyNum=" + this.getUnresolvedCompanyNum() + ", risk=" + this.getRisk() + ", resolvedRiskNum=" + this.getResolvedRiskNum() + ", unresolvedRiskNum=" + this.getUnresolvedRiskNum() + ", lastWeekRisk=" + this.getLastWeekRisk() + ", lastWeekResolvedRiskNum=" + this.getLastWeekResolvedRiskNum() + ", lastWeekUnresolvedRiskNum=" + this.getLastWeekUnresolvedRiskNum() + ", resolutionRate=" + this.getResolutionRate() + ", lastWeekResolutionRate=" + this.getLastWeekResolutionRate() + ", chain=" + this.getChain() + ", pushNum=" + this.getPushNum() + ", rankWeight=" + this.getRankWeight() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HomeVisualizationRiskDataVo)) {
            return false;
        }
        HomeVisualizationRiskDataVo other = (HomeVisualizationRiskDataVo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$areaId = this.getAreaId();
        Long other$areaId = other.getAreaId();
        if (this$areaId == null ? other$areaId != null : !((Object)this$areaId).equals(other$areaId)) {
            return false;
        }
        Integer this$level = this.getLevel();
        Integer other$level = other.getLevel();
        if (this$level == null ? other$level != null : !((Object)this$level).equals(other$level)) {
            return false;
        }
        Integer this$needCompanyNum = this.getNeedCompanyNum();
        Integer other$needCompanyNum = other.getNeedCompanyNum();
        if (this$needCompanyNum == null ? other$needCompanyNum != null : !((Object)this$needCompanyNum).equals(other$needCompanyNum)) {
            return false;
        }
        Integer this$resolvedCompanyNum = this.getResolvedCompanyNum();
        Integer other$resolvedCompanyNum = other.getResolvedCompanyNum();
        if (this$resolvedCompanyNum == null ? other$resolvedCompanyNum != null : !((Object)this$resolvedCompanyNum).equals(other$resolvedCompanyNum)) {
            return false;
        }
        Integer this$unresolvedCompanyNum = this.getUnresolvedCompanyNum();
        Integer other$unresolvedCompanyNum = other.getUnresolvedCompanyNum();
        if (this$unresolvedCompanyNum == null ? other$unresolvedCompanyNum != null : !((Object)this$unresolvedCompanyNum).equals(other$unresolvedCompanyNum)) {
            return false;
        }
        Integer this$risk = this.getRisk();
        Integer other$risk = other.getRisk();
        if (this$risk == null ? other$risk != null : !((Object)this$risk).equals(other$risk)) {
            return false;
        }
        Integer this$resolvedRiskNum = this.getResolvedRiskNum();
        Integer other$resolvedRiskNum = other.getResolvedRiskNum();
        if (this$resolvedRiskNum == null ? other$resolvedRiskNum != null : !((Object)this$resolvedRiskNum).equals(other$resolvedRiskNum)) {
            return false;
        }
        Integer this$unresolvedRiskNum = this.getUnresolvedRiskNum();
        Integer other$unresolvedRiskNum = other.getUnresolvedRiskNum();
        if (this$unresolvedRiskNum == null ? other$unresolvedRiskNum != null : !((Object)this$unresolvedRiskNum).equals(other$unresolvedRiskNum)) {
            return false;
        }
        Integer this$lastWeekRisk = this.getLastWeekRisk();
        Integer other$lastWeekRisk = other.getLastWeekRisk();
        if (this$lastWeekRisk == null ? other$lastWeekRisk != null : !((Object)this$lastWeekRisk).equals(other$lastWeekRisk)) {
            return false;
        }
        Integer this$lastWeekResolvedRiskNum = this.getLastWeekResolvedRiskNum();
        Integer other$lastWeekResolvedRiskNum = other.getLastWeekResolvedRiskNum();
        if (this$lastWeekResolvedRiskNum == null ? other$lastWeekResolvedRiskNum != null : !((Object)this$lastWeekResolvedRiskNum).equals(other$lastWeekResolvedRiskNum)) {
            return false;
        }
        Integer this$lastWeekUnresolvedRiskNum = this.getLastWeekUnresolvedRiskNum();
        Integer other$lastWeekUnresolvedRiskNum = other.getLastWeekUnresolvedRiskNum();
        if (this$lastWeekUnresolvedRiskNum == null ? other$lastWeekUnresolvedRiskNum != null : !((Object)this$lastWeekUnresolvedRiskNum).equals(other$lastWeekUnresolvedRiskNum)) {
            return false;
        }
        String this$resolutionRate = this.getResolutionRate();
        String other$resolutionRate = other.getResolutionRate();
        if (this$resolutionRate == null ? other$resolutionRate != null : !this$resolutionRate.equals(other$resolutionRate)) {
            return false;
        }
        String this$lastWeekResolutionRate = this.getLastWeekResolutionRate();
        String other$lastWeekResolutionRate = other.getLastWeekResolutionRate();
        if (this$lastWeekResolutionRate == null ? other$lastWeekResolutionRate != null : !this$lastWeekResolutionRate.equals(other$lastWeekResolutionRate)) {
            return false;
        }
        String this$chain = this.getChain();
        String other$chain = other.getChain();
        if (this$chain == null ? other$chain != null : !this$chain.equals(other$chain)) {
            return false;
        }
        Integer this$pushNum = this.getPushNum();
        Integer other$pushNum = other.getPushNum();
        if (this$pushNum == null ? other$pushNum != null : !((Object)this$pushNum).equals(other$pushNum)) {
            return false;
        }
        Double this$rankWeight = this.getRankWeight();
        Double other$rankWeight = other.getRankWeight();
        return !(this$rankWeight == null ? other$rankWeight != null : !((Object)this$rankWeight).equals(other$rankWeight));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof HomeVisualizationRiskDataVo;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $areaId = this.getAreaId();
        result = result * 59 + ($areaId == null ? 43 : ((Object)$areaId).hashCode());
        Integer $level = this.getLevel();
        result = result * 59 + ($level == null ? 43 : ((Object)$level).hashCode());
        Integer $needCompanyNum = this.getNeedCompanyNum();
        result = result * 59 + ($needCompanyNum == null ? 43 : ((Object)$needCompanyNum).hashCode());
        Integer $resolvedCompanyNum = this.getResolvedCompanyNum();
        result = result * 59 + ($resolvedCompanyNum == null ? 43 : ((Object)$resolvedCompanyNum).hashCode());
        Integer $unresolvedCompanyNum = this.getUnresolvedCompanyNum();
        result = result * 59 + ($unresolvedCompanyNum == null ? 43 : ((Object)$unresolvedCompanyNum).hashCode());
        Integer $risk = this.getRisk();
        result = result * 59 + ($risk == null ? 43 : ((Object)$risk).hashCode());
        Integer $resolvedRiskNum = this.getResolvedRiskNum();
        result = result * 59 + ($resolvedRiskNum == null ? 43 : ((Object)$resolvedRiskNum).hashCode());
        Integer $unresolvedRiskNum = this.getUnresolvedRiskNum();
        result = result * 59 + ($unresolvedRiskNum == null ? 43 : ((Object)$unresolvedRiskNum).hashCode());
        Integer $lastWeekRisk = this.getLastWeekRisk();
        result = result * 59 + ($lastWeekRisk == null ? 43 : ((Object)$lastWeekRisk).hashCode());
        Integer $lastWeekResolvedRiskNum = this.getLastWeekResolvedRiskNum();
        result = result * 59 + ($lastWeekResolvedRiskNum == null ? 43 : ((Object)$lastWeekResolvedRiskNum).hashCode());
        Integer $lastWeekUnresolvedRiskNum = this.getLastWeekUnresolvedRiskNum();
        result = result * 59 + ($lastWeekUnresolvedRiskNum == null ? 43 : ((Object)$lastWeekUnresolvedRiskNum).hashCode());
        String $resolutionRate = this.getResolutionRate();
        result = result * 59 + ($resolutionRate == null ? 43 : $resolutionRate.hashCode());
        String $lastWeekResolutionRate = this.getLastWeekResolutionRate();
        result = result * 59 + ($lastWeekResolutionRate == null ? 43 : $lastWeekResolutionRate.hashCode());
        String $chain = this.getChain();
        result = result * 59 + ($chain == null ? 43 : $chain.hashCode());
        Integer $pushNum = this.getPushNum();
        result = result * 59 + ($pushNum == null ? 43 : ((Object)$pushNum).hashCode());
        Double $rankWeight = this.getRankWeight();
        result = result * 59 + ($rankWeight == null ? 43 : ((Object)$rankWeight).hashCode());
        return result;
    }
}

