/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.supervise.manage.staff;

import cn.hutool.core.collection.CollUtil;
import cn.smarthse.core.framework.model.LayuiGridData;
import cn.smarthse.rho.modules.supervise.model.c.param.StaffStatisticsAdminParam;
import cn.smarthse.rho.modules.supervise.model.c.vo.CDoseDataVo;
import cn.smarthse.rho.modules.supervise.model.c.vo.CHealthCheckDataVo;
import cn.smarthse.rho.modules.supervise.model.c.vo.CStaffWorkExperienceAdminVo;
import cn.smarthse.rho.modules.supervise.model.c.vo.CTrainingCertVo;
import cn.smarthse.rho.modules.supervise.model.staffArchives.param.CertConditionParam;
import cn.smarthse.rho.modules.supervise.model.staffArchives.param.StaffInfoAdminParam;
import cn.smarthse.rho.modules.supervise.model.staffArchives.param.StaffPageAdminParam;
import cn.smarthse.rho.modules.supervise.model.staffArchives.vo.StaffArchiveListAdminVo;
import cn.smarthse.rho.modules.supervise.model.staffArchives.vo.StaffCompanyVo;
import cn.smarthse.rho.modules.supervise.model.staffArchives.vo.StaffDetailInfoVo;
import cn.smarthse.rho.modules.supervise.service.b.IBCompanyService;
import cn.smarthse.rho.modules.supervise.service.b.IBStatisticService;
import cn.smarthse.rho.modules.supervise.service.c.ICDoseDataService;
import cn.smarthse.rho.modules.supervise.service.c.ICHealthCheckDataService;
import cn.smarthse.rho.modules.supervise.service.c.ICStaffBaseInfoService;
import cn.smarthse.rho.modules.supervise.service.c.ICStaffService;
import cn.smarthse.rho.modules.supervise.service.c.ICStaffWorkExperienceService;
import cn.smarthse.rho.modules.supervise.service.c.ICTrainingCertService;
import cn.smarthse.rho.modules.sys.model.c.param.CDoseQueryParam;
import cn.smarthse.rho.modules.sys.model.c.param.CHealthCheckQueryParam;
import cn.smarthse.rho.modules.sys.model.c.param.CStaffBaseInfoEditParam;
import cn.smarthse.rho.modules.sys.model.c.param.CStaffEditParam;
import cn.smarthse.rho.modules.sys.model.c.param.CStaffWorkExperiencePageParam;
import cn.smarthse.rho.modules.sys.model.c.param.CTrainingCertPageParam;
import cn.smarthse.rho.modules.sys.model.c.param.StaffAcInfoParam;
import cn.smarthse.rho.modules.sys.model.c.vo.CertConditionVo;
import cn.smarthse.rho.modules.sys.model.c.vo.StaffAcVo;
import cn.smarthse.rho.modules.sys.model.c.vo.StaffArchiveListVo;
import cn.smarthse.rho.modules.sys.model.c.vo.StaffArchiveStatisticsAdminVo;
import cn.smarthse.rho.modules.sys.model.c.vo.StaffChooseListVo;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional(readOnly=true)
public class StaffManager {
    private static final Logger log = LoggerFactory.getLogger(StaffManager.class);
    private final IBCompanyService companyService;
    private final ICStaffBaseInfoService staffBaseInfoService;
    private final ICStaffService cStaffService;
    private final IBStatisticService bStatisticService;
    private final ICHealthCheckDataService healthCheckDataService;
    private final ICDoseDataService doseDataService;
    private final ICStaffWorkExperienceService cStaffWorkExperienceService;
    private final ICTrainingCertService cTrainingCertService;

    public LayuiGridData<StaffArchiveListAdminVo> getStaffArchiveList(StaffPageAdminParam param) {
        return this.staffBaseInfoService.getStaffArchiveList(param);
    }

    public LayuiGridData<StaffArchiveListAdminVo> getPostStaffArchiveList(StaffPageAdminParam param) {
        return this.staffBaseInfoService.getPostStaffArchiveList(param);
    }

    public LayuiGridData<StaffChooseListVo> getChooseList(StaffPageAdminParam param) {
        return this.staffBaseInfoService.getChooseList(param);
    }

    @Transactional
    public StaffArchiveListVo editStaffFullInfo(CStaffBaseInfoEditParam param) {
        return this.staffBaseInfoService.editInfo(param);
    }

    @Transactional
    public StaffDetailInfoVo getInfo(StaffInfoAdminParam param) {
        StaffDetailInfoVo result = this.staffBaseInfoService.getInfo(param);
        result.genSex();
        result.genAge();
        result.genPhone();
        result.genIdcard();
        return result;
    }

    public StaffAcVo getAcInfo(StaffAcInfoParam param) {
        return this.staffBaseInfoService.getAcInfo(param);
    }

    public StaffArchiveStatisticsAdminVo getStaffArchiveStatistics(StaffStatisticsAdminParam param) {
        return this.staffBaseInfoService.getStaffArchiveStatistics(param);
    }

    public CertConditionVo getCertCondition(CertConditionParam param) {
        return this.staffBaseInfoService.getOneCertCondition(param);
    }

    public LayuiGridData<CHealthCheckDataVo> getHealthList(CHealthCheckQueryParam param) {
        LayuiGridData<CHealthCheckDataVo> result = this.healthCheckDataService.getListForArchive(param);
        List<StaffCompanyVo> staffCompanyList = this.staffBaseInfoService.getStaffCompanyList(new StaffInfoAdminParam().setId(param.getStaffBaseInfoId()));
        Map<Long, StaffCompanyVo> staffCompanyVoMap = staffCompanyList.stream().collect(Collectors.toMap(v -> v.getCid(), v -> v));
        for (CHealthCheckDataVo vo : result.getData()) {
            if (!staffCompanyVoMap.containsKey(vo.getCid())) continue;
            vo.setStaffCompanyVo(staffCompanyVoMap.get(vo.getCid()));
        }
        return result;
    }

    public LayuiGridData<CDoseDataVo> getDoseList(CDoseQueryParam param) {
        LayuiGridData<CDoseDataVo> result = this.doseDataService.getDoseListForArchive(param);
        List<Long> cidList = result.getData().stream().map(v -> v.getCid()).distinct().collect(Collectors.toList());
        if (CollUtil.isNotEmpty(cidList)) {
            List<StaffCompanyVo> staffCompanyList = this.companyService.listForStaffArchive(cidList);
            Map<Long, StaffCompanyVo> staffCompanyVoMap = staffCompanyList.stream().collect(Collectors.toMap(v -> v.getCid(), v -> v));
            for (CDoseDataVo vo : result.getData()) {
                if (!staffCompanyVoMap.containsKey(vo.getCid())) continue;
                vo.setStaffCompanyVo(staffCompanyVoMap.get(vo.getCid()));
            }
        }
        return result;
    }

    public LayuiGridData<CStaffWorkExperienceAdminVo> getWorkExperienceList(CStaffWorkExperiencePageParam param) {
        LayuiGridData<CStaffWorkExperienceAdminVo> result = this.cStaffWorkExperienceService.getListForArchive(param);
        List<Long> cidList = result.getData().stream().map(v -> v.getCid()).distinct().collect(Collectors.toList());
        if (CollUtil.isNotEmpty(cidList)) {
            List<StaffCompanyVo> staffCompanyList = this.companyService.listForStaffArchive(cidList);
            Map<Long, StaffCompanyVo> staffCompanyVoMap = staffCompanyList.stream().collect(Collectors.toMap(v -> v.getCid(), v -> v));
            for (CStaffWorkExperienceAdminVo vo : result.getData()) {
                if (!staffCompanyVoMap.containsKey(vo.getCid())) continue;
                vo.setStaffCompanyVo(staffCompanyVoMap.get(vo.getCid()));
            }
        }
        return result;
    }

    public LayuiGridData<CTrainingCertVo> getCertList(CTrainingCertPageParam param) {
        LayuiGridData<CTrainingCertVo> result = this.cTrainingCertService.getListForArchive(param);
        List<Long> cidList = result.getData().stream().map(v -> v.getCid()).distinct().collect(Collectors.toList());
        if (CollUtil.isNotEmpty(cidList)) {
            List<StaffCompanyVo> staffCompanyList = this.companyService.listForStaffArchive(cidList);
            Map<Long, StaffCompanyVo> staffCompanyVoMap = staffCompanyList.stream().collect(Collectors.toMap(v -> v.getCid(), v -> v));
            for (CTrainingCertVo vo : result.getData()) {
                if (!staffCompanyVoMap.containsKey(vo.getCid())) continue;
                vo.setStaffCompanyVo(staffCompanyVoMap.get(vo.getCid()));
            }
        }
        return result;
    }

    @Transactional
    public void editStaffInfo(CStaffEditParam param) {
        this.cStaffService.editInfo(param);
    }

    public StaffManager(IBCompanyService companyService, ICStaffBaseInfoService staffBaseInfoService, ICStaffService cStaffService, IBStatisticService bStatisticService, ICHealthCheckDataService healthCheckDataService, ICDoseDataService doseDataService, ICStaffWorkExperienceService cStaffWorkExperienceService, ICTrainingCertService cTrainingCertService) {
        this.companyService = companyService;
        this.staffBaseInfoService = staffBaseInfoService;
        this.cStaffService = cStaffService;
        this.bStatisticService = bStatisticService;
        this.healthCheckDataService = healthCheckDataService;
        this.doseDataService = doseDataService;
        this.cStaffWorkExperienceService = cStaffWorkExperienceService;
        this.cTrainingCertService = cTrainingCertService;
    }
}

